/*
 * Decompiled with CFR 0.152.
 */
package com.vectorprint.vectorprintreportgui.xml;

import java.util.ArrayList;
import java.util.List;
import javafx.scene.text.Text;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class XmlContentHandler
extends DefaultHandler {
    private final List<Text> texts = new ArrayList<Text>(100);
    private final StringBuilder text = new StringBuilder();

    XmlContentHandler() {
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        Text t = new Text(new String(ch).substring(start, start + length));
        this.texts.add(t);
        this.text.append(t.getText());
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        Text t = new Text("</" + qName + '>');
        t.getStyleClass().add((Object)"xmlelement");
        this.texts.add(t);
        this.text.append(t.getText());
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        Text t = new Text("<" + qName);
        t.getStyleClass().add((Object)"xmlelement");
        this.texts.add(t);
        this.text.append(t.getText());
        for (int i = 0; i < attributes.getLength(); ++i) {
            t = new Text(" " + attributes.getQName(i) + "=\"");
            t.getStyleClass().add((Object)"xmlattribute");
            this.texts.add(t);
            this.text.append(t.getText());
            t = new Text(attributes.getValue(i));
            this.texts.add(t);
            this.text.append(t.getText());
            t = new Text("\"");
            t.getStyleClass().add((Object)"xmlattribute");
            this.texts.add(t);
            this.text.append(t.getText());
        }
        t = new Text(">");
        t.getStyleClass().add((Object)"xmlelement");
        this.texts.add(t);
        this.text.append(t.getText());
    }

    public List<Text> getTexts() {
        return this.texts;
    }

    public String getText() {
        return this.text.toString();
    }
}

