/*
 * Velo Payments APIs
 * ## Terms and Definitions  Throughout this document and the Velo platform the following terms are used:  * **Payor.** An entity (typically a corporation) which wishes to pay funds to one or more payees via a payout. * **Payee.** The recipient of funds paid out by a payor. * **Payment.** A single transfer of funds from a payor to a payee. * **Payout.** A batch of Payments, typically used by a payor to logically group payments (e.g. by business day). Technically there need be no relationship between the payments in a payout - a single payout can contain payments to multiple payees and/or multiple payments to a single payee. * **Sandbox.** An integration environment provided by Velo Payments which offers a similar API experience to the production environment, but all funding and payment events are simulated, along with many other services such as OFAC sanctions list checking.  ## Overview  The Velo Payments API allows a payor to perform a number of operations. The following is a list of the main capabilities in a natural order of execution:  * Authenticate with the Velo platform * Maintain a collection of payees * Query the payor’s current balance of funds within the platform and perform additional funding * Issue payments to payees * Query the platform for a history of those payments  This document describes the main concepts and APIs required to get up and running with the Velo Payments platform. It is not an exhaustive API reference. For that, please see the separate Velo Payments API Reference.  ## API Considerations  The Velo Payments API is REST based and uses the JSON format for requests and responses.  Most calls are secured using OAuth 2 security and require a valid authentication access token for successful operation. See the Authentication section for details.  Where a dynamic value is required in the examples below, the {token} format is used, suggesting that the caller needs to supply the appropriate value of the token in question (without including the { or } characters).  Where curl examples are given, the –d @filename.json approach is used, indicating that the request body should be placed into a file named filename.json in the current directory. Each of the curl examples in this document should be considered a single line on the command-line, regardless of how they appear in print.  ## Authenticating with the Velo Platform  Once Velo backoffice staff have added your organization as a payor within the Velo platform sandbox, they will create you a payor Id, an API key and an API secret and share these with you in a secure manner.  You will need to use these values to authenticate with the Velo platform in order to gain access to the APIs. The steps to take are explained in the following:  create a string comprising the API key (e.g. 44a9537d-d55d-4b47-8082-14061c2bcdd8) and API secret (e.g. c396b26b-137a-44fd-87f5-34631f8fd529) with a colon between them. E.g. 44a9537d-d55d-4b47-8082-14061c2bcdd8:c396b26b-137a-44fd-87f5-34631f8fd529  base64 encode this string. E.g.: NDRhOTUzN2QtZDU1ZC00YjQ3LTgwODItMTQwNjFjMmJjZGQ4OmMzOTZiMjZiLTEzN2EtNDRmZC04N2Y1LTM0NjMxZjhmZDUyOQ==  create an HTTP **Authorization** header with the value set to e.g. Basic NDRhOTUzN2QtZDU1ZC00YjQ3LTgwODItMTQwNjFjMmJjZGQ4OmMzOTZiMjZiLTEzN2EtNDRmZC04N2Y1LTM0NjMxZjhmZDUyOQ==  perform the Velo authentication REST call using the HTTP header created above e.g. via curl:  ```   curl -X POST \\   -H \"Content-Type: application/json\" \\   -H \"Authorization: Basic NDRhOTUzN2QtZDU1ZC00YjQ3LTgwODItMTQwNjFjMmJjZGQ4OmMzOTZiMjZiLTEzN2EtNDRmZC04N2Y1LTM0NjMxZjhmZDUyOQ==\" \\   'https://api.sandbox.velopayments.com/v1/authenticate?grant_type=client_credentials' ```  If successful, this call will result in a **200** HTTP status code and a response body such as:  ```   {     \"access_token\":\"19f6bafd-93fd-4747-b229-00507bbc991f\",     \"token_type\":\"bearer\",     \"expires_in\":1799,     \"scope\":\"...\"   } ``` ## API access following authentication Following successful authentication, the value of the access_token field in the response (indicated in green above) should then be presented with all subsequent API calls to allow the Velo platform to validate that the caller is authenticated.  This is achieved by setting the HTTP Authorization header with the value set to e.g. Bearer 19f6bafd-93fd-4747-b229-00507bbc991f such as the curl example below:  ```   -H \"Authorization: Bearer 19f6bafd-93fd-4747-b229-00507bbc991f \" ```  If you make other Velo API calls which require authorization but the Authorization header is missing or invalid then you will get a **401** HTTP status response. 
 *
 * The version of the OpenAPI document: 2.18.113
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.velopayments.oa3.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.velopayments.oa3.model.PayeeType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import javax.validation.constraints.*;
import javax.validation.Valid;

/**
 * CreatePayeesCSVRequest
 */
@JsonPropertyOrder({
  CreatePayeesCSVRequest.JSON_PROPERTY_TYPE,
  CreatePayeesCSVRequest.JSON_PROPERTY_REMOTE_ID,
  CreatePayeesCSVRequest.JSON_PROPERTY_EMAIL,
  CreatePayeesCSVRequest.JSON_PROPERTY_ADDRESS_LINE1,
  CreatePayeesCSVRequest.JSON_PROPERTY_ADDRESS_LINE2,
  CreatePayeesCSVRequest.JSON_PROPERTY_ADDRESS_LINE3,
  CreatePayeesCSVRequest.JSON_PROPERTY_ADDRESS_LINE4,
  CreatePayeesCSVRequest.JSON_PROPERTY_ADDRESS_CITY,
  CreatePayeesCSVRequest.JSON_PROPERTY_ADDRESS_COUNTY_OR_PROVINCE,
  CreatePayeesCSVRequest.JSON_PROPERTY_ADDRESS_ZIP_OR_POSTCODE,
  CreatePayeesCSVRequest.JSON_PROPERTY_ADDRESS_COUNTRY,
  CreatePayeesCSVRequest.JSON_PROPERTY_INDIVIDUAL_NATIONAL_IDENTIFICATION,
  CreatePayeesCSVRequest.JSON_PROPERTY_INDIVIDUAL_DATE_OF_BIRTH,
  CreatePayeesCSVRequest.JSON_PROPERTY_INDIVIDUAL_TITLE,
  CreatePayeesCSVRequest.JSON_PROPERTY_INDIVIDUAL_FIRST_NAME,
  CreatePayeesCSVRequest.JSON_PROPERTY_INDIVIDUAL_OTHER_NAMES,
  CreatePayeesCSVRequest.JSON_PROPERTY_INDIVIDUAL_LAST_NAME,
  CreatePayeesCSVRequest.JSON_PROPERTY_COMPANY_NAME,
  CreatePayeesCSVRequest.JSON_PROPERTY_COMPANY_E_I_N,
  CreatePayeesCSVRequest.JSON_PROPERTY_COMPANY_OPERATING_NAME,
  CreatePayeesCSVRequest.JSON_PROPERTY_PAYMENT_CHANNEL_ACCOUNT_NUMBER,
  CreatePayeesCSVRequest.JSON_PROPERTY_PAYMENT_CHANNEL_ROUTING_NUMBER,
  CreatePayeesCSVRequest.JSON_PROPERTY_PAYMENT_CHANNEL_ACCOUNT_NAME,
  CreatePayeesCSVRequest.JSON_PROPERTY_PAYMENT_CHANNEL_IBAN,
  CreatePayeesCSVRequest.JSON_PROPERTY_PAYMENT_CHANNEL_COUNTRY_CODE,
  CreatePayeesCSVRequest.JSON_PROPERTY_PAYMENT_CHANNEL_CURRENCY,
  CreatePayeesCSVRequest.JSON_PROPERTY_CHALLENGE_DESCRIPTION,
  CreatePayeesCSVRequest.JSON_PROPERTY_CHALLENGE_VALUE,
  CreatePayeesCSVRequest.JSON_PROPERTY_PAYEE_LANGUAGE
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-01-15T12:59:39.508953-05:00[America/New_York]")
public class CreatePayeesCSVRequest {
  public static final String JSON_PROPERTY_TYPE = "type";
  private PayeeType type;

  public static final String JSON_PROPERTY_REMOTE_ID = "remoteId";
  private String remoteId;

  public static final String JSON_PROPERTY_EMAIL = "email";
  private String email;

  public static final String JSON_PROPERTY_ADDRESS_LINE1 = "addressLine1";
  private String addressLine1;

  public static final String JSON_PROPERTY_ADDRESS_LINE2 = "addressLine2";
  private String addressLine2;

  public static final String JSON_PROPERTY_ADDRESS_LINE3 = "addressLine3";
  private String addressLine3;

  public static final String JSON_PROPERTY_ADDRESS_LINE4 = "addressLine4";
  private String addressLine4;

  public static final String JSON_PROPERTY_ADDRESS_CITY = "addressCity";
  private String addressCity;

  public static final String JSON_PROPERTY_ADDRESS_COUNTY_OR_PROVINCE = "addressCountyOrProvince";
  private String addressCountyOrProvince;

  public static final String JSON_PROPERTY_ADDRESS_ZIP_OR_POSTCODE = "addressZipOrPostcode";
  private String addressZipOrPostcode;

  public static final String JSON_PROPERTY_ADDRESS_COUNTRY = "addressCountry";
  private String addressCountry;

  public static final String JSON_PROPERTY_INDIVIDUAL_NATIONAL_IDENTIFICATION = "individualNationalIdentification";
  private String individualNationalIdentification;

  public static final String JSON_PROPERTY_INDIVIDUAL_DATE_OF_BIRTH = "individualDateOfBirth";
  private LocalDate individualDateOfBirth;

  public static final String JSON_PROPERTY_INDIVIDUAL_TITLE = "individualTitle";
  private String individualTitle;

  public static final String JSON_PROPERTY_INDIVIDUAL_FIRST_NAME = "individualFirstName";
  private String individualFirstName;

  public static final String JSON_PROPERTY_INDIVIDUAL_OTHER_NAMES = "individualOtherNames";
  private String individualOtherNames;

  public static final String JSON_PROPERTY_INDIVIDUAL_LAST_NAME = "individualLastName";
  private String individualLastName;

  public static final String JSON_PROPERTY_COMPANY_NAME = "companyName";
  private String companyName;

  public static final String JSON_PROPERTY_COMPANY_E_I_N = "companyEIN";
  private String companyEIN;

  public static final String JSON_PROPERTY_COMPANY_OPERATING_NAME = "companyOperatingName";
  private String companyOperatingName;

  public static final String JSON_PROPERTY_PAYMENT_CHANNEL_ACCOUNT_NUMBER = "paymentChannelAccountNumber";
  private String paymentChannelAccountNumber;

  public static final String JSON_PROPERTY_PAYMENT_CHANNEL_ROUTING_NUMBER = "paymentChannelRoutingNumber";
  private String paymentChannelRoutingNumber;

  public static final String JSON_PROPERTY_PAYMENT_CHANNEL_ACCOUNT_NAME = "paymentChannelAccountName";
  private String paymentChannelAccountName;

  public static final String JSON_PROPERTY_PAYMENT_CHANNEL_IBAN = "paymentChannelIban";
  private String paymentChannelIban;

  /**
   * Must be a 2 character country code - per ISO 3166-1
   */
  public enum PaymentChannelCountryCodeEnum {
    AF("AF"),
    
    AX("AX"),
    
    AL("AL"),
    
    DZ("DZ"),
    
    AS("AS"),
    
    AD("AD"),
    
    AO("AO"),
    
    AI("AI"),
    
    AQ("AQ"),
    
    AG("AG"),
    
    AR("AR"),
    
    AM("AM"),
    
    AW("AW"),
    
    AU("AU"),
    
    AT("AT"),
    
    AZ("AZ"),
    
    BS("BS"),
    
    BH("BH"),
    
    BD("BD"),
    
    BB("BB"),
    
    BY("BY"),
    
    BE("BE"),
    
    BZ("BZ"),
    
    BJ("BJ"),
    
    BM("BM"),
    
    BT("BT"),
    
    BO("BO"),
    
    BQ("BQ"),
    
    BA("BA"),
    
    BW("BW"),
    
    BV("BV"),
    
    BR("BR"),
    
    IO("IO"),
    
    BN("BN"),
    
    BG("BG"),
    
    BF("BF"),
    
    BI("BI"),
    
    KH("KH"),
    
    CM("CM"),
    
    CA("CA"),
    
    CV("CV"),
    
    KY("KY"),
    
    CF("CF"),
    
    TD("TD"),
    
    CL("CL"),
    
    CN("CN"),
    
    CX("CX"),
    
    CC("CC"),
    
    CO("CO"),
    
    KM("KM"),
    
    CG("CG"),
    
    CD("CD"),
    
    CK("CK"),
    
    CR("CR"),
    
    CI("CI"),
    
    HR("HR"),
    
    CU("CU"),
    
    CW("CW"),
    
    CY("CY"),
    
    CZ("CZ"),
    
    DK("DK"),
    
    DJ("DJ"),
    
    DM("DM"),
    
    DO("DO"),
    
    EC("EC"),
    
    EG("EG"),
    
    SV("SV"),
    
    GQ("GQ"),
    
    ER("ER"),
    
    EE("EE"),
    
    ET("ET"),
    
    FK("FK"),
    
    FO("FO"),
    
    FJ("FJ"),
    
    FI("FI"),
    
    FR("FR"),
    
    GF("GF"),
    
    PF("PF"),
    
    TF("TF"),
    
    GA("GA"),
    
    GM("GM"),
    
    GE("GE"),
    
    DE("DE"),
    
    GH("GH"),
    
    GI("GI"),
    
    GR("GR"),
    
    GL("GL"),
    
    GD("GD"),
    
    GP("GP"),
    
    GU("GU"),
    
    GT("GT"),
    
    GG("GG"),
    
    GN("GN"),
    
    GW("GW"),
    
    GY("GY"),
    
    HT("HT"),
    
    HM("HM"),
    
    VA("VA"),
    
    HN("HN"),
    
    HK("HK"),
    
    HU("HU"),
    
    IS("IS"),
    
    IN("IN"),
    
    ID("ID"),
    
    IR("IR"),
    
    IQ("IQ"),
    
    IE("IE"),
    
    IM("IM"),
    
    IL("IL"),
    
    IT("IT"),
    
    JM("JM"),
    
    JP("JP"),
    
    JE("JE"),
    
    JO("JO"),
    
    KZ("KZ"),
    
    KE("KE"),
    
    KI("KI"),
    
    KP("KP"),
    
    KR("KR"),
    
    KW("KW"),
    
    KG("KG"),
    
    LA("LA"),
    
    LV("LV"),
    
    LB("LB"),
    
    LS("LS"),
    
    LR("LR"),
    
    LY("LY"),
    
    LI("LI"),
    
    LT("LT"),
    
    LU("LU"),
    
    MO("MO"),
    
    MK("MK"),
    
    MG("MG"),
    
    MW("MW"),
    
    MY("MY"),
    
    MV("MV"),
    
    ML("ML"),
    
    MT("MT"),
    
    MH("MH"),
    
    MQ("MQ"),
    
    MR("MR"),
    
    MU("MU"),
    
    YT("YT"),
    
    MX("MX"),
    
    FM("FM"),
    
    MD("MD"),
    
    MC("MC"),
    
    MN("MN"),
    
    ME("ME"),
    
    MS("MS"),
    
    MA("MA"),
    
    MZ("MZ"),
    
    MM("MM"),
    
    NA("NA"),
    
    NR("NR"),
    
    NP("NP"),
    
    NL("NL"),
    
    NC("NC"),
    
    NZ("NZ"),
    
    NI("NI"),
    
    NE("NE"),
    
    NG("NG"),
    
    NU("NU"),
    
    NF("NF"),
    
    MP("MP"),
    
    NO("NO"),
    
    OM("OM"),
    
    PK("PK"),
    
    PW("PW"),
    
    PS("PS"),
    
    PA("PA"),
    
    PG("PG"),
    
    PY("PY"),
    
    PE("PE"),
    
    PH("PH"),
    
    PN("PN"),
    
    PL("PL"),
    
    PT("PT"),
    
    PR("PR"),
    
    QA("QA"),
    
    RE("RE"),
    
    RO("RO"),
    
    RU("RU"),
    
    RW("RW"),
    
    BL("BL"),
    
    SH("SH"),
    
    KN("KN"),
    
    LC("LC"),
    
    MF("MF"),
    
    PM("PM"),
    
    VC("VC"),
    
    WS("WS"),
    
    SM("SM"),
    
    ST("ST"),
    
    SA("SA"),
    
    SN("SN"),
    
    RS("RS"),
    
    SC("SC"),
    
    SL("SL"),
    
    SG("SG"),
    
    SX("SX"),
    
    SK("SK"),
    
    SI("SI"),
    
    SB("SB"),
    
    SO("SO"),
    
    ZA("ZA"),
    
    GS("GS"),
    
    SS("SS"),
    
    ES("ES"),
    
    LK("LK"),
    
    SD("SD"),
    
    SR("SR"),
    
    SJ("SJ"),
    
    SZ("SZ"),
    
    SE("SE"),
    
    CH("CH"),
    
    SY("SY"),
    
    TW("TW"),
    
    TJ("TJ"),
    
    TZ("TZ"),
    
    TH("TH"),
    
    TL("TL"),
    
    TG("TG"),
    
    TK("TK"),
    
    TO("TO"),
    
    TT("TT"),
    
    TN("TN"),
    
    TR("TR"),
    
    TM("TM"),
    
    TC("TC"),
    
    TV("TV"),
    
    UG("UG"),
    
    UA("UA"),
    
    AE("AE"),
    
    GB("GB"),
    
    US("US"),
    
    UM("UM"),
    
    UY("UY"),
    
    UZ("UZ"),
    
    VU("VU"),
    
    VE("VE"),
    
    VN("VN"),
    
    VG("VG"),
    
    VI("VI"),
    
    WF("WF"),
    
    EH("EH"),
    
    YE("YE"),
    
    ZM("ZM"),
    
    ZW("ZW");

    private String value;

    PaymentChannelCountryCodeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PaymentChannelCountryCodeEnum fromValue(String value) {
      for (PaymentChannelCountryCodeEnum b : PaymentChannelCountryCodeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PAYMENT_CHANNEL_COUNTRY_CODE = "paymentChannelCountryCode";
  private PaymentChannelCountryCodeEnum paymentChannelCountryCode;

  /**
   * Gets or Sets paymentChannelCurrency
   */
  public enum PaymentChannelCurrencyEnum {
    USD("USD"),
    
    GBP("GBP"),
    
    EUR("EUR");

    private String value;

    PaymentChannelCurrencyEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PaymentChannelCurrencyEnum fromValue(String value) {
      for (PaymentChannelCurrencyEnum b : PaymentChannelCurrencyEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PAYMENT_CHANNEL_CURRENCY = "paymentChannelCurrency";
  private PaymentChannelCurrencyEnum paymentChannelCurrency;

  public static final String JSON_PROPERTY_CHALLENGE_DESCRIPTION = "challengeDescription";
  private String challengeDescription;

  public static final String JSON_PROPERTY_CHALLENGE_VALUE = "challengeValue";
  private String challengeValue;

  /**
   * Gets or Sets payeeLanguage
   */
  public enum PayeeLanguageEnum {
    AR("AR"),
    
    EN("EN"),
    
    ES("ES"),
    
    FR("FR"),
    
    HE("HE"),
    
    HI("HI"),
    
    JA("JA"),
    
    PT("PT"),
    
    RU("RU"),
    
    UR("UR"),
    
    ZH("ZH");

    private String value;

    PayeeLanguageEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PayeeLanguageEnum fromValue(String value) {
      for (PayeeLanguageEnum b : PayeeLanguageEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PAYEE_LANGUAGE = "payeeLanguage";
  private PayeeLanguageEnum payeeLanguage;


  public CreatePayeesCSVRequest type(PayeeType type) {
    
    this.type = type;
    return this;
  }

   /**
   * Get type
   * @return type
  **/
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public PayeeType getType() {
    return type;
  }


  public void setType(PayeeType type) {
    this.type = type;
  }


  public CreatePayeesCSVRequest remoteId(String remoteId) {
    
    this.remoteId = remoteId;
    return this;
  }

   /**
   * Get remoteId
   * @return remoteId
  **/
  @NotNull
 @Size(min=1,max=100)  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_REMOTE_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getRemoteId() {
    return remoteId;
  }


  public void setRemoteId(String remoteId) {
    this.remoteId = remoteId;
  }


  public CreatePayeesCSVRequest email(String email) {
    
    this.email = email;
    return this;
  }

   /**
   * Get email
   * @return email
  **/
  @NotNull
 @Size(min=3,max=255)  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_EMAIL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getEmail() {
    return email;
  }


  public void setEmail(String email) {
    this.email = email;
  }


  public CreatePayeesCSVRequest addressLine1(String addressLine1) {
    
    this.addressLine1 = addressLine1;
    return this;
  }

   /**
   * Get addressLine1
   * @return addressLine1
  **/
  @NotNull
 @Size(min=2,max=100)  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_ADDRESS_LINE1)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getAddressLine1() {
    return addressLine1;
  }


  public void setAddressLine1(String addressLine1) {
    this.addressLine1 = addressLine1;
  }


  public CreatePayeesCSVRequest addressLine2(String addressLine2) {
    
    this.addressLine2 = addressLine2;
    return this;
  }

   /**
   * Get addressLine2
   * @return addressLine2
  **/
  @javax.annotation.Nullable
 @Size(min=0,max=100)  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ADDRESS_LINE2)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAddressLine2() {
    return addressLine2;
  }


  public void setAddressLine2(String addressLine2) {
    this.addressLine2 = addressLine2;
  }


  public CreatePayeesCSVRequest addressLine3(String addressLine3) {
    
    this.addressLine3 = addressLine3;
    return this;
  }

   /**
   * Get addressLine3
   * @return addressLine3
  **/
  @javax.annotation.Nullable
 @Size(min=0,max=100)  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ADDRESS_LINE3)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAddressLine3() {
    return addressLine3;
  }


  public void setAddressLine3(String addressLine3) {
    this.addressLine3 = addressLine3;
  }


  public CreatePayeesCSVRequest addressLine4(String addressLine4) {
    
    this.addressLine4 = addressLine4;
    return this;
  }

   /**
   * Get addressLine4
   * @return addressLine4
  **/
  @javax.annotation.Nullable
 @Size(min=0,max=100)  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ADDRESS_LINE4)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAddressLine4() {
    return addressLine4;
  }


  public void setAddressLine4(String addressLine4) {
    this.addressLine4 = addressLine4;
  }


  public CreatePayeesCSVRequest addressCity(String addressCity) {
    
    this.addressCity = addressCity;
    return this;
  }

   /**
   * Get addressCity
   * @return addressCity
  **/
  @NotNull
 @Size(min=2,max=50)  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_ADDRESS_CITY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getAddressCity() {
    return addressCity;
  }


  public void setAddressCity(String addressCity) {
    this.addressCity = addressCity;
  }


  public CreatePayeesCSVRequest addressCountyOrProvince(String addressCountyOrProvince) {
    
    this.addressCountyOrProvince = addressCountyOrProvince;
    return this;
  }

   /**
   * Get addressCountyOrProvince
   * @return addressCountyOrProvince
  **/
  @javax.annotation.Nullable
 @Size(min=1,max=50)  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ADDRESS_COUNTY_OR_PROVINCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAddressCountyOrProvince() {
    return addressCountyOrProvince;
  }


  public void setAddressCountyOrProvince(String addressCountyOrProvince) {
    this.addressCountyOrProvince = addressCountyOrProvince;
  }


  public CreatePayeesCSVRequest addressZipOrPostcode(String addressZipOrPostcode) {
    
    this.addressZipOrPostcode = addressZipOrPostcode;
    return this;
  }

   /**
   * Get addressZipOrPostcode
   * @return addressZipOrPostcode
  **/
  @NotNull
 @Size(min=1,max=60)  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_ADDRESS_ZIP_OR_POSTCODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getAddressZipOrPostcode() {
    return addressZipOrPostcode;
  }


  public void setAddressZipOrPostcode(String addressZipOrPostcode) {
    this.addressZipOrPostcode = addressZipOrPostcode;
  }


  public CreatePayeesCSVRequest addressCountry(String addressCountry) {
    
    this.addressCountry = addressCountry;
    return this;
  }

   /**
   * Ideally a 2 letter ISO 3166-1 country code.  But a limited set of additional values will be corrected.  See Java Locale.getISOCountries() and Locale.getDisplayCountry()
   * @return addressCountry
  **/
  @NotNull
 @Size(min=2,max=50)  @ApiModelProperty(required = true, value = "Ideally a 2 letter ISO 3166-1 country code.  But a limited set of additional values will be corrected.  See Java Locale.getISOCountries() and Locale.getDisplayCountry()")
  @JsonProperty(JSON_PROPERTY_ADDRESS_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getAddressCountry() {
    return addressCountry;
  }


  public void setAddressCountry(String addressCountry) {
    this.addressCountry = addressCountry;
  }


  public CreatePayeesCSVRequest individualNationalIdentification(String individualNationalIdentification) {
    
    this.individualNationalIdentification = individualNationalIdentification;
    return this;
  }

   /**
   * Get individualNationalIdentification
   * @return individualNationalIdentification
  **/
  @javax.annotation.Nullable
 @Size(min=6,max=30)  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_INDIVIDUAL_NATIONAL_IDENTIFICATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getIndividualNationalIdentification() {
    return individualNationalIdentification;
  }


  public void setIndividualNationalIdentification(String individualNationalIdentification) {
    this.individualNationalIdentification = individualNationalIdentification;
  }


  public CreatePayeesCSVRequest individualDateOfBirth(LocalDate individualDateOfBirth) {
    
    this.individualDateOfBirth = individualDateOfBirth;
    return this;
  }

   /**
   * Must not be date in future. Example - 1970-05-20
   * @return individualDateOfBirth
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Must not be date in future. Example - 1970-05-20")
  @JsonProperty(JSON_PROPERTY_INDIVIDUAL_DATE_OF_BIRTH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalDate getIndividualDateOfBirth() {
    return individualDateOfBirth;
  }


  public void setIndividualDateOfBirth(LocalDate individualDateOfBirth) {
    this.individualDateOfBirth = individualDateOfBirth;
  }


  public CreatePayeesCSVRequest individualTitle(String individualTitle) {
    
    this.individualTitle = individualTitle;
    return this;
  }

   /**
   * Get individualTitle
   * @return individualTitle
  **/
  @javax.annotation.Nullable
 @Size(min=1,max=40)  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_INDIVIDUAL_TITLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getIndividualTitle() {
    return individualTitle;
  }


  public void setIndividualTitle(String individualTitle) {
    this.individualTitle = individualTitle;
  }


  public CreatePayeesCSVRequest individualFirstName(String individualFirstName) {
    
    this.individualFirstName = individualFirstName;
    return this;
  }

   /**
   * Get individualFirstName
   * @return individualFirstName
  **/
  @javax.annotation.Nullable
 @Size(min=1,max=40)  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_INDIVIDUAL_FIRST_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getIndividualFirstName() {
    return individualFirstName;
  }


  public void setIndividualFirstName(String individualFirstName) {
    this.individualFirstName = individualFirstName;
  }


  public CreatePayeesCSVRequest individualOtherNames(String individualOtherNames) {
    
    this.individualOtherNames = individualOtherNames;
    return this;
  }

   /**
   * Get individualOtherNames
   * @return individualOtherNames
  **/
  @javax.annotation.Nullable
 @Size(min=1,max=40)  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_INDIVIDUAL_OTHER_NAMES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getIndividualOtherNames() {
    return individualOtherNames;
  }


  public void setIndividualOtherNames(String individualOtherNames) {
    this.individualOtherNames = individualOtherNames;
  }


  public CreatePayeesCSVRequest individualLastName(String individualLastName) {
    
    this.individualLastName = individualLastName;
    return this;
  }

   /**
   * Get individualLastName
   * @return individualLastName
  **/
  @javax.annotation.Nullable
 @Size(min=1,max=40)  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_INDIVIDUAL_LAST_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getIndividualLastName() {
    return individualLastName;
  }


  public void setIndividualLastName(String individualLastName) {
    this.individualLastName = individualLastName;
  }


  public CreatePayeesCSVRequest companyName(String companyName) {
    
    this.companyName = companyName;
    return this;
  }

   /**
   * Get companyName
   * @return companyName
  **/
  @javax.annotation.Nullable
 @Size(min=1,max=40)  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_COMPANY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCompanyName() {
    return companyName;
  }


  public void setCompanyName(String companyName) {
    this.companyName = companyName;
  }


  public CreatePayeesCSVRequest companyEIN(String companyEIN) {
    
    this.companyEIN = companyEIN;
    return this;
  }

   /**
   * Company Tax Id (EIN) must be 9 numeric characters. Must match the regular expression &#x60;&#x60;&#x60;[\\d]{9}&#x60;&#x60;&#x60;.
   * @return companyEIN
  **/
  @javax.annotation.Nullable
 @Pattern(regexp="[\\\\d]{9}")  @ApiModelProperty(value = "Company Tax Id (EIN) must be 9 numeric characters. Must match the regular expression ```[\\d]{9}```.")
  @JsonProperty(JSON_PROPERTY_COMPANY_E_I_N)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCompanyEIN() {
    return companyEIN;
  }


  public void setCompanyEIN(String companyEIN) {
    this.companyEIN = companyEIN;
  }


  public CreatePayeesCSVRequest companyOperatingName(String companyOperatingName) {
    
    this.companyOperatingName = companyOperatingName;
    return this;
  }

   /**
   * Get companyOperatingName
   * @return companyOperatingName
  **/
  @javax.annotation.Nullable
 @Size(min=1,max=100)  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_COMPANY_OPERATING_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCompanyOperatingName() {
    return companyOperatingName;
  }


  public void setCompanyOperatingName(String companyOperatingName) {
    this.companyOperatingName = companyOperatingName;
  }


  public CreatePayeesCSVRequest paymentChannelAccountNumber(String paymentChannelAccountNumber) {
    
    this.paymentChannelAccountNumber = paymentChannelAccountNumber;
    return this;
  }

   /**
   * Either routing number and account number or only iban must be set
   * @return paymentChannelAccountNumber
  **/
  @javax.annotation.Nullable
 @Size(min=6,max=17)  @ApiModelProperty(value = "Either routing number and account number or only iban must be set")
  @JsonProperty(JSON_PROPERTY_PAYMENT_CHANNEL_ACCOUNT_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPaymentChannelAccountNumber() {
    return paymentChannelAccountNumber;
  }


  public void setPaymentChannelAccountNumber(String paymentChannelAccountNumber) {
    this.paymentChannelAccountNumber = paymentChannelAccountNumber;
  }


  public CreatePayeesCSVRequest paymentChannelRoutingNumber(String paymentChannelRoutingNumber) {
    
    this.paymentChannelRoutingNumber = paymentChannelRoutingNumber;
    return this;
  }

   /**
   * Either routing number and account number or only iban must be set
   * @return paymentChannelRoutingNumber
  **/
  @javax.annotation.Nullable
 @Size(min=9,max=9)  @ApiModelProperty(value = "Either routing number and account number or only iban must be set")
  @JsonProperty(JSON_PROPERTY_PAYMENT_CHANNEL_ROUTING_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPaymentChannelRoutingNumber() {
    return paymentChannelRoutingNumber;
  }


  public void setPaymentChannelRoutingNumber(String paymentChannelRoutingNumber) {
    this.paymentChannelRoutingNumber = paymentChannelRoutingNumber;
  }


  public CreatePayeesCSVRequest paymentChannelAccountName(String paymentChannelAccountName) {
    
    this.paymentChannelAccountName = paymentChannelAccountName;
    return this;
  }

   /**
   * Get paymentChannelAccountName
   * @return paymentChannelAccountName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PAYMENT_CHANNEL_ACCOUNT_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPaymentChannelAccountName() {
    return paymentChannelAccountName;
  }


  public void setPaymentChannelAccountName(String paymentChannelAccountName) {
    this.paymentChannelAccountName = paymentChannelAccountName;
  }


  public CreatePayeesCSVRequest paymentChannelIban(String paymentChannelIban) {
    
    this.paymentChannelIban = paymentChannelIban;
    return this;
  }

   /**
   * Must match the regular expression &#x60;&#x60;&#x60;^[A-Za-z0-9]+$&#x60;&#x60;&#x60;.
   * @return paymentChannelIban
  **/
  @javax.annotation.Nullable
 @Pattern(regexp="^[A-Za-z0-9]+$") @Size(min=15,max=34)  @ApiModelProperty(value = "Must match the regular expression ```^[A-Za-z0-9]+$```.")
  @JsonProperty(JSON_PROPERTY_PAYMENT_CHANNEL_IBAN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPaymentChannelIban() {
    return paymentChannelIban;
  }


  public void setPaymentChannelIban(String paymentChannelIban) {
    this.paymentChannelIban = paymentChannelIban;
  }


  public CreatePayeesCSVRequest paymentChannelCountryCode(PaymentChannelCountryCodeEnum paymentChannelCountryCode) {
    
    this.paymentChannelCountryCode = paymentChannelCountryCode;
    return this;
  }

   /**
   * Must be a 2 character country code - per ISO 3166-1
   * @return paymentChannelCountryCode
  **/
  @javax.annotation.Nullable
 @Size(min=2,max=2)  @ApiModelProperty(value = "Must be a 2 character country code - per ISO 3166-1")
  @JsonProperty(JSON_PROPERTY_PAYMENT_CHANNEL_COUNTRY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PaymentChannelCountryCodeEnum getPaymentChannelCountryCode() {
    return paymentChannelCountryCode;
  }


  public void setPaymentChannelCountryCode(PaymentChannelCountryCodeEnum paymentChannelCountryCode) {
    this.paymentChannelCountryCode = paymentChannelCountryCode;
  }


  public CreatePayeesCSVRequest paymentChannelCurrency(PaymentChannelCurrencyEnum paymentChannelCurrency) {
    
    this.paymentChannelCurrency = paymentChannelCurrency;
    return this;
  }

   /**
   * Get paymentChannelCurrency
   * @return paymentChannelCurrency
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PAYMENT_CHANNEL_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PaymentChannelCurrencyEnum getPaymentChannelCurrency() {
    return paymentChannelCurrency;
  }


  public void setPaymentChannelCurrency(PaymentChannelCurrencyEnum paymentChannelCurrency) {
    this.paymentChannelCurrency = paymentChannelCurrency;
  }


  public CreatePayeesCSVRequest challengeDescription(String challengeDescription) {
    
    this.challengeDescription = challengeDescription;
    return this;
  }

   /**
   * Get challengeDescription
   * @return challengeDescription
  **/
  @javax.annotation.Nullable
 @Size(min=1,max=255)  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CHALLENGE_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getChallengeDescription() {
    return challengeDescription;
  }


  public void setChallengeDescription(String challengeDescription) {
    this.challengeDescription = challengeDescription;
  }


  public CreatePayeesCSVRequest challengeValue(String challengeValue) {
    
    this.challengeValue = challengeValue;
    return this;
  }

   /**
   * Get challengeValue
   * @return challengeValue
  **/
  @javax.annotation.Nullable
 @Size(min=3,max=20)  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CHALLENGE_VALUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getChallengeValue() {
    return challengeValue;
  }


  public void setChallengeValue(String challengeValue) {
    this.challengeValue = challengeValue;
  }


  public CreatePayeesCSVRequest payeeLanguage(PayeeLanguageEnum payeeLanguage) {
    
    this.payeeLanguage = payeeLanguage;
    return this;
  }

   /**
   * Get payeeLanguage
   * @return payeeLanguage
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PAYEE_LANGUAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PayeeLanguageEnum getPayeeLanguage() {
    return payeeLanguage;
  }


  public void setPayeeLanguage(PayeeLanguageEnum payeeLanguage) {
    this.payeeLanguage = payeeLanguage;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CreatePayeesCSVRequest createPayeesCSVRequest = (CreatePayeesCSVRequest) o;
    return Objects.equals(this.type, createPayeesCSVRequest.type) &&
        Objects.equals(this.remoteId, createPayeesCSVRequest.remoteId) &&
        Objects.equals(this.email, createPayeesCSVRequest.email) &&
        Objects.equals(this.addressLine1, createPayeesCSVRequest.addressLine1) &&
        Objects.equals(this.addressLine2, createPayeesCSVRequest.addressLine2) &&
        Objects.equals(this.addressLine3, createPayeesCSVRequest.addressLine3) &&
        Objects.equals(this.addressLine4, createPayeesCSVRequest.addressLine4) &&
        Objects.equals(this.addressCity, createPayeesCSVRequest.addressCity) &&
        Objects.equals(this.addressCountyOrProvince, createPayeesCSVRequest.addressCountyOrProvince) &&
        Objects.equals(this.addressZipOrPostcode, createPayeesCSVRequest.addressZipOrPostcode) &&
        Objects.equals(this.addressCountry, createPayeesCSVRequest.addressCountry) &&
        Objects.equals(this.individualNationalIdentification, createPayeesCSVRequest.individualNationalIdentification) &&
        Objects.equals(this.individualDateOfBirth, createPayeesCSVRequest.individualDateOfBirth) &&
        Objects.equals(this.individualTitle, createPayeesCSVRequest.individualTitle) &&
        Objects.equals(this.individualFirstName, createPayeesCSVRequest.individualFirstName) &&
        Objects.equals(this.individualOtherNames, createPayeesCSVRequest.individualOtherNames) &&
        Objects.equals(this.individualLastName, createPayeesCSVRequest.individualLastName) &&
        Objects.equals(this.companyName, createPayeesCSVRequest.companyName) &&
        Objects.equals(this.companyEIN, createPayeesCSVRequest.companyEIN) &&
        Objects.equals(this.companyOperatingName, createPayeesCSVRequest.companyOperatingName) &&
        Objects.equals(this.paymentChannelAccountNumber, createPayeesCSVRequest.paymentChannelAccountNumber) &&
        Objects.equals(this.paymentChannelRoutingNumber, createPayeesCSVRequest.paymentChannelRoutingNumber) &&
        Objects.equals(this.paymentChannelAccountName, createPayeesCSVRequest.paymentChannelAccountName) &&
        Objects.equals(this.paymentChannelIban, createPayeesCSVRequest.paymentChannelIban) &&
        Objects.equals(this.paymentChannelCountryCode, createPayeesCSVRequest.paymentChannelCountryCode) &&
        Objects.equals(this.paymentChannelCurrency, createPayeesCSVRequest.paymentChannelCurrency) &&
        Objects.equals(this.challengeDescription, createPayeesCSVRequest.challengeDescription) &&
        Objects.equals(this.challengeValue, createPayeesCSVRequest.challengeValue) &&
        Objects.equals(this.payeeLanguage, createPayeesCSVRequest.payeeLanguage);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, remoteId, email, addressLine1, addressLine2, addressLine3, addressLine4, addressCity, addressCountyOrProvince, addressZipOrPostcode, addressCountry, individualNationalIdentification, individualDateOfBirth, individualTitle, individualFirstName, individualOtherNames, individualLastName, companyName, companyEIN, companyOperatingName, paymentChannelAccountNumber, paymentChannelRoutingNumber, paymentChannelAccountName, paymentChannelIban, paymentChannelCountryCode, paymentChannelCurrency, challengeDescription, challengeValue, payeeLanguage);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CreatePayeesCSVRequest {\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    remoteId: ").append(toIndentedString(remoteId)).append("\n");
    sb.append("    email: ").append(toIndentedString(email)).append("\n");
    sb.append("    addressLine1: ").append(toIndentedString(addressLine1)).append("\n");
    sb.append("    addressLine2: ").append(toIndentedString(addressLine2)).append("\n");
    sb.append("    addressLine3: ").append(toIndentedString(addressLine3)).append("\n");
    sb.append("    addressLine4: ").append(toIndentedString(addressLine4)).append("\n");
    sb.append("    addressCity: ").append(toIndentedString(addressCity)).append("\n");
    sb.append("    addressCountyOrProvince: ").append(toIndentedString(addressCountyOrProvince)).append("\n");
    sb.append("    addressZipOrPostcode: ").append(toIndentedString(addressZipOrPostcode)).append("\n");
    sb.append("    addressCountry: ").append(toIndentedString(addressCountry)).append("\n");
    sb.append("    individualNationalIdentification: ").append(toIndentedString(individualNationalIdentification)).append("\n");
    sb.append("    individualDateOfBirth: ").append(toIndentedString(individualDateOfBirth)).append("\n");
    sb.append("    individualTitle: ").append(toIndentedString(individualTitle)).append("\n");
    sb.append("    individualFirstName: ").append(toIndentedString(individualFirstName)).append("\n");
    sb.append("    individualOtherNames: ").append(toIndentedString(individualOtherNames)).append("\n");
    sb.append("    individualLastName: ").append(toIndentedString(individualLastName)).append("\n");
    sb.append("    companyName: ").append(toIndentedString(companyName)).append("\n");
    sb.append("    companyEIN: ").append(toIndentedString(companyEIN)).append("\n");
    sb.append("    companyOperatingName: ").append(toIndentedString(companyOperatingName)).append("\n");
    sb.append("    paymentChannelAccountNumber: ").append(toIndentedString(paymentChannelAccountNumber)).append("\n");
    sb.append("    paymentChannelRoutingNumber: ").append(toIndentedString(paymentChannelRoutingNumber)).append("\n");
    sb.append("    paymentChannelAccountName: ").append(toIndentedString(paymentChannelAccountName)).append("\n");
    sb.append("    paymentChannelIban: ").append(toIndentedString(paymentChannelIban)).append("\n");
    sb.append("    paymentChannelCountryCode: ").append(toIndentedString(paymentChannelCountryCode)).append("\n");
    sb.append("    paymentChannelCurrency: ").append(toIndentedString(paymentChannelCurrency)).append("\n");
    sb.append("    challengeDescription: ").append(toIndentedString(challengeDescription)).append("\n");
    sb.append("    challengeValue: ").append(toIndentedString(challengeValue)).append("\n");
    sb.append("    payeeLanguage: ").append(toIndentedString(payeeLanguage)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

