/*
 * Velo Payments APIs
 * ## Terms and Definitions  Throughout this document and the Velo platform the following terms are used:  * **Payor.** An entity (typically a corporation) which wishes to pay funds to one or more payees via a payout. * **Payee.** The recipient of funds paid out by a payor. * **Payment.** A single transfer of funds from a payor to a payee. * **Payout.** A batch of Payments, typically used by a payor to logically group payments (e.g. by business day). Technically there need be no relationship between the payments in a payout - a single payout can contain payments to multiple payees and/or multiple payments to a single payee. * **Sandbox.** An integration environment provided by Velo Payments which offers a similar API experience to the production environment, but all funding and payment events are simulated, along with many other services such as OFAC sanctions list checking.  ## Overview  The Velo Payments API allows a payor to perform a number of operations. The following is a list of the main capabilities in a natural order of execution:  * Authenticate with the Velo platform * Maintain a collection of payees * Query the payor’s current balance of funds within the platform and perform additional funding * Issue payments to payees * Query the platform for a history of those payments  This document describes the main concepts and APIs required to get up and running with the Velo Payments platform. It is not an exhaustive API reference. For that, please see the separate Velo Payments API Reference.  ## API Considerations  The Velo Payments API is REST based and uses the JSON format for requests and responses.  Most calls are secured using OAuth 2 security and require a valid authentication access token for successful operation. See the Authentication section for details.  Where a dynamic value is required in the examples below, the {token} format is used, suggesting that the caller needs to supply the appropriate value of the token in question (without including the { or } characters).  Where curl examples are given, the –d @filename.json approach is used, indicating that the request body should be placed into a file named filename.json in the current directory. Each of the curl examples in this document should be considered a single line on the command-line, regardless of how they appear in print.  ## Authenticating with the Velo Platform  Once Velo backoffice staff have added your organization as a payor within the Velo platform sandbox, they will create you a payor Id, an API key and an API secret and share these with you in a secure manner.  You will need to use these values to authenticate with the Velo platform in order to gain access to the APIs. The steps to take are explained in the following:  create a string comprising the API key (e.g. 44a9537d-d55d-4b47-8082-14061c2bcdd8) and API secret (e.g. c396b26b-137a-44fd-87f5-34631f8fd529) with a colon between them. E.g. 44a9537d-d55d-4b47-8082-14061c2bcdd8:c396b26b-137a-44fd-87f5-34631f8fd529  base64 encode this string. E.g.: NDRhOTUzN2QtZDU1ZC00YjQ3LTgwODItMTQwNjFjMmJjZGQ4OmMzOTZiMjZiLTEzN2EtNDRmZC04N2Y1LTM0NjMxZjhmZDUyOQ==  create an HTTP **Authorization** header with the value set to e.g. Basic NDRhOTUzN2QtZDU1ZC00YjQ3LTgwODItMTQwNjFjMmJjZGQ4OmMzOTZiMjZiLTEzN2EtNDRmZC04N2Y1LTM0NjMxZjhmZDUyOQ==  perform the Velo authentication REST call using the HTTP header created above e.g. via curl:  ```   curl -X POST \\   -H \"Content-Type: application/json\" \\   -H \"Authorization: Basic NDRhOTUzN2QtZDU1ZC00YjQ3LTgwODItMTQwNjFjMmJjZGQ4OmMzOTZiMjZiLTEzN2EtNDRmZC04N2Y1LTM0NjMxZjhmZDUyOQ==\" \\   'https://api.sandbox.velopayments.com/v1/authenticate?grant_type=client_credentials' ```  If successful, this call will result in a **200** HTTP status code and a response body such as:  ```   {     \"access_token\":\"19f6bafd-93fd-4747-b229-00507bbc991f\",     \"token_type\":\"bearer\",     \"expires_in\":1799,     \"scope\":\"...\"   } ``` ## API access following authentication Following successful authentication, the value of the access_token field in the response (indicated in green above) should then be presented with all subsequent API calls to allow the Velo platform to validate that the caller is authenticated.  This is achieved by setting the HTTP Authorization header with the value set to e.g. Bearer 19f6bafd-93fd-4747-b229-00507bbc991f such as the curl example below:  ```   -H \"Authorization: Bearer 19f6bafd-93fd-4747-b229-00507bbc991f \" ```  If you make other Velo API calls which require authorization but the Authorization header is missing or invalid then you will get a **401** HTTP status response. 
 *
 * The version of the OpenAPI document: 2.18.113
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.velopayments.oa3.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.velopayments.oa3.model.PaymentAuditCurrencyV4;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.UUID;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import javax.validation.constraints.*;
import javax.validation.Valid;

/**
 * PaymentEventResponseV4
 */
@JsonPropertyOrder({
  PaymentEventResponseV4.JSON_PROPERTY_EVENT_ID,
  PaymentEventResponseV4.JSON_PROPERTY_EVENT_DATE_TIME,
  PaymentEventResponseV4.JSON_PROPERTY_EVENT_TYPE,
  PaymentEventResponseV4.JSON_PROPERTY_SOURCE_CURRENCY,
  PaymentEventResponseV4.JSON_PROPERTY_SOURCE_AMOUNT,
  PaymentEventResponseV4.JSON_PROPERTY_PAYMENT_CURRENCY,
  PaymentEventResponseV4.JSON_PROPERTY_PAYMENT_AMOUNT,
  PaymentEventResponseV4.JSON_PROPERTY_ACCOUNT_NUMBER,
  PaymentEventResponseV4.JSON_PROPERTY_ROUTING_NUMBER,
  PaymentEventResponseV4.JSON_PROPERTY_IBAN,
  PaymentEventResponseV4.JSON_PROPERTY_ACCOUNT_NAME,
  PaymentEventResponseV4.JSON_PROPERTY_PRINCIPAL
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-01-15T12:59:39.508953-05:00[America/New_York]")
public class PaymentEventResponseV4 {
  public static final String JSON_PROPERTY_EVENT_ID = "eventId";
  private UUID eventId;

  public static final String JSON_PROPERTY_EVENT_DATE_TIME = "eventDateTime";
  private OffsetDateTime eventDateTime;

  /**
   * The type of the event.
   */
  public enum EventTypeEnum {
    PAYOUT_SUBMITTED("PAYOUT_SUBMITTED"),
    
    PAYOUT_COMPLETED("PAYOUT_COMPLETED"),
    
    PAYOUT_INSTRUCTED_V3("PAYOUT_INSTRUCTED_V3"),
    
    BANK_PAYMENT_REQUESTED("BANK_PAYMENT_REQUESTED"),
    
    SOURCE_AMOUNT_CONFIRMED("SOURCE_AMOUNT_CONFIRMED"),
    
    PAYMENT_SUBMITTED("PAYMENT_SUBMITTED"),
    
    PAYMENT_SUBMITTED_ACCEPTED("PAYMENT_SUBMITTED_ACCEPTED"),
    
    PAYMENT_SUBMITTED_REJECTED("PAYMENT_SUBMITTED_REJECTED"),
    
    PAYMENT_CONFIRMED("PAYMENT_CONFIRMED"),
    
    PAYMENT_AWAITING_FUNDS("PAYMENT_AWAITING_FUNDS"),
    
    PAYMENT_FUNDED("PAYMENT_FUNDED"),
    
    PAYMENT_UNFUNDED("PAYMENT_UNFUNDED"),
    
    PAYMENT_FAILED("PAYMENT_FAILED"),
    
    ACH_SUBMITTED_TO_ODFI("ACH_SUBMITTED_TO_ODFI"),
    
    PAYMENT_ACCEPTED_BY_RAILS("PAYMENT_ACCEPTED_BY_RAILS"),
    
    ACH_RETURN_RECEIVED("ACH_RETURN_RECEIVED"),
    
    RETURN_PAYMENT_FUNDING_REQUESTED("RETURN_PAYMENT_FUNDING_REQUESTED"),
    
    PAYOUT_BATCH_EXECUTED("PAYOUT_BATCH_EXECUTED"),
    
    PAYOUT_BATCH_QUOTE_EXPIRED("PAYOUT_BATCH_QUOTE_EXPIRED"),
    
    PAYOUT_BATCH_FUNDED("PAYOUT_BATCH_FUNDED"),
    
    PAYOUT_BATCH_FUNDS_RETURN_REQUEST("PAYOUT_BATCH_FUNDS_RETURN_REQUEST"),
    
    PAYOUT_BATCH_FUNDS_RETURNED("PAYOUT_BATCH_FUNDS_RETURNED"),
    
    PAYOUT_FUNDS_REQUEST("PAYOUT_FUNDS_REQUEST"),
    
    PAYOUT_FUNDS_GRANTED("PAYOUT_FUNDS_GRANTED"),
    
    PAYOUT_FUNDS_DENIED("PAYOUT_FUNDS_DENIED"),
    
    PAYOUT_BATCH_QUOTED("PAYOUT_BATCH_QUOTED"),
    
    PAYOUT_QUOTED("PAYOUT_QUOTED"),
    
    ACH_PAYMENT_RETURN_CANCELLED("ACH_PAYMENT_RETURN_CANCELLED"),
    
    RETURN_PAYMENT_CANCELLATION_REQUESTED("RETURN_PAYMENT_CANCELLATION_REQUESTED"),
    
    PAYOUT_WITHDRAWN("PAYOUT_WITHDRAWN");

    private String value;

    EventTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static EventTypeEnum fromValue(String value) {
      for (EventTypeEnum b : EventTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_EVENT_TYPE = "eventType";
  private EventTypeEnum eventType;

  public static final String JSON_PROPERTY_SOURCE_CURRENCY = "sourceCurrency";
  private PaymentAuditCurrencyV4 sourceCurrency;

  public static final String JSON_PROPERTY_SOURCE_AMOUNT = "sourceAmount";
  private Long sourceAmount;

  public static final String JSON_PROPERTY_PAYMENT_CURRENCY = "paymentCurrency";
  private PaymentAuditCurrencyV4 paymentCurrency;

  public static final String JSON_PROPERTY_PAYMENT_AMOUNT = "paymentAmount";
  private Long paymentAmount;

  public static final String JSON_PROPERTY_ACCOUNT_NUMBER = "accountNumber";
  private String accountNumber;

  public static final String JSON_PROPERTY_ROUTING_NUMBER = "routingNumber";
  private String routingNumber;

  public static final String JSON_PROPERTY_IBAN = "iban";
  private String iban;

  public static final String JSON_PROPERTY_ACCOUNT_NAME = "accountName";
  private String accountName;

  public static final String JSON_PROPERTY_PRINCIPAL = "principal";
  private String principal;


  public PaymentEventResponseV4 eventId(UUID eventId) {
    
    this.eventId = eventId;
    return this;
  }

   /**
   * The id of the event.
   * @return eventId
  **/
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "The id of the event.")
  @JsonProperty(JSON_PROPERTY_EVENT_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getEventId() {
    return eventId;
  }


  public void setEventId(UUID eventId) {
    this.eventId = eventId;
  }


  public PaymentEventResponseV4 eventDateTime(OffsetDateTime eventDateTime) {
    
    this.eventDateTime = eventDateTime;
    return this;
  }

   /**
   * The date/time at which the event occurred.
   * @return eventDateTime
  **/
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "The date/time at which the event occurred.")
  @JsonProperty(JSON_PROPERTY_EVENT_DATE_TIME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public OffsetDateTime getEventDateTime() {
    return eventDateTime;
  }


  public void setEventDateTime(OffsetDateTime eventDateTime) {
    this.eventDateTime = eventDateTime;
  }


  public PaymentEventResponseV4 eventType(EventTypeEnum eventType) {
    
    this.eventType = eventType;
    return this;
  }

   /**
   * The type of the event.
   * @return eventType
  **/
  @NotNull
  @ApiModelProperty(required = true, value = "The type of the event.")
  @JsonProperty(JSON_PROPERTY_EVENT_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public EventTypeEnum getEventType() {
    return eventType;
  }


  public void setEventType(EventTypeEnum eventType) {
    this.eventType = eventType;
  }


  public PaymentEventResponseV4 sourceCurrency(PaymentAuditCurrencyV4 sourceCurrency) {
    
    this.sourceCurrency = sourceCurrency;
    return this;
  }

   /**
   * Get sourceCurrency
   * @return sourceCurrency
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SOURCE_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PaymentAuditCurrencyV4 getSourceCurrency() {
    return sourceCurrency;
  }


  public void setSourceCurrency(PaymentAuditCurrencyV4 sourceCurrency) {
    this.sourceCurrency = sourceCurrency;
  }


  public PaymentEventResponseV4 sourceAmount(Long sourceAmount) {
    
    this.sourceAmount = sourceAmount;
    return this;
  }

   /**
   * The source amount exposed by the event.
   * @return sourceAmount
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "1299", value = "The source amount exposed by the event.")
  @JsonProperty(JSON_PROPERTY_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getSourceAmount() {
    return sourceAmount;
  }


  public void setSourceAmount(Long sourceAmount) {
    this.sourceAmount = sourceAmount;
  }


  public PaymentEventResponseV4 paymentCurrency(PaymentAuditCurrencyV4 paymentCurrency) {
    
    this.paymentCurrency = paymentCurrency;
    return this;
  }

   /**
   * Get paymentCurrency
   * @return paymentCurrency
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PAYMENT_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PaymentAuditCurrencyV4 getPaymentCurrency() {
    return paymentCurrency;
  }


  public void setPaymentCurrency(PaymentAuditCurrencyV4 paymentCurrency) {
    this.paymentCurrency = paymentCurrency;
  }


  public PaymentEventResponseV4 paymentAmount(Long paymentAmount) {
    
    this.paymentAmount = paymentAmount;
    return this;
  }

   /**
   * The destination amount exposed by the event.
   * @return paymentAmount
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "1299", value = "The destination amount exposed by the event.")
  @JsonProperty(JSON_PROPERTY_PAYMENT_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getPaymentAmount() {
    return paymentAmount;
  }


  public void setPaymentAmount(Long paymentAmount) {
    this.paymentAmount = paymentAmount;
  }


  public PaymentEventResponseV4 accountNumber(String accountNumber) {
    
    this.accountNumber = accountNumber;
    return this;
  }

   /**
   * The account number attached to the event.
   * @return accountNumber
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The account number attached to the event.")
  @JsonProperty(JSON_PROPERTY_ACCOUNT_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAccountNumber() {
    return accountNumber;
  }


  public void setAccountNumber(String accountNumber) {
    this.accountNumber = accountNumber;
  }


  public PaymentEventResponseV4 routingNumber(String routingNumber) {
    
    this.routingNumber = routingNumber;
    return this;
  }

   /**
   * The routing number attached to the event.
   * @return routingNumber
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The routing number attached to the event.")
  @JsonProperty(JSON_PROPERTY_ROUTING_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRoutingNumber() {
    return routingNumber;
  }


  public void setRoutingNumber(String routingNumber) {
    this.routingNumber = routingNumber;
  }


  public PaymentEventResponseV4 iban(String iban) {
    
    this.iban = iban;
    return this;
  }

   /**
   * Get iban
   * @return iban
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_IBAN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getIban() {
    return iban;
  }


  public void setIban(String iban) {
    this.iban = iban;
  }


  public PaymentEventResponseV4 accountName(String accountName) {
    
    this.accountName = accountName;
    return this;
  }

   /**
   * Get accountName
   * @return accountName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ACCOUNT_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAccountName() {
    return accountName;
  }


  public void setAccountName(String accountName) {
    this.accountName = accountName;
  }


  public PaymentEventResponseV4 principal(String principal) {
    
    this.principal = principal;
    return this;
  }

   /**
   * Get principal
   * @return principal
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PRINCIPAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPrincipal() {
    return principal;
  }


  public void setPrincipal(String principal) {
    this.principal = principal;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PaymentEventResponseV4 paymentEventResponseV4 = (PaymentEventResponseV4) o;
    return Objects.equals(this.eventId, paymentEventResponseV4.eventId) &&
        Objects.equals(this.eventDateTime, paymentEventResponseV4.eventDateTime) &&
        Objects.equals(this.eventType, paymentEventResponseV4.eventType) &&
        Objects.equals(this.sourceCurrency, paymentEventResponseV4.sourceCurrency) &&
        Objects.equals(this.sourceAmount, paymentEventResponseV4.sourceAmount) &&
        Objects.equals(this.paymentCurrency, paymentEventResponseV4.paymentCurrency) &&
        Objects.equals(this.paymentAmount, paymentEventResponseV4.paymentAmount) &&
        Objects.equals(this.accountNumber, paymentEventResponseV4.accountNumber) &&
        Objects.equals(this.routingNumber, paymentEventResponseV4.routingNumber) &&
        Objects.equals(this.iban, paymentEventResponseV4.iban) &&
        Objects.equals(this.accountName, paymentEventResponseV4.accountName) &&
        Objects.equals(this.principal, paymentEventResponseV4.principal);
  }

  @Override
  public int hashCode() {
    return Objects.hash(eventId, eventDateTime, eventType, sourceCurrency, sourceAmount, paymentCurrency, paymentAmount, accountNumber, routingNumber, iban, accountName, principal);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PaymentEventResponseV4 {\n");
    sb.append("    eventId: ").append(toIndentedString(eventId)).append("\n");
    sb.append("    eventDateTime: ").append(toIndentedString(eventDateTime)).append("\n");
    sb.append("    eventType: ").append(toIndentedString(eventType)).append("\n");
    sb.append("    sourceCurrency: ").append(toIndentedString(sourceCurrency)).append("\n");
    sb.append("    sourceAmount: ").append(toIndentedString(sourceAmount)).append("\n");
    sb.append("    paymentCurrency: ").append(toIndentedString(paymentCurrency)).append("\n");
    sb.append("    paymentAmount: ").append(toIndentedString(paymentAmount)).append("\n");
    sb.append("    accountNumber: ").append(toIndentedString(accountNumber)).append("\n");
    sb.append("    routingNumber: ").append(toIndentedString(routingNumber)).append("\n");
    sb.append("    iban: ").append(toIndentedString(iban)).append("\n");
    sb.append("    accountName: ").append(toIndentedString(accountName)).append("\n");
    sb.append("    principal: ").append(toIndentedString(principal)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

