/*
 * Velo Payments APIs
 * ## Terms and Definitions  Throughout this document and the Velo platform the following terms are used:  * **Payor.** An entity (typically a corporation) which wishes to pay funds to one or more payees via a payout. * **Payee.** The recipient of funds paid out by a payor. * **Payment.** A single transfer of funds from a payor to a payee. * **Payout.** A batch of Payments, typically used by a payor to logically group payments (e.g. by business day). Technically there need be no relationship between the payments in a payout - a single payout can contain payments to multiple payees and/or multiple payments to a single payee. * **Sandbox.** An integration environment provided by Velo Payments which offers a similar API experience to the production environment, but all funding and payment events are simulated, along with many other services such as OFAC sanctions list checking.  ## Overview  The Velo Payments API allows a payor to perform a number of operations. The following is a list of the main capabilities in a natural order of execution:  * Authenticate with the Velo platform * Maintain a collection of payees * Query the payor’s current balance of funds within the platform and perform additional funding * Issue payments to payees * Query the platform for a history of those payments  This document describes the main concepts and APIs required to get up and running with the Velo Payments platform. It is not an exhaustive API reference. For that, please see the separate Velo Payments API Reference.  ## API Considerations  The Velo Payments API is REST based and uses the JSON format for requests and responses.  Most calls are secured using OAuth 2 security and require a valid authentication access token for successful operation. See the Authentication section for details.  Where a dynamic value is required in the examples below, the {token} format is used, suggesting that the caller needs to supply the appropriate value of the token in question (without including the { or } characters).  Where curl examples are given, the –d @filename.json approach is used, indicating that the request body should be placed into a file named filename.json in the current directory. Each of the curl examples in this document should be considered a single line on the command-line, regardless of how they appear in print.  ## Authenticating with the Velo Platform  Once Velo backoffice staff have added your organization as a payor within the Velo platform sandbox, they will create you a payor Id, an API key and an API secret and share these with you in a secure manner.  You will need to use these values to authenticate with the Velo platform in order to gain access to the APIs. The steps to take are explained in the following:  create a string comprising the API key (e.g. 44a9537d-d55d-4b47-8082-14061c2bcdd8) and API secret (e.g. c396b26b-137a-44fd-87f5-34631f8fd529) with a colon between them. E.g. 44a9537d-d55d-4b47-8082-14061c2bcdd8:c396b26b-137a-44fd-87f5-34631f8fd529  base64 encode this string. E.g.: NDRhOTUzN2QtZDU1ZC00YjQ3LTgwODItMTQwNjFjMmJjZGQ4OmMzOTZiMjZiLTEzN2EtNDRmZC04N2Y1LTM0NjMxZjhmZDUyOQ==  create an HTTP **Authorization** header with the value set to e.g. Basic NDRhOTUzN2QtZDU1ZC00YjQ3LTgwODItMTQwNjFjMmJjZGQ4OmMzOTZiMjZiLTEzN2EtNDRmZC04N2Y1LTM0NjMxZjhmZDUyOQ==  perform the Velo authentication REST call using the HTTP header created above e.g. via curl:  ```   curl -X POST \\   -H \"Content-Type: application/json\" \\   -H \"Authorization: Basic NDRhOTUzN2QtZDU1ZC00YjQ3LTgwODItMTQwNjFjMmJjZGQ4OmMzOTZiMjZiLTEzN2EtNDRmZC04N2Y1LTM0NjMxZjhmZDUyOQ==\" \\   'https://api.sandbox.velopayments.com/v1/authenticate?grant_type=client_credentials' ```  If successful, this call will result in a **200** HTTP status code and a response body such as:  ```   {     \"access_token\":\"19f6bafd-93fd-4747-b229-00507bbc991f\",     \"token_type\":\"bearer\",     \"expires_in\":1799,     \"scope\":\"...\"   } ``` ## API access following authentication Following successful authentication, the value of the access_token field in the response (indicated in green above) should then be presented with all subsequent API calls to allow the Velo platform to validate that the caller is authenticated.  This is achieved by setting the HTTP Authorization header with the value set to e.g. Bearer 19f6bafd-93fd-4747-b229-00507bbc991f such as the curl example below:  ```   -H \"Authorization: Bearer 19f6bafd-93fd-4747-b229-00507bbc991f \" ```  If you make other Velo API calls which require authorization but the Authorization header is missing or invalid then you will get a **401** HTTP status response. 
 *
 * The version of the OpenAPI document: 2.18.113
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.velopayments.oa3.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.velopayments.oa3.model.PaymentAuditCurrencyV3;
import com.velopayments.oa3.model.PaymentEventResponseV3;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import javax.validation.constraints.*;
import javax.validation.Valid;

/**
 * PaymentResponseV3
 */
@JsonPropertyOrder({
  PaymentResponseV3.JSON_PROPERTY_PAYMENT_ID,
  PaymentResponseV3.JSON_PROPERTY_PAYEE_ID,
  PaymentResponseV3.JSON_PROPERTY_PAYOR_ID,
  PaymentResponseV3.JSON_PROPERTY_PAYOR_NAME,
  PaymentResponseV3.JSON_PROPERTY_QUOTE_ID,
  PaymentResponseV3.JSON_PROPERTY_SOURCE_ACCOUNT_ID,
  PaymentResponseV3.JSON_PROPERTY_SOURCE_ACCOUNT_NAME,
  PaymentResponseV3.JSON_PROPERTY_REMOTE_ID,
  PaymentResponseV3.JSON_PROPERTY_SOURCE_AMOUNT,
  PaymentResponseV3.JSON_PROPERTY_SOURCE_CURRENCY,
  PaymentResponseV3.JSON_PROPERTY_PAYMENT_AMOUNT,
  PaymentResponseV3.JSON_PROPERTY_PAYMENT_CURRENCY,
  PaymentResponseV3.JSON_PROPERTY_RATE,
  PaymentResponseV3.JSON_PROPERTY_INVERTED_RATE,
  PaymentResponseV3.JSON_PROPERTY_SUBMITTED_DATE_TIME,
  PaymentResponseV3.JSON_PROPERTY_STATUS,
  PaymentResponseV3.JSON_PROPERTY_FUNDING_STATUS,
  PaymentResponseV3.JSON_PROPERTY_ROUTING_NUMBER,
  PaymentResponseV3.JSON_PROPERTY_ACCOUNT_NUMBER,
  PaymentResponseV3.JSON_PROPERTY_IBAN,
  PaymentResponseV3.JSON_PROPERTY_PAYMENT_MEMO,
  PaymentResponseV3.JSON_PROPERTY_FILENAME_REFERENCE,
  PaymentResponseV3.JSON_PROPERTY_INDIVIDUAL_IDENTIFICATION_NUMBER,
  PaymentResponseV3.JSON_PROPERTY_TRACE_NUMBER,
  PaymentResponseV3.JSON_PROPERTY_PAYOR_PAYMENT_ID,
  PaymentResponseV3.JSON_PROPERTY_PAYMENT_CHANNEL_ID,
  PaymentResponseV3.JSON_PROPERTY_PAYMENT_CHANNEL_NAME,
  PaymentResponseV3.JSON_PROPERTY_ACCOUNT_NAME,
  PaymentResponseV3.JSON_PROPERTY_RAILS_ID,
  PaymentResponseV3.JSON_PROPERTY_COUNTRY_CODE,
  PaymentResponseV3.JSON_PROPERTY_EVENTS,
  PaymentResponseV3.JSON_PROPERTY_RETURN_COST,
  PaymentResponseV3.JSON_PROPERTY_RETURN_REASON,
  PaymentResponseV3.JSON_PROPERTY_RAILS_PAYMENT_ID,
  PaymentResponseV3.JSON_PROPERTY_RAILS_BATCH_ID,
  PaymentResponseV3.JSON_PROPERTY_REJECTION_REASON
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-01-15T12:59:39.508953-05:00[America/New_York]")
public class PaymentResponseV3 {
  public static final String JSON_PROPERTY_PAYMENT_ID = "paymentId";
  private UUID paymentId;

  public static final String JSON_PROPERTY_PAYEE_ID = "payeeId";
  private UUID payeeId;

  public static final String JSON_PROPERTY_PAYOR_ID = "payorId";
  private UUID payorId;

  public static final String JSON_PROPERTY_PAYOR_NAME = "payorName";
  private String payorName;

  public static final String JSON_PROPERTY_QUOTE_ID = "quoteId";
  private UUID quoteId;

  public static final String JSON_PROPERTY_SOURCE_ACCOUNT_ID = "sourceAccountId";
  private UUID sourceAccountId;

  public static final String JSON_PROPERTY_SOURCE_ACCOUNT_NAME = "sourceAccountName";
  private String sourceAccountName;

  public static final String JSON_PROPERTY_REMOTE_ID = "remoteId";
  private String remoteId;

  public static final String JSON_PROPERTY_SOURCE_AMOUNT = "sourceAmount";
  private Integer sourceAmount;

  public static final String JSON_PROPERTY_SOURCE_CURRENCY = "sourceCurrency";
  private PaymentAuditCurrencyV3 sourceCurrency;

  public static final String JSON_PROPERTY_PAYMENT_AMOUNT = "paymentAmount";
  private Integer paymentAmount;

  public static final String JSON_PROPERTY_PAYMENT_CURRENCY = "paymentCurrency";
  private PaymentAuditCurrencyV3 paymentCurrency;

  public static final String JSON_PROPERTY_RATE = "rate";
  private Float rate;

  public static final String JSON_PROPERTY_INVERTED_RATE = "invertedRate";
  private Float invertedRate;

  public static final String JSON_PROPERTY_SUBMITTED_DATE_TIME = "submittedDateTime";
  private OffsetDateTime submittedDateTime;

  /**
   * Gets or Sets status
   */
  public enum StatusEnum {
    ACCEPTED("ACCEPTED"),
    
    AWAITING_FUNDS("AWAITING_FUNDS"),
    
    FUNDED("FUNDED"),
    
    UNFUNDED("UNFUNDED"),
    
    BANK_PAYMENT_REQUESTED("BANK_PAYMENT_REQUESTED"),
    
    REJECTED("REJECTED"),
    
    ACCEPTED_BY_RAILS("ACCEPTED_BY_RAILS"),
    
    CONFIRMED("CONFIRMED"),
    
    FAILED("FAILED"),
    
    WITHDRAWN("WITHDRAWN");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StatusEnum fromValue(String value) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_STATUS = "status";
  private StatusEnum status;

  /**
   * The funding status of the payment
   */
  public enum FundingStatusEnum {
    FUNDED("FUNDED"),
    
    INSTRUCTED("INSTRUCTED"),
    
    UNFUNDED("UNFUNDED");

    private String value;

    FundingStatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static FundingStatusEnum fromValue(String value) {
      for (FundingStatusEnum b : FundingStatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_FUNDING_STATUS = "fundingStatus";
  private FundingStatusEnum fundingStatus;

  public static final String JSON_PROPERTY_ROUTING_NUMBER = "routingNumber";
  private String routingNumber;

  public static final String JSON_PROPERTY_ACCOUNT_NUMBER = "accountNumber";
  private String accountNumber;

  public static final String JSON_PROPERTY_IBAN = "iban";
  private String iban;

  public static final String JSON_PROPERTY_PAYMENT_MEMO = "paymentMemo";
  private String paymentMemo;

  public static final String JSON_PROPERTY_FILENAME_REFERENCE = "filenameReference";
  private String filenameReference;

  public static final String JSON_PROPERTY_INDIVIDUAL_IDENTIFICATION_NUMBER = "individualIdentificationNumber";
  private String individualIdentificationNumber;

  public static final String JSON_PROPERTY_TRACE_NUMBER = "traceNumber";
  private String traceNumber;

  public static final String JSON_PROPERTY_PAYOR_PAYMENT_ID = "payorPaymentId";
  private String payorPaymentId;

  public static final String JSON_PROPERTY_PAYMENT_CHANNEL_ID = "paymentChannelId";
  private String paymentChannelId;

  public static final String JSON_PROPERTY_PAYMENT_CHANNEL_NAME = "paymentChannelName";
  private String paymentChannelName;

  public static final String JSON_PROPERTY_ACCOUNT_NAME = "accountName";
  private String accountName;

  public static final String JSON_PROPERTY_RAILS_ID = "railsId";
  private String railsId = "RAILS ID UNAVAILABLE";

  public static final String JSON_PROPERTY_COUNTRY_CODE = "countryCode";
  private String countryCode;

  public static final String JSON_PROPERTY_EVENTS = "events";
  private List<PaymentEventResponseV3> events = new ArrayList<>();

  public static final String JSON_PROPERTY_RETURN_COST = "returnCost";
  private Integer returnCost;

  public static final String JSON_PROPERTY_RETURN_REASON = "returnReason";
  private String returnReason;

  public static final String JSON_PROPERTY_RAILS_PAYMENT_ID = "railsPaymentId";
  private String railsPaymentId;

  public static final String JSON_PROPERTY_RAILS_BATCH_ID = "railsBatchId";
  private String railsBatchId;

  public static final String JSON_PROPERTY_REJECTION_REASON = "rejectionReason";
  private String rejectionReason;


  public PaymentResponseV3 paymentId(UUID paymentId) {
    
    this.paymentId = paymentId;
    return this;
  }

   /**
   * The id of the payment
   * @return paymentId
  **/
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "The id of the payment")
  @JsonProperty(JSON_PROPERTY_PAYMENT_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getPaymentId() {
    return paymentId;
  }


  public void setPaymentId(UUID paymentId) {
    this.paymentId = paymentId;
  }


  public PaymentResponseV3 payeeId(UUID payeeId) {
    
    this.payeeId = payeeId;
    return this;
  }

   /**
   * The id of the paymeee
   * @return payeeId
  **/
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "The id of the paymeee")
  @JsonProperty(JSON_PROPERTY_PAYEE_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getPayeeId() {
    return payeeId;
  }


  public void setPayeeId(UUID payeeId) {
    this.payeeId = payeeId;
  }


  public PaymentResponseV3 payorId(UUID payorId) {
    
    this.payorId = payorId;
    return this;
  }

   /**
   * The id of the payor
   * @return payorId
  **/
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "The id of the payor")
  @JsonProperty(JSON_PROPERTY_PAYOR_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getPayorId() {
    return payorId;
  }


  public void setPayorId(UUID payorId) {
    this.payorId = payorId;
  }


  public PaymentResponseV3 payorName(String payorName) {
    
    this.payorName = payorName;
    return this;
  }

   /**
   * The name of the payor
   * @return payorName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The name of the payor")
  @JsonProperty(JSON_PROPERTY_PAYOR_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPayorName() {
    return payorName;
  }


  public void setPayorName(String payorName) {
    this.payorName = payorName;
  }


  public PaymentResponseV3 quoteId(UUID quoteId) {
    
    this.quoteId = quoteId;
    return this;
  }

   /**
   * The quote Id used for the FX
   * @return quoteId
  **/
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "The quote Id used for the FX")
  @JsonProperty(JSON_PROPERTY_QUOTE_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getQuoteId() {
    return quoteId;
  }


  public void setQuoteId(UUID quoteId) {
    this.quoteId = quoteId;
  }


  public PaymentResponseV3 sourceAccountId(UUID sourceAccountId) {
    
    this.sourceAccountId = sourceAccountId;
    return this;
  }

   /**
   * The id of the source account from which the payment was taken
   * @return sourceAccountId
  **/
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "The id of the source account from which the payment was taken")
  @JsonProperty(JSON_PROPERTY_SOURCE_ACCOUNT_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getSourceAccountId() {
    return sourceAccountId;
  }


  public void setSourceAccountId(UUID sourceAccountId) {
    this.sourceAccountId = sourceAccountId;
  }


  public PaymentResponseV3 sourceAccountName(String sourceAccountName) {
    
    this.sourceAccountName = sourceAccountName;
    return this;
  }

   /**
   * The name of the source account from which the payment was taken
   * @return sourceAccountName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "My Account", value = "The name of the source account from which the payment was taken")
  @JsonProperty(JSON_PROPERTY_SOURCE_ACCOUNT_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSourceAccountName() {
    return sourceAccountName;
  }


  public void setSourceAccountName(String sourceAccountName) {
    this.sourceAccountName = sourceAccountName;
  }


  public PaymentResponseV3 remoteId(String remoteId) {
    
    this.remoteId = remoteId;
    return this;
  }

   /**
   * The remote id by which the payor refers to the payee. Only populated once payment is confirmed
   * @return remoteId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "aasdf123", value = "The remote id by which the payor refers to the payee. Only populated once payment is confirmed")
  @JsonProperty(JSON_PROPERTY_REMOTE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRemoteId() {
    return remoteId;
  }


  public void setRemoteId(String remoteId) {
    this.remoteId = remoteId;
  }


  public PaymentResponseV3 sourceAmount(Integer sourceAmount) {
    
    this.sourceAmount = sourceAmount;
    return this;
  }

   /**
   * The source amount for the payment (amount debited to make the payment)
   * @return sourceAmount
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "12345", value = "The source amount for the payment (amount debited to make the payment)")
  @JsonProperty(JSON_PROPERTY_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getSourceAmount() {
    return sourceAmount;
  }


  public void setSourceAmount(Integer sourceAmount) {
    this.sourceAmount = sourceAmount;
  }


  public PaymentResponseV3 sourceCurrency(PaymentAuditCurrencyV3 sourceCurrency) {
    
    this.sourceCurrency = sourceCurrency;
    return this;
  }

   /**
   * Get sourceCurrency
   * @return sourceCurrency
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SOURCE_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PaymentAuditCurrencyV3 getSourceCurrency() {
    return sourceCurrency;
  }


  public void setSourceCurrency(PaymentAuditCurrencyV3 sourceCurrency) {
    this.sourceCurrency = sourceCurrency;
  }


  public PaymentResponseV3 paymentAmount(Integer paymentAmount) {
    
    this.paymentAmount = paymentAmount;
    return this;
  }

   /**
   * The amount which the payee will receive
   * @return paymentAmount
  **/
  @NotNull
  @ApiModelProperty(required = true, value = "The amount which the payee will receive")
  @JsonProperty(JSON_PROPERTY_PAYMENT_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getPaymentAmount() {
    return paymentAmount;
  }


  public void setPaymentAmount(Integer paymentAmount) {
    this.paymentAmount = paymentAmount;
  }


  public PaymentResponseV3 paymentCurrency(PaymentAuditCurrencyV3 paymentCurrency) {
    
    this.paymentCurrency = paymentCurrency;
    return this;
  }

   /**
   * Get paymentCurrency
   * @return paymentCurrency
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PAYMENT_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PaymentAuditCurrencyV3 getPaymentCurrency() {
    return paymentCurrency;
  }


  public void setPaymentCurrency(PaymentAuditCurrencyV3 paymentCurrency) {
    this.paymentCurrency = paymentCurrency;
  }


  public PaymentResponseV3 rate(Float rate) {
    
    this.rate = rate;
    return this;
  }

   /**
   * The FX rate for the payment, if FX was involved. **Note** that (depending on the role of the caller) this information may not be displayed
   * @return rate
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The FX rate for the payment, if FX was involved. **Note** that (depending on the role of the caller) this information may not be displayed")
  @JsonProperty(JSON_PROPERTY_RATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getRate() {
    return rate;
  }


  public void setRate(Float rate) {
    this.rate = rate;
  }


  public PaymentResponseV3 invertedRate(Float invertedRate) {
    
    this.invertedRate = invertedRate;
    return this;
  }

   /**
   * The inverted FX rate for the payment, if FX was involved. **Note** that (depending on the role of the caller) this information may not be displayed
   * @return invertedRate
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The inverted FX rate for the payment, if FX was involved. **Note** that (depending on the role of the caller) this information may not be displayed")
  @JsonProperty(JSON_PROPERTY_INVERTED_RATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getInvertedRate() {
    return invertedRate;
  }


  public void setInvertedRate(Float invertedRate) {
    this.invertedRate = invertedRate;
  }


  public PaymentResponseV3 submittedDateTime(OffsetDateTime submittedDateTime) {
    
    this.submittedDateTime = submittedDateTime;
    return this;
  }

   /**
   * Get submittedDateTime
   * @return submittedDateTime
  **/
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_SUBMITTED_DATE_TIME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public OffsetDateTime getSubmittedDateTime() {
    return submittedDateTime;
  }


  public void setSubmittedDateTime(OffsetDateTime submittedDateTime) {
    this.submittedDateTime = submittedDateTime;
  }


  public PaymentResponseV3 status(StatusEnum status) {
    
    this.status = status;
    return this;
  }

   /**
   * Get status
   * @return status
  **/
  @NotNull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public StatusEnum getStatus() {
    return status;
  }


  public void setStatus(StatusEnum status) {
    this.status = status;
  }


  public PaymentResponseV3 fundingStatus(FundingStatusEnum fundingStatus) {
    
    this.fundingStatus = fundingStatus;
    return this;
  }

   /**
   * The funding status of the payment
   * @return fundingStatus
  **/
  @NotNull
  @ApiModelProperty(required = true, value = "The funding status of the payment")
  @JsonProperty(JSON_PROPERTY_FUNDING_STATUS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public FundingStatusEnum getFundingStatus() {
    return fundingStatus;
  }


  public void setFundingStatus(FundingStatusEnum fundingStatus) {
    this.fundingStatus = fundingStatus;
  }


  public PaymentResponseV3 routingNumber(String routingNumber) {
    
    this.routingNumber = routingNumber;
    return this;
  }

   /**
   * The routing number for the payment.
   * @return routingNumber
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "123123123123", value = "The routing number for the payment.")
  @JsonProperty(JSON_PROPERTY_ROUTING_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRoutingNumber() {
    return routingNumber;
  }


  public void setRoutingNumber(String routingNumber) {
    this.routingNumber = routingNumber;
  }


  public PaymentResponseV3 accountNumber(String accountNumber) {
    
    this.accountNumber = accountNumber;
    return this;
  }

   /**
   * The account number for the account which will receive the payment.
   * @return accountNumber
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "123123232323", value = "The account number for the account which will receive the payment.")
  @JsonProperty(JSON_PROPERTY_ACCOUNT_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAccountNumber() {
    return accountNumber;
  }


  public void setAccountNumber(String accountNumber) {
    this.accountNumber = accountNumber;
  }


  public PaymentResponseV3 iban(String iban) {
    
    this.iban = iban;
    return this;
  }

   /**
   * The iban for the payment.
   * @return iban
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "DE89 3704 0044 0532 0130 00", value = "The iban for the payment.")
  @JsonProperty(JSON_PROPERTY_IBAN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getIban() {
    return iban;
  }


  public void setIban(String iban) {
    this.iban = iban;
  }


  public PaymentResponseV3 paymentMemo(String paymentMemo) {
    
    this.paymentMemo = paymentMemo;
    return this;
  }

   /**
   * The payment memo set by the payor
   * @return paymentMemo
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "Payment memo", value = "The payment memo set by the payor")
  @JsonProperty(JSON_PROPERTY_PAYMENT_MEMO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPaymentMemo() {
    return paymentMemo;
  }


  public void setPaymentMemo(String paymentMemo) {
    this.paymentMemo = paymentMemo;
  }


  public PaymentResponseV3 filenameReference(String filenameReference) {
    
    this.filenameReference = filenameReference;
    return this;
  }

   /**
   * ACH file payment was submitted in, if applicable
   * @return filenameReference
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "file ref", value = "ACH file payment was submitted in, if applicable")
  @JsonProperty(JSON_PROPERTY_FILENAME_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFilenameReference() {
    return filenameReference;
  }


  public void setFilenameReference(String filenameReference) {
    this.filenameReference = filenameReference;
  }


  public PaymentResponseV3 individualIdentificationNumber(String individualIdentificationNumber) {
    
    this.individualIdentificationNumber = individualIdentificationNumber;
    return this;
  }

   /**
   * Individual Identification Number assigned to the payment in the ACH file, if applicable
   * @return individualIdentificationNumber
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "1231231adf", value = "Individual Identification Number assigned to the payment in the ACH file, if applicable")
  @JsonProperty(JSON_PROPERTY_INDIVIDUAL_IDENTIFICATION_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getIndividualIdentificationNumber() {
    return individualIdentificationNumber;
  }


  public void setIndividualIdentificationNumber(String individualIdentificationNumber) {
    this.individualIdentificationNumber = individualIdentificationNumber;
  }


  public PaymentResponseV3 traceNumber(String traceNumber) {
    
    this.traceNumber = traceNumber;
    return this;
  }

   /**
   * Trace Number assigned to the payment in the ACH file, if applicable
   * @return traceNumber
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "abodu123", value = "Trace Number assigned to the payment in the ACH file, if applicable")
  @JsonProperty(JSON_PROPERTY_TRACE_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTraceNumber() {
    return traceNumber;
  }


  public void setTraceNumber(String traceNumber) {
    this.traceNumber = traceNumber;
  }


  public PaymentResponseV3 payorPaymentId(String payorPaymentId) {
    
    this.payorPaymentId = payorPaymentId;
    return this;
  }

   /**
   * Get payorPaymentId
   * @return payorPaymentId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "123123asdf", value = "")
  @JsonProperty(JSON_PROPERTY_PAYOR_PAYMENT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPayorPaymentId() {
    return payorPaymentId;
  }


  public void setPayorPaymentId(String payorPaymentId) {
    this.payorPaymentId = payorPaymentId;
  }


  public PaymentResponseV3 paymentChannelId(String paymentChannelId) {
    
    this.paymentChannelId = paymentChannelId;
    return this;
  }

   /**
   * Get paymentChannelId
   * @return paymentChannelId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "123asdf", value = "")
  @JsonProperty(JSON_PROPERTY_PAYMENT_CHANNEL_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPaymentChannelId() {
    return paymentChannelId;
  }


  public void setPaymentChannelId(String paymentChannelId) {
    this.paymentChannelId = paymentChannelId;
  }


  public PaymentResponseV3 paymentChannelName(String paymentChannelName) {
    
    this.paymentChannelName = paymentChannelName;
    return this;
  }

   /**
   * Get paymentChannelName
   * @return paymentChannelName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "My Payment Channel", value = "")
  @JsonProperty(JSON_PROPERTY_PAYMENT_CHANNEL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPaymentChannelName() {
    return paymentChannelName;
  }


  public void setPaymentChannelName(String paymentChannelName) {
    this.paymentChannelName = paymentChannelName;
  }


  public PaymentResponseV3 accountName(String accountName) {
    
    this.accountName = accountName;
    return this;
  }

   /**
   * Get accountName
   * @return accountName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "My Account Name", value = "")
  @JsonProperty(JSON_PROPERTY_ACCOUNT_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAccountName() {
    return accountName;
  }


  public void setAccountName(String accountName) {
    this.accountName = accountName;
  }


  public PaymentResponseV3 railsId(String railsId) {
    
    this.railsId = railsId;
    return this;
  }

   /**
   * The rails ID. Default value is RAILS ID UNAVAILABLE when not populated.
   * @return railsId
  **/
  @NotNull
  @ApiModelProperty(example = "asdf123", required = true, value = "The rails ID. Default value is RAILS ID UNAVAILABLE when not populated.")
  @JsonProperty(JSON_PROPERTY_RAILS_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getRailsId() {
    return railsId;
  }


  public void setRailsId(String railsId) {
    this.railsId = railsId;
  }


  public PaymentResponseV3 countryCode(String countryCode) {
    
    this.countryCode = countryCode;
    return this;
  }

   /**
   * The country code of the payment channel.
   * @return countryCode
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "US", value = "The country code of the payment channel.")
  @JsonProperty(JSON_PROPERTY_COUNTRY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCountryCode() {
    return countryCode;
  }


  public void setCountryCode(String countryCode) {
    this.countryCode = countryCode;
  }


  public PaymentResponseV3 events(List<PaymentEventResponseV3> events) {
    
    this.events = events;
    return this;
  }

  public PaymentResponseV3 addEventsItem(PaymentEventResponseV3 eventsItem) {
    this.events.add(eventsItem);
    return this;
  }

   /**
   * Get events
   * @return events
  **/
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_EVENTS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<PaymentEventResponseV3> getEvents() {
    return events;
  }


  public void setEvents(List<PaymentEventResponseV3> events) {
    this.events = events;
  }


  public PaymentResponseV3 returnCost(Integer returnCost) {
    
    this.returnCost = returnCost;
    return this;
  }

   /**
   * The return cost if a returned payment.
   * @return returnCost
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "1232", value = "The return cost if a returned payment.")
  @JsonProperty(JSON_PROPERTY_RETURN_COST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getReturnCost() {
    return returnCost;
  }


  public void setReturnCost(Integer returnCost) {
    this.returnCost = returnCost;
  }


  public PaymentResponseV3 returnReason(String returnReason) {
    
    this.returnReason = returnReason;
    return this;
  }

   /**
   * Get returnReason
   * @return returnReason
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "Some Reason Value", value = "")
  @JsonProperty(JSON_PROPERTY_RETURN_REASON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getReturnReason() {
    return returnReason;
  }


  public void setReturnReason(String returnReason) {
    this.returnReason = returnReason;
  }


  public PaymentResponseV3 railsPaymentId(String railsPaymentId) {
    
    this.railsPaymentId = railsPaymentId;
    return this;
  }

   /**
   * Get railsPaymentId
   * @return railsPaymentId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_RAILS_PAYMENT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRailsPaymentId() {
    return railsPaymentId;
  }


  public void setRailsPaymentId(String railsPaymentId) {
    this.railsPaymentId = railsPaymentId;
  }


  public PaymentResponseV3 railsBatchId(String railsBatchId) {
    
    this.railsBatchId = railsBatchId;
    return this;
  }

   /**
   * Get railsBatchId
   * @return railsBatchId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_RAILS_BATCH_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRailsBatchId() {
    return railsBatchId;
  }


  public void setRailsBatchId(String railsBatchId) {
    this.railsBatchId = railsBatchId;
  }


  public PaymentResponseV3 rejectionReason(String rejectionReason) {
    
    this.rejectionReason = rejectionReason;
    return this;
  }

   /**
   * Get rejectionReason
   * @return rejectionReason
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_REJECTION_REASON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRejectionReason() {
    return rejectionReason;
  }


  public void setRejectionReason(String rejectionReason) {
    this.rejectionReason = rejectionReason;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PaymentResponseV3 paymentResponseV3 = (PaymentResponseV3) o;
    return Objects.equals(this.paymentId, paymentResponseV3.paymentId) &&
        Objects.equals(this.payeeId, paymentResponseV3.payeeId) &&
        Objects.equals(this.payorId, paymentResponseV3.payorId) &&
        Objects.equals(this.payorName, paymentResponseV3.payorName) &&
        Objects.equals(this.quoteId, paymentResponseV3.quoteId) &&
        Objects.equals(this.sourceAccountId, paymentResponseV3.sourceAccountId) &&
        Objects.equals(this.sourceAccountName, paymentResponseV3.sourceAccountName) &&
        Objects.equals(this.remoteId, paymentResponseV3.remoteId) &&
        Objects.equals(this.sourceAmount, paymentResponseV3.sourceAmount) &&
        Objects.equals(this.sourceCurrency, paymentResponseV3.sourceCurrency) &&
        Objects.equals(this.paymentAmount, paymentResponseV3.paymentAmount) &&
        Objects.equals(this.paymentCurrency, paymentResponseV3.paymentCurrency) &&
        Objects.equals(this.rate, paymentResponseV3.rate) &&
        Objects.equals(this.invertedRate, paymentResponseV3.invertedRate) &&
        Objects.equals(this.submittedDateTime, paymentResponseV3.submittedDateTime) &&
        Objects.equals(this.status, paymentResponseV3.status) &&
        Objects.equals(this.fundingStatus, paymentResponseV3.fundingStatus) &&
        Objects.equals(this.routingNumber, paymentResponseV3.routingNumber) &&
        Objects.equals(this.accountNumber, paymentResponseV3.accountNumber) &&
        Objects.equals(this.iban, paymentResponseV3.iban) &&
        Objects.equals(this.paymentMemo, paymentResponseV3.paymentMemo) &&
        Objects.equals(this.filenameReference, paymentResponseV3.filenameReference) &&
        Objects.equals(this.individualIdentificationNumber, paymentResponseV3.individualIdentificationNumber) &&
        Objects.equals(this.traceNumber, paymentResponseV3.traceNumber) &&
        Objects.equals(this.payorPaymentId, paymentResponseV3.payorPaymentId) &&
        Objects.equals(this.paymentChannelId, paymentResponseV3.paymentChannelId) &&
        Objects.equals(this.paymentChannelName, paymentResponseV3.paymentChannelName) &&
        Objects.equals(this.accountName, paymentResponseV3.accountName) &&
        Objects.equals(this.railsId, paymentResponseV3.railsId) &&
        Objects.equals(this.countryCode, paymentResponseV3.countryCode) &&
        Objects.equals(this.events, paymentResponseV3.events) &&
        Objects.equals(this.returnCost, paymentResponseV3.returnCost) &&
        Objects.equals(this.returnReason, paymentResponseV3.returnReason) &&
        Objects.equals(this.railsPaymentId, paymentResponseV3.railsPaymentId) &&
        Objects.equals(this.railsBatchId, paymentResponseV3.railsBatchId) &&
        Objects.equals(this.rejectionReason, paymentResponseV3.rejectionReason);
  }

  @Override
  public int hashCode() {
    return Objects.hash(paymentId, payeeId, payorId, payorName, quoteId, sourceAccountId, sourceAccountName, remoteId, sourceAmount, sourceCurrency, paymentAmount, paymentCurrency, rate, invertedRate, submittedDateTime, status, fundingStatus, routingNumber, accountNumber, iban, paymentMemo, filenameReference, individualIdentificationNumber, traceNumber, payorPaymentId, paymentChannelId, paymentChannelName, accountName, railsId, countryCode, events, returnCost, returnReason, railsPaymentId, railsBatchId, rejectionReason);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PaymentResponseV3 {\n");
    sb.append("    paymentId: ").append(toIndentedString(paymentId)).append("\n");
    sb.append("    payeeId: ").append(toIndentedString(payeeId)).append("\n");
    sb.append("    payorId: ").append(toIndentedString(payorId)).append("\n");
    sb.append("    payorName: ").append(toIndentedString(payorName)).append("\n");
    sb.append("    quoteId: ").append(toIndentedString(quoteId)).append("\n");
    sb.append("    sourceAccountId: ").append(toIndentedString(sourceAccountId)).append("\n");
    sb.append("    sourceAccountName: ").append(toIndentedString(sourceAccountName)).append("\n");
    sb.append("    remoteId: ").append(toIndentedString(remoteId)).append("\n");
    sb.append("    sourceAmount: ").append(toIndentedString(sourceAmount)).append("\n");
    sb.append("    sourceCurrency: ").append(toIndentedString(sourceCurrency)).append("\n");
    sb.append("    paymentAmount: ").append(toIndentedString(paymentAmount)).append("\n");
    sb.append("    paymentCurrency: ").append(toIndentedString(paymentCurrency)).append("\n");
    sb.append("    rate: ").append(toIndentedString(rate)).append("\n");
    sb.append("    invertedRate: ").append(toIndentedString(invertedRate)).append("\n");
    sb.append("    submittedDateTime: ").append(toIndentedString(submittedDateTime)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    fundingStatus: ").append(toIndentedString(fundingStatus)).append("\n");
    sb.append("    routingNumber: ").append(toIndentedString(routingNumber)).append("\n");
    sb.append("    accountNumber: ").append(toIndentedString(accountNumber)).append("\n");
    sb.append("    iban: ").append(toIndentedString(iban)).append("\n");
    sb.append("    paymentMemo: ").append(toIndentedString(paymentMemo)).append("\n");
    sb.append("    filenameReference: ").append(toIndentedString(filenameReference)).append("\n");
    sb.append("    individualIdentificationNumber: ").append(toIndentedString(individualIdentificationNumber)).append("\n");
    sb.append("    traceNumber: ").append(toIndentedString(traceNumber)).append("\n");
    sb.append("    payorPaymentId: ").append(toIndentedString(payorPaymentId)).append("\n");
    sb.append("    paymentChannelId: ").append(toIndentedString(paymentChannelId)).append("\n");
    sb.append("    paymentChannelName: ").append(toIndentedString(paymentChannelName)).append("\n");
    sb.append("    accountName: ").append(toIndentedString(accountName)).append("\n");
    sb.append("    railsId: ").append(toIndentedString(railsId)).append("\n");
    sb.append("    countryCode: ").append(toIndentedString(countryCode)).append("\n");
    sb.append("    events: ").append(toIndentedString(events)).append("\n");
    sb.append("    returnCost: ").append(toIndentedString(returnCost)).append("\n");
    sb.append("    returnReason: ").append(toIndentedString(returnReason)).append("\n");
    sb.append("    railsPaymentId: ").append(toIndentedString(railsPaymentId)).append("\n");
    sb.append("    railsBatchId: ").append(toIndentedString(railsBatchId)).append("\n");
    sb.append("    rejectionReason: ").append(toIndentedString(rejectionReason)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

