/*
 * Velo Payments APIs
 * ## Terms and Definitions  Throughout this document and the Velo platform the following terms are used:  * **Payor.** An entity (typically a corporation) which wishes to pay funds to one or more payees via a payout. * **Payee.** The recipient of funds paid out by a payor. * **Payment.** A single transfer of funds from a payor to a payee. * **Payout.** A batch of Payments, typically used by a payor to logically group payments (e.g. by business day). Technically there need be no relationship between the payments in a payout - a single payout can contain payments to multiple payees and/or multiple payments to a single payee. * **Sandbox.** An integration environment provided by Velo Payments which offers a similar API experience to the production environment, but all funding and payment events are simulated, along with many other services such as OFAC sanctions list checking.  ## Overview  The Velo Payments API allows a payor to perform a number of operations. The following is a list of the main capabilities in a natural order of execution:  * Authenticate with the Velo platform * Maintain a collection of payees * Query the payor’s current balance of funds within the platform and perform additional funding * Issue payments to payees * Query the platform for a history of those payments  This document describes the main concepts and APIs required to get up and running with the Velo Payments platform. It is not an exhaustive API reference. For that, please see the separate Velo Payments API Reference.  ## API Considerations  The Velo Payments API is REST based and uses the JSON format for requests and responses.  Most calls are secured using OAuth 2 security and require a valid authentication access token for successful operation. See the Authentication section for details.  Where a dynamic value is required in the examples below, the {token} format is used, suggesting that the caller needs to supply the appropriate value of the token in question (without including the { or } characters).  Where curl examples are given, the –d @filename.json approach is used, indicating that the request body should be placed into a file named filename.json in the current directory. Each of the curl examples in this document should be considered a single line on the command-line, regardless of how they appear in print.  ## Authenticating with the Velo Platform  Once Velo backoffice staff have added your organization as a payor within the Velo platform sandbox, they will create you a payor Id, an API key and an API secret and share these with you in a secure manner.  You will need to use these values to authenticate with the Velo platform in order to gain access to the APIs. The steps to take are explained in the following:  create a string comprising the API key (e.g. 44a9537d-d55d-4b47-8082-14061c2bcdd8) and API secret (e.g. c396b26b-137a-44fd-87f5-34631f8fd529) with a colon between them. E.g. 44a9537d-d55d-4b47-8082-14061c2bcdd8:c396b26b-137a-44fd-87f5-34631f8fd529  base64 encode this string. E.g.: NDRhOTUzN2QtZDU1ZC00YjQ3LTgwODItMTQwNjFjMmJjZGQ4OmMzOTZiMjZiLTEzN2EtNDRmZC04N2Y1LTM0NjMxZjhmZDUyOQ==  create an HTTP **Authorization** header with the value set to e.g. Basic NDRhOTUzN2QtZDU1ZC00YjQ3LTgwODItMTQwNjFjMmJjZGQ4OmMzOTZiMjZiLTEzN2EtNDRmZC04N2Y1LTM0NjMxZjhmZDUyOQ==  perform the Velo authentication REST call using the HTTP header created above e.g. via curl:  ```   curl -X POST \\   -H \"Content-Type: application/json\" \\   -H \"Authorization: Basic NDRhOTUzN2QtZDU1ZC00YjQ3LTgwODItMTQwNjFjMmJjZGQ4OmMzOTZiMjZiLTEzN2EtNDRmZC04N2Y1LTM0NjMxZjhmZDUyOQ==\" \\   'https://api.sandbox.velopayments.com/v1/authenticate?grant_type=client_credentials' ```  If successful, this call will result in a **200** HTTP status code and a response body such as:  ```   {     \"access_token\":\"19f6bafd-93fd-4747-b229-00507bbc991f\",     \"token_type\":\"bearer\",     \"expires_in\":1799,     \"scope\":\"...\"   } ``` ## API access following authentication Following successful authentication, the value of the access_token field in the response (indicated in green above) should then be presented with all subsequent API calls to allow the Velo platform to validate that the caller is authenticated.  This is achieved by setting the HTTP Authorization header with the value set to e.g. Bearer 19f6bafd-93fd-4747-b229-00507bbc991f such as the curl example below:  ```   -H \"Authorization: Bearer 19f6bafd-93fd-4747-b229-00507bbc991f \" ```  If you make other Velo API calls which require authorization but the Authorization header is missing or invalid then you will get a **401** HTTP status response. 
 *
 * The version of the OpenAPI document: 2.18.113
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.velopayments.oa3.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import javax.validation.constraints.*;
import javax.validation.Valid;

/**
 * PayorAddressV2
 */
@JsonPropertyOrder({
  PayorAddressV2.JSON_PROPERTY_LINE1,
  PayorAddressV2.JSON_PROPERTY_LINE2,
  PayorAddressV2.JSON_PROPERTY_LINE3,
  PayorAddressV2.JSON_PROPERTY_LINE4,
  PayorAddressV2.JSON_PROPERTY_CITY,
  PayorAddressV2.JSON_PROPERTY_COUNTY_OR_PROVINCE,
  PayorAddressV2.JSON_PROPERTY_ZIP_OR_POSTCODE,
  PayorAddressV2.JSON_PROPERTY_COUNTRY
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-01-15T12:59:39.508953-05:00[America/New_York]")
public class PayorAddressV2 {
  public static final String JSON_PROPERTY_LINE1 = "line1";
  private String line1;

  public static final String JSON_PROPERTY_LINE2 = "line2";
  private JsonNullable<String> line2 = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_LINE3 = "line3";
  private JsonNullable<String> line3 = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_LINE4 = "line4";
  private JsonNullable<String> line4 = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_CITY = "city";
  private String city;

  public static final String JSON_PROPERTY_COUNTY_OR_PROVINCE = "countyOrProvince";
  private JsonNullable<String> countyOrProvince = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_ZIP_OR_POSTCODE = "zipOrPostcode";
  private JsonNullable<String> zipOrPostcode = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_COUNTRY = "country";
  private String country;


  public PayorAddressV2 line1(String line1) {
    
    this.line1 = line1;
    return this;
  }

   /**
   * Get line1
   * @return line1
  **/
  @NotNull
 @Size(min=2,max=255)  @ApiModelProperty(example = "500 Duval St", required = true, value = "")
  @JsonProperty(JSON_PROPERTY_LINE1)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getLine1() {
    return line1;
  }


  public void setLine1(String line1) {
    this.line1 = line1;
  }


  public PayorAddressV2 line2(String line2) {
    this.line2 = JsonNullable.<String>of(line2);
    
    return this;
  }

   /**
   * Get line2
   * @return line2
  **/
  @javax.annotation.Nullable
 @Size(min=0,max=255)  @ApiModelProperty(value = "")
  @JsonIgnore

  public String getLine2() {
        return line2.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_LINE2)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getLine2_JsonNullable() {
    return line2;
  }
  
  @JsonProperty(JSON_PROPERTY_LINE2)
  public void setLine2_JsonNullable(JsonNullable<String> line2) {
    this.line2 = line2;
  }

  public void setLine2(String line2) {
    this.line2 = JsonNullable.<String>of(line2);
  }


  public PayorAddressV2 line3(String line3) {
    this.line3 = JsonNullable.<String>of(line3);
    
    return this;
  }

   /**
   * Get line3
   * @return line3
  **/
  @javax.annotation.Nullable
 @Size(min=0,max=255)  @ApiModelProperty(value = "")
  @JsonIgnore

  public String getLine3() {
        return line3.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_LINE3)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getLine3_JsonNullable() {
    return line3;
  }
  
  @JsonProperty(JSON_PROPERTY_LINE3)
  public void setLine3_JsonNullable(JsonNullable<String> line3) {
    this.line3 = line3;
  }

  public void setLine3(String line3) {
    this.line3 = JsonNullable.<String>of(line3);
  }


  public PayorAddressV2 line4(String line4) {
    this.line4 = JsonNullable.<String>of(line4);
    
    return this;
  }

   /**
   * Get line4
   * @return line4
  **/
  @javax.annotation.Nullable
 @Size(min=0,max=255)  @ApiModelProperty(value = "")
  @JsonIgnore

  public String getLine4() {
        return line4.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_LINE4)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getLine4_JsonNullable() {
    return line4;
  }
  
  @JsonProperty(JSON_PROPERTY_LINE4)
  public void setLine4_JsonNullable(JsonNullable<String> line4) {
    this.line4 = line4;
  }

  public void setLine4(String line4) {
    this.line4 = JsonNullable.<String>of(line4);
  }


  public PayorAddressV2 city(String city) {
    
    this.city = city;
    return this;
  }

   /**
   * Get city
   * @return city
  **/
  @NotNull
 @Size(min=2,max=100)  @ApiModelProperty(example = "Key West", required = true, value = "")
  @JsonProperty(JSON_PROPERTY_CITY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getCity() {
    return city;
  }


  public void setCity(String city) {
    this.city = city;
  }


  public PayorAddressV2 countyOrProvince(String countyOrProvince) {
    this.countyOrProvince = JsonNullable.<String>of(countyOrProvince);
    
    return this;
  }

   /**
   * Get countyOrProvince
   * @return countyOrProvince
  **/
  @javax.annotation.Nullable
 @Size(min=2,max=100)  @ApiModelProperty(example = "FL", value = "")
  @JsonIgnore

  public String getCountyOrProvince() {
        return countyOrProvince.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_COUNTY_OR_PROVINCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getCountyOrProvince_JsonNullable() {
    return countyOrProvince;
  }
  
  @JsonProperty(JSON_PROPERTY_COUNTY_OR_PROVINCE)
  public void setCountyOrProvince_JsonNullable(JsonNullable<String> countyOrProvince) {
    this.countyOrProvince = countyOrProvince;
  }

  public void setCountyOrProvince(String countyOrProvince) {
    this.countyOrProvince = JsonNullable.<String>of(countyOrProvince);
  }


  public PayorAddressV2 zipOrPostcode(String zipOrPostcode) {
    this.zipOrPostcode = JsonNullable.<String>of(zipOrPostcode);
    
    return this;
  }

   /**
   * Get zipOrPostcode
   * @return zipOrPostcode
  **/
  @javax.annotation.Nullable
 @Size(min=2,max=30)  @ApiModelProperty(example = "33945", value = "")
  @JsonIgnore

  public String getZipOrPostcode() {
        return zipOrPostcode.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ZIP_OR_POSTCODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getZipOrPostcode_JsonNullable() {
    return zipOrPostcode;
  }
  
  @JsonProperty(JSON_PROPERTY_ZIP_OR_POSTCODE)
  public void setZipOrPostcode_JsonNullable(JsonNullable<String> zipOrPostcode) {
    this.zipOrPostcode = zipOrPostcode;
  }

  public void setZipOrPostcode(String zipOrPostcode) {
    this.zipOrPostcode = JsonNullable.<String>of(zipOrPostcode);
  }


  public PayorAddressV2 country(String country) {
    
    this.country = country;
    return this;
  }

   /**
   * Get country
   * @return country
  **/
  @NotNull
 @Size(min=2,max=50)  @ApiModelProperty(example = "US", required = true, value = "")
  @JsonProperty(JSON_PROPERTY_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getCountry() {
    return country;
  }


  public void setCountry(String country) {
    this.country = country;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PayorAddressV2 payorAddressV2 = (PayorAddressV2) o;
    return Objects.equals(this.line1, payorAddressV2.line1) &&
        Objects.equals(this.line2, payorAddressV2.line2) &&
        Objects.equals(this.line3, payorAddressV2.line3) &&
        Objects.equals(this.line4, payorAddressV2.line4) &&
        Objects.equals(this.city, payorAddressV2.city) &&
        Objects.equals(this.countyOrProvince, payorAddressV2.countyOrProvince) &&
        Objects.equals(this.zipOrPostcode, payorAddressV2.zipOrPostcode) &&
        Objects.equals(this.country, payorAddressV2.country);
  }

  @Override
  public int hashCode() {
    return Objects.hash(line1, line2, line3, line4, city, countyOrProvince, zipOrPostcode, country);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PayorAddressV2 {\n");
    sb.append("    line1: ").append(toIndentedString(line1)).append("\n");
    sb.append("    line2: ").append(toIndentedString(line2)).append("\n");
    sb.append("    line3: ").append(toIndentedString(line3)).append("\n");
    sb.append("    line4: ").append(toIndentedString(line4)).append("\n");
    sb.append("    city: ").append(toIndentedString(city)).append("\n");
    sb.append("    countyOrProvince: ").append(toIndentedString(countyOrProvince)).append("\n");
    sb.append("    zipOrPostcode: ").append(toIndentedString(zipOrPostcode)).append("\n");
    sb.append("    country: ").append(toIndentedString(country)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

