/*
 * Velo Payments APIs
 * ## Terms and Definitions  Throughout this document and the Velo platform the following terms are used:  * **Payor.** An entity (typically a corporation) which wishes to pay funds to one or more payees via a payout. * **Payee.** The recipient of funds paid out by a payor. * **Payment.** A single transfer of funds from a payor to a payee. * **Payout.** A batch of Payments, typically used by a payor to logically group payments (e.g. by business day). Technically there need be no relationship between the payments in a payout - a single payout can contain payments to multiple payees and/or multiple payments to a single payee. * **Sandbox.** An integration environment provided by Velo Payments which offers a similar API experience to the production environment, but all funding and payment events are simulated, along with many other services such as OFAC sanctions list checking.  ## Overview  The Velo Payments API allows a payor to perform a number of operations. The following is a list of the main capabilities in a natural order of execution:  * Authenticate with the Velo platform * Maintain a collection of payees * Query the payor’s current balance of funds within the platform and perform additional funding * Issue payments to payees * Query the platform for a history of those payments  This document describes the main concepts and APIs required to get up and running with the Velo Payments platform. It is not an exhaustive API reference. For that, please see the separate Velo Payments API Reference.  ## API Considerations  The Velo Payments API is REST based and uses the JSON format for requests and responses.  Most calls are secured using OAuth 2 security and require a valid authentication access token for successful operation. See the Authentication section for details.  Where a dynamic value is required in the examples below, the {token} format is used, suggesting that the caller needs to supply the appropriate value of the token in question (without including the { or } characters).  Where curl examples are given, the –d @filename.json approach is used, indicating that the request body should be placed into a file named filename.json in the current directory. Each of the curl examples in this document should be considered a single line on the command-line, regardless of how they appear in print.  ## Authenticating with the Velo Platform  Once Velo backoffice staff have added your organization as a payor within the Velo platform sandbox, they will create you a payor Id, an API key and an API secret and share these with you in a secure manner.  You will need to use these values to authenticate with the Velo platform in order to gain access to the APIs. The steps to take are explained in the following:  create a string comprising the API key (e.g. 44a9537d-d55d-4b47-8082-14061c2bcdd8) and API secret (e.g. c396b26b-137a-44fd-87f5-34631f8fd529) with a colon between them. E.g. 44a9537d-d55d-4b47-8082-14061c2bcdd8:c396b26b-137a-44fd-87f5-34631f8fd529  base64 encode this string. E.g.: NDRhOTUzN2QtZDU1ZC00YjQ3LTgwODItMTQwNjFjMmJjZGQ4OmMzOTZiMjZiLTEzN2EtNDRmZC04N2Y1LTM0NjMxZjhmZDUyOQ==  create an HTTP **Authorization** header with the value set to e.g. Basic NDRhOTUzN2QtZDU1ZC00YjQ3LTgwODItMTQwNjFjMmJjZGQ4OmMzOTZiMjZiLTEzN2EtNDRmZC04N2Y1LTM0NjMxZjhmZDUyOQ==  perform the Velo authentication REST call using the HTTP header created above e.g. via curl:  ```   curl -X POST \\   -H \"Content-Type: application/json\" \\   -H \"Authorization: Basic NDRhOTUzN2QtZDU1ZC00YjQ3LTgwODItMTQwNjFjMmJjZGQ4OmMzOTZiMjZiLTEzN2EtNDRmZC04N2Y1LTM0NjMxZjhmZDUyOQ==\" \\   'https://api.sandbox.velopayments.com/v1/authenticate?grant_type=client_credentials' ```  If successful, this call will result in a **200** HTTP status code and a response body such as:  ```   {     \"access_token\":\"19f6bafd-93fd-4747-b229-00507bbc991f\",     \"token_type\":\"bearer\",     \"expires_in\":1799,     \"scope\":\"...\"   } ``` ## API access following authentication Following successful authentication, the value of the access_token field in the response (indicated in green above) should then be presented with all subsequent API calls to allow the Velo platform to validate that the caller is authenticated.  This is achieved by setting the HTTP Authorization header with the value set to e.g. Bearer 19f6bafd-93fd-4747-b229-00507bbc991f such as the curl example below:  ```   -H \"Authorization: Bearer 19f6bafd-93fd-4747-b229-00507bbc991f \" ```  If you make other Velo API calls which require authorization but the Authorization header is missing or invalid then you will get a **401** HTTP status response. 
 *
 * The version of the OpenAPI document: 2.18.113
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.velopayments.oa3.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import javax.validation.constraints.*;
import javax.validation.Valid;

/**
 * PayorAmlTransactionV3
 */
@JsonPropertyOrder({
  PayorAmlTransactionV3.JSON_PROPERTY_TRANSACTION_DATE,
  PayorAmlTransactionV3.JSON_PROPERTY_TRANSACTION_TIME,
  PayorAmlTransactionV3.JSON_PROPERTY_REPORT_TRANSACTION_TYPE,
  PayorAmlTransactionV3.JSON_PROPERTY_DEBIT,
  PayorAmlTransactionV3.JSON_PROPERTY_DEBIT_CURRENCY,
  PayorAmlTransactionV3.JSON_PROPERTY_CREDIT,
  PayorAmlTransactionV3.JSON_PROPERTY_CREDIT_CURRENCY,
  PayorAmlTransactionV3.JSON_PROPERTY_RETURN_FEE,
  PayorAmlTransactionV3.JSON_PROPERTY_RETURN_FEE_CURRENCY,
  PayorAmlTransactionV3.JSON_PROPERTY_RETURN_FEE_DESCRIPTION,
  PayorAmlTransactionV3.JSON_PROPERTY_RETURN_CODE,
  PayorAmlTransactionV3.JSON_PROPERTY_RETURN_DESCRIPTION,
  PayorAmlTransactionV3.JSON_PROPERTY_FUNDING_TYPE,
  PayorAmlTransactionV3.JSON_PROPERTY_DATE_FUNDING_REQUESTED,
  PayorAmlTransactionV3.JSON_PROPERTY_PAYEE_NAME,
  PayorAmlTransactionV3.JSON_PROPERTY_REMOTE_ID,
  PayorAmlTransactionV3.JSON_PROPERTY_PAYEE_TYPE,
  PayorAmlTransactionV3.JSON_PROPERTY_PAYEE_EMAIL,
  PayorAmlTransactionV3.JSON_PROPERTY_SOURCE_ACCOUNT,
  PayorAmlTransactionV3.JSON_PROPERTY_PAYMENT_AMOUNT,
  PayorAmlTransactionV3.JSON_PROPERTY_PAYMENT_CURRENCY,
  PayorAmlTransactionV3.JSON_PROPERTY_PAYMENT_MEMO,
  PayorAmlTransactionV3.JSON_PROPERTY_PAYMENT_TYPE,
  PayorAmlTransactionV3.JSON_PROPERTY_PAYMENT_RAILS,
  PayorAmlTransactionV3.JSON_PROPERTY_PAYOR_PAYMENT_ID,
  PayorAmlTransactionV3.JSON_PROPERTY_PAYMENT_STATUS,
  PayorAmlTransactionV3.JSON_PROPERTY_REJECT_REASON,
  PayorAmlTransactionV3.JSON_PROPERTY_FX_APPLIED
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-01-15T12:59:39.508953-05:00[America/New_York]")
public class PayorAmlTransactionV3 {
  public static final String JSON_PROPERTY_TRANSACTION_DATE = "transactionDate";
  private LocalDate transactionDate;

  public static final String JSON_PROPERTY_TRANSACTION_TIME = "transactionTime";
  private String transactionTime;

  public static final String JSON_PROPERTY_REPORT_TRANSACTION_TYPE = "reportTransactionType";
  private String reportTransactionType;

  public static final String JSON_PROPERTY_DEBIT = "debit";
  private Long debit;

  public static final String JSON_PROPERTY_DEBIT_CURRENCY = "debitCurrency";
  private String debitCurrency;

  public static final String JSON_PROPERTY_CREDIT = "credit";
  private Long credit;

  public static final String JSON_PROPERTY_CREDIT_CURRENCY = "creditCurrency";
  private String creditCurrency;

  public static final String JSON_PROPERTY_RETURN_FEE = "returnFee";
  private String returnFee;

  public static final String JSON_PROPERTY_RETURN_FEE_CURRENCY = "returnFeeCurrency";
  private String returnFeeCurrency;

  public static final String JSON_PROPERTY_RETURN_FEE_DESCRIPTION = "returnFeeDescription";
  private String returnFeeDescription;

  public static final String JSON_PROPERTY_RETURN_CODE = "returnCode";
  private String returnCode;

  public static final String JSON_PROPERTY_RETURN_DESCRIPTION = "returnDescription";
  private String returnDescription;

  public static final String JSON_PROPERTY_FUNDING_TYPE = "fundingType";
  private String fundingType;

  public static final String JSON_PROPERTY_DATE_FUNDING_REQUESTED = "dateFundingRequested";
  private String dateFundingRequested;

  public static final String JSON_PROPERTY_PAYEE_NAME = "payeeName";
  private String payeeName;

  public static final String JSON_PROPERTY_REMOTE_ID = "remoteId";
  private String remoteId;

  public static final String JSON_PROPERTY_PAYEE_TYPE = "payeeType";
  private String payeeType;

  public static final String JSON_PROPERTY_PAYEE_EMAIL = "payeeEmail";
  private String payeeEmail;

  public static final String JSON_PROPERTY_SOURCE_ACCOUNT = "sourceAccount";
  private String sourceAccount;

  public static final String JSON_PROPERTY_PAYMENT_AMOUNT = "paymentAmount";
  private Long paymentAmount;

  public static final String JSON_PROPERTY_PAYMENT_CURRENCY = "paymentCurrency";
  private String paymentCurrency;

  public static final String JSON_PROPERTY_PAYMENT_MEMO = "paymentMemo";
  private String paymentMemo;

  public static final String JSON_PROPERTY_PAYMENT_TYPE = "paymentType";
  private String paymentType;

  public static final String JSON_PROPERTY_PAYMENT_RAILS = "paymentRails";
  private String paymentRails;

  public static final String JSON_PROPERTY_PAYOR_PAYMENT_ID = "payorPaymentId";
  private String payorPaymentId;

  public static final String JSON_PROPERTY_PAYMENT_STATUS = "paymentStatus";
  private String paymentStatus;

  public static final String JSON_PROPERTY_REJECT_REASON = "rejectReason";
  private String rejectReason;

  public static final String JSON_PROPERTY_FX_APPLIED = "fxApplied";
  private Double fxApplied;


  public PayorAmlTransactionV3 transactionDate(LocalDate transactionDate) {
    
    this.transactionDate = transactionDate;
    return this;
  }

   /**
   * Get transactionDate
   * @return transactionDate
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TRANSACTION_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalDate getTransactionDate() {
    return transactionDate;
  }


  public void setTransactionDate(LocalDate transactionDate) {
    this.transactionDate = transactionDate;
  }


  public PayorAmlTransactionV3 transactionTime(String transactionTime) {
    
    this.transactionTime = transactionTime;
    return this;
  }

   /**
   * Get transactionTime
   * @return transactionTime
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TRANSACTION_TIME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTransactionTime() {
    return transactionTime;
  }


  public void setTransactionTime(String transactionTime) {
    this.transactionTime = transactionTime;
  }


  public PayorAmlTransactionV3 reportTransactionType(String reportTransactionType) {
    
    this.reportTransactionType = reportTransactionType;
    return this;
  }

   /**
   * Get reportTransactionType
   * @return reportTransactionType
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_REPORT_TRANSACTION_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getReportTransactionType() {
    return reportTransactionType;
  }


  public void setReportTransactionType(String reportTransactionType) {
    this.reportTransactionType = reportTransactionType;
  }


  public PayorAmlTransactionV3 debit(Long debit) {
    
    this.debit = debit;
    return this;
  }

   /**
   * Get debit
   * @return debit
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DEBIT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getDebit() {
    return debit;
  }


  public void setDebit(Long debit) {
    this.debit = debit;
  }


  public PayorAmlTransactionV3 debitCurrency(String debitCurrency) {
    
    this.debitCurrency = debitCurrency;
    return this;
  }

   /**
   * ISO 4217 3 character currency code
   * @return debitCurrency
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "ISO 4217 3 character currency code")
  @JsonProperty(JSON_PROPERTY_DEBIT_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDebitCurrency() {
    return debitCurrency;
  }


  public void setDebitCurrency(String debitCurrency) {
    this.debitCurrency = debitCurrency;
  }


  public PayorAmlTransactionV3 credit(Long credit) {
    
    this.credit = credit;
    return this;
  }

   /**
   * Get credit
   * @return credit
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CREDIT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getCredit() {
    return credit;
  }


  public void setCredit(Long credit) {
    this.credit = credit;
  }


  public PayorAmlTransactionV3 creditCurrency(String creditCurrency) {
    
    this.creditCurrency = creditCurrency;
    return this;
  }

   /**
   * ISO 4217 3 character currency code
   * @return creditCurrency
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "ISO 4217 3 character currency code")
  @JsonProperty(JSON_PROPERTY_CREDIT_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCreditCurrency() {
    return creditCurrency;
  }


  public void setCreditCurrency(String creditCurrency) {
    this.creditCurrency = creditCurrency;
  }


  public PayorAmlTransactionV3 returnFee(String returnFee) {
    
    this.returnFee = returnFee;
    return this;
  }

   /**
   * Get returnFee
   * @return returnFee
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_RETURN_FEE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getReturnFee() {
    return returnFee;
  }


  public void setReturnFee(String returnFee) {
    this.returnFee = returnFee;
  }


  public PayorAmlTransactionV3 returnFeeCurrency(String returnFeeCurrency) {
    
    this.returnFeeCurrency = returnFeeCurrency;
    return this;
  }

   /**
   * ISO 4217 3 character currency code
   * @return returnFeeCurrency
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "ISO 4217 3 character currency code")
  @JsonProperty(JSON_PROPERTY_RETURN_FEE_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getReturnFeeCurrency() {
    return returnFeeCurrency;
  }


  public void setReturnFeeCurrency(String returnFeeCurrency) {
    this.returnFeeCurrency = returnFeeCurrency;
  }


  public PayorAmlTransactionV3 returnFeeDescription(String returnFeeDescription) {
    
    this.returnFeeDescription = returnFeeDescription;
    return this;
  }

   /**
   * Get returnFeeDescription
   * @return returnFeeDescription
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_RETURN_FEE_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getReturnFeeDescription() {
    return returnFeeDescription;
  }


  public void setReturnFeeDescription(String returnFeeDescription) {
    this.returnFeeDescription = returnFeeDescription;
  }


  public PayorAmlTransactionV3 returnCode(String returnCode) {
    
    this.returnCode = returnCode;
    return this;
  }

   /**
   * Get returnCode
   * @return returnCode
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_RETURN_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getReturnCode() {
    return returnCode;
  }


  public void setReturnCode(String returnCode) {
    this.returnCode = returnCode;
  }


  public PayorAmlTransactionV3 returnDescription(String returnDescription) {
    
    this.returnDescription = returnDescription;
    return this;
  }

   /**
   * Get returnDescription
   * @return returnDescription
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_RETURN_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getReturnDescription() {
    return returnDescription;
  }


  public void setReturnDescription(String returnDescription) {
    this.returnDescription = returnDescription;
  }


  public PayorAmlTransactionV3 fundingType(String fundingType) {
    
    this.fundingType = fundingType;
    return this;
  }

   /**
   * Get fundingType
   * @return fundingType
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_FUNDING_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFundingType() {
    return fundingType;
  }


  public void setFundingType(String fundingType) {
    this.fundingType = fundingType;
  }


  public PayorAmlTransactionV3 dateFundingRequested(String dateFundingRequested) {
    
    this.dateFundingRequested = dateFundingRequested;
    return this;
  }

   /**
   * Get dateFundingRequested
   * @return dateFundingRequested
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DATE_FUNDING_REQUESTED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDateFundingRequested() {
    return dateFundingRequested;
  }


  public void setDateFundingRequested(String dateFundingRequested) {
    this.dateFundingRequested = dateFundingRequested;
  }


  public PayorAmlTransactionV3 payeeName(String payeeName) {
    
    this.payeeName = payeeName;
    return this;
  }

   /**
   * Get payeeName
   * @return payeeName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PAYEE_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPayeeName() {
    return payeeName;
  }


  public void setPayeeName(String payeeName) {
    this.payeeName = payeeName;
  }


  public PayorAmlTransactionV3 remoteId(String remoteId) {
    
    this.remoteId = remoteId;
    return this;
  }

   /**
   * Remote ID of the Payee, set by Payor
   * @return remoteId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Remote ID of the Payee, set by Payor")
  @JsonProperty(JSON_PROPERTY_REMOTE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRemoteId() {
    return remoteId;
  }


  public void setRemoteId(String remoteId) {
    this.remoteId = remoteId;
  }


  public PayorAmlTransactionV3 payeeType(String payeeType) {
    
    this.payeeType = payeeType;
    return this;
  }

   /**
   * Get payeeType
   * @return payeeType
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PAYEE_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPayeeType() {
    return payeeType;
  }


  public void setPayeeType(String payeeType) {
    this.payeeType = payeeType;
  }


  public PayorAmlTransactionV3 payeeEmail(String payeeEmail) {
    
    this.payeeEmail = payeeEmail;
    return this;
  }

   /**
   * Get payeeEmail
   * @return payeeEmail
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PAYEE_EMAIL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPayeeEmail() {
    return payeeEmail;
  }


  public void setPayeeEmail(String payeeEmail) {
    this.payeeEmail = payeeEmail;
  }


  public PayorAmlTransactionV3 sourceAccount(String sourceAccount) {
    
    this.sourceAccount = sourceAccount;
    return this;
  }

   /**
   * Get sourceAccount
   * @return sourceAccount
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SOURCE_ACCOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSourceAccount() {
    return sourceAccount;
  }


  public void setSourceAccount(String sourceAccount) {
    this.sourceAccount = sourceAccount;
  }


  public PayorAmlTransactionV3 paymentAmount(Long paymentAmount) {
    
    this.paymentAmount = paymentAmount;
    return this;
  }

   /**
   * Get paymentAmount
   * @return paymentAmount
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PAYMENT_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getPaymentAmount() {
    return paymentAmount;
  }


  public void setPaymentAmount(Long paymentAmount) {
    this.paymentAmount = paymentAmount;
  }


  public PayorAmlTransactionV3 paymentCurrency(String paymentCurrency) {
    
    this.paymentCurrency = paymentCurrency;
    return this;
  }

   /**
   * ISO 4217 3 character currency code
   * @return paymentCurrency
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "ISO 4217 3 character currency code")
  @JsonProperty(JSON_PROPERTY_PAYMENT_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPaymentCurrency() {
    return paymentCurrency;
  }


  public void setPaymentCurrency(String paymentCurrency) {
    this.paymentCurrency = paymentCurrency;
  }


  public PayorAmlTransactionV3 paymentMemo(String paymentMemo) {
    
    this.paymentMemo = paymentMemo;
    return this;
  }

   /**
   * Get paymentMemo
   * @return paymentMemo
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PAYMENT_MEMO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPaymentMemo() {
    return paymentMemo;
  }


  public void setPaymentMemo(String paymentMemo) {
    this.paymentMemo = paymentMemo;
  }


  public PayorAmlTransactionV3 paymentType(String paymentType) {
    
    this.paymentType = paymentType;
    return this;
  }

   /**
   * Get paymentType
   * @return paymentType
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PAYMENT_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPaymentType() {
    return paymentType;
  }


  public void setPaymentType(String paymentType) {
    this.paymentType = paymentType;
  }


  public PayorAmlTransactionV3 paymentRails(String paymentRails) {
    
    this.paymentRails = paymentRails;
    return this;
  }

   /**
   * Get paymentRails
   * @return paymentRails
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PAYMENT_RAILS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPaymentRails() {
    return paymentRails;
  }


  public void setPaymentRails(String paymentRails) {
    this.paymentRails = paymentRails;
  }


  public PayorAmlTransactionV3 payorPaymentId(String payorPaymentId) {
    
    this.payorPaymentId = payorPaymentId;
    return this;
  }

   /**
   * Get payorPaymentId
   * @return payorPaymentId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PAYOR_PAYMENT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPayorPaymentId() {
    return payorPaymentId;
  }


  public void setPayorPaymentId(String payorPaymentId) {
    this.payorPaymentId = payorPaymentId;
  }


  public PayorAmlTransactionV3 paymentStatus(String paymentStatus) {
    
    this.paymentStatus = paymentStatus;
    return this;
  }

   /**
   * Get paymentStatus
   * @return paymentStatus
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PAYMENT_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPaymentStatus() {
    return paymentStatus;
  }


  public void setPaymentStatus(String paymentStatus) {
    this.paymentStatus = paymentStatus;
  }


  public PayorAmlTransactionV3 rejectReason(String rejectReason) {
    
    this.rejectReason = rejectReason;
    return this;
  }

   /**
   * Get rejectReason
   * @return rejectReason
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_REJECT_REASON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRejectReason() {
    return rejectReason;
  }


  public void setRejectReason(String rejectReason) {
    this.rejectReason = rejectReason;
  }


  public PayorAmlTransactionV3 fxApplied(Double fxApplied) {
    
    this.fxApplied = fxApplied;
    return this;
  }

   /**
   * Get fxApplied
   * @return fxApplied
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_FX_APPLIED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getFxApplied() {
    return fxApplied;
  }


  public void setFxApplied(Double fxApplied) {
    this.fxApplied = fxApplied;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PayorAmlTransactionV3 payorAmlTransactionV3 = (PayorAmlTransactionV3) o;
    return Objects.equals(this.transactionDate, payorAmlTransactionV3.transactionDate) &&
        Objects.equals(this.transactionTime, payorAmlTransactionV3.transactionTime) &&
        Objects.equals(this.reportTransactionType, payorAmlTransactionV3.reportTransactionType) &&
        Objects.equals(this.debit, payorAmlTransactionV3.debit) &&
        Objects.equals(this.debitCurrency, payorAmlTransactionV3.debitCurrency) &&
        Objects.equals(this.credit, payorAmlTransactionV3.credit) &&
        Objects.equals(this.creditCurrency, payorAmlTransactionV3.creditCurrency) &&
        Objects.equals(this.returnFee, payorAmlTransactionV3.returnFee) &&
        Objects.equals(this.returnFeeCurrency, payorAmlTransactionV3.returnFeeCurrency) &&
        Objects.equals(this.returnFeeDescription, payorAmlTransactionV3.returnFeeDescription) &&
        Objects.equals(this.returnCode, payorAmlTransactionV3.returnCode) &&
        Objects.equals(this.returnDescription, payorAmlTransactionV3.returnDescription) &&
        Objects.equals(this.fundingType, payorAmlTransactionV3.fundingType) &&
        Objects.equals(this.dateFundingRequested, payorAmlTransactionV3.dateFundingRequested) &&
        Objects.equals(this.payeeName, payorAmlTransactionV3.payeeName) &&
        Objects.equals(this.remoteId, payorAmlTransactionV3.remoteId) &&
        Objects.equals(this.payeeType, payorAmlTransactionV3.payeeType) &&
        Objects.equals(this.payeeEmail, payorAmlTransactionV3.payeeEmail) &&
        Objects.equals(this.sourceAccount, payorAmlTransactionV3.sourceAccount) &&
        Objects.equals(this.paymentAmount, payorAmlTransactionV3.paymentAmount) &&
        Objects.equals(this.paymentCurrency, payorAmlTransactionV3.paymentCurrency) &&
        Objects.equals(this.paymentMemo, payorAmlTransactionV3.paymentMemo) &&
        Objects.equals(this.paymentType, payorAmlTransactionV3.paymentType) &&
        Objects.equals(this.paymentRails, payorAmlTransactionV3.paymentRails) &&
        Objects.equals(this.payorPaymentId, payorAmlTransactionV3.payorPaymentId) &&
        Objects.equals(this.paymentStatus, payorAmlTransactionV3.paymentStatus) &&
        Objects.equals(this.rejectReason, payorAmlTransactionV3.rejectReason) &&
        Objects.equals(this.fxApplied, payorAmlTransactionV3.fxApplied);
  }

  @Override
  public int hashCode() {
    return Objects.hash(transactionDate, transactionTime, reportTransactionType, debit, debitCurrency, credit, creditCurrency, returnFee, returnFeeCurrency, returnFeeDescription, returnCode, returnDescription, fundingType, dateFundingRequested, payeeName, remoteId, payeeType, payeeEmail, sourceAccount, paymentAmount, paymentCurrency, paymentMemo, paymentType, paymentRails, payorPaymentId, paymentStatus, rejectReason, fxApplied);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PayorAmlTransactionV3 {\n");
    sb.append("    transactionDate: ").append(toIndentedString(transactionDate)).append("\n");
    sb.append("    transactionTime: ").append(toIndentedString(transactionTime)).append("\n");
    sb.append("    reportTransactionType: ").append(toIndentedString(reportTransactionType)).append("\n");
    sb.append("    debit: ").append(toIndentedString(debit)).append("\n");
    sb.append("    debitCurrency: ").append(toIndentedString(debitCurrency)).append("\n");
    sb.append("    credit: ").append(toIndentedString(credit)).append("\n");
    sb.append("    creditCurrency: ").append(toIndentedString(creditCurrency)).append("\n");
    sb.append("    returnFee: ").append(toIndentedString(returnFee)).append("\n");
    sb.append("    returnFeeCurrency: ").append(toIndentedString(returnFeeCurrency)).append("\n");
    sb.append("    returnFeeDescription: ").append(toIndentedString(returnFeeDescription)).append("\n");
    sb.append("    returnCode: ").append(toIndentedString(returnCode)).append("\n");
    sb.append("    returnDescription: ").append(toIndentedString(returnDescription)).append("\n");
    sb.append("    fundingType: ").append(toIndentedString(fundingType)).append("\n");
    sb.append("    dateFundingRequested: ").append(toIndentedString(dateFundingRequested)).append("\n");
    sb.append("    payeeName: ").append(toIndentedString(payeeName)).append("\n");
    sb.append("    remoteId: ").append(toIndentedString(remoteId)).append("\n");
    sb.append("    payeeType: ").append(toIndentedString(payeeType)).append("\n");
    sb.append("    payeeEmail: ").append(toIndentedString(payeeEmail)).append("\n");
    sb.append("    sourceAccount: ").append(toIndentedString(sourceAccount)).append("\n");
    sb.append("    paymentAmount: ").append(toIndentedString(paymentAmount)).append("\n");
    sb.append("    paymentCurrency: ").append(toIndentedString(paymentCurrency)).append("\n");
    sb.append("    paymentMemo: ").append(toIndentedString(paymentMemo)).append("\n");
    sb.append("    paymentType: ").append(toIndentedString(paymentType)).append("\n");
    sb.append("    paymentRails: ").append(toIndentedString(paymentRails)).append("\n");
    sb.append("    payorPaymentId: ").append(toIndentedString(payorPaymentId)).append("\n");
    sb.append("    paymentStatus: ").append(toIndentedString(paymentStatus)).append("\n");
    sb.append("    rejectReason: ").append(toIndentedString(rejectReason)).append("\n");
    sb.append("    fxApplied: ").append(toIndentedString(fxApplied)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

