/*
 * Velo Payments APIs
 * ## Terms and Definitions  Throughout this document and the Velo platform the following terms are used:  * **Payor.** An entity (typically a corporation) which wishes to pay funds to one or more payees via a payout. * **Payee.** The recipient of funds paid out by a payor. * **Payment.** A single transfer of funds from a payor to a payee. * **Payout.** A batch of Payments, typically used by a payor to logically group payments (e.g. by business day). Technically there need be no relationship between the payments in a payout - a single payout can contain payments to multiple payees and/or multiple payments to a single payee. * **Sandbox.** An integration environment provided by Velo Payments which offers a similar API experience to the production environment, but all funding and payment events are simulated, along with many other services such as OFAC sanctions list checking.  ## Overview  The Velo Payments API allows a payor to perform a number of operations. The following is a list of the main capabilities in a natural order of execution:  * Authenticate with the Velo platform * Maintain a collection of payees * Query the payor’s current balance of funds within the platform and perform additional funding * Issue payments to payees * Query the platform for a history of those payments  This document describes the main concepts and APIs required to get up and running with the Velo Payments platform. It is not an exhaustive API reference. For that, please see the separate Velo Payments API Reference.  ## API Considerations  The Velo Payments API is REST based and uses the JSON format for requests and responses.  Most calls are secured using OAuth 2 security and require a valid authentication access token for successful operation. See the Authentication section for details.  Where a dynamic value is required in the examples below, the {token} format is used, suggesting that the caller needs to supply the appropriate value of the token in question (without including the { or } characters).  Where curl examples are given, the –d @filename.json approach is used, indicating that the request body should be placed into a file named filename.json in the current directory. Each of the curl examples in this document should be considered a single line on the command-line, regardless of how they appear in print.  ## Authenticating with the Velo Platform  Once Velo backoffice staff have added your organization as a payor within the Velo platform sandbox, they will create you a payor Id, an API key and an API secret and share these with you in a secure manner.  You will need to use these values to authenticate with the Velo platform in order to gain access to the APIs. The steps to take are explained in the following:  create a string comprising the API key (e.g. 44a9537d-d55d-4b47-8082-14061c2bcdd8) and API secret (e.g. c396b26b-137a-44fd-87f5-34631f8fd529) with a colon between them. E.g. 44a9537d-d55d-4b47-8082-14061c2bcdd8:c396b26b-137a-44fd-87f5-34631f8fd529  base64 encode this string. E.g.: NDRhOTUzN2QtZDU1ZC00YjQ3LTgwODItMTQwNjFjMmJjZGQ4OmMzOTZiMjZiLTEzN2EtNDRmZC04N2Y1LTM0NjMxZjhmZDUyOQ==  create an HTTP **Authorization** header with the value set to e.g. Basic NDRhOTUzN2QtZDU1ZC00YjQ3LTgwODItMTQwNjFjMmJjZGQ4OmMzOTZiMjZiLTEzN2EtNDRmZC04N2Y1LTM0NjMxZjhmZDUyOQ==  perform the Velo authentication REST call using the HTTP header created above e.g. via curl:  ```   curl -X POST \\   -H \"Content-Type: application/json\" \\   -H \"Authorization: Basic NDRhOTUzN2QtZDU1ZC00YjQ3LTgwODItMTQwNjFjMmJjZGQ4OmMzOTZiMjZiLTEzN2EtNDRmZC04N2Y1LTM0NjMxZjhmZDUyOQ==\" \\   'https://api.sandbox.velopayments.com/v1/authenticate?grant_type=client_credentials' ```  If successful, this call will result in a **200** HTTP status code and a response body such as:  ```   {     \"access_token\":\"19f6bafd-93fd-4747-b229-00507bbc991f\",     \"token_type\":\"bearer\",     \"expires_in\":1799,     \"scope\":\"...\"   } ``` ## API access following authentication Following successful authentication, the value of the access_token field in the response (indicated in green above) should then be presented with all subsequent API calls to allow the Velo platform to validate that the caller is authenticated.  This is achieved by setting the HTTP Authorization header with the value set to e.g. Bearer 19f6bafd-93fd-4747-b229-00507bbc991f such as the curl example below:  ```   -H \"Authorization: Bearer 19f6bafd-93fd-4747-b229-00507bbc991f \" ```  If you make other Velo API calls which require authorization but the Authorization header is missing or invalid then you will get a **401** HTTP status response. 
 *
 * The version of the OpenAPI document: 2.18.113
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.velopayments.oa3.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.velopayments.oa3.model.KycState;
import com.velopayments.oa3.model.PayorAddress;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.UUID;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import javax.validation.constraints.*;
import javax.validation.Valid;

/**
 * PayorV1
 */
@JsonPropertyOrder({
  PayorV1.JSON_PROPERTY_PAYOR_ID,
  PayorV1.JSON_PROPERTY_PAYOR_NAME,
  PayorV1.JSON_PROPERTY_ADDRESS,
  PayorV1.JSON_PROPERTY_PRIMARY_CONTACT_NAME,
  PayorV1.JSON_PROPERTY_PRIMARY_CONTACT_PHONE,
  PayorV1.JSON_PROPERTY_PRIMARY_CONTACT_EMAIL,
  PayorV1.JSON_PROPERTY_FUNDING_ACCOUNT_ROUTING_NUMBER,
  PayorV1.JSON_PROPERTY_FUNDING_ACCOUNT_ACCOUNT_NUMBER,
  PayorV1.JSON_PROPERTY_FUNDING_ACCOUNT_ACCOUNT_NAME,
  PayorV1.JSON_PROPERTY_KYC_STATE,
  PayorV1.JSON_PROPERTY_MANUAL_LOCKOUT,
  PayorV1.JSON_PROPERTY_PAYEE_GRACE_PERIOD_PROCESSING_ENABLED,
  PayorV1.JSON_PROPERTY_PAYEE_GRACE_PERIOD_DAYS,
  PayorV1.JSON_PROPERTY_COLLECTIVE_ALIAS,
  PayorV1.JSON_PROPERTY_SUPPORT_CONTACT,
  PayorV1.JSON_PROPERTY_DBA_NAME,
  PayorV1.JSON_PROPERTY_ALLOWS_LANGUAGE_CHOICE,
  PayorV1.JSON_PROPERTY_REMINDER_EMAILS_OPT_OUT,
  PayorV1.JSON_PROPERTY_LANGUAGE,
  PayorV1.JSON_PROPERTY_INCLUDES_REPORTS,
  PayorV1.JSON_PROPERTY_MAX_MASTER_PAYOR_ADMINS
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-01-15T12:59:39.508953-05:00[America/New_York]")
public class PayorV1 {
  public static final String JSON_PROPERTY_PAYOR_ID = "payorId";
  private UUID payorId;

  public static final String JSON_PROPERTY_PAYOR_NAME = "payorName";
  private String payorName;

  public static final String JSON_PROPERTY_ADDRESS = "address";
  private PayorAddress address;

  public static final String JSON_PROPERTY_PRIMARY_CONTACT_NAME = "primaryContactName";
  private String primaryContactName;

  public static final String JSON_PROPERTY_PRIMARY_CONTACT_PHONE = "primaryContactPhone";
  private String primaryContactPhone;

  public static final String JSON_PROPERTY_PRIMARY_CONTACT_EMAIL = "primaryContactEmail";
  private String primaryContactEmail;

  public static final String JSON_PROPERTY_FUNDING_ACCOUNT_ROUTING_NUMBER = "fundingAccountRoutingNumber";
  private String fundingAccountRoutingNumber;

  public static final String JSON_PROPERTY_FUNDING_ACCOUNT_ACCOUNT_NUMBER = "fundingAccountAccountNumber";
  private String fundingAccountAccountNumber;

  public static final String JSON_PROPERTY_FUNDING_ACCOUNT_ACCOUNT_NAME = "fundingAccountAccountName";
  private String fundingAccountAccountName;

  public static final String JSON_PROPERTY_KYC_STATE = "kycState";
  private KycState kycState;

  public static final String JSON_PROPERTY_MANUAL_LOCKOUT = "manualLockout";
  private Boolean manualLockout;

  public static final String JSON_PROPERTY_PAYEE_GRACE_PERIOD_PROCESSING_ENABLED = "payeeGracePeriodProcessingEnabled";
  private Boolean payeeGracePeriodProcessingEnabled;

  public static final String JSON_PROPERTY_PAYEE_GRACE_PERIOD_DAYS = "payeeGracePeriodDays";
  private Integer payeeGracePeriodDays;

  public static final String JSON_PROPERTY_COLLECTIVE_ALIAS = "collectiveAlias";
  private String collectiveAlias;

  public static final String JSON_PROPERTY_SUPPORT_CONTACT = "supportContact";
  private String supportContact;

  public static final String JSON_PROPERTY_DBA_NAME = "dbaName";
  private String dbaName;

  public static final String JSON_PROPERTY_ALLOWS_LANGUAGE_CHOICE = "allowsLanguageChoice";
  private Boolean allowsLanguageChoice;

  public static final String JSON_PROPERTY_REMINDER_EMAILS_OPT_OUT = "reminderEmailsOptOut";
  private Boolean reminderEmailsOptOut;

  /**
   * The payor’s language preference. Must be one of [EN, FR].
   */
  public enum LanguageEnum {
    EN("EN"),
    
    FR("FR");

    private String value;

    LanguageEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static LanguageEnum fromValue(String value) {
      for (LanguageEnum b : LanguageEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_LANGUAGE = "language";
  private LanguageEnum language;

  public static final String JSON_PROPERTY_INCLUDES_REPORTS = "includesReports";
  private Boolean includesReports;

  public static final String JSON_PROPERTY_MAX_MASTER_PAYOR_ADMINS = "maxMasterPayorAdmins";
  private Integer maxMasterPayorAdmins;


   /**
   * Get payorId
   * @return payorId
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PAYOR_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getPayorId() {
    return payorId;
  }




  public PayorV1 payorName(String payorName) {
    
    this.payorName = payorName;
    return this;
  }

   /**
   * The name of the payor.
   * @return payorName
  **/
  @NotNull
  @ApiModelProperty(example = "Example, Corp", required = true, value = "The name of the payor.")
  @JsonProperty(JSON_PROPERTY_PAYOR_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getPayorName() {
    return payorName;
  }


  public void setPayorName(String payorName) {
    this.payorName = payorName;
  }


  public PayorV1 address(PayorAddress address) {
    
    this.address = address;
    return this;
  }

   /**
   * Get address
   * @return address
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PayorAddress getAddress() {
    return address;
  }


  public void setAddress(PayorAddress address) {
    this.address = address;
  }


  public PayorV1 primaryContactName(String primaryContactName) {
    
    this.primaryContactName = primaryContactName;
    return this;
  }

   /**
   * Name of primary contact for the payor.
   * @return primaryContactName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "Joe Buck", value = "Name of primary contact for the payor.")
  @JsonProperty(JSON_PROPERTY_PRIMARY_CONTACT_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPrimaryContactName() {
    return primaryContactName;
  }


  public void setPrimaryContactName(String primaryContactName) {
    this.primaryContactName = primaryContactName;
  }


  public PayorV1 primaryContactPhone(String primaryContactPhone) {
    
    this.primaryContactPhone = primaryContactPhone;
    return this;
  }

   /**
   * Primary contact phone number for the payor.
   * @return primaryContactPhone
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "123-123-1234", value = "Primary contact phone number for the payor.")
  @JsonProperty(JSON_PROPERTY_PRIMARY_CONTACT_PHONE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPrimaryContactPhone() {
    return primaryContactPhone;
  }


  public void setPrimaryContactPhone(String primaryContactPhone) {
    this.primaryContactPhone = primaryContactPhone;
  }


  public PayorV1 primaryContactEmail(String primaryContactEmail) {
    
    this.primaryContactEmail = primaryContactEmail;
    return this;
  }

   /**
   * Primary contact email for the payor.
   * @return primaryContactEmail
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "joe.buck@example.com", value = "Primary contact email for the payor.")
  @JsonProperty(JSON_PROPERTY_PRIMARY_CONTACT_EMAIL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPrimaryContactEmail() {
    return primaryContactEmail;
  }


  public void setPrimaryContactEmail(String primaryContactEmail) {
    this.primaryContactEmail = primaryContactEmail;
  }


  public PayorV1 fundingAccountRoutingNumber(String fundingAccountRoutingNumber) {
    
    this.fundingAccountRoutingNumber = fundingAccountRoutingNumber;
    return this;
  }

   /**
   * The funding account routing number to be used for the payor.
   * @return fundingAccountRoutingNumber
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "123456789", value = "The funding account routing number to be used for the payor.")
  @JsonProperty(JSON_PROPERTY_FUNDING_ACCOUNT_ROUTING_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFundingAccountRoutingNumber() {
    return fundingAccountRoutingNumber;
  }


  public void setFundingAccountRoutingNumber(String fundingAccountRoutingNumber) {
    this.fundingAccountRoutingNumber = fundingAccountRoutingNumber;
  }


  public PayorV1 fundingAccountAccountNumber(String fundingAccountAccountNumber) {
    
    this.fundingAccountAccountNumber = fundingAccountAccountNumber;
    return this;
  }

   /**
   * The funding account number to be used for the payor.
   * @return fundingAccountAccountNumber
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "1234567890123", value = "The funding account number to be used for the payor.")
  @JsonProperty(JSON_PROPERTY_FUNDING_ACCOUNT_ACCOUNT_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFundingAccountAccountNumber() {
    return fundingAccountAccountNumber;
  }


  public void setFundingAccountAccountNumber(String fundingAccountAccountNumber) {
    this.fundingAccountAccountNumber = fundingAccountAccountNumber;
  }


  public PayorV1 fundingAccountAccountName(String fundingAccountAccountName) {
    
    this.fundingAccountAccountName = fundingAccountAccountName;
    return this;
  }

   /**
   * The funding account name to be used for the payor.
   * @return fundingAccountAccountName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "Example Corp BOA", value = "The funding account name to be used for the payor.")
  @JsonProperty(JSON_PROPERTY_FUNDING_ACCOUNT_ACCOUNT_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFundingAccountAccountName() {
    return fundingAccountAccountName;
  }


  public void setFundingAccountAccountName(String fundingAccountAccountName) {
    this.fundingAccountAccountName = fundingAccountAccountName;
  }


  public PayorV1 kycState(KycState kycState) {
    
    this.kycState = kycState;
    return this;
  }

   /**
   * Get kycState
   * @return kycState
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_KYC_STATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public KycState getKycState() {
    return kycState;
  }


  public void setKycState(KycState kycState) {
    this.kycState = kycState;
  }


  public PayorV1 manualLockout(Boolean manualLockout) {
    
    this.manualLockout = manualLockout;
    return this;
  }

   /**
   * Whether or not the payor has been manually locked by the backoffice.
   * @return manualLockout
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Whether or not the payor has been manually locked by the backoffice.")
  @JsonProperty(JSON_PROPERTY_MANUAL_LOCKOUT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getManualLockout() {
    return manualLockout;
  }


  public void setManualLockout(Boolean manualLockout) {
    this.manualLockout = manualLockout;
  }


   /**
   * Whether grace period processing is enabled.
   * @return payeeGracePeriodProcessingEnabled
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Whether grace period processing is enabled.")
  @JsonProperty(JSON_PROPERTY_PAYEE_GRACE_PERIOD_PROCESSING_ENABLED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getPayeeGracePeriodProcessingEnabled() {
    return payeeGracePeriodProcessingEnabled;
  }




   /**
   * The grace period for paying payees in days.
   * @return payeeGracePeriodDays
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The grace period for paying payees in days.")
  @JsonProperty(JSON_PROPERTY_PAYEE_GRACE_PERIOD_DAYS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getPayeeGracePeriodDays() {
    return payeeGracePeriodDays;
  }




  public PayorV1 collectiveAlias(String collectiveAlias) {
    
    this.collectiveAlias = collectiveAlias;
    return this;
  }

   /**
   * How the payor has chosen to refer to payees.
   * @return collectiveAlias
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "Payee", value = "How the payor has chosen to refer to payees.")
  @JsonProperty(JSON_PROPERTY_COLLECTIVE_ALIAS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCollectiveAlias() {
    return collectiveAlias;
  }


  public void setCollectiveAlias(String collectiveAlias) {
    this.collectiveAlias = collectiveAlias;
  }


  public PayorV1 supportContact(String supportContact) {
    
    this.supportContact = supportContact;
    return this;
  }

   /**
   * The payor’s support contact email address.
   * @return supportContact
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "support@example.com", value = "The payor’s support contact email address.")
  @JsonProperty(JSON_PROPERTY_SUPPORT_CONTACT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSupportContact() {
    return supportContact;
  }


  public void setSupportContact(String supportContact) {
    this.supportContact = supportContact;
  }


  public PayorV1 dbaName(String dbaName) {
    
    this.dbaName = dbaName;
    return this;
  }

   /**
   * The payor’s &#39;Doing Business As&#39; name.
   * @return dbaName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "Some Biz", value = "The payor’s 'Doing Business As' name.")
  @JsonProperty(JSON_PROPERTY_DBA_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDbaName() {
    return dbaName;
  }


  public void setDbaName(String dbaName) {
    this.dbaName = dbaName;
  }


  public PayorV1 allowsLanguageChoice(Boolean allowsLanguageChoice) {
    
    this.allowsLanguageChoice = allowsLanguageChoice;
    return this;
  }

   /**
   * Whether or not the payor allows language choice in the UI.
   * @return allowsLanguageChoice
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Whether or not the payor allows language choice in the UI.")
  @JsonProperty(JSON_PROPERTY_ALLOWS_LANGUAGE_CHOICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getAllowsLanguageChoice() {
    return allowsLanguageChoice;
  }


  public void setAllowsLanguageChoice(Boolean allowsLanguageChoice) {
    this.allowsLanguageChoice = allowsLanguageChoice;
  }


   /**
   * Whether or not the payor has opted-out of reminder emails being sent.
   * @return reminderEmailsOptOut
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Whether or not the payor has opted-out of reminder emails being sent.")
  @JsonProperty(JSON_PROPERTY_REMINDER_EMAILS_OPT_OUT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getReminderEmailsOptOut() {
    return reminderEmailsOptOut;
  }




  public PayorV1 language(LanguageEnum language) {
    
    this.language = language;
    return this;
  }

   /**
   * The payor’s language preference. Must be one of [EN, FR].
   * @return language
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "EN", value = "The payor’s language preference. Must be one of [EN, FR].")
  @JsonProperty(JSON_PROPERTY_LANGUAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LanguageEnum getLanguage() {
    return language;
  }


  public void setLanguage(LanguageEnum language) {
    this.language = language;
  }


  public PayorV1 includesReports(Boolean includesReports) {
    
    this.includesReports = includesReports;
    return this;
  }

   /**
   * Get includesReports
   * @return includesReports
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_INCLUDES_REPORTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIncludesReports() {
    return includesReports;
  }


  public void setIncludesReports(Boolean includesReports) {
    this.includesReports = includesReports;
  }


  public PayorV1 maxMasterPayorAdmins(Integer maxMasterPayorAdmins) {
    
    this.maxMasterPayorAdmins = maxMasterPayorAdmins;
    return this;
  }

   /**
   * Get maxMasterPayorAdmins
   * @return maxMasterPayorAdmins
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_MAX_MASTER_PAYOR_ADMINS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMaxMasterPayorAdmins() {
    return maxMasterPayorAdmins;
  }


  public void setMaxMasterPayorAdmins(Integer maxMasterPayorAdmins) {
    this.maxMasterPayorAdmins = maxMasterPayorAdmins;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PayorV1 payorV1 = (PayorV1) o;
    return Objects.equals(this.payorId, payorV1.payorId) &&
        Objects.equals(this.payorName, payorV1.payorName) &&
        Objects.equals(this.address, payorV1.address) &&
        Objects.equals(this.primaryContactName, payorV1.primaryContactName) &&
        Objects.equals(this.primaryContactPhone, payorV1.primaryContactPhone) &&
        Objects.equals(this.primaryContactEmail, payorV1.primaryContactEmail) &&
        Objects.equals(this.fundingAccountRoutingNumber, payorV1.fundingAccountRoutingNumber) &&
        Objects.equals(this.fundingAccountAccountNumber, payorV1.fundingAccountAccountNumber) &&
        Objects.equals(this.fundingAccountAccountName, payorV1.fundingAccountAccountName) &&
        Objects.equals(this.kycState, payorV1.kycState) &&
        Objects.equals(this.manualLockout, payorV1.manualLockout) &&
        Objects.equals(this.payeeGracePeriodProcessingEnabled, payorV1.payeeGracePeriodProcessingEnabled) &&
        Objects.equals(this.payeeGracePeriodDays, payorV1.payeeGracePeriodDays) &&
        Objects.equals(this.collectiveAlias, payorV1.collectiveAlias) &&
        Objects.equals(this.supportContact, payorV1.supportContact) &&
        Objects.equals(this.dbaName, payorV1.dbaName) &&
        Objects.equals(this.allowsLanguageChoice, payorV1.allowsLanguageChoice) &&
        Objects.equals(this.reminderEmailsOptOut, payorV1.reminderEmailsOptOut) &&
        Objects.equals(this.language, payorV1.language) &&
        Objects.equals(this.includesReports, payorV1.includesReports) &&
        Objects.equals(this.maxMasterPayorAdmins, payorV1.maxMasterPayorAdmins);
  }

  @Override
  public int hashCode() {
    return Objects.hash(payorId, payorName, address, primaryContactName, primaryContactPhone, primaryContactEmail, fundingAccountRoutingNumber, fundingAccountAccountNumber, fundingAccountAccountName, kycState, manualLockout, payeeGracePeriodProcessingEnabled, payeeGracePeriodDays, collectiveAlias, supportContact, dbaName, allowsLanguageChoice, reminderEmailsOptOut, language, includesReports, maxMasterPayorAdmins);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PayorV1 {\n");
    sb.append("    payorId: ").append(toIndentedString(payorId)).append("\n");
    sb.append("    payorName: ").append(toIndentedString(payorName)).append("\n");
    sb.append("    address: ").append(toIndentedString(address)).append("\n");
    sb.append("    primaryContactName: ").append(toIndentedString(primaryContactName)).append("\n");
    sb.append("    primaryContactPhone: ").append(toIndentedString(primaryContactPhone)).append("\n");
    sb.append("    primaryContactEmail: ").append(toIndentedString(primaryContactEmail)).append("\n");
    sb.append("    fundingAccountRoutingNumber: ").append(toIndentedString(fundingAccountRoutingNumber)).append("\n");
    sb.append("    fundingAccountAccountNumber: ").append(toIndentedString(fundingAccountAccountNumber)).append("\n");
    sb.append("    fundingAccountAccountName: ").append(toIndentedString(fundingAccountAccountName)).append("\n");
    sb.append("    kycState: ").append(toIndentedString(kycState)).append("\n");
    sb.append("    manualLockout: ").append(toIndentedString(manualLockout)).append("\n");
    sb.append("    payeeGracePeriodProcessingEnabled: ").append(toIndentedString(payeeGracePeriodProcessingEnabled)).append("\n");
    sb.append("    payeeGracePeriodDays: ").append(toIndentedString(payeeGracePeriodDays)).append("\n");
    sb.append("    collectiveAlias: ").append(toIndentedString(collectiveAlias)).append("\n");
    sb.append("    supportContact: ").append(toIndentedString(supportContact)).append("\n");
    sb.append("    dbaName: ").append(toIndentedString(dbaName)).append("\n");
    sb.append("    allowsLanguageChoice: ").append(toIndentedString(allowsLanguageChoice)).append("\n");
    sb.append("    reminderEmailsOptOut: ").append(toIndentedString(reminderEmailsOptOut)).append("\n");
    sb.append("    language: ").append(toIndentedString(language)).append("\n");
    sb.append("    includesReports: ").append(toIndentedString(includesReports)).append("\n");
    sb.append("    maxMasterPayorAdmins: ").append(toIndentedString(maxMasterPayorAdmins)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

