/*
 * Velo Payments APIs
 * ## Terms and Definitions  Throughout this document and the Velo platform the following terms are used:  * **Payor.** An entity (typically a corporation) which wishes to pay funds to one or more payees via a payout. * **Payee.** The recipient of funds paid out by a payor. * **Payment.** A single transfer of funds from a payor to a payee. * **Payout.** A batch of Payments, typically used by a payor to logically group payments (e.g. by business day). Technically there need be no relationship between the payments in a payout - a single payout can contain payments to multiple payees and/or multiple payments to a single payee. * **Sandbox.** An integration environment provided by Velo Payments which offers a similar API experience to the production environment, but all funding and payment events are simulated, along with many other services such as OFAC sanctions list checking.  ## Overview  The Velo Payments API allows a payor to perform a number of operations. The following is a list of the main capabilities in a natural order of execution:  * Authenticate with the Velo platform * Maintain a collection of payees * Query the payor’s current balance of funds within the platform and perform additional funding * Issue payments to payees * Query the platform for a history of those payments  This document describes the main concepts and APIs required to get up and running with the Velo Payments platform. It is not an exhaustive API reference. For that, please see the separate Velo Payments API Reference.  ## API Considerations  The Velo Payments API is REST based and uses the JSON format for requests and responses.  Most calls are secured using OAuth 2 security and require a valid authentication access token for successful operation. See the Authentication section for details.  Where a dynamic value is required in the examples below, the {token} format is used, suggesting that the caller needs to supply the appropriate value of the token in question (without including the { or } characters).  Where curl examples are given, the –d @filename.json approach is used, indicating that the request body should be placed into a file named filename.json in the current directory. Each of the curl examples in this document should be considered a single line on the command-line, regardless of how they appear in print.  ## Authenticating with the Velo Platform  Once Velo backoffice staff have added your organization as a payor within the Velo platform sandbox, they will create you a payor Id, an API key and an API secret and share these with you in a secure manner.  You will need to use these values to authenticate with the Velo platform in order to gain access to the APIs. The steps to take are explained in the following:  create a string comprising the API key (e.g. 44a9537d-d55d-4b47-8082-14061c2bcdd8) and API secret (e.g. c396b26b-137a-44fd-87f5-34631f8fd529) with a colon between them. E.g. 44a9537d-d55d-4b47-8082-14061c2bcdd8:c396b26b-137a-44fd-87f5-34631f8fd529  base64 encode this string. E.g.: NDRhOTUzN2QtZDU1ZC00YjQ3LTgwODItMTQwNjFjMmJjZGQ4OmMzOTZiMjZiLTEzN2EtNDRmZC04N2Y1LTM0NjMxZjhmZDUyOQ==  create an HTTP **Authorization** header with the value set to e.g. Basic NDRhOTUzN2QtZDU1ZC00YjQ3LTgwODItMTQwNjFjMmJjZGQ4OmMzOTZiMjZiLTEzN2EtNDRmZC04N2Y1LTM0NjMxZjhmZDUyOQ==  perform the Velo authentication REST call using the HTTP header created above e.g. via curl:  ```   curl -X POST \\   -H \"Content-Type: application/json\" \\   -H \"Authorization: Basic NDRhOTUzN2QtZDU1ZC00YjQ3LTgwODItMTQwNjFjMmJjZGQ4OmMzOTZiMjZiLTEzN2EtNDRmZC04N2Y1LTM0NjMxZjhmZDUyOQ==\" \\   'https://api.sandbox.velopayments.com/v1/authenticate?grant_type=client_credentials' ```  If successful, this call will result in a **200** HTTP status code and a response body such as:  ```   {     \"access_token\":\"19f6bafd-93fd-4747-b229-00507bbc991f\",     \"token_type\":\"bearer\",     \"expires_in\":1799,     \"scope\":\"...\"   } ``` ## API access following authentication Following successful authentication, the value of the access_token field in the response (indicated in green above) should then be presented with all subsequent API calls to allow the Velo platform to validate that the caller is authenticated.  This is achieved by setting the HTTP Authorization header with the value set to e.g. Bearer 19f6bafd-93fd-4747-b229-00507bbc991f such as the curl example below:  ```   -H \"Authorization: Bearer 19f6bafd-93fd-4747-b229-00507bbc991f \" ```  If you make other Velo API calls which require authorization but the Authorization header is missing or invalid then you will get a **401** HTTP status response. 
 *
 * The version of the OpenAPI document: 2.18.113
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.velopayments.oa3.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.velopayments.oa3.model.AutoTopUpConfig;
import com.velopayments.oa3.model.Notifications;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.UUID;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import javax.validation.constraints.*;
import javax.validation.Valid;

/**
 * SourceAccountResponseV2
 */
@JsonPropertyOrder({
  SourceAccountResponseV2.JSON_PROPERTY_ID,
  SourceAccountResponseV2.JSON_PROPERTY_BALANCE,
  SourceAccountResponseV2.JSON_PROPERTY_CURRENCY,
  SourceAccountResponseV2.JSON_PROPERTY_FUNDING_REF,
  SourceAccountResponseV2.JSON_PROPERTY_PHYSICAL_ACCOUNT_NAME,
  SourceAccountResponseV2.JSON_PROPERTY_RAILS_ID,
  SourceAccountResponseV2.JSON_PROPERTY_PAYOR_ID,
  SourceAccountResponseV2.JSON_PROPERTY_NAME,
  SourceAccountResponseV2.JSON_PROPERTY_POOLED,
  SourceAccountResponseV2.JSON_PROPERTY_BALANCE_VISIBLE,
  SourceAccountResponseV2.JSON_PROPERTY_CUSTOMER_ID,
  SourceAccountResponseV2.JSON_PROPERTY_PHYSICAL_ACCOUNT_ID,
  SourceAccountResponseV2.JSON_PROPERTY_NOTIFICATIONS,
  SourceAccountResponseV2.JSON_PROPERTY_FUNDING_ACCOUNT_ID,
  SourceAccountResponseV2.JSON_PROPERTY_AUTO_TOP_UP_CONFIG
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-01-15T12:59:39.508953-05:00[America/New_York]")
public class SourceAccountResponseV2 {
  public static final String JSON_PROPERTY_ID = "id";
  private UUID id;

  public static final String JSON_PROPERTY_BALANCE = "balance";
  private Long balance;

  /**
   * Gets or Sets currency
   */
  public enum CurrencyEnum {
    USD("USD");

    private String value;

    CurrencyEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static CurrencyEnum fromValue(String value) {
      for (CurrencyEnum b : CurrencyEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_CURRENCY = "currency";
  private CurrencyEnum currency;

  public static final String JSON_PROPERTY_FUNDING_REF = "fundingRef";
  private String fundingRef;

  public static final String JSON_PROPERTY_PHYSICAL_ACCOUNT_NAME = "physicalAccountName";
  private String physicalAccountName;

  public static final String JSON_PROPERTY_RAILS_ID = "railsId";
  private String railsId;

  public static final String JSON_PROPERTY_PAYOR_ID = "payorId";
  private UUID payorId;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_POOLED = "pooled";
  private Boolean pooled;

  public static final String JSON_PROPERTY_BALANCE_VISIBLE = "balanceVisible";
  private Boolean balanceVisible;

  public static final String JSON_PROPERTY_CUSTOMER_ID = "customerId";
  private JsonNullable<String> customerId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_PHYSICAL_ACCOUNT_ID = "physicalAccountId";
  private UUID physicalAccountId;

  public static final String JSON_PROPERTY_NOTIFICATIONS = "notifications";
  private Notifications notifications;

  public static final String JSON_PROPERTY_FUNDING_ACCOUNT_ID = "fundingAccountId";
  private JsonNullable<UUID> fundingAccountId = JsonNullable.<UUID>undefined();

  public static final String JSON_PROPERTY_AUTO_TOP_UP_CONFIG = "autoTopUpConfig";
  private AutoTopUpConfig autoTopUpConfig;


  public SourceAccountResponseV2 id(UUID id) {
    
    this.id = id;
    return this;
  }

   /**
   * Source Account Id
   * @return id
  **/
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "Source Account Id")
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getId() {
    return id;
  }


  public void setId(UUID id) {
    this.id = id;
  }


  public SourceAccountResponseV2 balance(Long balance) {
    
    this.balance = balance;
    return this;
  }

   /**
   * Decimal implied
   * @return balance
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "1203489", value = "Decimal implied")
  @JsonProperty(JSON_PROPERTY_BALANCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getBalance() {
    return balance;
  }


  public void setBalance(Long balance) {
    this.balance = balance;
  }


  public SourceAccountResponseV2 currency(CurrencyEnum currency) {
    
    this.currency = currency;
    return this;
  }

   /**
   * Get currency
   * @return currency
  **/
  @javax.annotation.Nullable
 @Size(min=3,max=3)  @ApiModelProperty(example = "USD", value = "")
  @JsonProperty(JSON_PROPERTY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CurrencyEnum getCurrency() {
    return currency;
  }


  public void setCurrency(CurrencyEnum currency) {
    this.currency = currency;
  }


  public SourceAccountResponseV2 fundingRef(String fundingRef) {
    
    this.fundingRef = fundingRef;
    return this;
  }

   /**
   * Get fundingRef
   * @return fundingRef
  **/
  @NotNull
  @ApiModelProperty(example = "a1b2c3d4", required = true, value = "")
  @JsonProperty(JSON_PROPERTY_FUNDING_REF)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getFundingRef() {
    return fundingRef;
  }


  public void setFundingRef(String fundingRef) {
    this.fundingRef = fundingRef;
  }


  public SourceAccountResponseV2 physicalAccountName(String physicalAccountName) {
    
    this.physicalAccountName = physicalAccountName;
    return this;
  }

   /**
   * Get physicalAccountName
   * @return physicalAccountName
  **/
  @NotNull
  @ApiModelProperty(example = "VELO_FBO_MYBANKA_USD", required = true, value = "")
  @JsonProperty(JSON_PROPERTY_PHYSICAL_ACCOUNT_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getPhysicalAccountName() {
    return physicalAccountName;
  }


  public void setPhysicalAccountName(String physicalAccountName) {
    this.physicalAccountName = physicalAccountName;
  }


  public SourceAccountResponseV2 railsId(String railsId) {
    
    this.railsId = railsId;
    return this;
  }

   /**
   * Get railsId
   * @return railsId
  **/
  @NotNull
  @ApiModelProperty(example = "BOA_RAIL", required = true, value = "")
  @JsonProperty(JSON_PROPERTY_RAILS_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getRailsId() {
    return railsId;
  }


  public void setRailsId(String railsId) {
    this.railsId = railsId;
  }


  public SourceAccountResponseV2 payorId(UUID payorId) {
    
    this.payorId = payorId;
    return this;
  }

   /**
   * Get payorId
   * @return payorId
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PAYOR_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getPayorId() {
    return payorId;
  }


  public void setPayorId(UUID payorId) {
    this.payorId = payorId;
  }


  public SourceAccountResponseV2 name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Get name
   * @return name
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "MyAccountName", value = "")
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getName() {
    return name;
  }


  public void setName(String name) {
    this.name = name;
  }


  public SourceAccountResponseV2 pooled(Boolean pooled) {
    
    this.pooled = pooled;
    return this;
  }

   /**
   * Get pooled
   * @return pooled
  **/
  @NotNull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_POOLED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getPooled() {
    return pooled;
  }


  public void setPooled(Boolean pooled) {
    this.pooled = pooled;
  }


  public SourceAccountResponseV2 balanceVisible(Boolean balanceVisible) {
    
    this.balanceVisible = balanceVisible;
    return this;
  }

   /**
   * Get balanceVisible
   * @return balanceVisible
  **/
  @NotNull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_BALANCE_VISIBLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getBalanceVisible() {
    return balanceVisible;
  }


  public void setBalanceVisible(Boolean balanceVisible) {
    this.balanceVisible = balanceVisible;
  }


  public SourceAccountResponseV2 customerId(String customerId) {
    this.customerId = JsonNullable.<String>of(customerId);
    
    return this;
  }

   /**
   * Get customerId
   * @return customerId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "Joe Customer", value = "")
  @JsonIgnore

  public String getCustomerId() {
        return customerId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_CUSTOMER_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getCustomerId_JsonNullable() {
    return customerId;
  }
  
  @JsonProperty(JSON_PROPERTY_CUSTOMER_ID)
  public void setCustomerId_JsonNullable(JsonNullable<String> customerId) {
    this.customerId = customerId;
  }

  public void setCustomerId(String customerId) {
    this.customerId = JsonNullable.<String>of(customerId);
  }


  public SourceAccountResponseV2 physicalAccountId(UUID physicalAccountId) {
    
    this.physicalAccountId = physicalAccountId;
    return this;
  }

   /**
   * Get physicalAccountId
   * @return physicalAccountId
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PHYSICAL_ACCOUNT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getPhysicalAccountId() {
    return physicalAccountId;
  }


  public void setPhysicalAccountId(UUID physicalAccountId) {
    this.physicalAccountId = physicalAccountId;
  }


  public SourceAccountResponseV2 notifications(Notifications notifications) {
    
    this.notifications = notifications;
    return this;
  }

   /**
   * Get notifications
   * @return notifications
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_NOTIFICATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Notifications getNotifications() {
    return notifications;
  }


  public void setNotifications(Notifications notifications) {
    this.notifications = notifications;
  }


  public SourceAccountResponseV2 fundingAccountId(UUID fundingAccountId) {
    this.fundingAccountId = JsonNullable.<UUID>of(fundingAccountId);
    
    return this;
  }

   /**
   * Get fundingAccountId
   * @return fundingAccountId
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonIgnore

  public UUID getFundingAccountId() {
        return fundingAccountId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_FUNDING_ACCOUNT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<UUID> getFundingAccountId_JsonNullable() {
    return fundingAccountId;
  }
  
  @JsonProperty(JSON_PROPERTY_FUNDING_ACCOUNT_ID)
  public void setFundingAccountId_JsonNullable(JsonNullable<UUID> fundingAccountId) {
    this.fundingAccountId = fundingAccountId;
  }

  public void setFundingAccountId(UUID fundingAccountId) {
    this.fundingAccountId = JsonNullable.<UUID>of(fundingAccountId);
  }


  public SourceAccountResponseV2 autoTopUpConfig(AutoTopUpConfig autoTopUpConfig) {
    
    this.autoTopUpConfig = autoTopUpConfig;
    return this;
  }

   /**
   * Get autoTopUpConfig
   * @return autoTopUpConfig
  **/
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_AUTO_TOP_UP_CONFIG)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public AutoTopUpConfig getAutoTopUpConfig() {
    return autoTopUpConfig;
  }


  public void setAutoTopUpConfig(AutoTopUpConfig autoTopUpConfig) {
    this.autoTopUpConfig = autoTopUpConfig;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SourceAccountResponseV2 sourceAccountResponseV2 = (SourceAccountResponseV2) o;
    return Objects.equals(this.id, sourceAccountResponseV2.id) &&
        Objects.equals(this.balance, sourceAccountResponseV2.balance) &&
        Objects.equals(this.currency, sourceAccountResponseV2.currency) &&
        Objects.equals(this.fundingRef, sourceAccountResponseV2.fundingRef) &&
        Objects.equals(this.physicalAccountName, sourceAccountResponseV2.physicalAccountName) &&
        Objects.equals(this.railsId, sourceAccountResponseV2.railsId) &&
        Objects.equals(this.payorId, sourceAccountResponseV2.payorId) &&
        Objects.equals(this.name, sourceAccountResponseV2.name) &&
        Objects.equals(this.pooled, sourceAccountResponseV2.pooled) &&
        Objects.equals(this.balanceVisible, sourceAccountResponseV2.balanceVisible) &&
        Objects.equals(this.customerId, sourceAccountResponseV2.customerId) &&
        Objects.equals(this.physicalAccountId, sourceAccountResponseV2.physicalAccountId) &&
        Objects.equals(this.notifications, sourceAccountResponseV2.notifications) &&
        Objects.equals(this.fundingAccountId, sourceAccountResponseV2.fundingAccountId) &&
        Objects.equals(this.autoTopUpConfig, sourceAccountResponseV2.autoTopUpConfig);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, balance, currency, fundingRef, physicalAccountName, railsId, payorId, name, pooled, balanceVisible, customerId, physicalAccountId, notifications, fundingAccountId, autoTopUpConfig);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SourceAccountResponseV2 {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    balance: ").append(toIndentedString(balance)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    fundingRef: ").append(toIndentedString(fundingRef)).append("\n");
    sb.append("    physicalAccountName: ").append(toIndentedString(physicalAccountName)).append("\n");
    sb.append("    railsId: ").append(toIndentedString(railsId)).append("\n");
    sb.append("    payorId: ").append(toIndentedString(payorId)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    pooled: ").append(toIndentedString(pooled)).append("\n");
    sb.append("    balanceVisible: ").append(toIndentedString(balanceVisible)).append("\n");
    sb.append("    customerId: ").append(toIndentedString(customerId)).append("\n");
    sb.append("    physicalAccountId: ").append(toIndentedString(physicalAccountId)).append("\n");
    sb.append("    notifications: ").append(toIndentedString(notifications)).append("\n");
    sb.append("    fundingAccountId: ").append(toIndentedString(fundingAccountId)).append("\n");
    sb.append("    autoTopUpConfig: ").append(toIndentedString(autoTopUpConfig)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

