/*
 * Velo Payments APIs
 * ## Terms and Definitions  Throughout this document and the Velo platform the following terms are used:  * **Payor.** An entity (typically a corporation) which wishes to pay funds to one or more payees via a payout. * **Payee.** The recipient of funds paid out by a payor. * **Payment.** A single transfer of funds from a payor to a payee. * **Payout.** A batch of Payments, typically used by a payor to logically group payments (e.g. by business day). Technically there need be no relationship between the payments in a payout - a single payout can contain payments to multiple payees and/or multiple payments to a single payee. * **Sandbox.** An integration environment provided by Velo Payments which offers a similar API experience to the production environment, but all funding and payment events are simulated, along with many other services such as OFAC sanctions list checking.  ## Overview  The Velo Payments API allows a payor to perform a number of operations. The following is a list of the main capabilities in a natural order of execution:  * Authenticate with the Velo platform * Maintain a collection of payees * Query the payor’s current balance of funds within the platform and perform additional funding * Issue payments to payees * Query the platform for a history of those payments  This document describes the main concepts and APIs required to get up and running with the Velo Payments platform. It is not an exhaustive API reference. For that, please see the separate Velo Payments API Reference.  ## API Considerations  The Velo Payments API is REST based and uses the JSON format for requests and responses.  Most calls are secured using OAuth 2 security and require a valid authentication access token for successful operation. See the Authentication section for details.  Where a dynamic value is required in the examples below, the {token} format is used, suggesting that the caller needs to supply the appropriate value of the token in question (without including the { or } characters).  Where curl examples are given, the –d @filename.json approach is used, indicating that the request body should be placed into a file named filename.json in the current directory. Each of the curl examples in this document should be considered a single line on the command-line, regardless of how they appear in print.  ## Authenticating with the Velo Platform  Once Velo backoffice staff have added your organization as a payor within the Velo platform sandbox, they will create you a payor Id, an API key and an API secret and share these with you in a secure manner.  You will need to use these values to authenticate with the Velo platform in order to gain access to the APIs. The steps to take are explained in the following:  create a string comprising the API key (e.g. 44a9537d-d55d-4b47-8082-14061c2bcdd8) and API secret (e.g. c396b26b-137a-44fd-87f5-34631f8fd529) with a colon between them. E.g. 44a9537d-d55d-4b47-8082-14061c2bcdd8:c396b26b-137a-44fd-87f5-34631f8fd529  base64 encode this string. E.g.: NDRhOTUzN2QtZDU1ZC00YjQ3LTgwODItMTQwNjFjMmJjZGQ4OmMzOTZiMjZiLTEzN2EtNDRmZC04N2Y1LTM0NjMxZjhmZDUyOQ==  create an HTTP **Authorization** header with the value set to e.g. Basic NDRhOTUzN2QtZDU1ZC00YjQ3LTgwODItMTQwNjFjMmJjZGQ4OmMzOTZiMjZiLTEzN2EtNDRmZC04N2Y1LTM0NjMxZjhmZDUyOQ==  perform the Velo authentication REST call using the HTTP header created above e.g. via curl:  ```   curl -X POST \\   -H \"Content-Type: application/json\" \\   -H \"Authorization: Basic NDRhOTUzN2QtZDU1ZC00YjQ3LTgwODItMTQwNjFjMmJjZGQ4OmMzOTZiMjZiLTEzN2EtNDRmZC04N2Y1LTM0NjMxZjhmZDUyOQ==\" \\   'https://api.sandbox.velopayments.com/v1/authenticate?grant_type=client_credentials' ```  If successful, this call will result in a **200** HTTP status code and a response body such as:  ```   {     \"access_token\":\"19f6bafd-93fd-4747-b229-00507bbc991f\",     \"token_type\":\"bearer\",     \"expires_in\":1799,     \"scope\":\"...\"   } ``` ## API access following authentication Following successful authentication, the value of the access_token field in the response (indicated in green above) should then be presented with all subsequent API calls to allow the Velo platform to validate that the caller is authenticated.  This is achieved by setting the HTTP Authorization header with the value set to e.g. Bearer 19f6bafd-93fd-4747-b229-00507bbc991f such as the curl example below:  ```   -H \"Authorization: Bearer 19f6bafd-93fd-4747-b229-00507bbc991f \" ```  If you make other Velo API calls which require authorization but the Authorization header is missing or invalid then you will get a **401** HTTP status response. 
 *
 * The version of the OpenAPI document: 2.18.113
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.velopayments.oa3.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.velopayments.oa3.model.Role;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import javax.validation.constraints.*;
import javax.validation.Valid;

/**
 * UserResponse
 */
@JsonPropertyOrder({
  UserResponse.JSON_PROPERTY_ID,
  UserResponse.JSON_PROPERTY_STATUS,
  UserResponse.JSON_PROPERTY_EMAIL,
  UserResponse.JSON_PROPERTY_SMS_NUMBER,
  UserResponse.JSON_PROPERTY_PRIMARY_CONTACT_NUMBER,
  UserResponse.JSON_PROPERTY_SECONDARY_CONTACT_NUMBER,
  UserResponse.JSON_PROPERTY_FIRST_NAME,
  UserResponse.JSON_PROPERTY_LAST_NAME,
  UserResponse.JSON_PROPERTY_ENTITY_ID,
  UserResponse.JSON_PROPERTY_ROLES,
  UserResponse.JSON_PROPERTY_MFA_TYPE,
  UserResponse.JSON_PROPERTY_MFA_STATUS,
  UserResponse.JSON_PROPERTY_LOCKED_OUT,
  UserResponse.JSON_PROPERTY_LOCKED_OUT_TIMESTAMP
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-01-15T12:59:39.508953-05:00[America/New_York]")
public class UserResponse {
  public static final String JSON_PROPERTY_ID = "id";
  private UUID id;

  /**
   * The status of the user when the user has been invited but not yet enrolled they will have a PENDING status 
   */
  public enum StatusEnum {
    ENABLED("ENABLED"),
    
    DISABLED("DISABLED"),
    
    PENDING("PENDING");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StatusEnum fromValue(String value) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_STATUS = "status";
  private StatusEnum status;

  public static final String JSON_PROPERTY_EMAIL = "email";
  private String email;

  public static final String JSON_PROPERTY_SMS_NUMBER = "smsNumber";
  private String smsNumber;

  public static final String JSON_PROPERTY_PRIMARY_CONTACT_NUMBER = "primaryContactNumber";
  private String primaryContactNumber;

  public static final String JSON_PROPERTY_SECONDARY_CONTACT_NUMBER = "secondaryContactNumber";
  private String secondaryContactNumber;

  public static final String JSON_PROPERTY_FIRST_NAME = "firstName";
  private String firstName;

  public static final String JSON_PROPERTY_LAST_NAME = "lastName";
  private String lastName;

  public static final String JSON_PROPERTY_ENTITY_ID = "entityId";
  private UUID entityId;

  public static final String JSON_PROPERTY_ROLES = "roles";
  private List<Role> roles = null;

  /**
   * The type of the MFA device
   */
  public enum MfaTypeEnum {
    SMS("SMS"),
    
    YUBIKEY("YUBIKEY"),
    
    TOTP("TOTP");

    private String value;

    MfaTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static MfaTypeEnum fromValue(String value) {
      for (MfaTypeEnum b : MfaTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_MFA_TYPE = "mfaType";
  private MfaTypeEnum mfaType;

  /**
   * The status of the MFA device
   */
  public enum MfaStatusEnum {
    REGISTERED("REGISTERED"),
    
    UNREGISTERED("UNREGISTERED");

    private String value;

    MfaStatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static MfaStatusEnum fromValue(String value) {
      for (MfaStatusEnum b : MfaStatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_MFA_STATUS = "mfaStatus";
  private MfaStatusEnum mfaStatus;

  public static final String JSON_PROPERTY_LOCKED_OUT = "lockedOut";
  private Boolean lockedOut;

  public static final String JSON_PROPERTY_LOCKED_OUT_TIMESTAMP = "lockedOutTimestamp";
  private JsonNullable<OffsetDateTime> lockedOutTimestamp = JsonNullable.<OffsetDateTime>undefined();


  public UserResponse id(UUID id) {
    
    this.id = id;
    return this;
  }

   /**
   * The id of the user
   * @return id
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(example = "8bbf301c-948f-4445-b411-357eec53e441", value = "The id of the user")
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getId() {
    return id;
  }


  public void setId(UUID id) {
    this.id = id;
  }


  public UserResponse status(StatusEnum status) {
    
    this.status = status;
    return this;
  }

   /**
   * The status of the user when the user has been invited but not yet enrolled they will have a PENDING status 
   * @return status
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "ENABLED", value = "The status of the user when the user has been invited but not yet enrolled they will have a PENDING status ")
  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public StatusEnum getStatus() {
    return status;
  }


  public void setStatus(StatusEnum status) {
    this.status = status;
  }


  public UserResponse email(String email) {
    
    this.email = email;
    return this;
  }

   /**
   * the email address of the user
   * @return email
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "foo@example.com", value = "the email address of the user")
  @JsonProperty(JSON_PROPERTY_EMAIL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getEmail() {
    return email;
  }


  public void setEmail(String email) {
    this.email = email;
  }


  public UserResponse smsNumber(String smsNumber) {
    
    this.smsNumber = smsNumber;
    return this;
  }

   /**
   * The phone number of a device that the user can receive sms messages on 
   * @return smsNumber
  **/
  @javax.annotation.Nullable
 @Pattern(regexp="^\\+?[1-9]\\d{1,14}$")  @ApiModelProperty(example = "11235555555", value = "The phone number of a device that the user can receive sms messages on ")
  @JsonProperty(JSON_PROPERTY_SMS_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSmsNumber() {
    return smsNumber;
  }


  public void setSmsNumber(String smsNumber) {
    this.smsNumber = smsNumber;
  }


  public UserResponse primaryContactNumber(String primaryContactNumber) {
    
    this.primaryContactNumber = primaryContactNumber;
    return this;
  }

   /**
   * The main contact number for the user 
   * @return primaryContactNumber
  **/
  @javax.annotation.Nullable
 @Pattern(regexp="^\\+?[1-9]\\d{1,14}$")  @ApiModelProperty(example = "11235555555", value = "The main contact number for the user ")
  @JsonProperty(JSON_PROPERTY_PRIMARY_CONTACT_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPrimaryContactNumber() {
    return primaryContactNumber;
  }


  public void setPrimaryContactNumber(String primaryContactNumber) {
    this.primaryContactNumber = primaryContactNumber;
  }


  public UserResponse secondaryContactNumber(String secondaryContactNumber) {
    
    this.secondaryContactNumber = secondaryContactNumber;
    return this;
  }

   /**
   * The secondary contact number for the user 
   * @return secondaryContactNumber
  **/
  @javax.annotation.Nullable
 @Pattern(regexp="^\\+?[1-9]\\d{1,14}$")  @ApiModelProperty(example = "11235555550", value = "The secondary contact number for the user ")
  @JsonProperty(JSON_PROPERTY_SECONDARY_CONTACT_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSecondaryContactNumber() {
    return secondaryContactNumber;
  }


  public void setSecondaryContactNumber(String secondaryContactNumber) {
    this.secondaryContactNumber = secondaryContactNumber;
  }


  public UserResponse firstName(String firstName) {
    
    this.firstName = firstName;
    return this;
  }

   /**
   * Get firstName
   * @return firstName
  **/
  @javax.annotation.Nullable
 @Size(min=1,max=128)  @ApiModelProperty(example = "John", value = "")
  @JsonProperty(JSON_PROPERTY_FIRST_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFirstName() {
    return firstName;
  }


  public void setFirstName(String firstName) {
    this.firstName = firstName;
  }


  public UserResponse lastName(String lastName) {
    
    this.lastName = lastName;
    return this;
  }

   /**
   * Get lastName
   * @return lastName
  **/
  @javax.annotation.Nullable
 @Size(min=1,max=128)  @ApiModelProperty(example = "Doe", value = "")
  @JsonProperty(JSON_PROPERTY_LAST_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLastName() {
    return lastName;
  }


  public void setLastName(String lastName) {
    this.lastName = lastName;
  }


  public UserResponse entityId(UUID entityId) {
    
    this.entityId = entityId;
    return this;
  }

   /**
   * The payorId or payeeId or null if the user is not a payor or payee user 
   * @return entityId
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(example = "7fffa261-ac68-49e6-b605-d24a444d9206", value = "The payorId or payeeId or null if the user is not a payor or payee user ")
  @JsonProperty(JSON_PROPERTY_ENTITY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getEntityId() {
    return entityId;
  }


  public void setEntityId(UUID entityId) {
    this.entityId = entityId;
  }


  public UserResponse roles(List<Role> roles) {
    
    this.roles = roles;
    return this;
  }

  public UserResponse addRolesItem(Role rolesItem) {
    if (this.roles == null) {
      this.roles = new ArrayList<>();
    }
    this.roles.add(rolesItem);
    return this;
  }

   /**
   * The role(s) for the user 
   * @return roles
  **/
  @javax.annotation.Nullable
  @Valid
 @Size(min=1)  @ApiModelProperty(example = "[\"payor.admin\"]", value = "The role(s) for the user ")
  @JsonProperty(JSON_PROPERTY_ROLES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Role> getRoles() {
    return roles;
  }


  public void setRoles(List<Role> roles) {
    this.roles = roles;
  }


  public UserResponse mfaType(MfaTypeEnum mfaType) {
    
    this.mfaType = mfaType;
    return this;
  }

   /**
   * The type of the MFA device
   * @return mfaType
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "TOTP", value = "The type of the MFA device")
  @JsonProperty(JSON_PROPERTY_MFA_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MfaTypeEnum getMfaType() {
    return mfaType;
  }


  public void setMfaType(MfaTypeEnum mfaType) {
    this.mfaType = mfaType;
  }


  public UserResponse mfaStatus(MfaStatusEnum mfaStatus) {
    
    this.mfaStatus = mfaStatus;
    return this;
  }

   /**
   * The status of the MFA device
   * @return mfaStatus
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "REGISTERED", value = "The status of the MFA device")
  @JsonProperty(JSON_PROPERTY_MFA_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MfaStatusEnum getMfaStatus() {
    return mfaStatus;
  }


  public void setMfaStatus(MfaStatusEnum mfaStatus) {
    this.mfaStatus = mfaStatus;
  }


  public UserResponse lockedOut(Boolean lockedOut) {
    
    this.lockedOut = lockedOut;
    return this;
  }

   /**
   * If true the user is currently locked out and unable to log in
   * @return lockedOut
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "true", value = "If true the user is currently locked out and unable to log in")
  @JsonProperty(JSON_PROPERTY_LOCKED_OUT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getLockedOut() {
    return lockedOut;
  }


  public void setLockedOut(Boolean lockedOut) {
    this.lockedOut = lockedOut;
  }


  public UserResponse lockedOutTimestamp(OffsetDateTime lockedOutTimestamp) {
    this.lockedOutTimestamp = JsonNullable.<OffsetDateTime>of(lockedOutTimestamp);
    
    return this;
  }

   /**
   * A timestamp showing when the user was locked out If null then the user is not currently locked out 
   * @return lockedOutTimestamp
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "A timestamp showing when the user was locked out If null then the user is not currently locked out ")
  @JsonIgnore

  public OffsetDateTime getLockedOutTimestamp() {
        return lockedOutTimestamp.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_LOCKED_OUT_TIMESTAMP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<OffsetDateTime> getLockedOutTimestamp_JsonNullable() {
    return lockedOutTimestamp;
  }
  
  @JsonProperty(JSON_PROPERTY_LOCKED_OUT_TIMESTAMP)
  public void setLockedOutTimestamp_JsonNullable(JsonNullable<OffsetDateTime> lockedOutTimestamp) {
    this.lockedOutTimestamp = lockedOutTimestamp;
  }

  public void setLockedOutTimestamp(OffsetDateTime lockedOutTimestamp) {
    this.lockedOutTimestamp = JsonNullable.<OffsetDateTime>of(lockedOutTimestamp);
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UserResponse userResponse = (UserResponse) o;
    return Objects.equals(this.id, userResponse.id) &&
        Objects.equals(this.status, userResponse.status) &&
        Objects.equals(this.email, userResponse.email) &&
        Objects.equals(this.smsNumber, userResponse.smsNumber) &&
        Objects.equals(this.primaryContactNumber, userResponse.primaryContactNumber) &&
        Objects.equals(this.secondaryContactNumber, userResponse.secondaryContactNumber) &&
        Objects.equals(this.firstName, userResponse.firstName) &&
        Objects.equals(this.lastName, userResponse.lastName) &&
        Objects.equals(this.entityId, userResponse.entityId) &&
        Objects.equals(this.roles, userResponse.roles) &&
        Objects.equals(this.mfaType, userResponse.mfaType) &&
        Objects.equals(this.mfaStatus, userResponse.mfaStatus) &&
        Objects.equals(this.lockedOut, userResponse.lockedOut) &&
        Objects.equals(this.lockedOutTimestamp, userResponse.lockedOutTimestamp);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, status, email, smsNumber, primaryContactNumber, secondaryContactNumber, firstName, lastName, entityId, roles, mfaType, mfaStatus, lockedOut, lockedOutTimestamp);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UserResponse {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    email: ").append(toIndentedString(email)).append("\n");
    sb.append("    smsNumber: ").append(toIndentedString(smsNumber)).append("\n");
    sb.append("    primaryContactNumber: ").append(toIndentedString(primaryContactNumber)).append("\n");
    sb.append("    secondaryContactNumber: ").append(toIndentedString(secondaryContactNumber)).append("\n");
    sb.append("    firstName: ").append(toIndentedString(firstName)).append("\n");
    sb.append("    lastName: ").append(toIndentedString(lastName)).append("\n");
    sb.append("    entityId: ").append(toIndentedString(entityId)).append("\n");
    sb.append("    roles: ").append(toIndentedString(roles)).append("\n");
    sb.append("    mfaType: ").append(toIndentedString(mfaType)).append("\n");
    sb.append("    mfaStatus: ").append(toIndentedString(mfaStatus)).append("\n");
    sb.append("    lockedOut: ").append(toIndentedString(lockedOut)).append("\n");
    sb.append("    lockedOutTimestamp: ").append(toIndentedString(lockedOutTimestamp)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

