/*
 * Decompiled with CFR 0.152.
 */
package com.velopayments.oa3.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.velopayments.oa3.model.PayeeType;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;

@JsonPropertyOrder(value={"type", "remoteId", "email", "addressLine1", "addressLine2", "addressLine3", "addressLine4", "addressCity", "addressCountyOrProvince", "addressZipOrPostcode", "addressCountry", "individualNationalIdentification", "individualDateOfBirth", "individualTitle", "individualFirstName", "individualOtherNames", "individualLastName", "companyName", "companyEIN", "companyOperatingName", "paymentChannelAccountNumber", "paymentChannelRoutingNumber", "paymentChannelAccountName", "paymentChannelIban", "paymentChannelCountryCode", "paymentChannelCurrency", "challengeDescription", "challengeValue", "payeeLanguage"})
public class CreatePayeesCSVRequest2 {
    public static final String JSON_PROPERTY_TYPE = "type";
    private PayeeType type;
    public static final String JSON_PROPERTY_REMOTE_ID = "remoteId";
    private String remoteId;
    public static final String JSON_PROPERTY_EMAIL = "email";
    private String email;
    public static final String JSON_PROPERTY_ADDRESS_LINE1 = "addressLine1";
    private String addressLine1;
    public static final String JSON_PROPERTY_ADDRESS_LINE2 = "addressLine2";
    private String addressLine2;
    public static final String JSON_PROPERTY_ADDRESS_LINE3 = "addressLine3";
    private String addressLine3;
    public static final String JSON_PROPERTY_ADDRESS_LINE4 = "addressLine4";
    private String addressLine4;
    public static final String JSON_PROPERTY_ADDRESS_CITY = "addressCity";
    private String addressCity;
    public static final String JSON_PROPERTY_ADDRESS_COUNTY_OR_PROVINCE = "addressCountyOrProvince";
    private String addressCountyOrProvince;
    public static final String JSON_PROPERTY_ADDRESS_ZIP_OR_POSTCODE = "addressZipOrPostcode";
    private String addressZipOrPostcode;
    public static final String JSON_PROPERTY_ADDRESS_COUNTRY = "addressCountry";
    private AddressCountryEnum addressCountry;
    public static final String JSON_PROPERTY_INDIVIDUAL_NATIONAL_IDENTIFICATION = "individualNationalIdentification";
    private String individualNationalIdentification;
    public static final String JSON_PROPERTY_INDIVIDUAL_DATE_OF_BIRTH = "individualDateOfBirth";
    private LocalDate individualDateOfBirth;
    public static final String JSON_PROPERTY_INDIVIDUAL_TITLE = "individualTitle";
    private String individualTitle;
    public static final String JSON_PROPERTY_INDIVIDUAL_FIRST_NAME = "individualFirstName";
    private String individualFirstName;
    public static final String JSON_PROPERTY_INDIVIDUAL_OTHER_NAMES = "individualOtherNames";
    private String individualOtherNames;
    public static final String JSON_PROPERTY_INDIVIDUAL_LAST_NAME = "individualLastName";
    private String individualLastName;
    public static final String JSON_PROPERTY_COMPANY_NAME = "companyName";
    private String companyName;
    public static final String JSON_PROPERTY_COMPANY_E_I_N = "companyEIN";
    private String companyEIN;
    public static final String JSON_PROPERTY_COMPANY_OPERATING_NAME = "companyOperatingName";
    private String companyOperatingName;
    public static final String JSON_PROPERTY_PAYMENT_CHANNEL_ACCOUNT_NUMBER = "paymentChannelAccountNumber";
    private String paymentChannelAccountNumber;
    public static final String JSON_PROPERTY_PAYMENT_CHANNEL_ROUTING_NUMBER = "paymentChannelRoutingNumber";
    private String paymentChannelRoutingNumber;
    public static final String JSON_PROPERTY_PAYMENT_CHANNEL_ACCOUNT_NAME = "paymentChannelAccountName";
    private String paymentChannelAccountName;
    public static final String JSON_PROPERTY_PAYMENT_CHANNEL_IBAN = "paymentChannelIban";
    private String paymentChannelIban;
    public static final String JSON_PROPERTY_PAYMENT_CHANNEL_COUNTRY_CODE = "paymentChannelCountryCode";
    private PaymentChannelCountryCodeEnum paymentChannelCountryCode;
    public static final String JSON_PROPERTY_PAYMENT_CHANNEL_CURRENCY = "paymentChannelCurrency";
    private PaymentChannelCurrencyEnum paymentChannelCurrency;
    public static final String JSON_PROPERTY_CHALLENGE_DESCRIPTION = "challengeDescription";
    private String challengeDescription;
    public static final String JSON_PROPERTY_CHALLENGE_VALUE = "challengeValue";
    private String challengeValue;
    public static final String JSON_PROPERTY_PAYEE_LANGUAGE = "payeeLanguage";
    private PayeeLanguageEnum payeeLanguage;

    public CreatePayeesCSVRequest2 type(PayeeType type) {
        this.type = type;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public PayeeType getType() {
        return this.type;
    }

    public void setType(PayeeType type) {
        this.type = type;
    }

    public CreatePayeesCSVRequest2 remoteId(String remoteId) {
        this.remoteId = remoteId;
        return this;
    }

    @NotNull
    @Size(min=1, max=100)
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="remoteId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1, max=100) String getRemoteId() {
        return this.remoteId;
    }

    public void setRemoteId(String remoteId) {
        this.remoteId = remoteId;
    }

    public CreatePayeesCSVRequest2 email(String email) {
        this.email = email;
        return this;
    }

    @NotNull
    @Size(min=3, max=255)
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="email")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=3, max=255) String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public CreatePayeesCSVRequest2 addressLine1(String addressLine1) {
        this.addressLine1 = addressLine1;
        return this;
    }

    @NotNull
    @Size(min=2, max=100)
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="addressLine1")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=2, max=100) String getAddressLine1() {
        return this.addressLine1;
    }

    public void setAddressLine1(String addressLine1) {
        this.addressLine1 = addressLine1;
    }

    public CreatePayeesCSVRequest2 addressLine2(String addressLine2) {
        this.addressLine2 = addressLine2;
        return this;
    }

    @Nullable
    @Size(min=0, max=100)
    @ApiModelProperty(value="")
    @JsonProperty(value="addressLine2")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Size(min=0, max=100) String getAddressLine2() {
        return this.addressLine2;
    }

    public void setAddressLine2(String addressLine2) {
        this.addressLine2 = addressLine2;
    }

    public CreatePayeesCSVRequest2 addressLine3(String addressLine3) {
        this.addressLine3 = addressLine3;
        return this;
    }

    @Nullable
    @Size(min=0, max=100)
    @ApiModelProperty(value="")
    @JsonProperty(value="addressLine3")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Size(min=0, max=100) String getAddressLine3() {
        return this.addressLine3;
    }

    public void setAddressLine3(String addressLine3) {
        this.addressLine3 = addressLine3;
    }

    public CreatePayeesCSVRequest2 addressLine4(String addressLine4) {
        this.addressLine4 = addressLine4;
        return this;
    }

    @Nullable
    @Size(min=0, max=100)
    @ApiModelProperty(value="")
    @JsonProperty(value="addressLine4")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Size(min=0, max=100) String getAddressLine4() {
        return this.addressLine4;
    }

    public void setAddressLine4(String addressLine4) {
        this.addressLine4 = addressLine4;
    }

    public CreatePayeesCSVRequest2 addressCity(String addressCity) {
        this.addressCity = addressCity;
        return this;
    }

    @NotNull
    @Size(min=2, max=50)
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="addressCity")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=2, max=50) String getAddressCity() {
        return this.addressCity;
    }

    public void setAddressCity(String addressCity) {
        this.addressCity = addressCity;
    }

    public CreatePayeesCSVRequest2 addressCountyOrProvince(String addressCountyOrProvince) {
        this.addressCountyOrProvince = addressCountyOrProvince;
        return this;
    }

    @Nullable
    @Size(min=1, max=50)
    @ApiModelProperty(value="")
    @JsonProperty(value="addressCountyOrProvince")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Size(min=1, max=50) String getAddressCountyOrProvince() {
        return this.addressCountyOrProvince;
    }

    public void setAddressCountyOrProvince(String addressCountyOrProvince) {
        this.addressCountyOrProvince = addressCountyOrProvince;
    }

    public CreatePayeesCSVRequest2 addressZipOrPostcode(String addressZipOrPostcode) {
        this.addressZipOrPostcode = addressZipOrPostcode;
        return this;
    }

    @NotNull
    @Size(min=1, max=60)
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="addressZipOrPostcode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1, max=60) String getAddressZipOrPostcode() {
        return this.addressZipOrPostcode;
    }

    public void setAddressZipOrPostcode(String addressZipOrPostcode) {
        this.addressZipOrPostcode = addressZipOrPostcode;
    }

    public CreatePayeesCSVRequest2 addressCountry(AddressCountryEnum addressCountry) {
        this.addressCountry = addressCountry;
        return this;
    }

    @NotNull
    @Size(min=2, max=2)
    @ApiModelProperty(required=true, value="Must be a 2 character country code - per ISO 3166-1")
    @JsonProperty(value="addressCountry")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=2, max=2) AddressCountryEnum getAddressCountry() {
        return this.addressCountry;
    }

    public void setAddressCountry(AddressCountryEnum addressCountry) {
        this.addressCountry = addressCountry;
    }

    public CreatePayeesCSVRequest2 individualNationalIdentification(String individualNationalIdentification) {
        this.individualNationalIdentification = individualNationalIdentification;
        return this;
    }

    @Nullable
    @Size(min=6, max=30)
    @ApiModelProperty(value="")
    @JsonProperty(value="individualNationalIdentification")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Size(min=6, max=30) String getIndividualNationalIdentification() {
        return this.individualNationalIdentification;
    }

    public void setIndividualNationalIdentification(String individualNationalIdentification) {
        this.individualNationalIdentification = individualNationalIdentification;
    }

    public CreatePayeesCSVRequest2 individualDateOfBirth(LocalDate individualDateOfBirth) {
        this.individualDateOfBirth = individualDateOfBirth;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Must not be date in future. Example - 1970-05-20")
    @JsonProperty(value="individualDateOfBirth")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDate getIndividualDateOfBirth() {
        return this.individualDateOfBirth;
    }

    public void setIndividualDateOfBirth(LocalDate individualDateOfBirth) {
        this.individualDateOfBirth = individualDateOfBirth;
    }

    public CreatePayeesCSVRequest2 individualTitle(String individualTitle) {
        this.individualTitle = individualTitle;
        return this;
    }

    @Nullable
    @Size(min=1, max=40)
    @ApiModelProperty(value="")
    @JsonProperty(value="individualTitle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Size(min=1, max=40) String getIndividualTitle() {
        return this.individualTitle;
    }

    public void setIndividualTitle(String individualTitle) {
        this.individualTitle = individualTitle;
    }

    public CreatePayeesCSVRequest2 individualFirstName(String individualFirstName) {
        this.individualFirstName = individualFirstName;
        return this;
    }

    @Nullable
    @Size(min=1, max=40)
    @ApiModelProperty(value="")
    @JsonProperty(value="individualFirstName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Size(min=1, max=40) String getIndividualFirstName() {
        return this.individualFirstName;
    }

    public void setIndividualFirstName(String individualFirstName) {
        this.individualFirstName = individualFirstName;
    }

    public CreatePayeesCSVRequest2 individualOtherNames(String individualOtherNames) {
        this.individualOtherNames = individualOtherNames;
        return this;
    }

    @Nullable
    @Size(min=1, max=40)
    @ApiModelProperty(value="")
    @JsonProperty(value="individualOtherNames")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Size(min=1, max=40) String getIndividualOtherNames() {
        return this.individualOtherNames;
    }

    public void setIndividualOtherNames(String individualOtherNames) {
        this.individualOtherNames = individualOtherNames;
    }

    public CreatePayeesCSVRequest2 individualLastName(String individualLastName) {
        this.individualLastName = individualLastName;
        return this;
    }

    @Nullable
    @Size(min=1, max=40)
    @ApiModelProperty(value="")
    @JsonProperty(value="individualLastName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Size(min=1, max=40) String getIndividualLastName() {
        return this.individualLastName;
    }

    public void setIndividualLastName(String individualLastName) {
        this.individualLastName = individualLastName;
    }

    public CreatePayeesCSVRequest2 companyName(String companyName) {
        this.companyName = companyName;
        return this;
    }

    @Nullable
    @Size(min=1, max=40)
    @ApiModelProperty(value="")
    @JsonProperty(value="companyName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Size(min=1, max=40) String getCompanyName() {
        return this.companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public CreatePayeesCSVRequest2 companyEIN(String companyEIN) {
        this.companyEIN = companyEIN;
        return this;
    }

    @Nullable
    @Pattern(regexp="[\\\\d]{9}")
    @ApiModelProperty(value="Company Tax Id (EIN) must be 9 numeric characters. Must match the regular expression ```[\\d]{9}```.")
    @JsonProperty(value="companyEIN")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Pattern(regexp="[\\\\d]{9}") String getCompanyEIN() {
        return this.companyEIN;
    }

    public void setCompanyEIN(String companyEIN) {
        this.companyEIN = companyEIN;
    }

    public CreatePayeesCSVRequest2 companyOperatingName(String companyOperatingName) {
        this.companyOperatingName = companyOperatingName;
        return this;
    }

    @Nullable
    @Size(min=1, max=100)
    @ApiModelProperty(value="")
    @JsonProperty(value="companyOperatingName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Size(min=1, max=100) String getCompanyOperatingName() {
        return this.companyOperatingName;
    }

    public void setCompanyOperatingName(String companyOperatingName) {
        this.companyOperatingName = companyOperatingName;
    }

    public CreatePayeesCSVRequest2 paymentChannelAccountNumber(String paymentChannelAccountNumber) {
        this.paymentChannelAccountNumber = paymentChannelAccountNumber;
        return this;
    }

    @Nullable
    @Size(min=6, max=17)
    @ApiModelProperty(value="Either routing number and account number or only iban must be set")
    @JsonProperty(value="paymentChannelAccountNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Size(min=6, max=17) String getPaymentChannelAccountNumber() {
        return this.paymentChannelAccountNumber;
    }

    public void setPaymentChannelAccountNumber(String paymentChannelAccountNumber) {
        this.paymentChannelAccountNumber = paymentChannelAccountNumber;
    }

    public CreatePayeesCSVRequest2 paymentChannelRoutingNumber(String paymentChannelRoutingNumber) {
        this.paymentChannelRoutingNumber = paymentChannelRoutingNumber;
        return this;
    }

    @Nullable
    @Size(min=9, max=9)
    @ApiModelProperty(value="Either routing number and account number or only iban must be set")
    @JsonProperty(value="paymentChannelRoutingNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Size(min=9, max=9) String getPaymentChannelRoutingNumber() {
        return this.paymentChannelRoutingNumber;
    }

    public void setPaymentChannelRoutingNumber(String paymentChannelRoutingNumber) {
        this.paymentChannelRoutingNumber = paymentChannelRoutingNumber;
    }

    public CreatePayeesCSVRequest2 paymentChannelAccountName(String paymentChannelAccountName) {
        this.paymentChannelAccountName = paymentChannelAccountName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="paymentChannelAccountName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPaymentChannelAccountName() {
        return this.paymentChannelAccountName;
    }

    public void setPaymentChannelAccountName(String paymentChannelAccountName) {
        this.paymentChannelAccountName = paymentChannelAccountName;
    }

    public CreatePayeesCSVRequest2 paymentChannelIban(String paymentChannelIban) {
        this.paymentChannelIban = paymentChannelIban;
        return this;
    }

    @Nullable
    @Pattern(regexp="^[A-Za-z0-9]+$")
    @Size(min=15, max=34)
    @ApiModelProperty(value="Must match the regular expression ```^[A-Za-z0-9]+$```.")
    @JsonProperty(value="paymentChannelIban")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Pattern(regexp="^[A-Za-z0-9]+$") @Size(min=15, max=34) String getPaymentChannelIban() {
        return this.paymentChannelIban;
    }

    public void setPaymentChannelIban(String paymentChannelIban) {
        this.paymentChannelIban = paymentChannelIban;
    }

    public CreatePayeesCSVRequest2 paymentChannelCountryCode(PaymentChannelCountryCodeEnum paymentChannelCountryCode) {
        this.paymentChannelCountryCode = paymentChannelCountryCode;
        return this;
    }

    @Nullable
    @Size(min=2, max=2)
    @ApiModelProperty(value="Must be a 2 character country code - per ISO 3166-1")
    @JsonProperty(value="paymentChannelCountryCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Size(min=2, max=2) PaymentChannelCountryCodeEnum getPaymentChannelCountryCode() {
        return this.paymentChannelCountryCode;
    }

    public void setPaymentChannelCountryCode(PaymentChannelCountryCodeEnum paymentChannelCountryCode) {
        this.paymentChannelCountryCode = paymentChannelCountryCode;
    }

    public CreatePayeesCSVRequest2 paymentChannelCurrency(PaymentChannelCurrencyEnum paymentChannelCurrency) {
        this.paymentChannelCurrency = paymentChannelCurrency;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="paymentChannelCurrency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PaymentChannelCurrencyEnum getPaymentChannelCurrency() {
        return this.paymentChannelCurrency;
    }

    public void setPaymentChannelCurrency(PaymentChannelCurrencyEnum paymentChannelCurrency) {
        this.paymentChannelCurrency = paymentChannelCurrency;
    }

    public CreatePayeesCSVRequest2 challengeDescription(String challengeDescription) {
        this.challengeDescription = challengeDescription;
        return this;
    }

    @Nullable
    @Size(min=1, max=255)
    @ApiModelProperty(value="")
    @JsonProperty(value="challengeDescription")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Size(min=1, max=255) String getChallengeDescription() {
        return this.challengeDescription;
    }

    public void setChallengeDescription(String challengeDescription) {
        this.challengeDescription = challengeDescription;
    }

    public CreatePayeesCSVRequest2 challengeValue(String challengeValue) {
        this.challengeValue = challengeValue;
        return this;
    }

    @Nullable
    @Size(min=3, max=20)
    @ApiModelProperty(value="")
    @JsonProperty(value="challengeValue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Size(min=3, max=20) String getChallengeValue() {
        return this.challengeValue;
    }

    public void setChallengeValue(String challengeValue) {
        this.challengeValue = challengeValue;
    }

    public CreatePayeesCSVRequest2 payeeLanguage(PayeeLanguageEnum payeeLanguage) {
        this.payeeLanguage = payeeLanguage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="payeeLanguage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PayeeLanguageEnum getPayeeLanguage() {
        return this.payeeLanguage;
    }

    public void setPayeeLanguage(PayeeLanguageEnum payeeLanguage) {
        this.payeeLanguage = payeeLanguage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreatePayeesCSVRequest2 createPayeesCSVRequest2 = (CreatePayeesCSVRequest2)o;
        return Objects.equals((Object)this.type, (Object)createPayeesCSVRequest2.type) && Objects.equals(this.remoteId, createPayeesCSVRequest2.remoteId) && Objects.equals(this.email, createPayeesCSVRequest2.email) && Objects.equals(this.addressLine1, createPayeesCSVRequest2.addressLine1) && Objects.equals(this.addressLine2, createPayeesCSVRequest2.addressLine2) && Objects.equals(this.addressLine3, createPayeesCSVRequest2.addressLine3) && Objects.equals(this.addressLine4, createPayeesCSVRequest2.addressLine4) && Objects.equals(this.addressCity, createPayeesCSVRequest2.addressCity) && Objects.equals(this.addressCountyOrProvince, createPayeesCSVRequest2.addressCountyOrProvince) && Objects.equals(this.addressZipOrPostcode, createPayeesCSVRequest2.addressZipOrPostcode) && Objects.equals((Object)this.addressCountry, (Object)createPayeesCSVRequest2.addressCountry) && Objects.equals(this.individualNationalIdentification, createPayeesCSVRequest2.individualNationalIdentification) && Objects.equals(this.individualDateOfBirth, createPayeesCSVRequest2.individualDateOfBirth) && Objects.equals(this.individualTitle, createPayeesCSVRequest2.individualTitle) && Objects.equals(this.individualFirstName, createPayeesCSVRequest2.individualFirstName) && Objects.equals(this.individualOtherNames, createPayeesCSVRequest2.individualOtherNames) && Objects.equals(this.individualLastName, createPayeesCSVRequest2.individualLastName) && Objects.equals(this.companyName, createPayeesCSVRequest2.companyName) && Objects.equals(this.companyEIN, createPayeesCSVRequest2.companyEIN) && Objects.equals(this.companyOperatingName, createPayeesCSVRequest2.companyOperatingName) && Objects.equals(this.paymentChannelAccountNumber, createPayeesCSVRequest2.paymentChannelAccountNumber) && Objects.equals(this.paymentChannelRoutingNumber, createPayeesCSVRequest2.paymentChannelRoutingNumber) && Objects.equals(this.paymentChannelAccountName, createPayeesCSVRequest2.paymentChannelAccountName) && Objects.equals(this.paymentChannelIban, createPayeesCSVRequest2.paymentChannelIban) && Objects.equals((Object)this.paymentChannelCountryCode, (Object)createPayeesCSVRequest2.paymentChannelCountryCode) && Objects.equals((Object)this.paymentChannelCurrency, (Object)createPayeesCSVRequest2.paymentChannelCurrency) && Objects.equals(this.challengeDescription, createPayeesCSVRequest2.challengeDescription) && Objects.equals(this.challengeValue, createPayeesCSVRequest2.challengeValue) && Objects.equals((Object)this.payeeLanguage, (Object)createPayeesCSVRequest2.payeeLanguage);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.remoteId, this.email, this.addressLine1, this.addressLine2, this.addressLine3, this.addressLine4, this.addressCity, this.addressCountyOrProvince, this.addressZipOrPostcode, this.addressCountry, this.individualNationalIdentification, this.individualDateOfBirth, this.individualTitle, this.individualFirstName, this.individualOtherNames, this.individualLastName, this.companyName, this.companyEIN, this.companyOperatingName, this.paymentChannelAccountNumber, this.paymentChannelRoutingNumber, this.paymentChannelAccountName, this.paymentChannelIban, this.paymentChannelCountryCode, this.paymentChannelCurrency, this.challengeDescription, this.challengeValue, this.payeeLanguage});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreatePayeesCSVRequest2 {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    remoteId: ").append(this.toIndentedString(this.remoteId)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    addressLine1: ").append(this.toIndentedString(this.addressLine1)).append("\n");
        sb.append("    addressLine2: ").append(this.toIndentedString(this.addressLine2)).append("\n");
        sb.append("    addressLine3: ").append(this.toIndentedString(this.addressLine3)).append("\n");
        sb.append("    addressLine4: ").append(this.toIndentedString(this.addressLine4)).append("\n");
        sb.append("    addressCity: ").append(this.toIndentedString(this.addressCity)).append("\n");
        sb.append("    addressCountyOrProvince: ").append(this.toIndentedString(this.addressCountyOrProvince)).append("\n");
        sb.append("    addressZipOrPostcode: ").append(this.toIndentedString(this.addressZipOrPostcode)).append("\n");
        sb.append("    addressCountry: ").append(this.toIndentedString((Object)this.addressCountry)).append("\n");
        sb.append("    individualNationalIdentification: ").append(this.toIndentedString(this.individualNationalIdentification)).append("\n");
        sb.append("    individualDateOfBirth: ").append(this.toIndentedString(this.individualDateOfBirth)).append("\n");
        sb.append("    individualTitle: ").append(this.toIndentedString(this.individualTitle)).append("\n");
        sb.append("    individualFirstName: ").append(this.toIndentedString(this.individualFirstName)).append("\n");
        sb.append("    individualOtherNames: ").append(this.toIndentedString(this.individualOtherNames)).append("\n");
        sb.append("    individualLastName: ").append(this.toIndentedString(this.individualLastName)).append("\n");
        sb.append("    companyName: ").append(this.toIndentedString(this.companyName)).append("\n");
        sb.append("    companyEIN: ").append(this.toIndentedString(this.companyEIN)).append("\n");
        sb.append("    companyOperatingName: ").append(this.toIndentedString(this.companyOperatingName)).append("\n");
        sb.append("    paymentChannelAccountNumber: ").append(this.toIndentedString(this.paymentChannelAccountNumber)).append("\n");
        sb.append("    paymentChannelRoutingNumber: ").append(this.toIndentedString(this.paymentChannelRoutingNumber)).append("\n");
        sb.append("    paymentChannelAccountName: ").append(this.toIndentedString(this.paymentChannelAccountName)).append("\n");
        sb.append("    paymentChannelIban: ").append(this.toIndentedString(this.paymentChannelIban)).append("\n");
        sb.append("    paymentChannelCountryCode: ").append(this.toIndentedString((Object)this.paymentChannelCountryCode)).append("\n");
        sb.append("    paymentChannelCurrency: ").append(this.toIndentedString((Object)this.paymentChannelCurrency)).append("\n");
        sb.append("    challengeDescription: ").append(this.toIndentedString(this.challengeDescription)).append("\n");
        sb.append("    challengeValue: ").append(this.toIndentedString(this.challengeValue)).append("\n");
        sb.append("    payeeLanguage: ").append(this.toIndentedString((Object)this.payeeLanguage)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum PayeeLanguageEnum {
        AR("AR"),
        EN("EN"),
        ES("ES"),
        FR("FR"),
        HE("HE"),
        HI("HI"),
        JA("JA"),
        PT("PT"),
        RU("RU"),
        UR("UR"),
        ZH("ZH");

        private String value;

        private PayeeLanguageEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PayeeLanguageEnum fromValue(String value) {
            for (PayeeLanguageEnum b : PayeeLanguageEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum PaymentChannelCurrencyEnum {
        USD("USD"),
        GBP("GBP"),
        EUR("EUR");

        private String value;

        private PaymentChannelCurrencyEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PaymentChannelCurrencyEnum fromValue(String value) {
            for (PaymentChannelCurrencyEnum b : PaymentChannelCurrencyEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum PaymentChannelCountryCodeEnum {
        AF("AF"),
        AX("AX"),
        AL("AL"),
        DZ("DZ"),
        AS("AS"),
        AD("AD"),
        AO("AO"),
        AI("AI"),
        AQ("AQ"),
        AG("AG"),
        AR("AR"),
        AM("AM"),
        AW("AW"),
        AU("AU"),
        AT("AT"),
        AZ("AZ"),
        BS("BS"),
        BH("BH"),
        BD("BD"),
        BB("BB"),
        BY("BY"),
        BE("BE"),
        BZ("BZ"),
        BJ("BJ"),
        BM("BM"),
        BT("BT"),
        BO("BO"),
        BQ("BQ"),
        BA("BA"),
        BW("BW"),
        BV("BV"),
        BR("BR"),
        IO("IO"),
        BN("BN"),
        BG("BG"),
        BF("BF"),
        BI("BI"),
        KH("KH"),
        CM("CM"),
        CA("CA"),
        CV("CV"),
        KY("KY"),
        CF("CF"),
        TD("TD"),
        CL("CL"),
        CN("CN"),
        CX("CX"),
        CC("CC"),
        CO("CO"),
        KM("KM"),
        CG("CG"),
        CD("CD"),
        CK("CK"),
        CR("CR"),
        CI("CI"),
        HR("HR"),
        CU("CU"),
        CW("CW"),
        CY("CY"),
        CZ("CZ"),
        DK("DK"),
        DJ("DJ"),
        DM("DM"),
        DO("DO"),
        EC("EC"),
        EG("EG"),
        SV("SV"),
        GQ("GQ"),
        ER("ER"),
        EE("EE"),
        ET("ET"),
        FK("FK"),
        FO("FO"),
        FJ("FJ"),
        FI("FI"),
        FR("FR"),
        GF("GF"),
        PF("PF"),
        TF("TF"),
        GA("GA"),
        GM("GM"),
        GE("GE"),
        DE("DE"),
        GH("GH"),
        GI("GI"),
        GR("GR"),
        GL("GL"),
        GD("GD"),
        GP("GP"),
        GU("GU"),
        GT("GT"),
        GG("GG"),
        GN("GN"),
        GW("GW"),
        GY("GY"),
        HT("HT"),
        HM("HM"),
        VA("VA"),
        HN("HN"),
        HK("HK"),
        HU("HU"),
        IS("IS"),
        IN("IN"),
        ID("ID"),
        IR("IR"),
        IQ("IQ"),
        IE("IE"),
        IM("IM"),
        IL("IL"),
        IT("IT"),
        JM("JM"),
        JP("JP"),
        JE("JE"),
        JO("JO"),
        KZ("KZ"),
        KE("KE"),
        KI("KI"),
        KP("KP"),
        KR("KR"),
        KW("KW"),
        KG("KG"),
        LA("LA"),
        LV("LV"),
        LB("LB"),
        LS("LS"),
        LR("LR"),
        LY("LY"),
        LI("LI"),
        LT("LT"),
        LU("LU"),
        MO("MO"),
        MK("MK"),
        MG("MG"),
        MW("MW"),
        MY("MY"),
        MV("MV"),
        ML("ML"),
        MT("MT"),
        MH("MH"),
        MQ("MQ"),
        MR("MR"),
        MU("MU"),
        YT("YT"),
        MX("MX"),
        FM("FM"),
        MD("MD"),
        MC("MC"),
        MN("MN"),
        ME("ME"),
        MS("MS"),
        MA("MA"),
        MZ("MZ"),
        MM("MM"),
        NA("NA"),
        NR("NR"),
        NP("NP"),
        NL("NL"),
        NC("NC"),
        NZ("NZ"),
        NI("NI"),
        NE("NE"),
        NG("NG"),
        NU("NU"),
        NF("NF"),
        MP("MP"),
        NO("NO"),
        OM("OM"),
        PK("PK"),
        PW("PW"),
        PS("PS"),
        PA("PA"),
        PG("PG"),
        PY("PY"),
        PE("PE"),
        PH("PH"),
        PN("PN"),
        PL("PL"),
        PT("PT"),
        PR("PR"),
        QA("QA"),
        RE("RE"),
        RO("RO"),
        RU("RU"),
        RW("RW"),
        BL("BL"),
        SH("SH"),
        KN("KN"),
        LC("LC"),
        MF("MF"),
        PM("PM"),
        VC("VC"),
        WS("WS"),
        SM("SM"),
        ST("ST"),
        SA("SA"),
        SN("SN"),
        RS("RS"),
        SC("SC"),
        SL("SL"),
        SG("SG"),
        SX("SX"),
        SK("SK"),
        SI("SI"),
        SB("SB"),
        SO("SO"),
        ZA("ZA"),
        GS("GS"),
        SS("SS"),
        ES("ES"),
        LK("LK"),
        SD("SD"),
        SR("SR"),
        SJ("SJ"),
        SZ("SZ"),
        SE("SE"),
        CH("CH"),
        SY("SY"),
        TW("TW"),
        TJ("TJ"),
        TZ("TZ"),
        TH("TH"),
        TL("TL"),
        TG("TG"),
        TK("TK"),
        TO("TO"),
        TT("TT"),
        TN("TN"),
        TR("TR"),
        TM("TM"),
        TC("TC"),
        TV("TV"),
        UG("UG"),
        UA("UA"),
        AE("AE"),
        GB("GB"),
        US("US"),
        UM("UM"),
        UY("UY"),
        UZ("UZ"),
        VU("VU"),
        VE("VE"),
        VN("VN"),
        VG("VG"),
        VI("VI"),
        WF("WF"),
        EH("EH"),
        YE("YE"),
        ZM("ZM"),
        ZW("ZW");

        private String value;

        private PaymentChannelCountryCodeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PaymentChannelCountryCodeEnum fromValue(String value) {
            for (PaymentChannelCountryCodeEnum b : PaymentChannelCountryCodeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum AddressCountryEnum {
        AF("AF"),
        AX("AX"),
        AL("AL"),
        DZ("DZ"),
        AS("AS"),
        AD("AD"),
        AO("AO"),
        AI("AI"),
        AQ("AQ"),
        AG("AG"),
        AR("AR"),
        AM("AM"),
        AW("AW"),
        AU("AU"),
        AT("AT"),
        AZ("AZ"),
        BS("BS"),
        BH("BH"),
        BD("BD"),
        BB("BB"),
        BY("BY"),
        BE("BE"),
        BZ("BZ"),
        BJ("BJ"),
        BM("BM"),
        BT("BT"),
        BO("BO"),
        BQ("BQ"),
        BA("BA"),
        BW("BW"),
        BV("BV"),
        BR("BR"),
        IO("IO"),
        BN("BN"),
        BG("BG"),
        BF("BF"),
        BI("BI"),
        KH("KH"),
        CM("CM"),
        CA("CA"),
        CV("CV"),
        KY("KY"),
        CF("CF"),
        TD("TD"),
        CL("CL"),
        CN("CN"),
        CX("CX"),
        CC("CC"),
        CO("CO"),
        KM("KM"),
        CG("CG"),
        CD("CD"),
        CK("CK"),
        CR("CR"),
        CI("CI"),
        HR("HR"),
        CU("CU"),
        CW("CW"),
        CY("CY"),
        CZ("CZ"),
        DK("DK"),
        DJ("DJ"),
        DM("DM"),
        DO("DO"),
        EC("EC"),
        EG("EG"),
        SV("SV"),
        GQ("GQ"),
        ER("ER"),
        EE("EE"),
        ET("ET"),
        FK("FK"),
        FO("FO"),
        FJ("FJ"),
        FI("FI"),
        FR("FR"),
        GF("GF"),
        PF("PF"),
        TF("TF"),
        GA("GA"),
        GM("GM"),
        GE("GE"),
        DE("DE"),
        GH("GH"),
        GI("GI"),
        GR("GR"),
        GL("GL"),
        GD("GD"),
        GP("GP"),
        GU("GU"),
        GT("GT"),
        GG("GG"),
        GN("GN"),
        GW("GW"),
        GY("GY"),
        HT("HT"),
        HM("HM"),
        VA("VA"),
        HN("HN"),
        HK("HK"),
        HU("HU"),
        IS("IS"),
        IN("IN"),
        ID("ID"),
        IR("IR"),
        IQ("IQ"),
        IE("IE"),
        IM("IM"),
        IL("IL"),
        IT("IT"),
        JM("JM"),
        JP("JP"),
        JE("JE"),
        JO("JO"),
        KZ("KZ"),
        KE("KE"),
        KI("KI"),
        KP("KP"),
        KR("KR"),
        KW("KW"),
        KG("KG"),
        LA("LA"),
        LV("LV"),
        LB("LB"),
        LS("LS"),
        LR("LR"),
        LY("LY"),
        LI("LI"),
        LT("LT"),
        LU("LU"),
        MO("MO"),
        MK("MK"),
        MG("MG"),
        MW("MW"),
        MY("MY"),
        MV("MV"),
        ML("ML"),
        MT("MT"),
        MH("MH"),
        MQ("MQ"),
        MR("MR"),
        MU("MU"),
        YT("YT"),
        MX("MX"),
        FM("FM"),
        MD("MD"),
        MC("MC"),
        MN("MN"),
        ME("ME"),
        MS("MS"),
        MA("MA"),
        MZ("MZ"),
        MM("MM"),
        NA("NA"),
        NR("NR"),
        NP("NP"),
        NL("NL"),
        NC("NC"),
        NZ("NZ"),
        NI("NI"),
        NE("NE"),
        NG("NG"),
        NU("NU"),
        NF("NF"),
        MP("MP"),
        NO("NO"),
        OM("OM"),
        PK("PK"),
        PW("PW"),
        PS("PS"),
        PA("PA"),
        PG("PG"),
        PY("PY"),
        PE("PE"),
        PH("PH"),
        PN("PN"),
        PL("PL"),
        PT("PT"),
        PR("PR"),
        QA("QA"),
        RE("RE"),
        RO("RO"),
        RU("RU"),
        RW("RW"),
        BL("BL"),
        SH("SH"),
        KN("KN"),
        LC("LC"),
        MF("MF"),
        PM("PM"),
        VC("VC"),
        WS("WS"),
        SM("SM"),
        ST("ST"),
        SA("SA"),
        SN("SN"),
        RS("RS"),
        SC("SC"),
        SL("SL"),
        SG("SG"),
        SX("SX"),
        SK("SK"),
        SI("SI"),
        SB("SB"),
        SO("SO"),
        ZA("ZA"),
        GS("GS"),
        SS("SS"),
        ES("ES"),
        LK("LK"),
        SD("SD"),
        SR("SR"),
        SJ("SJ"),
        SZ("SZ"),
        SE("SE"),
        CH("CH"),
        SY("SY"),
        TW("TW"),
        TJ("TJ"),
        TZ("TZ"),
        TH("TH"),
        TL("TL"),
        TG("TG"),
        TK("TK"),
        TO("TO"),
        TT("TT"),
        TN("TN"),
        TR("TR"),
        TM("TM"),
        TC("TC"),
        TV("TV"),
        UG("UG"),
        UA("UA"),
        AE("AE"),
        GB("GB"),
        US("US"),
        UM("UM"),
        UY("UY"),
        UZ("UZ"),
        VU("VU"),
        VE("VE"),
        VN("VN"),
        VG("VG"),
        VI("VI"),
        WF("WF"),
        EH("EH"),
        YE("YE"),
        ZM("ZM"),
        ZW("ZW");

        private String value;

        private AddressCountryEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AddressCountryEnum fromValue(String value) {
            for (AddressCountryEnum b : AddressCountryEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

