/*
 * Decompiled with CFR 0.152.
 */
package com.velopayments.oa3.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.velopayments.oa3.model.PaymentInstruction;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@JsonPropertyOrder(value={"payorId", "payoutFromPayorId", "payoutToPayorId", "payoutMemo", "payments"})
public class CreatePayoutRequest {
    public static final String JSON_PROPERTY_PAYOR_ID = "payorId";
    private UUID payorId;
    public static final String JSON_PROPERTY_PAYOUT_FROM_PAYOR_ID = "payoutFromPayorId";
    private UUID payoutFromPayorId;
    public static final String JSON_PROPERTY_PAYOUT_TO_PAYOR_ID = "payoutToPayorId";
    private UUID payoutToPayorId;
    public static final String JSON_PROPERTY_PAYOUT_MEMO = "payoutMemo";
    private String payoutMemo;
    public static final String JSON_PROPERTY_PAYMENTS = "payments";
    private List<PaymentInstruction> payments = new ArrayList<PaymentInstruction>();

    public CreatePayoutRequest payorId(UUID payorId) {
        this.payorId = payorId;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Deprecated in v2.16. Any value supplied here will be ignored.")
    @JsonProperty(value="payorId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getPayorId() {
        return this.payorId;
    }

    public void setPayorId(UUID payorId) {
        this.payorId = payorId;
    }

    public CreatePayoutRequest payoutFromPayorId(UUID payoutFromPayorId) {
        this.payoutFromPayorId = payoutFromPayorId;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="The id of the payor whose source account(s) will be debited. payoutFromPayorId and payoutToPayorId must be both supplied or both omitted.")
    @JsonProperty(value="payoutFromPayorId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getPayoutFromPayorId() {
        return this.payoutFromPayorId;
    }

    public void setPayoutFromPayorId(UUID payoutFromPayorId) {
        this.payoutFromPayorId = payoutFromPayorId;
    }

    public CreatePayoutRequest payoutToPayorId(UUID payoutToPayorId) {
        this.payoutToPayorId = payoutToPayorId;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="The id of the payor whose payees will be paid. payoutFromPayorId and payoutToPayorId must be both supplied or both omitted.")
    @JsonProperty(value="payoutToPayorId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getPayoutToPayorId() {
        return this.payoutToPayorId;
    }

    public void setPayoutToPayorId(UUID payoutToPayorId) {
        this.payoutToPayorId = payoutToPayorId;
    }

    public CreatePayoutRequest payoutMemo(String payoutMemo) {
        this.payoutMemo = payoutMemo;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="A memo", value="Text applied to all payment memos unless specified explicitly on a payment. This should be the reference field on the statement seen by the payee (but not via ACH)")
    @JsonProperty(value="payoutMemo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPayoutMemo() {
        return this.payoutMemo;
    }

    public void setPayoutMemo(String payoutMemo) {
        this.payoutMemo = payoutMemo;
    }

    public CreatePayoutRequest payments(List<PaymentInstruction> payments) {
        this.payments = payments;
        return this;
    }

    public CreatePayoutRequest addPaymentsItem(PaymentInstruction paymentsItem) {
        this.payments.add(paymentsItem);
        return this;
    }

    @NotNull
    @Valid
    @Size(min=1, max=2000)
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="payments")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @Size(min=1, max=2000) List<PaymentInstruction> getPayments() {
        return this.payments;
    }

    public void setPayments(List<PaymentInstruction> payments) {
        this.payments = payments;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreatePayoutRequest createPayoutRequest = (CreatePayoutRequest)o;
        return Objects.equals(this.payorId, createPayoutRequest.payorId) && Objects.equals(this.payoutFromPayorId, createPayoutRequest.payoutFromPayorId) && Objects.equals(this.payoutToPayorId, createPayoutRequest.payoutToPayorId) && Objects.equals(this.payoutMemo, createPayoutRequest.payoutMemo) && Objects.equals(this.payments, createPayoutRequest.payments);
    }

    public int hashCode() {
        return Objects.hash(this.payorId, this.payoutFromPayorId, this.payoutToPayorId, this.payoutMemo, this.payments);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreatePayoutRequest {\n");
        sb.append("    payorId: ").append(this.toIndentedString(this.payorId)).append("\n");
        sb.append("    payoutFromPayorId: ").append(this.toIndentedString(this.payoutFromPayorId)).append("\n");
        sb.append("    payoutToPayorId: ").append(this.toIndentedString(this.payoutToPayorId)).append("\n");
        sb.append("    payoutMemo: ").append(this.toIndentedString(this.payoutMemo)).append("\n");
        sb.append("    payments: ").append(this.toIndentedString(this.payments)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

