/*
 * Decompiled with CFR 0.152.
 */
package com.velopayments.oa3.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"email", "mfaType", "smsNumber", "primaryContactNumber", "secondaryContactNumber", "roles", "firstName", "lastName", "entityId", "verificationCode"})
public class InviteUserRequest {
    public static final String JSON_PROPERTY_EMAIL = "email";
    private String email;
    public static final String JSON_PROPERTY_MFA_TYPE = "mfaType";
    private MfaTypeEnum mfaType;
    public static final String JSON_PROPERTY_SMS_NUMBER = "smsNumber";
    private String smsNumber;
    public static final String JSON_PROPERTY_PRIMARY_CONTACT_NUMBER = "primaryContactNumber";
    private String primaryContactNumber;
    public static final String JSON_PROPERTY_SECONDARY_CONTACT_NUMBER = "secondaryContactNumber";
    private JsonNullable<String> secondaryContactNumber = JsonNullable.undefined();
    public static final String JSON_PROPERTY_ROLES = "roles";
    private List<String> roles = new ArrayList<String>();
    public static final String JSON_PROPERTY_FIRST_NAME = "firstName";
    private String firstName;
    public static final String JSON_PROPERTY_LAST_NAME = "lastName";
    private String lastName;
    public static final String JSON_PROPERTY_ENTITY_ID = "entityId";
    private JsonNullable<UUID> entityId = JsonNullable.undefined();
    public static final String JSON_PROPERTY_VERIFICATION_CODE = "verificationCode";
    private JsonNullable<String> verificationCode = JsonNullable.undefined();

    public InviteUserRequest email(String email) {
        this.email = email;
        return this;
    }

    @NotNull
    @ApiModelProperty(example="foo@example.com", required=true, value="the email address of the invited user")
    @JsonProperty(value="email")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public InviteUserRequest mfaType(MfaTypeEnum mfaType) {
        this.mfaType = mfaType;
        return this;
    }

    @NotNull
    @ApiModelProperty(required=true, value="The MFA type that the user will use The type may be conditional on the role(s) the user has ")
    @JsonProperty(value="mfaType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public MfaTypeEnum getMfaType() {
        return this.mfaType;
    }

    public void setMfaType(MfaTypeEnum mfaType) {
        this.mfaType = mfaType;
    }

    public InviteUserRequest smsNumber(String smsNumber) {
        this.smsNumber = smsNumber;
        return this;
    }

    @NotNull
    @Pattern(regexp="^\\+?[1-9]\\d{1,14}$")
    @ApiModelProperty(example="11235555555", required=true, value="The phone number of a device that the user can receive sms messages on ")
    @JsonProperty(value="smsNumber")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Pattern(regexp="^\\+?[1-9]\\d{1,14}$") String getSmsNumber() {
        return this.smsNumber;
    }

    public void setSmsNumber(String smsNumber) {
        this.smsNumber = smsNumber;
    }

    public InviteUserRequest primaryContactNumber(String primaryContactNumber) {
        this.primaryContactNumber = primaryContactNumber;
        return this;
    }

    @NotNull
    @Pattern(regexp="^\\+?[1-9]\\d{1,14}$")
    @ApiModelProperty(example="11235555555", required=true, value="The main contact number for the user ")
    @JsonProperty(value="primaryContactNumber")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Pattern(regexp="^\\+?[1-9]\\d{1,14}$") String getPrimaryContactNumber() {
        return this.primaryContactNumber;
    }

    public void setPrimaryContactNumber(String primaryContactNumber) {
        this.primaryContactNumber = primaryContactNumber;
    }

    public InviteUserRequest secondaryContactNumber(String secondaryContactNumber) {
        this.secondaryContactNumber = JsonNullable.of((Object)secondaryContactNumber);
        return this;
    }

    @Nullable
    @Pattern(regexp="^\\+?[1-9]\\d{1,14}$")
    @ApiModelProperty(example="11235555550", value="The secondary contact number for the user ")
    @JsonIgnore
    public @Pattern(regexp="^\\+?[1-9]\\d{1,14}$") String getSecondaryContactNumber() {
        return (String)this.secondaryContactNumber.orElse(null);
    }

    @JsonProperty(value="secondaryContactNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getSecondaryContactNumber_JsonNullable() {
        return this.secondaryContactNumber;
    }

    @JsonProperty(value="secondaryContactNumber")
    public void setSecondaryContactNumber_JsonNullable(JsonNullable<String> secondaryContactNumber) {
        this.secondaryContactNumber = secondaryContactNumber;
    }

    public void setSecondaryContactNumber(String secondaryContactNumber) {
        this.secondaryContactNumber = JsonNullable.of((Object)secondaryContactNumber);
    }

    public InviteUserRequest roles(List<String> roles) {
        this.roles = roles;
        return this;
    }

    public InviteUserRequest addRolesItem(String rolesItem) {
        this.roles.add(rolesItem);
        return this;
    }

    @NotNull
    @ApiModelProperty(example="[\"payor.admin\"]", required=true, value="The role(s) for the user The role must exist The role can be a custom role or a system role but the invoker must have the permissions to assign the role System roles are: backoffice.admin, payor.master_admin, payor.admin, payor.support ")
    @JsonProperty(value="roles")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<String> getRoles() {
        return this.roles;
    }

    public void setRoles(List<String> roles) {
        this.roles = roles;
    }

    public InviteUserRequest firstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    @Nullable
    @Size(min=1, max=128)
    @ApiModelProperty(example="John", value="")
    @JsonProperty(value="firstName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Size(min=1, max=128) String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public InviteUserRequest lastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    @Nullable
    @Size(min=1, max=128)
    @ApiModelProperty(example="Doe", value="")
    @JsonProperty(value="lastName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Size(min=1, max=128) String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public InviteUserRequest entityId(UUID entityId) {
        this.entityId = JsonNullable.of((Object)entityId);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(example="7fffa261-ac68-49e6-b605-d24a444d9206", value="The payorId or null if the user is not a payor user ")
    @JsonIgnore
    public UUID getEntityId() {
        return (UUID)this.entityId.orElse(null);
    }

    @JsonProperty(value="entityId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<UUID> getEntityId_JsonNullable() {
        return this.entityId;
    }

    @JsonProperty(value="entityId")
    public void setEntityId_JsonNullable(JsonNullable<UUID> entityId) {
        this.entityId = entityId;
    }

    public void setEntityId(UUID entityId) {
        this.entityId = JsonNullable.of((Object)entityId);
    }

    public InviteUserRequest verificationCode(String verificationCode) {
        this.verificationCode = JsonNullable.of((Object)verificationCode);
        return this;
    }

    @Nullable
    @Size(min=6, max=6)
    @ApiModelProperty(example="123456", value="Optional property that MUST be suppied when manually verifying a user The user's smsNumber is registered via a separate endpoint and an OTP sent to them ")
    @JsonIgnore
    public @Size(min=6, max=6) String getVerificationCode() {
        return (String)this.verificationCode.orElse(null);
    }

    @JsonProperty(value="verificationCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getVerificationCode_JsonNullable() {
        return this.verificationCode;
    }

    @JsonProperty(value="verificationCode")
    public void setVerificationCode_JsonNullable(JsonNullable<String> verificationCode) {
        this.verificationCode = verificationCode;
    }

    public void setVerificationCode(String verificationCode) {
        this.verificationCode = JsonNullable.of((Object)verificationCode);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InviteUserRequest inviteUserRequest = (InviteUserRequest)o;
        return Objects.equals(this.email, inviteUserRequest.email) && Objects.equals((Object)this.mfaType, (Object)inviteUserRequest.mfaType) && Objects.equals(this.smsNumber, inviteUserRequest.smsNumber) && Objects.equals(this.primaryContactNumber, inviteUserRequest.primaryContactNumber) && Objects.equals(this.secondaryContactNumber, inviteUserRequest.secondaryContactNumber) && Objects.equals(this.roles, inviteUserRequest.roles) && Objects.equals(this.firstName, inviteUserRequest.firstName) && Objects.equals(this.lastName, inviteUserRequest.lastName) && Objects.equals(this.entityId, inviteUserRequest.entityId) && Objects.equals(this.verificationCode, inviteUserRequest.verificationCode);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.email, this.mfaType, this.smsNumber, this.primaryContactNumber, this.secondaryContactNumber, this.roles, this.firstName, this.lastName, this.entityId, this.verificationCode});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InviteUserRequest {\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    mfaType: ").append(this.toIndentedString((Object)this.mfaType)).append("\n");
        sb.append("    smsNumber: ").append(this.toIndentedString(this.smsNumber)).append("\n");
        sb.append("    primaryContactNumber: ").append(this.toIndentedString(this.primaryContactNumber)).append("\n");
        sb.append("    secondaryContactNumber: ").append(this.toIndentedString(this.secondaryContactNumber)).append("\n");
        sb.append("    roles: ").append(this.toIndentedString(this.roles)).append("\n");
        sb.append("    firstName: ").append(this.toIndentedString(this.firstName)).append("\n");
        sb.append("    lastName: ").append(this.toIndentedString(this.lastName)).append("\n");
        sb.append("    entityId: ").append(this.toIndentedString(this.entityId)).append("\n");
        sb.append("    verificationCode: ").append(this.toIndentedString(this.verificationCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum MfaTypeEnum {
        SMS("SMS"),
        YUBIKEY("YUBIKEY"),
        TOTP("TOTP");

        private String value;

        private MfaTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static MfaTypeEnum fromValue(String value) {
            for (MfaTypeEnum b : MfaTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

