/*
 * Decompiled with CFR 0.152.
 */
package com.velopayments.oa3.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@JsonPropertyOrder(value={"remoteId", "currency", "amount", "paymentMemo", "sourceAccountName", "payorPaymentId"})
public class PaymentInstruction {
    public static final String JSON_PROPERTY_REMOTE_ID = "remoteId";
    private String remoteId;
    public static final String JSON_PROPERTY_CURRENCY = "currency";
    private CurrencyEnum currency;
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private Long amount;
    public static final String JSON_PROPERTY_PAYMENT_MEMO = "paymentMemo";
    private String paymentMemo;
    public static final String JSON_PROPERTY_SOURCE_ACCOUNT_NAME = "sourceAccountName";
    private String sourceAccountName;
    public static final String JSON_PROPERTY_PAYOR_PAYMENT_ID = "payorPaymentId";
    private String payorPaymentId;

    public PaymentInstruction remoteId(String remoteId) {
        this.remoteId = remoteId;
        return this;
    }

    @NotNull
    @Size(min=1, max=100)
    @ApiModelProperty(example="remoteId1234", required=true, value="Your identifier for payee")
    @JsonProperty(value="remoteId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1, max=100) String getRemoteId() {
        return this.remoteId;
    }

    public void setRemoteId(String remoteId) {
        this.remoteId = remoteId;
    }

    public PaymentInstruction currency(CurrencyEnum currency) {
        this.currency = currency;
        return this;
    }

    @NotNull
    @ApiModelProperty(example="USD", required=true, value="Payee's currency")
    @JsonProperty(value="currency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public CurrencyEnum getCurrency() {
        return this.currency;
    }

    public void setCurrency(CurrencyEnum currency) {
        this.currency = currency;
    }

    public PaymentInstruction amount(Long amount) {
        this.amount = amount;
        return this;
    }

    @NotNull
    @Min(value=1L)
    @Max(value=-9223372036854775616L)
    @ApiModelProperty(example="1299", required=true, value="Amount to send to Payee")
    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=1L) @Max(value=-9223372036854775616L) Long getAmount() {
        return this.amount;
    }

    public void setAmount(Long amount) {
        this.amount = amount;
    }

    public PaymentInstruction paymentMemo(String paymentMemo) {
        this.paymentMemo = paymentMemo;
        return this;
    }

    @Nullable
    @Size(min=0, max=40)
    @ApiModelProperty(example="my memo", value="")
    @JsonProperty(value="paymentMemo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Size(min=0, max=40) String getPaymentMemo() {
        return this.paymentMemo;
    }

    public void setPaymentMemo(String paymentMemo) {
        this.paymentMemo = paymentMemo;
    }

    public PaymentInstruction sourceAccountName(String sourceAccountName) {
        this.sourceAccountName = sourceAccountName;
        return this;
    }

    @NotNull
    @Size(min=1, max=64)
    @ApiModelProperty(example="MyAccountName", required=true, value="")
    @JsonProperty(value="sourceAccountName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1, max=64) String getSourceAccountName() {
        return this.sourceAccountName;
    }

    public void setSourceAccountName(String sourceAccountName) {
        this.sourceAccountName = sourceAccountName;
    }

    public PaymentInstruction payorPaymentId(String payorPaymentId) {
        this.payorPaymentId = payorPaymentId;
        return this;
    }

    @Nullable
    @Size(min=0, max=40)
    @ApiModelProperty(example="123211321ABSD", value="")
    @JsonProperty(value="payorPaymentId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Size(min=0, max=40) String getPayorPaymentId() {
        return this.payorPaymentId;
    }

    public void setPayorPaymentId(String payorPaymentId) {
        this.payorPaymentId = payorPaymentId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentInstruction paymentInstruction = (PaymentInstruction)o;
        return Objects.equals(this.remoteId, paymentInstruction.remoteId) && Objects.equals((Object)this.currency, (Object)paymentInstruction.currency) && Objects.equals(this.amount, paymentInstruction.amount) && Objects.equals(this.paymentMemo, paymentInstruction.paymentMemo) && Objects.equals(this.sourceAccountName, paymentInstruction.sourceAccountName) && Objects.equals(this.payorPaymentId, paymentInstruction.payorPaymentId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.remoteId, this.currency, this.amount, this.paymentMemo, this.sourceAccountName, this.payorPaymentId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentInstruction {\n");
        sb.append("    remoteId: ").append(this.toIndentedString(this.remoteId)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString((Object)this.currency)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    paymentMemo: ").append(this.toIndentedString(this.paymentMemo)).append("\n");
        sb.append("    sourceAccountName: ").append(this.toIndentedString(this.sourceAccountName)).append("\n");
        sb.append("    payorPaymentId: ").append(this.toIndentedString(this.payorPaymentId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum CurrencyEnum {
        USD("USD"),
        GBP("GBP"),
        EUR("EUR");

        private String value;

        private CurrencyEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CurrencyEnum fromValue(String value) {
            for (CurrencyEnum b : CurrencyEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

