/*
 * Decompiled with CFR 0.152.
 */
package com.velopayments.oa3.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@JsonPropertyOrder(value={"rate", "invertedRate", "creationTime", "expiryTime", "quoteId", "totalSourceAmount", "totalPaymentAmount", "sourceCurrency", "paymentCurrency", "fundingStatus", "status"})
public class QuoteFxSummary {
    public static final String JSON_PROPERTY_RATE = "rate";
    private Float rate;
    public static final String JSON_PROPERTY_INVERTED_RATE = "invertedRate";
    private Float invertedRate;
    public static final String JSON_PROPERTY_CREATION_TIME = "creationTime";
    private OffsetDateTime creationTime;
    public static final String JSON_PROPERTY_EXPIRY_TIME = "expiryTime";
    private OffsetDateTime expiryTime;
    public static final String JSON_PROPERTY_QUOTE_ID = "quoteId";
    private UUID quoteId;
    public static final String JSON_PROPERTY_TOTAL_SOURCE_AMOUNT = "totalSourceAmount";
    private Integer totalSourceAmount;
    public static final String JSON_PROPERTY_TOTAL_PAYMENT_AMOUNT = "totalPaymentAmount";
    private Integer totalPaymentAmount;
    public static final String JSON_PROPERTY_SOURCE_CURRENCY = "sourceCurrency";
    private String sourceCurrency;
    public static final String JSON_PROPERTY_PAYMENT_CURRENCY = "paymentCurrency";
    private String paymentCurrency;
    public static final String JSON_PROPERTY_FUNDING_STATUS = "fundingStatus";
    private FundingStatusEnum fundingStatus;
    public static final String JSON_PROPERTY_STATUS = "status";
    private StatusEnum status;

    public QuoteFxSummary rate(Float rate) {
        this.rate = rate;
        return this;
    }

    @NotNull
    @ApiModelProperty(example="1.12", required=true, value="")
    @JsonProperty(value="rate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Float getRate() {
        return this.rate;
    }

    public void setRate(Float rate) {
        this.rate = rate;
    }

    public QuoteFxSummary invertedRate(Float invertedRate) {
        this.invertedRate = invertedRate;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1.12", value="")
    @JsonProperty(value="invertedRate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Float getInvertedRate() {
        return this.invertedRate;
    }

    public void setInvertedRate(Float invertedRate) {
        this.invertedRate = invertedRate;
    }

    public QuoteFxSummary creationTime(OffsetDateTime creationTime) {
        this.creationTime = creationTime;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="creationTime")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public OffsetDateTime getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(OffsetDateTime creationTime) {
        this.creationTime = creationTime;
    }

    public QuoteFxSummary expiryTime(OffsetDateTime expiryTime) {
        this.expiryTime = expiryTime;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="expiryTime")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getExpiryTime() {
        return this.expiryTime;
    }

    public void setExpiryTime(OffsetDateTime expiryTime) {
        this.expiryTime = expiryTime;
    }

    public QuoteFxSummary quoteId(UUID quoteId) {
        this.quoteId = quoteId;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="quoteId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getQuoteId() {
        return this.quoteId;
    }

    public void setQuoteId(UUID quoteId) {
        this.quoteId = quoteId;
    }

    public QuoteFxSummary totalSourceAmount(Integer totalSourceAmount) {
        this.totalSourceAmount = totalSourceAmount;
        return this;
    }

    @NotNull
    @ApiModelProperty(example="1234", required=true, value="")
    @JsonProperty(value="totalSourceAmount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Integer getTotalSourceAmount() {
        return this.totalSourceAmount;
    }

    public void setTotalSourceAmount(Integer totalSourceAmount) {
        this.totalSourceAmount = totalSourceAmount;
    }

    public QuoteFxSummary totalPaymentAmount(Integer totalPaymentAmount) {
        this.totalPaymentAmount = totalPaymentAmount;
        return this;
    }

    @NotNull
    @ApiModelProperty(example="1234", required=true, value="")
    @JsonProperty(value="totalPaymentAmount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Integer getTotalPaymentAmount() {
        return this.totalPaymentAmount;
    }

    public void setTotalPaymentAmount(Integer totalPaymentAmount) {
        this.totalPaymentAmount = totalPaymentAmount;
    }

    public QuoteFxSummary sourceCurrency(String sourceCurrency) {
        this.sourceCurrency = sourceCurrency;
        return this;
    }

    @NotNull
    @Size(min=3, max=3)
    @ApiModelProperty(example="USD", required=true, value="")
    @JsonProperty(value="sourceCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=3, max=3) String getSourceCurrency() {
        return this.sourceCurrency;
    }

    public void setSourceCurrency(String sourceCurrency) {
        this.sourceCurrency = sourceCurrency;
    }

    public QuoteFxSummary paymentCurrency(String paymentCurrency) {
        this.paymentCurrency = paymentCurrency;
        return this;
    }

    @NotNull
    @Size(min=3, max=3)
    @ApiModelProperty(example="USD", required=true, value="")
    @JsonProperty(value="paymentCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=3, max=3) String getPaymentCurrency() {
        return this.paymentCurrency;
    }

    public void setPaymentCurrency(String paymentCurrency) {
        this.paymentCurrency = paymentCurrency;
    }

    public QuoteFxSummary fundingStatus(FundingStatusEnum fundingStatus) {
        this.fundingStatus = fundingStatus;
        return this;
    }

    @NotNull
    @ApiModelProperty(example="FUNDED", required=true, value="")
    @JsonProperty(value="fundingStatus")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public FundingStatusEnum getFundingStatus() {
        return this.fundingStatus;
    }

    public void setFundingStatus(FundingStatusEnum fundingStatus) {
        this.fundingStatus = fundingStatus;
    }

    public QuoteFxSummary status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @NotNull
    @ApiModelProperty(example="QUOTED", required=true, value="")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QuoteFxSummary quoteFxSummary = (QuoteFxSummary)o;
        return Objects.equals(this.rate, quoteFxSummary.rate) && Objects.equals(this.invertedRate, quoteFxSummary.invertedRate) && Objects.equals(this.creationTime, quoteFxSummary.creationTime) && Objects.equals(this.expiryTime, quoteFxSummary.expiryTime) && Objects.equals(this.quoteId, quoteFxSummary.quoteId) && Objects.equals(this.totalSourceAmount, quoteFxSummary.totalSourceAmount) && Objects.equals(this.totalPaymentAmount, quoteFxSummary.totalPaymentAmount) && Objects.equals(this.sourceCurrency, quoteFxSummary.sourceCurrency) && Objects.equals(this.paymentCurrency, quoteFxSummary.paymentCurrency) && Objects.equals((Object)this.fundingStatus, (Object)quoteFxSummary.fundingStatus) && Objects.equals((Object)this.status, (Object)quoteFxSummary.status);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.rate, this.invertedRate, this.creationTime, this.expiryTime, this.quoteId, this.totalSourceAmount, this.totalPaymentAmount, this.sourceCurrency, this.paymentCurrency, this.fundingStatus, this.status});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class QuoteFxSummary {\n");
        sb.append("    rate: ").append(this.toIndentedString(this.rate)).append("\n");
        sb.append("    invertedRate: ").append(this.toIndentedString(this.invertedRate)).append("\n");
        sb.append("    creationTime: ").append(this.toIndentedString(this.creationTime)).append("\n");
        sb.append("    expiryTime: ").append(this.toIndentedString(this.expiryTime)).append("\n");
        sb.append("    quoteId: ").append(this.toIndentedString(this.quoteId)).append("\n");
        sb.append("    totalSourceAmount: ").append(this.toIndentedString(this.totalSourceAmount)).append("\n");
        sb.append("    totalPaymentAmount: ").append(this.toIndentedString(this.totalPaymentAmount)).append("\n");
        sb.append("    sourceCurrency: ").append(this.toIndentedString(this.sourceCurrency)).append("\n");
        sb.append("    paymentCurrency: ").append(this.toIndentedString(this.paymentCurrency)).append("\n");
        sb.append("    fundingStatus: ").append(this.toIndentedString((Object)this.fundingStatus)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        UNQUOTED("UNQUOTED"),
        QUOTED("QUOTED"),
        EXPIRED("EXPIRED"),
        EXECUTED("EXECUTED"),
        REJECTED("REJECTED");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum FundingStatusEnum {
        UNFUNDED("UNFUNDED"),
        INSTRUCTED("INSTRUCTED"),
        FUNDED("FUNDED");

        private String value;

        private FundingStatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static FundingStatusEnum fromValue(String value) {
            for (FundingStatusEnum b : FundingStatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

