/*
 * Decompiled with CFR 0.152.
 */
package com.velopayments.oa3.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.velopayments.oa3.model.Region;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.validation.Valid;

@JsonPropertyOrder(value={"isoCountryCode", "currencies", "regions"})
public class SupportedCountryV2 {
    public static final String JSON_PROPERTY_ISO_COUNTRY_CODE = "isoCountryCode";
    private IsoCountryCodeEnum isoCountryCode;
    public static final String JSON_PROPERTY_CURRENCIES = "currencies";
    private List<CurrenciesEnum> currencies = null;
    public static final String JSON_PROPERTY_REGIONS = "regions";
    private Region regions;

    public SupportedCountryV2 isoCountryCode(IsoCountryCodeEnum isoCountryCode) {
        this.isoCountryCode = isoCountryCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="US", value="")
    @JsonProperty(value="isoCountryCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public IsoCountryCodeEnum getIsoCountryCode() {
        return this.isoCountryCode;
    }

    public void setIsoCountryCode(IsoCountryCodeEnum isoCountryCode) {
        this.isoCountryCode = isoCountryCode;
    }

    public SupportedCountryV2 currencies(List<CurrenciesEnum> currencies) {
        this.currencies = currencies;
        return this;
    }

    public SupportedCountryV2 addCurrenciesItem(CurrenciesEnum currenciesItem) {
        if (this.currencies == null) {
            this.currencies = new ArrayList<CurrenciesEnum>();
        }
        this.currencies.add(currenciesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"USD\"]", value="")
    @JsonProperty(value="currencies")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<CurrenciesEnum> getCurrencies() {
        return this.currencies;
    }

    public void setCurrencies(List<CurrenciesEnum> currencies) {
        this.currencies = currencies;
    }

    public SupportedCountryV2 regions(Region regions) {
        this.regions = regions;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="regions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Region getRegions() {
        return this.regions;
    }

    public void setRegions(Region regions) {
        this.regions = regions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SupportedCountryV2 supportedCountryV2 = (SupportedCountryV2)o;
        return Objects.equals((Object)this.isoCountryCode, (Object)supportedCountryV2.isoCountryCode) && Objects.equals(this.currencies, supportedCountryV2.currencies) && Objects.equals(this.regions, supportedCountryV2.regions);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.isoCountryCode, this.currencies, this.regions});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SupportedCountryV2 {\n");
        sb.append("    isoCountryCode: ").append(this.toIndentedString((Object)this.isoCountryCode)).append("\n");
        sb.append("    currencies: ").append(this.toIndentedString(this.currencies)).append("\n");
        sb.append("    regions: ").append(this.toIndentedString(this.regions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum CurrenciesEnum {
        USD("USD"),
        GBP("GBP"),
        EUR("EUR"),
        CAD("CAD"),
        JPY("JPY");

        private String value;

        private CurrenciesEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CurrenciesEnum fromValue(String value) {
            for (CurrenciesEnum b : CurrenciesEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum IsoCountryCodeEnum {
        US("US"),
        GB("GB"),
        FR("FR"),
        CA("CA"),
        JP("JP");

        private String value;

        private IsoCountryCodeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static IsoCountryCodeEnum fromValue(String value) {
            for (IsoCountryCodeEnum b : IsoCountryCodeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

