/*
 * Decompiled with CFR 0.152.
 */
package com.velopayments.oa3.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@JsonPropertyOrder(value={"mfaType", "verificationCode"})
public class UnregisterMFARequest {
    public static final String JSON_PROPERTY_MFA_TYPE = "mfaType";
    private MfaTypeEnum mfaType;
    public static final String JSON_PROPERTY_VERIFICATION_CODE = "verificationCode";
    private String verificationCode;

    public UnregisterMFARequest mfaType(MfaTypeEnum mfaType) {
        this.mfaType = mfaType;
        return this;
    }

    @NotNull
    @ApiModelProperty(example="TOTP", required=true, value="The type of the MFA device")
    @JsonProperty(value="mfaType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public MfaTypeEnum getMfaType() {
        return this.mfaType;
    }

    public void setMfaType(MfaTypeEnum mfaType) {
        this.mfaType = mfaType;
    }

    public UnregisterMFARequest verificationCode(String verificationCode) {
        this.verificationCode = verificationCode;
        return this;
    }

    @Nullable
    @Size(min=6, max=6)
    @ApiModelProperty(example="123456", value="Optional property that MUST be suppied when manually verifying a user The user's smsNumber is registered via a separate endpoint and an OTP sent to them ")
    @JsonProperty(value="verificationCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Size(min=6, max=6) String getVerificationCode() {
        return this.verificationCode;
    }

    public void setVerificationCode(String verificationCode) {
        this.verificationCode = verificationCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnregisterMFARequest unregisterMFARequest = (UnregisterMFARequest)o;
        return Objects.equals((Object)this.mfaType, (Object)unregisterMFARequest.mfaType) && Objects.equals(this.verificationCode, unregisterMFARequest.verificationCode);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.mfaType, this.verificationCode});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UnregisterMFARequest {\n");
        sb.append("    mfaType: ").append(this.toIndentedString((Object)this.mfaType)).append("\n");
        sb.append("    verificationCode: ").append(this.toIndentedString(this.verificationCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum MfaTypeEnum {
        SMS("SMS"),
        YUBIKEY("YUBIKEY"),
        TOTP("TOTP");

        private String value;

        private MfaTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static MfaTypeEnum fromValue(String value) {
            for (MfaTypeEnum b : MfaTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

