/*
 * Velo Payments APIs
 * ## Terms and Definitions  Throughout this document and the Velo platform the following terms are used:  * **Payor.** An entity (typically a corporation) which wishes to pay funds to one or more payees via a payout. * **Payee.** The recipient of funds paid out by a payor. * **Payment.** A single transfer of funds from a payor to a payee. * **Payout.** A batch of Payments, typically used by a payor to logically group payments (e.g. by business day). Technically there need be no relationship between the payments in a payout - a single payout can contain payments to multiple payees and/or multiple payments to a single payee. * **Sandbox.** An integration environment provided by Velo Payments which offers a similar API experience to the production environment, but all funding and payment events are simulated, along with many other services such as OFAC sanctions list checking.  ## Overview  The Velo Payments API allows a payor to perform a number of operations. The following is a list of the main capabilities in a natural order of execution:  * Authenticate with the Velo platform * Maintain a collection of payees * Query the payor’s current balance of funds within the platform and perform additional funding * Issue payments to payees * Query the platform for a history of those payments  This document describes the main concepts and APIs required to get up and running with the Velo Payments platform. It is not an exhaustive API reference. For that, please see the separate Velo Payments API Reference.  ## API Considerations  The Velo Payments API is REST based and uses the JSON format for requests and responses.  Most calls are secured using OAuth 2 security and require a valid authentication access token for successful operation. See the Authentication section for details.  Where a dynamic value is required in the examples below, the {token} format is used, suggesting that the caller needs to supply the appropriate value of the token in question (without including the { or } characters).  Where curl examples are given, the –d @filename.json approach is used, indicating that the request body should be placed into a file named filename.json in the current directory. Each of the curl examples in this document should be considered a single line on the command-line, regardless of how they appear in print.  ## Authenticating with the Velo Platform  Once Velo backoffice staff have added your organization as a payor within the Velo platform sandbox, they will create you a payor Id, an API key and an API secret and share these with you in a secure manner.  You will need to use these values to authenticate with the Velo platform in order to gain access to the APIs. The steps to take are explained in the following:  create a string comprising the API key (e.g. 44a9537d-d55d-4b47-8082-14061c2bcdd8) and API secret (e.g. c396b26b-137a-44fd-87f5-34631f8fd529) with a colon between them. E.g. 44a9537d-d55d-4b47-8082-14061c2bcdd8:c396b26b-137a-44fd-87f5-34631f8fd529  base64 encode this string. E.g.: NDRhOTUzN2QtZDU1ZC00YjQ3LTgwODItMTQwNjFjMmJjZGQ4OmMzOTZiMjZiLTEzN2EtNDRmZC04N2Y1LTM0NjMxZjhmZDUyOQ==  create an HTTP **Authorization** header with the value set to e.g. Basic NDRhOTUzN2QtZDU1ZC00YjQ3LTgwODItMTQwNjFjMmJjZGQ4OmMzOTZiMjZiLTEzN2EtNDRmZC04N2Y1LTM0NjMxZjhmZDUyOQ==  perform the Velo authentication REST call using the HTTP header created above e.g. via curl:  ```   curl -X POST \\   -H \"Content-Type: application/json\" \\   -H \"Authorization: Basic NDRhOTUzN2QtZDU1ZC00YjQ3LTgwODItMTQwNjFjMmJjZGQ4OmMzOTZiMjZiLTEzN2EtNDRmZC04N2Y1LTM0NjMxZjhmZDUyOQ==\" \\   'https://api.sandbox.velopayments.com/v1/authenticate?grant_type=client_credentials' ```  If successful, this call will result in a **200** HTTP status code and a response body such as:  ```   {     \"access_token\":\"19f6bafd-93fd-4747-b229-00507bbc991f\",     \"token_type\":\"bearer\",     \"expires_in\":1799,     \"scope\":\"...\"   } ``` ## API access following authentication Following successful authentication, the value of the access_token field in the response (indicated in green above) should then be presented with all subsequent API calls to allow the Velo platform to validate that the caller is authenticated.  This is achieved by setting the HTTP Authorization header with the value set to e.g. Bearer 19f6bafd-93fd-4747-b229-00507bbc991f such as the curl example below:  ```   -H \"Authorization: Bearer 19f6bafd-93fd-4747-b229-00507bbc991f \" ```  If you make other Velo API calls which require authorization but the Authorization header is missing or invalid then you will get a **401** HTTP status response. 
 *
 * The version of the OpenAPI document: 2.19.37
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.velopayments.oa3.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import javax.validation.constraints.*;
import javax.validation.Valid;

/**
 * AutoTopUpConfig
 */
@JsonPropertyOrder({
  AutoTopUpConfig.JSON_PROPERTY_ENABLED,
  AutoTopUpConfig.JSON_PROPERTY_MIN_BALANCE,
  AutoTopUpConfig.JSON_PROPERTY_TARGET_BALANCE
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-01-15T13:04:46.100429-05:00[America/New_York]")
public class AutoTopUpConfig {
  public static final String JSON_PROPERTY_ENABLED = "enabled";
  private Boolean enabled;

  public static final String JSON_PROPERTY_MIN_BALANCE = "minBalance";
  private JsonNullable<Long> minBalance = JsonNullable.<Long>undefined();

  public static final String JSON_PROPERTY_TARGET_BALANCE = "targetBalance";
  private JsonNullable<Long> targetBalance = JsonNullable.<Long>undefined();


  public AutoTopUpConfig enabled(Boolean enabled) {
    
    this.enabled = enabled;
    return this;
  }

   /**
   * Is auto top-up enabled? automatically trigger funding to top-up the source account balance when the balance falls below the configured minimum level.
   * @return enabled
  **/
  @NotNull
  @ApiModelProperty(example = "true", required = true, value = "Is auto top-up enabled? automatically trigger funding to top-up the source account balance when the balance falls below the configured minimum level.")
  @JsonProperty(JSON_PROPERTY_ENABLED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getEnabled() {
    return enabled;
  }


  public void setEnabled(Boolean enabled) {
    this.enabled = enabled;
  }


  public AutoTopUpConfig minBalance(Long minBalance) {
    this.minBalance = JsonNullable.<Long>of(minBalance);
    
    return this;
  }

   /**
   * When the payor balance falls below this level then auto top-up will be triggered. Note - This is in minor units.
   * @return minBalance
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "10000", value = "When the payor balance falls below this level then auto top-up will be triggered. Note - This is in minor units.")
  @JsonIgnore

  public Long getMinBalance() {
        return minBalance.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_MIN_BALANCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Long> getMinBalance_JsonNullable() {
    return minBalance;
  }
  
  @JsonProperty(JSON_PROPERTY_MIN_BALANCE)
  public void setMinBalance_JsonNullable(JsonNullable<Long> minBalance) {
    this.minBalance = minBalance;
  }

  public void setMinBalance(Long minBalance) {
    this.minBalance = JsonNullable.<Long>of(minBalance);
  }


  public AutoTopUpConfig targetBalance(Long targetBalance) {
    this.targetBalance = JsonNullable.<Long>of(targetBalance);
    
    return this;
  }

   /**
   * When the payor balance falls below the min balance then auto top-up will request funds bring the balance to this level. Note - this is in minor units.
   * @return targetBalance
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "300000", value = "When the payor balance falls below the min balance then auto top-up will request funds bring the balance to this level. Note - this is in minor units.")
  @JsonIgnore

  public Long getTargetBalance() {
        return targetBalance.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_TARGET_BALANCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Long> getTargetBalance_JsonNullable() {
    return targetBalance;
  }
  
  @JsonProperty(JSON_PROPERTY_TARGET_BALANCE)
  public void setTargetBalance_JsonNullable(JsonNullable<Long> targetBalance) {
    this.targetBalance = targetBalance;
  }

  public void setTargetBalance(Long targetBalance) {
    this.targetBalance = JsonNullable.<Long>of(targetBalance);
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AutoTopUpConfig autoTopUpConfig = (AutoTopUpConfig) o;
    return Objects.equals(this.enabled, autoTopUpConfig.enabled) &&
        Objects.equals(this.minBalance, autoTopUpConfig.minBalance) &&
        Objects.equals(this.targetBalance, autoTopUpConfig.targetBalance);
  }

  @Override
  public int hashCode() {
    return Objects.hash(enabled, minBalance, targetBalance);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AutoTopUpConfig {\n");
    sb.append("    enabled: ").append(toIndentedString(enabled)).append("\n");
    sb.append("    minBalance: ").append(toIndentedString(minBalance)).append("\n");
    sb.append("    targetBalance: ").append(toIndentedString(targetBalance)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

