/*
 * Velo Payments APIs
 * ## Terms and Definitions  Throughout this document and the Velo platform the following terms are used:  * **Payor.** An entity (typically a corporation) which wishes to pay funds to one or more payees via a payout. * **Payee.** The recipient of funds paid out by a payor. * **Payment.** A single transfer of funds from a payor to a payee. * **Payout.** A batch of Payments, typically used by a payor to logically group payments (e.g. by business day). Technically there need be no relationship between the payments in a payout - a single payout can contain payments to multiple payees and/or multiple payments to a single payee. * **Sandbox.** An integration environment provided by Velo Payments which offers a similar API experience to the production environment, but all funding and payment events are simulated, along with many other services such as OFAC sanctions list checking.  ## Overview  The Velo Payments API allows a payor to perform a number of operations. The following is a list of the main capabilities in a natural order of execution:  * Authenticate with the Velo platform * Maintain a collection of payees * Query the payor’s current balance of funds within the platform and perform additional funding * Issue payments to payees * Query the platform for a history of those payments  This document describes the main concepts and APIs required to get up and running with the Velo Payments platform. It is not an exhaustive API reference. For that, please see the separate Velo Payments API Reference.  ## API Considerations  The Velo Payments API is REST based and uses the JSON format for requests and responses.  Most calls are secured using OAuth 2 security and require a valid authentication access token for successful operation. See the Authentication section for details.  Where a dynamic value is required in the examples below, the {token} format is used, suggesting that the caller needs to supply the appropriate value of the token in question (without including the { or } characters).  Where curl examples are given, the –d @filename.json approach is used, indicating that the request body should be placed into a file named filename.json in the current directory. Each of the curl examples in this document should be considered a single line on the command-line, regardless of how they appear in print.  ## Authenticating with the Velo Platform  Once Velo backoffice staff have added your organization as a payor within the Velo platform sandbox, they will create you a payor Id, an API key and an API secret and share these with you in a secure manner.  You will need to use these values to authenticate with the Velo platform in order to gain access to the APIs. The steps to take are explained in the following:  create a string comprising the API key (e.g. 44a9537d-d55d-4b47-8082-14061c2bcdd8) and API secret (e.g. c396b26b-137a-44fd-87f5-34631f8fd529) with a colon between them. E.g. 44a9537d-d55d-4b47-8082-14061c2bcdd8:c396b26b-137a-44fd-87f5-34631f8fd529  base64 encode this string. E.g.: NDRhOTUzN2QtZDU1ZC00YjQ3LTgwODItMTQwNjFjMmJjZGQ4OmMzOTZiMjZiLTEzN2EtNDRmZC04N2Y1LTM0NjMxZjhmZDUyOQ==  create an HTTP **Authorization** header with the value set to e.g. Basic NDRhOTUzN2QtZDU1ZC00YjQ3LTgwODItMTQwNjFjMmJjZGQ4OmMzOTZiMjZiLTEzN2EtNDRmZC04N2Y1LTM0NjMxZjhmZDUyOQ==  perform the Velo authentication REST call using the HTTP header created above e.g. via curl:  ```   curl -X POST \\   -H \"Content-Type: application/json\" \\   -H \"Authorization: Basic NDRhOTUzN2QtZDU1ZC00YjQ3LTgwODItMTQwNjFjMmJjZGQ4OmMzOTZiMjZiLTEzN2EtNDRmZC04N2Y1LTM0NjMxZjhmZDUyOQ==\" \\   'https://api.sandbox.velopayments.com/v1/authenticate?grant_type=client_credentials' ```  If successful, this call will result in a **200** HTTP status code and a response body such as:  ```   {     \"access_token\":\"19f6bafd-93fd-4747-b229-00507bbc991f\",     \"token_type\":\"bearer\",     \"expires_in\":1799,     \"scope\":\"...\"   } ``` ## API access following authentication Following successful authentication, the value of the access_token field in the response (indicated in green above) should then be presented with all subsequent API calls to allow the Velo platform to validate that the caller is authenticated.  This is achieved by setting the HTTP Authorization header with the value set to e.g. Bearer 19f6bafd-93fd-4747-b229-00507bbc991f such as the curl example below:  ```   -H \"Authorization: Bearer 19f6bafd-93fd-4747-b229-00507bbc991f \" ```  If you make other Velo API calls which require authorization but the Authorization header is missing or invalid then you will get a **401** HTTP status response. 
 *
 * The version of the OpenAPI document: 2.19.37
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.velopayments.oa3.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.velopayments.oa3.model.PaymentAuditCurrencyV4;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.UUID;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import javax.validation.constraints.*;
import javax.validation.Valid;

/**
 * FxSummaryV4
 */
@JsonPropertyOrder({
  FxSummaryV4.JSON_PROPERTY_QUOTE_ID,
  FxSummaryV4.JSON_PROPERTY_CREATION_DATE_TIME,
  FxSummaryV4.JSON_PROPERTY_RATE,
  FxSummaryV4.JSON_PROPERTY_INVERTED_RATE,
  FxSummaryV4.JSON_PROPERTY_TOTAL_COST,
  FxSummaryV4.JSON_PROPERTY_TOTAL_PAYMENT_AMOUNT,
  FxSummaryV4.JSON_PROPERTY_SOURCE_CURRENCY,
  FxSummaryV4.JSON_PROPERTY_PAYMENT_CURRENCY,
  FxSummaryV4.JSON_PROPERTY_STATUS,
  FxSummaryV4.JSON_PROPERTY_FUNDING_STATUS
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-01-15T13:04:46.100429-05:00[America/New_York]")
public class FxSummaryV4 {
  public static final String JSON_PROPERTY_QUOTE_ID = "quoteId";
  private UUID quoteId;

  public static final String JSON_PROPERTY_CREATION_DATE_TIME = "creationDateTime";
  private OffsetDateTime creationDateTime;

  public static final String JSON_PROPERTY_RATE = "rate";
  private Double rate;

  public static final String JSON_PROPERTY_INVERTED_RATE = "invertedRate";
  private Double invertedRate;

  public static final String JSON_PROPERTY_TOTAL_COST = "totalCost";
  private Integer totalCost;

  public static final String JSON_PROPERTY_TOTAL_PAYMENT_AMOUNT = "totalPaymentAmount";
  private Integer totalPaymentAmount;

  public static final String JSON_PROPERTY_SOURCE_CURRENCY = "sourceCurrency";
  private PaymentAuditCurrencyV4 sourceCurrency;

  public static final String JSON_PROPERTY_PAYMENT_CURRENCY = "paymentCurrency";
  private PaymentAuditCurrencyV4 paymentCurrency;

  /**
   * Gets or Sets status
   */
  public enum StatusEnum {
    UNQUOTED("UNQUOTED"),
    
    QUOTED("QUOTED"),
    
    EXPIRED("EXPIRED"),
    
    EXECUTED("EXECUTED");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StatusEnum fromValue(String value) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_STATUS = "status";
  private StatusEnum status;

  /**
   * Gets or Sets fundingStatus
   */
  public enum FundingStatusEnum {
    FUNDED("FUNDED"),
    
    INSTRUCTED("INSTRUCTED"),
    
    UNFUNDED("UNFUNDED");

    private String value;

    FundingStatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static FundingStatusEnum fromValue(String value) {
      for (FundingStatusEnum b : FundingStatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_FUNDING_STATUS = "fundingStatus";
  private FundingStatusEnum fundingStatus;


  public FxSummaryV4 quoteId(UUID quoteId) {
    
    this.quoteId = quoteId;
    return this;
  }

   /**
   * Get quoteId
   * @return quoteId
  **/
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_QUOTE_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getQuoteId() {
    return quoteId;
  }


  public void setQuoteId(UUID quoteId) {
    this.quoteId = quoteId;
  }


  public FxSummaryV4 creationDateTime(OffsetDateTime creationDateTime) {
    
    this.creationDateTime = creationDateTime;
    return this;
  }

   /**
   * Get creationDateTime
   * @return creationDateTime
  **/
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_CREATION_DATE_TIME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public OffsetDateTime getCreationDateTime() {
    return creationDateTime;
  }


  public void setCreationDateTime(OffsetDateTime creationDateTime) {
    this.creationDateTime = creationDateTime;
  }


  public FxSummaryV4 rate(Double rate) {
    
    this.rate = rate;
    return this;
  }

   /**
   * Get rate
   * @return rate
  **/
  @NotNull
  @ApiModelProperty(example = "123.23", required = true, value = "")
  @JsonProperty(JSON_PROPERTY_RATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Double getRate() {
    return rate;
  }


  public void setRate(Double rate) {
    this.rate = rate;
  }


  public FxSummaryV4 invertedRate(Double invertedRate) {
    
    this.invertedRate = invertedRate;
    return this;
  }

   /**
   * Get invertedRate
   * @return invertedRate
  **/
  @NotNull
  @ApiModelProperty(example = "123.23", required = true, value = "")
  @JsonProperty(JSON_PROPERTY_INVERTED_RATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Double getInvertedRate() {
    return invertedRate;
  }


  public void setInvertedRate(Double invertedRate) {
    this.invertedRate = invertedRate;
  }


  public FxSummaryV4 totalCost(Integer totalCost) {
    
    this.totalCost = totalCost;
    return this;
  }

   /**
   * Get totalCost
   * @return totalCost
  **/
  @NotNull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_TOTAL_COST)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getTotalCost() {
    return totalCost;
  }


  public void setTotalCost(Integer totalCost) {
    this.totalCost = totalCost;
  }


  public FxSummaryV4 totalPaymentAmount(Integer totalPaymentAmount) {
    
    this.totalPaymentAmount = totalPaymentAmount;
    return this;
  }

   /**
   * Get totalPaymentAmount
   * @return totalPaymentAmount
  **/
  @NotNull
  @ApiModelProperty(example = "34235", required = true, value = "")
  @JsonProperty(JSON_PROPERTY_TOTAL_PAYMENT_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getTotalPaymentAmount() {
    return totalPaymentAmount;
  }


  public void setTotalPaymentAmount(Integer totalPaymentAmount) {
    this.totalPaymentAmount = totalPaymentAmount;
  }


  public FxSummaryV4 sourceCurrency(PaymentAuditCurrencyV4 sourceCurrency) {
    
    this.sourceCurrency = sourceCurrency;
    return this;
  }

   /**
   * Get sourceCurrency
   * @return sourceCurrency
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SOURCE_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PaymentAuditCurrencyV4 getSourceCurrency() {
    return sourceCurrency;
  }


  public void setSourceCurrency(PaymentAuditCurrencyV4 sourceCurrency) {
    this.sourceCurrency = sourceCurrency;
  }


  public FxSummaryV4 paymentCurrency(PaymentAuditCurrencyV4 paymentCurrency) {
    
    this.paymentCurrency = paymentCurrency;
    return this;
  }

   /**
   * Get paymentCurrency
   * @return paymentCurrency
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PAYMENT_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PaymentAuditCurrencyV4 getPaymentCurrency() {
    return paymentCurrency;
  }


  public void setPaymentCurrency(PaymentAuditCurrencyV4 paymentCurrency) {
    this.paymentCurrency = paymentCurrency;
  }


  public FxSummaryV4 status(StatusEnum status) {
    
    this.status = status;
    return this;
  }

   /**
   * Get status
   * @return status
  **/
  @NotNull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public StatusEnum getStatus() {
    return status;
  }


  public void setStatus(StatusEnum status) {
    this.status = status;
  }


  public FxSummaryV4 fundingStatus(FundingStatusEnum fundingStatus) {
    
    this.fundingStatus = fundingStatus;
    return this;
  }

   /**
   * Get fundingStatus
   * @return fundingStatus
  **/
  @NotNull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_FUNDING_STATUS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public FundingStatusEnum getFundingStatus() {
    return fundingStatus;
  }


  public void setFundingStatus(FundingStatusEnum fundingStatus) {
    this.fundingStatus = fundingStatus;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    FxSummaryV4 fxSummaryV4 = (FxSummaryV4) o;
    return Objects.equals(this.quoteId, fxSummaryV4.quoteId) &&
        Objects.equals(this.creationDateTime, fxSummaryV4.creationDateTime) &&
        Objects.equals(this.rate, fxSummaryV4.rate) &&
        Objects.equals(this.invertedRate, fxSummaryV4.invertedRate) &&
        Objects.equals(this.totalCost, fxSummaryV4.totalCost) &&
        Objects.equals(this.totalPaymentAmount, fxSummaryV4.totalPaymentAmount) &&
        Objects.equals(this.sourceCurrency, fxSummaryV4.sourceCurrency) &&
        Objects.equals(this.paymentCurrency, fxSummaryV4.paymentCurrency) &&
        Objects.equals(this.status, fxSummaryV4.status) &&
        Objects.equals(this.fundingStatus, fxSummaryV4.fundingStatus);
  }

  @Override
  public int hashCode() {
    return Objects.hash(quoteId, creationDateTime, rate, invertedRate, totalCost, totalPaymentAmount, sourceCurrency, paymentCurrency, status, fundingStatus);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class FxSummaryV4 {\n");
    sb.append("    quoteId: ").append(toIndentedString(quoteId)).append("\n");
    sb.append("    creationDateTime: ").append(toIndentedString(creationDateTime)).append("\n");
    sb.append("    rate: ").append(toIndentedString(rate)).append("\n");
    sb.append("    invertedRate: ").append(toIndentedString(invertedRate)).append("\n");
    sb.append("    totalCost: ").append(toIndentedString(totalCost)).append("\n");
    sb.append("    totalPaymentAmount: ").append(toIndentedString(totalPaymentAmount)).append("\n");
    sb.append("    sourceCurrency: ").append(toIndentedString(sourceCurrency)).append("\n");
    sb.append("    paymentCurrency: ").append(toIndentedString(paymentCurrency)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    fundingStatus: ").append(toIndentedString(fundingStatus)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

