/*
 * Velo Payments APIs
 * ## Terms and Definitions  Throughout this document and the Velo platform the following terms are used:  * **Payor.** An entity (typically a corporation) which wishes to pay funds to one or more payees via a payout. * **Payee.** The recipient of funds paid out by a payor. * **Payment.** A single transfer of funds from a payor to a payee. * **Payout.** A batch of Payments, typically used by a payor to logically group payments (e.g. by business day). Technically there need be no relationship between the payments in a payout - a single payout can contain payments to multiple payees and/or multiple payments to a single payee. * **Sandbox.** An integration environment provided by Velo Payments which offers a similar API experience to the production environment, but all funding and payment events are simulated, along with many other services such as OFAC sanctions list checking.  ## Overview  The Velo Payments API allows a payor to perform a number of operations. The following is a list of the main capabilities in a natural order of execution:  * Authenticate with the Velo platform * Maintain a collection of payees * Query the payor’s current balance of funds within the platform and perform additional funding * Issue payments to payees * Query the platform for a history of those payments  This document describes the main concepts and APIs required to get up and running with the Velo Payments platform. It is not an exhaustive API reference. For that, please see the separate Velo Payments API Reference.  ## API Considerations  The Velo Payments API is REST based and uses the JSON format for requests and responses.  Most calls are secured using OAuth 2 security and require a valid authentication access token for successful operation. See the Authentication section for details.  Where a dynamic value is required in the examples below, the {token} format is used, suggesting that the caller needs to supply the appropriate value of the token in question (without including the { or } characters).  Where curl examples are given, the –d @filename.json approach is used, indicating that the request body should be placed into a file named filename.json in the current directory. Each of the curl examples in this document should be considered a single line on the command-line, regardless of how they appear in print.  ## Authenticating with the Velo Platform  Once Velo backoffice staff have added your organization as a payor within the Velo platform sandbox, they will create you a payor Id, an API key and an API secret and share these with you in a secure manner.  You will need to use these values to authenticate with the Velo platform in order to gain access to the APIs. The steps to take are explained in the following:  create a string comprising the API key (e.g. 44a9537d-d55d-4b47-8082-14061c2bcdd8) and API secret (e.g. c396b26b-137a-44fd-87f5-34631f8fd529) with a colon between them. E.g. 44a9537d-d55d-4b47-8082-14061c2bcdd8:c396b26b-137a-44fd-87f5-34631f8fd529  base64 encode this string. E.g.: NDRhOTUzN2QtZDU1ZC00YjQ3LTgwODItMTQwNjFjMmJjZGQ4OmMzOTZiMjZiLTEzN2EtNDRmZC04N2Y1LTM0NjMxZjhmZDUyOQ==  create an HTTP **Authorization** header with the value set to e.g. Basic NDRhOTUzN2QtZDU1ZC00YjQ3LTgwODItMTQwNjFjMmJjZGQ4OmMzOTZiMjZiLTEzN2EtNDRmZC04N2Y1LTM0NjMxZjhmZDUyOQ==  perform the Velo authentication REST call using the HTTP header created above e.g. via curl:  ```   curl -X POST \\   -H \"Content-Type: application/json\" \\   -H \"Authorization: Basic NDRhOTUzN2QtZDU1ZC00YjQ3LTgwODItMTQwNjFjMmJjZGQ4OmMzOTZiMjZiLTEzN2EtNDRmZC04N2Y1LTM0NjMxZjhmZDUyOQ==\" \\   'https://api.sandbox.velopayments.com/v1/authenticate?grant_type=client_credentials' ```  If successful, this call will result in a **200** HTTP status code and a response body such as:  ```   {     \"access_token\":\"19f6bafd-93fd-4747-b229-00507bbc991f\",     \"token_type\":\"bearer\",     \"expires_in\":1799,     \"scope\":\"...\"   } ``` ## API access following authentication Following successful authentication, the value of the access_token field in the response (indicated in green above) should then be presented with all subsequent API calls to allow the Velo platform to validate that the caller is authenticated.  This is achieved by setting the HTTP Authorization header with the value set to e.g. Bearer 19f6bafd-93fd-4747-b229-00507bbc991f such as the curl example below:  ```   -H \"Authorization: Bearer 19f6bafd-93fd-4747-b229-00507bbc991f \" ```  If you make other Velo API calls which require authorization but the Authorization header is missing or invalid then you will get a **401** HTTP status response. 
 *
 * The version of the OpenAPI document: 2.19.37
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.velopayments.oa3.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.velopayments.oa3.model.Challenge;
import com.velopayments.oa3.model.CompanyV1;
import com.velopayments.oa3.model.IndividualV1;
import com.velopayments.oa3.model.Language;
import com.velopayments.oa3.model.MarketingOptIn;
import com.velopayments.oa3.model.OfacStatus;
import com.velopayments.oa3.model.OnboardedStatus;
import com.velopayments.oa3.model.PayeeAddress;
import com.velopayments.oa3.model.PayeePaymentChannel;
import com.velopayments.oa3.model.PayeePayorRef;
import com.velopayments.oa3.model.PayeeType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import javax.validation.constraints.*;
import javax.validation.Valid;

/**
 * Payee
 */
@JsonPropertyOrder({
  Payee.JSON_PROPERTY_PAYEE_ID,
  Payee.JSON_PROPERTY_PAYOR_REFS,
  Payee.JSON_PROPERTY_EMAIL,
  Payee.JSON_PROPERTY_ADDRESS,
  Payee.JSON_PROPERTY_COUNTRY,
  Payee.JSON_PROPERTY_DISPLAY_NAME,
  Payee.JSON_PROPERTY_PAYMENT_CHANNEL,
  Payee.JSON_PROPERTY_CHALLENGE,
  Payee.JSON_PROPERTY_LANGUAGE,
  Payee.JSON_PROPERTY_ACCEPT_TERMS_AND_CONDITIONS_TIMESTAMP,
  Payee.JSON_PROPERTY_CELLPHONE_NUMBER,
  Payee.JSON_PROPERTY_PAYEE_TYPE,
  Payee.JSON_PROPERTY_COMPANY,
  Payee.JSON_PROPERTY_INDIVIDUAL,
  Payee.JSON_PROPERTY_CREATED,
  Payee.JSON_PROPERTY_GRACE_PERIOD_END_DATE,
  Payee.JSON_PROPERTY_LAST_OFAC_CHECK_TIMESTAMP,
  Payee.JSON_PROPERTY_MARKETING_OPT_INS,
  Payee.JSON_PROPERTY_OFAC_STATUS,
  Payee.JSON_PROPERTY_ONBOARDED_STATUS
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-01-15T13:04:46.100429-05:00[America/New_York]")
public class Payee {
  public static final String JSON_PROPERTY_PAYEE_ID = "payeeId";
  private UUID payeeId;

  public static final String JSON_PROPERTY_PAYOR_REFS = "payorRefs";
  private JsonNullable<List<PayeePayorRef>> payorRefs = JsonNullable.<List<PayeePayorRef>>undefined();

  public static final String JSON_PROPERTY_EMAIL = "email";
  private JsonNullable<String> email = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_ADDRESS = "address";
  private PayeeAddress address;

  public static final String JSON_PROPERTY_COUNTRY = "country";
  private String country;

  public static final String JSON_PROPERTY_DISPLAY_NAME = "displayName";
  private String displayName;

  public static final String JSON_PROPERTY_PAYMENT_CHANNEL = "paymentChannel";
  private PayeePaymentChannel paymentChannel;

  public static final String JSON_PROPERTY_CHALLENGE = "challenge";
  private Challenge challenge;

  public static final String JSON_PROPERTY_LANGUAGE = "language";
  private Language language;

  public static final String JSON_PROPERTY_ACCEPT_TERMS_AND_CONDITIONS_TIMESTAMP = "acceptTermsAndConditionsTimestamp";
  private JsonNullable<OffsetDateTime> acceptTermsAndConditionsTimestamp = JsonNullable.<OffsetDateTime>undefined();

  public static final String JSON_PROPERTY_CELLPHONE_NUMBER = "cellphoneNumber";
  private String cellphoneNumber;

  public static final String JSON_PROPERTY_PAYEE_TYPE = "payeeType";
  private PayeeType payeeType;

  public static final String JSON_PROPERTY_COMPANY = "company";
  private JsonNullable<CompanyV1> company = JsonNullable.<CompanyV1>undefined();

  public static final String JSON_PROPERTY_INDIVIDUAL = "individual";
  private IndividualV1 individual;

  public static final String JSON_PROPERTY_CREATED = "created";
  private OffsetDateTime created;

  public static final String JSON_PROPERTY_GRACE_PERIOD_END_DATE = "gracePeriodEndDate";
  private JsonNullable<LocalDate> gracePeriodEndDate = JsonNullable.<LocalDate>undefined();

  public static final String JSON_PROPERTY_LAST_OFAC_CHECK_TIMESTAMP = "lastOfacCheckTimestamp";
  private JsonNullable<String> lastOfacCheckTimestamp = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_MARKETING_OPT_INS = "marketingOptIns";
  private List<MarketingOptIn> marketingOptIns = null;

  public static final String JSON_PROPERTY_OFAC_STATUS = "ofacStatus";
  private OfacStatus ofacStatus;

  public static final String JSON_PROPERTY_ONBOARDED_STATUS = "onboardedStatus";
  private OnboardedStatus onboardedStatus;


   /**
   * Get payeeId
   * @return payeeId
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(example = "2aa5d7e0-2ecb-403f-8494-1865ed0454e9", value = "")
  @JsonProperty(JSON_PROPERTY_PAYEE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getPayeeId() {
    return payeeId;
  }




   /**
   * Get payorRefs
   * @return payorRefs
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonIgnore

  public List<PayeePayorRef> getPayorRefs() {
    
    if (payorRefs == null) {
      payorRefs = JsonNullable.<List<PayeePayorRef>>of(new ArrayList<>());
    }
    return payorRefs.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PAYOR_REFS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<PayeePayorRef>> getPayorRefs_JsonNullable() {
    return payorRefs;
  }
  
  @JsonProperty(JSON_PROPERTY_PAYOR_REFS)
  private void setPayorRefs_JsonNullable(JsonNullable<List<PayeePayorRef>> payorRefs) {
    this.payorRefs = payorRefs;
  }



  public Payee email(String email) {
    this.email = JsonNullable.<String>of(email);
    
    return this;
  }

   /**
   * Get email
   * @return email
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "bob@example.com", value = "")
  @JsonIgnore

  public String getEmail() {
        return email.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_EMAIL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getEmail_JsonNullable() {
    return email;
  }
  
  @JsonProperty(JSON_PROPERTY_EMAIL)
  public void setEmail_JsonNullable(JsonNullable<String> email) {
    this.email = email;
  }

  public void setEmail(String email) {
    this.email = JsonNullable.<String>of(email);
  }


  public Payee address(PayeeAddress address) {
    
    this.address = address;
    return this;
  }

   /**
   * Get address
   * @return address
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PayeeAddress getAddress() {
    return address;
  }


  public void setAddress(PayeeAddress address) {
    this.address = address;
  }


  public Payee country(String country) {
    
    this.country = country;
    return this;
  }

   /**
   * Get country
   * @return country
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "US", value = "")
  @JsonProperty(JSON_PROPERTY_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCountry() {
    return country;
  }


  public void setCountry(String country) {
    this.country = country;
  }


  public Payee displayName(String displayName) {
    
    this.displayName = displayName;
    return this;
  }

   /**
   * Get displayName
   * @return displayName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "Bob", value = "")
  @JsonProperty(JSON_PROPERTY_DISPLAY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDisplayName() {
    return displayName;
  }


  public void setDisplayName(String displayName) {
    this.displayName = displayName;
  }


  public Payee paymentChannel(PayeePaymentChannel paymentChannel) {
    
    this.paymentChannel = paymentChannel;
    return this;
  }

   /**
   * Get paymentChannel
   * @return paymentChannel
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PAYMENT_CHANNEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PayeePaymentChannel getPaymentChannel() {
    return paymentChannel;
  }


  public void setPaymentChannel(PayeePaymentChannel paymentChannel) {
    this.paymentChannel = paymentChannel;
  }


  public Payee challenge(Challenge challenge) {
    
    this.challenge = challenge;
    return this;
  }

   /**
   * Get challenge
   * @return challenge
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CHALLENGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Challenge getChallenge() {
    return challenge;
  }


  public void setChallenge(Challenge challenge) {
    this.challenge = challenge;
  }


  public Payee language(Language language) {
    
    this.language = language;
    return this;
  }

   /**
   * Get language
   * @return language
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_LANGUAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Language getLanguage() {
    return language;
  }


  public void setLanguage(Language language) {
    this.language = language;
  }


   /**
   * The timestamp when the payee last accepted T&amp;Cs
   * @return acceptTermsAndConditionsTimestamp
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(example = "2019-01-20T09:00Z", value = "The timestamp when the payee last accepted T&Cs")
  @JsonIgnore

  public OffsetDateTime getAcceptTermsAndConditionsTimestamp() {
    
    if (acceptTermsAndConditionsTimestamp == null) {
      acceptTermsAndConditionsTimestamp = JsonNullable.<OffsetDateTime>undefined();
    }
    return acceptTermsAndConditionsTimestamp.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ACCEPT_TERMS_AND_CONDITIONS_TIMESTAMP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<OffsetDateTime> getAcceptTermsAndConditionsTimestamp_JsonNullable() {
    return acceptTermsAndConditionsTimestamp;
  }
  
  @JsonProperty(JSON_PROPERTY_ACCEPT_TERMS_AND_CONDITIONS_TIMESTAMP)
  private void setAcceptTermsAndConditionsTimestamp_JsonNullable(JsonNullable<OffsetDateTime> acceptTermsAndConditionsTimestamp) {
    this.acceptTermsAndConditionsTimestamp = acceptTermsAndConditionsTimestamp;
  }



  public Payee cellphoneNumber(String cellphoneNumber) {
    
    this.cellphoneNumber = cellphoneNumber;
    return this;
  }

   /**
   * Get cellphoneNumber
   * @return cellphoneNumber
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "1234567890", value = "")
  @JsonProperty(JSON_PROPERTY_CELLPHONE_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCellphoneNumber() {
    return cellphoneNumber;
  }


  public void setCellphoneNumber(String cellphoneNumber) {
    this.cellphoneNumber = cellphoneNumber;
  }


  public Payee payeeType(PayeeType payeeType) {
    
    this.payeeType = payeeType;
    return this;
  }

   /**
   * Get payeeType
   * @return payeeType
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PAYEE_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PayeeType getPayeeType() {
    return payeeType;
  }


  public void setPayeeType(PayeeType payeeType) {
    this.payeeType = payeeType;
  }


  public Payee company(CompanyV1 company) {
    this.company = JsonNullable.<CompanyV1>of(company);
    
    return this;
  }

   /**
   * Get company
   * @return company
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonIgnore

  public CompanyV1 getCompany() {
        return company.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_COMPANY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<CompanyV1> getCompany_JsonNullable() {
    return company;
  }
  
  @JsonProperty(JSON_PROPERTY_COMPANY)
  public void setCompany_JsonNullable(JsonNullable<CompanyV1> company) {
    this.company = company;
  }

  public void setCompany(CompanyV1 company) {
    this.company = JsonNullable.<CompanyV1>of(company);
  }


  public Payee individual(IndividualV1 individual) {
    
    this.individual = individual;
    return this;
  }

   /**
   * Get individual
   * @return individual
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_INDIVIDUAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public IndividualV1 getIndividual() {
    return individual;
  }


  public void setIndividual(IndividualV1 individual) {
    this.individual = individual;
  }


  public Payee created(OffsetDateTime created) {
    
    this.created = created;
    return this;
  }

   /**
   * Get created
   * @return created
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(example = "2019-01-20T09:00Z", value = "")
  @JsonProperty(JSON_PROPERTY_CREATED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getCreated() {
    return created;
  }


  public void setCreated(OffsetDateTime created) {
    this.created = created;
  }


   /**
   * Get gracePeriodEndDate
   * @return gracePeriodEndDate
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonIgnore

  public LocalDate getGracePeriodEndDate() {
    
    if (gracePeriodEndDate == null) {
      gracePeriodEndDate = JsonNullable.<LocalDate>undefined();
    }
    return gracePeriodEndDate.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_GRACE_PERIOD_END_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<LocalDate> getGracePeriodEndDate_JsonNullable() {
    return gracePeriodEndDate;
  }
  
  @JsonProperty(JSON_PROPERTY_GRACE_PERIOD_END_DATE)
  private void setGracePeriodEndDate_JsonNullable(JsonNullable<LocalDate> gracePeriodEndDate) {
    this.gracePeriodEndDate = gracePeriodEndDate;
  }



   /**
   * Get lastOfacCheckTimestamp
   * @return lastOfacCheckTimestamp
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "2019-01-20T09:00:00.000Z", value = "")
  @JsonIgnore

  public String getLastOfacCheckTimestamp() {
    
    if (lastOfacCheckTimestamp == null) {
      lastOfacCheckTimestamp = JsonNullable.<String>undefined();
    }
    return lastOfacCheckTimestamp.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_LAST_OFAC_CHECK_TIMESTAMP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getLastOfacCheckTimestamp_JsonNullable() {
    return lastOfacCheckTimestamp;
  }
  
  @JsonProperty(JSON_PROPERTY_LAST_OFAC_CHECK_TIMESTAMP)
  private void setLastOfacCheckTimestamp_JsonNullable(JsonNullable<String> lastOfacCheckTimestamp) {
    this.lastOfacCheckTimestamp = lastOfacCheckTimestamp;
  }



  public Payee marketingOptIns(List<MarketingOptIn> marketingOptIns) {
    
    this.marketingOptIns = marketingOptIns;
    return this;
  }

  public Payee addMarketingOptInsItem(MarketingOptIn marketingOptInsItem) {
    if (this.marketingOptIns == null) {
      this.marketingOptIns = new ArrayList<>();
    }
    this.marketingOptIns.add(marketingOptInsItem);
    return this;
  }

   /**
   * Get marketingOptIns
   * @return marketingOptIns
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_MARKETING_OPT_INS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<MarketingOptIn> getMarketingOptIns() {
    return marketingOptIns;
  }


  public void setMarketingOptIns(List<MarketingOptIn> marketingOptIns) {
    this.marketingOptIns = marketingOptIns;
  }


  public Payee ofacStatus(OfacStatus ofacStatus) {
    
    this.ofacStatus = ofacStatus;
    return this;
  }

   /**
   * Get ofacStatus
   * @return ofacStatus
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_OFAC_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OfacStatus getOfacStatus() {
    return ofacStatus;
  }


  public void setOfacStatus(OfacStatus ofacStatus) {
    this.ofacStatus = ofacStatus;
  }


  public Payee onboardedStatus(OnboardedStatus onboardedStatus) {
    
    this.onboardedStatus = onboardedStatus;
    return this;
  }

   /**
   * Get onboardedStatus
   * @return onboardedStatus
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ONBOARDED_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OnboardedStatus getOnboardedStatus() {
    return onboardedStatus;
  }


  public void setOnboardedStatus(OnboardedStatus onboardedStatus) {
    this.onboardedStatus = onboardedStatus;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Payee payee = (Payee) o;
    return Objects.equals(this.payeeId, payee.payeeId) &&
        Objects.equals(this.payorRefs, payee.payorRefs) &&
        Objects.equals(this.email, payee.email) &&
        Objects.equals(this.address, payee.address) &&
        Objects.equals(this.country, payee.country) &&
        Objects.equals(this.displayName, payee.displayName) &&
        Objects.equals(this.paymentChannel, payee.paymentChannel) &&
        Objects.equals(this.challenge, payee.challenge) &&
        Objects.equals(this.language, payee.language) &&
        Objects.equals(this.acceptTermsAndConditionsTimestamp, payee.acceptTermsAndConditionsTimestamp) &&
        Objects.equals(this.cellphoneNumber, payee.cellphoneNumber) &&
        Objects.equals(this.payeeType, payee.payeeType) &&
        Objects.equals(this.company, payee.company) &&
        Objects.equals(this.individual, payee.individual) &&
        Objects.equals(this.created, payee.created) &&
        Objects.equals(this.gracePeriodEndDate, payee.gracePeriodEndDate) &&
        Objects.equals(this.lastOfacCheckTimestamp, payee.lastOfacCheckTimestamp) &&
        Objects.equals(this.marketingOptIns, payee.marketingOptIns) &&
        Objects.equals(this.ofacStatus, payee.ofacStatus) &&
        Objects.equals(this.onboardedStatus, payee.onboardedStatus);
  }

  @Override
  public int hashCode() {
    return Objects.hash(payeeId, payorRefs, email, address, country, displayName, paymentChannel, challenge, language, acceptTermsAndConditionsTimestamp, cellphoneNumber, payeeType, company, individual, created, gracePeriodEndDate, lastOfacCheckTimestamp, marketingOptIns, ofacStatus, onboardedStatus);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Payee {\n");
    sb.append("    payeeId: ").append(toIndentedString(payeeId)).append("\n");
    sb.append("    payorRefs: ").append(toIndentedString(payorRefs)).append("\n");
    sb.append("    email: ").append(toIndentedString(email)).append("\n");
    sb.append("    address: ").append(toIndentedString(address)).append("\n");
    sb.append("    country: ").append(toIndentedString(country)).append("\n");
    sb.append("    displayName: ").append(toIndentedString(displayName)).append("\n");
    sb.append("    paymentChannel: ").append(toIndentedString(paymentChannel)).append("\n");
    sb.append("    challenge: ").append(toIndentedString(challenge)).append("\n");
    sb.append("    language: ").append(toIndentedString(language)).append("\n");
    sb.append("    acceptTermsAndConditionsTimestamp: ").append(toIndentedString(acceptTermsAndConditionsTimestamp)).append("\n");
    sb.append("    cellphoneNumber: ").append(toIndentedString(cellphoneNumber)).append("\n");
    sb.append("    payeeType: ").append(toIndentedString(payeeType)).append("\n");
    sb.append("    company: ").append(toIndentedString(company)).append("\n");
    sb.append("    individual: ").append(toIndentedString(individual)).append("\n");
    sb.append("    created: ").append(toIndentedString(created)).append("\n");
    sb.append("    gracePeriodEndDate: ").append(toIndentedString(gracePeriodEndDate)).append("\n");
    sb.append("    lastOfacCheckTimestamp: ").append(toIndentedString(lastOfacCheckTimestamp)).append("\n");
    sb.append("    marketingOptIns: ").append(toIndentedString(marketingOptIns)).append("\n");
    sb.append("    ofacStatus: ").append(toIndentedString(ofacStatus)).append("\n");
    sb.append("    onboardedStatus: ").append(toIndentedString(onboardedStatus)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

