/*
 * Velo Payments APIs
 * ## Terms and Definitions  Throughout this document and the Velo platform the following terms are used:  * **Payor.** An entity (typically a corporation) which wishes to pay funds to one or more payees via a payout. * **Payee.** The recipient of funds paid out by a payor. * **Payment.** A single transfer of funds from a payor to a payee. * **Payout.** A batch of Payments, typically used by a payor to logically group payments (e.g. by business day). Technically there need be no relationship between the payments in a payout - a single payout can contain payments to multiple payees and/or multiple payments to a single payee. * **Sandbox.** An integration environment provided by Velo Payments which offers a similar API experience to the production environment, but all funding and payment events are simulated, along with many other services such as OFAC sanctions list checking.  ## Overview  The Velo Payments API allows a payor to perform a number of operations. The following is a list of the main capabilities in a natural order of execution:  * Authenticate with the Velo platform * Maintain a collection of payees * Query the payor’s current balance of funds within the platform and perform additional funding * Issue payments to payees * Query the platform for a history of those payments  This document describes the main concepts and APIs required to get up and running with the Velo Payments platform. It is not an exhaustive API reference. For that, please see the separate Velo Payments API Reference.  ## API Considerations  The Velo Payments API is REST based and uses the JSON format for requests and responses.  Most calls are secured using OAuth 2 security and require a valid authentication access token for successful operation. See the Authentication section for details.  Where a dynamic value is required in the examples below, the {token} format is used, suggesting that the caller needs to supply the appropriate value of the token in question (without including the { or } characters).  Where curl examples are given, the –d @filename.json approach is used, indicating that the request body should be placed into a file named filename.json in the current directory. Each of the curl examples in this document should be considered a single line on the command-line, regardless of how they appear in print.  ## Authenticating with the Velo Platform  Once Velo backoffice staff have added your organization as a payor within the Velo platform sandbox, they will create you a payor Id, an API key and an API secret and share these with you in a secure manner.  You will need to use these values to authenticate with the Velo platform in order to gain access to the APIs. The steps to take are explained in the following:  create a string comprising the API key (e.g. 44a9537d-d55d-4b47-8082-14061c2bcdd8) and API secret (e.g. c396b26b-137a-44fd-87f5-34631f8fd529) with a colon between them. E.g. 44a9537d-d55d-4b47-8082-14061c2bcdd8:c396b26b-137a-44fd-87f5-34631f8fd529  base64 encode this string. E.g.: NDRhOTUzN2QtZDU1ZC00YjQ3LTgwODItMTQwNjFjMmJjZGQ4OmMzOTZiMjZiLTEzN2EtNDRmZC04N2Y1LTM0NjMxZjhmZDUyOQ==  create an HTTP **Authorization** header with the value set to e.g. Basic NDRhOTUzN2QtZDU1ZC00YjQ3LTgwODItMTQwNjFjMmJjZGQ4OmMzOTZiMjZiLTEzN2EtNDRmZC04N2Y1LTM0NjMxZjhmZDUyOQ==  perform the Velo authentication REST call using the HTTP header created above e.g. via curl:  ```   curl -X POST \\   -H \"Content-Type: application/json\" \\   -H \"Authorization: Basic NDRhOTUzN2QtZDU1ZC00YjQ3LTgwODItMTQwNjFjMmJjZGQ4OmMzOTZiMjZiLTEzN2EtNDRmZC04N2Y1LTM0NjMxZjhmZDUyOQ==\" \\   'https://api.sandbox.velopayments.com/v1/authenticate?grant_type=client_credentials' ```  If successful, this call will result in a **200** HTTP status code and a response body such as:  ```   {     \"access_token\":\"19f6bafd-93fd-4747-b229-00507bbc991f\",     \"token_type\":\"bearer\",     \"expires_in\":1799,     \"scope\":\"...\"   } ``` ## API access following authentication Following successful authentication, the value of the access_token field in the response (indicated in green above) should then be presented with all subsequent API calls to allow the Velo platform to validate that the caller is authenticated.  This is achieved by setting the HTTP Authorization header with the value set to e.g. Bearer 19f6bafd-93fd-4747-b229-00507bbc991f such as the curl example below:  ```   -H \"Authorization: Bearer 19f6bafd-93fd-4747-b229-00507bbc991f \" ```  If you make other Velo API calls which require authorization but the Authorization header is missing or invalid then you will get a **401** HTTP status response. 
 *
 * The version of the OpenAPI document: 2.19.37
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.velopayments.oa3.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.velopayments.oa3.model.Company2;
import com.velopayments.oa3.model.Individual2;
import com.velopayments.oa3.model.Language2;
import com.velopayments.oa3.model.OnboardedStatus2;
import com.velopayments.oa3.model.PayeeAddress2;
import com.velopayments.oa3.model.PayeePayorRefV3;
import com.velopayments.oa3.model.PayeeType;
import com.velopayments.oa3.model.WatchlistStatus;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import javax.validation.constraints.*;
import javax.validation.Valid;

/**
 * PayeeResponseV3
 */
@JsonPropertyOrder({
  PayeeResponseV3.JSON_PROPERTY_PAYEE_ID,
  PayeeResponseV3.JSON_PROPERTY_PAYOR_REFS,
  PayeeResponseV3.JSON_PROPERTY_EMAIL,
  PayeeResponseV3.JSON_PROPERTY_ONBOARDED_STATUS,
  PayeeResponseV3.JSON_PROPERTY_WATCHLIST_STATUS,
  PayeeResponseV3.JSON_PROPERTY_WATCHLIST_OVERRIDE_EXPIRES_AT_TIMESTAMP,
  PayeeResponseV3.JSON_PROPERTY_WATCHLIST_OVERRIDE_COMMENT,
  PayeeResponseV3.JSON_PROPERTY_LANGUAGE,
  PayeeResponseV3.JSON_PROPERTY_CREATED,
  PayeeResponseV3.JSON_PROPERTY_COUNTRY,
  PayeeResponseV3.JSON_PROPERTY_DISPLAY_NAME,
  PayeeResponseV3.JSON_PROPERTY_PAYEE_TYPE,
  PayeeResponseV3.JSON_PROPERTY_DISABLED,
  PayeeResponseV3.JSON_PROPERTY_DISABLED_COMMENT,
  PayeeResponseV3.JSON_PROPERTY_DISABLED_UPDATED_TIMESTAMP,
  PayeeResponseV3.JSON_PROPERTY_ADDRESS,
  PayeeResponseV3.JSON_PROPERTY_INDIVIDUAL,
  PayeeResponseV3.JSON_PROPERTY_COMPANY,
  PayeeResponseV3.JSON_PROPERTY_CELLPHONE_NUMBER,
  PayeeResponseV3.JSON_PROPERTY_WATCHLIST_STATUS_UPDATED_TIMESTAMP,
  PayeeResponseV3.JSON_PROPERTY_GRACE_PERIOD_END_DATE,
  PayeeResponseV3.JSON_PROPERTY_ENHANCED_KYC_COMPLETED,
  PayeeResponseV3.JSON_PROPERTY_KYC_COMPLETED_TIMESTAMP,
  PayeeResponseV3.JSON_PROPERTY_PAUSE_PAYMENT,
  PayeeResponseV3.JSON_PROPERTY_PAUSE_PAYMENT_TIMESTAMP,
  PayeeResponseV3.JSON_PROPERTY_MARKETING_OPT_IN_DECISION,
  PayeeResponseV3.JSON_PROPERTY_MARKETING_OPT_IN_TIMESTAMP,
  PayeeResponseV3.JSON_PROPERTY_ACCEPT_TERMS_AND_CONDITIONS_TIMESTAMP
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-01-15T13:04:46.100429-05:00[America/New_York]")
public class PayeeResponseV3 {
  public static final String JSON_PROPERTY_PAYEE_ID = "payeeId";
  private UUID payeeId;

  public static final String JSON_PROPERTY_PAYOR_REFS = "payorRefs";
  private JsonNullable<List<PayeePayorRefV3>> payorRefs = JsonNullable.<List<PayeePayorRefV3>>undefined();

  public static final String JSON_PROPERTY_EMAIL = "email";
  private JsonNullable<String> email = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_ONBOARDED_STATUS = "onboardedStatus";
  private OnboardedStatus2 onboardedStatus;

  public static final String JSON_PROPERTY_WATCHLIST_STATUS = "watchlistStatus";
  private WatchlistStatus watchlistStatus;

  public static final String JSON_PROPERTY_WATCHLIST_OVERRIDE_EXPIRES_AT_TIMESTAMP = "watchlistOverrideExpiresAtTimestamp";
  private JsonNullable<OffsetDateTime> watchlistOverrideExpiresAtTimestamp = JsonNullable.<OffsetDateTime>undefined();

  public static final String JSON_PROPERTY_WATCHLIST_OVERRIDE_COMMENT = "watchlistOverrideComment";
  private String watchlistOverrideComment;

  public static final String JSON_PROPERTY_LANGUAGE = "language";
  private Language2 language;

  public static final String JSON_PROPERTY_CREATED = "created";
  private OffsetDateTime created;

  public static final String JSON_PROPERTY_COUNTRY = "country";
  private String country;

  public static final String JSON_PROPERTY_DISPLAY_NAME = "displayName";
  private String displayName;

  public static final String JSON_PROPERTY_PAYEE_TYPE = "payeeType";
  private PayeeType payeeType;

  public static final String JSON_PROPERTY_DISABLED = "disabled";
  private Boolean disabled;

  public static final String JSON_PROPERTY_DISABLED_COMMENT = "disabledComment";
  private String disabledComment;

  public static final String JSON_PROPERTY_DISABLED_UPDATED_TIMESTAMP = "disabledUpdatedTimestamp";
  private OffsetDateTime disabledUpdatedTimestamp;

  public static final String JSON_PROPERTY_ADDRESS = "address";
  private PayeeAddress2 address;

  public static final String JSON_PROPERTY_INDIVIDUAL = "individual";
  private Individual2 individual;

  public static final String JSON_PROPERTY_COMPANY = "company";
  private JsonNullable<Company2> company = JsonNullable.<Company2>undefined();

  public static final String JSON_PROPERTY_CELLPHONE_NUMBER = "cellphoneNumber";
  private String cellphoneNumber;

  public static final String JSON_PROPERTY_WATCHLIST_STATUS_UPDATED_TIMESTAMP = "watchlistStatusUpdatedTimestamp";
  private JsonNullable<String> watchlistStatusUpdatedTimestamp = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_GRACE_PERIOD_END_DATE = "gracePeriodEndDate";
  private JsonNullable<LocalDate> gracePeriodEndDate = JsonNullable.<LocalDate>undefined();

  public static final String JSON_PROPERTY_ENHANCED_KYC_COMPLETED = "enhancedKycCompleted";
  private Boolean enhancedKycCompleted;

  public static final String JSON_PROPERTY_KYC_COMPLETED_TIMESTAMP = "kycCompletedTimestamp";
  private JsonNullable<String> kycCompletedTimestamp = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_PAUSE_PAYMENT = "pausePayment";
  private Boolean pausePayment;

  public static final String JSON_PROPERTY_PAUSE_PAYMENT_TIMESTAMP = "pausePaymentTimestamp";
  private JsonNullable<String> pausePaymentTimestamp = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_MARKETING_OPT_IN_DECISION = "marketingOptInDecision";
  private Boolean marketingOptInDecision;

  public static final String JSON_PROPERTY_MARKETING_OPT_IN_TIMESTAMP = "marketingOptInTimestamp";
  private JsonNullable<String> marketingOptInTimestamp = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_ACCEPT_TERMS_AND_CONDITIONS_TIMESTAMP = "acceptTermsAndConditionsTimestamp";
  private JsonNullable<OffsetDateTime> acceptTermsAndConditionsTimestamp = JsonNullable.<OffsetDateTime>undefined();


   /**
   * Get payeeId
   * @return payeeId
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(example = "2aa5d7e0-2ecb-403f-8494-1865ed0454e9", value = "")
  @JsonProperty(JSON_PROPERTY_PAYEE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getPayeeId() {
    return payeeId;
  }




   /**
   * Get payorRefs
   * @return payorRefs
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonIgnore

  public List<PayeePayorRefV3> getPayorRefs() {
    
    if (payorRefs == null) {
      payorRefs = JsonNullable.<List<PayeePayorRefV3>>of(new ArrayList<>());
    }
    return payorRefs.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PAYOR_REFS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<PayeePayorRefV3>> getPayorRefs_JsonNullable() {
    return payorRefs;
  }
  
  @JsonProperty(JSON_PROPERTY_PAYOR_REFS)
  private void setPayorRefs_JsonNullable(JsonNullable<List<PayeePayorRefV3>> payorRefs) {
    this.payorRefs = payorRefs;
  }



  public PayeeResponseV3 email(String email) {
    this.email = JsonNullable.<String>of(email);
    
    return this;
  }

   /**
   * Get email
   * @return email
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "bob@example.com", value = "")
  @JsonIgnore

  public String getEmail() {
        return email.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_EMAIL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getEmail_JsonNullable() {
    return email;
  }
  
  @JsonProperty(JSON_PROPERTY_EMAIL)
  public void setEmail_JsonNullable(JsonNullable<String> email) {
    this.email = email;
  }

  public void setEmail(String email) {
    this.email = JsonNullable.<String>of(email);
  }


  public PayeeResponseV3 onboardedStatus(OnboardedStatus2 onboardedStatus) {
    
    this.onboardedStatus = onboardedStatus;
    return this;
  }

   /**
   * Get onboardedStatus
   * @return onboardedStatus
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ONBOARDED_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OnboardedStatus2 getOnboardedStatus() {
    return onboardedStatus;
  }


  public void setOnboardedStatus(OnboardedStatus2 onboardedStatus) {
    this.onboardedStatus = onboardedStatus;
  }


  public PayeeResponseV3 watchlistStatus(WatchlistStatus watchlistStatus) {
    
    this.watchlistStatus = watchlistStatus;
    return this;
  }

   /**
   * Get watchlistStatus
   * @return watchlistStatus
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_WATCHLIST_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public WatchlistStatus getWatchlistStatus() {
    return watchlistStatus;
  }


  public void setWatchlistStatus(WatchlistStatus watchlistStatus) {
    this.watchlistStatus = watchlistStatus;
  }


  public PayeeResponseV3 watchlistOverrideExpiresAtTimestamp(OffsetDateTime watchlistOverrideExpiresAtTimestamp) {
    this.watchlistOverrideExpiresAtTimestamp = JsonNullable.<OffsetDateTime>of(watchlistOverrideExpiresAtTimestamp);
    
    return this;
  }

   /**
   * Get watchlistOverrideExpiresAtTimestamp
   * @return watchlistOverrideExpiresAtTimestamp
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(example = "2019-01-20T09:00Z", value = "")
  @JsonIgnore

  public OffsetDateTime getWatchlistOverrideExpiresAtTimestamp() {
        return watchlistOverrideExpiresAtTimestamp.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_WATCHLIST_OVERRIDE_EXPIRES_AT_TIMESTAMP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<OffsetDateTime> getWatchlistOverrideExpiresAtTimestamp_JsonNullable() {
    return watchlistOverrideExpiresAtTimestamp;
  }
  
  @JsonProperty(JSON_PROPERTY_WATCHLIST_OVERRIDE_EXPIRES_AT_TIMESTAMP)
  public void setWatchlistOverrideExpiresAtTimestamp_JsonNullable(JsonNullable<OffsetDateTime> watchlistOverrideExpiresAtTimestamp) {
    this.watchlistOverrideExpiresAtTimestamp = watchlistOverrideExpiresAtTimestamp;
  }

  public void setWatchlistOverrideExpiresAtTimestamp(OffsetDateTime watchlistOverrideExpiresAtTimestamp) {
    this.watchlistOverrideExpiresAtTimestamp = JsonNullable.<OffsetDateTime>of(watchlistOverrideExpiresAtTimestamp);
  }


  public PayeeResponseV3 watchlistOverrideComment(String watchlistOverrideComment) {
    
    this.watchlistOverrideComment = watchlistOverrideComment;
    return this;
  }

   /**
   * Get watchlistOverrideComment
   * @return watchlistOverrideComment
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "watchlist override comment", value = "")
  @JsonProperty(JSON_PROPERTY_WATCHLIST_OVERRIDE_COMMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getWatchlistOverrideComment() {
    return watchlistOverrideComment;
  }


  public void setWatchlistOverrideComment(String watchlistOverrideComment) {
    this.watchlistOverrideComment = watchlistOverrideComment;
  }


  public PayeeResponseV3 language(Language2 language) {
    
    this.language = language;
    return this;
  }

   /**
   * Get language
   * @return language
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_LANGUAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Language2 getLanguage() {
    return language;
  }


  public void setLanguage(Language2 language) {
    this.language = language;
  }


  public PayeeResponseV3 created(OffsetDateTime created) {
    
    this.created = created;
    return this;
  }

   /**
   * Get created
   * @return created
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(example = "2019-01-20T09:00Z", value = "")
  @JsonProperty(JSON_PROPERTY_CREATED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getCreated() {
    return created;
  }


  public void setCreated(OffsetDateTime created) {
    this.created = created;
  }


  public PayeeResponseV3 country(String country) {
    
    this.country = country;
    return this;
  }

   /**
   * Get country
   * @return country
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "US", value = "")
  @JsonProperty(JSON_PROPERTY_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCountry() {
    return country;
  }


  public void setCountry(String country) {
    this.country = country;
  }


  public PayeeResponseV3 displayName(String displayName) {
    
    this.displayName = displayName;
    return this;
  }

   /**
   * Get displayName
   * @return displayName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "Bob", value = "")
  @JsonProperty(JSON_PROPERTY_DISPLAY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDisplayName() {
    return displayName;
  }


  public void setDisplayName(String displayName) {
    this.displayName = displayName;
  }


  public PayeeResponseV3 payeeType(PayeeType payeeType) {
    
    this.payeeType = payeeType;
    return this;
  }

   /**
   * Get payeeType
   * @return payeeType
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PAYEE_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PayeeType getPayeeType() {
    return payeeType;
  }


  public void setPayeeType(PayeeType payeeType) {
    this.payeeType = payeeType;
  }


  public PayeeResponseV3 disabled(Boolean disabled) {
    
    this.disabled = disabled;
    return this;
  }

   /**
   * Get disabled
   * @return disabled
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DISABLED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getDisabled() {
    return disabled;
  }


  public void setDisabled(Boolean disabled) {
    this.disabled = disabled;
  }


  public PayeeResponseV3 disabledComment(String disabledComment) {
    
    this.disabledComment = disabledComment;
    return this;
  }

   /**
   * Get disabledComment
   * @return disabledComment
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "reason for disabled", value = "")
  @JsonProperty(JSON_PROPERTY_DISABLED_COMMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDisabledComment() {
    return disabledComment;
  }


  public void setDisabledComment(String disabledComment) {
    this.disabledComment = disabledComment;
  }


  public PayeeResponseV3 disabledUpdatedTimestamp(OffsetDateTime disabledUpdatedTimestamp) {
    
    this.disabledUpdatedTimestamp = disabledUpdatedTimestamp;
    return this;
  }

   /**
   * Get disabledUpdatedTimestamp
   * @return disabledUpdatedTimestamp
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(example = "2019-01-20T09:00Z", value = "")
  @JsonProperty(JSON_PROPERTY_DISABLED_UPDATED_TIMESTAMP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getDisabledUpdatedTimestamp() {
    return disabledUpdatedTimestamp;
  }


  public void setDisabledUpdatedTimestamp(OffsetDateTime disabledUpdatedTimestamp) {
    this.disabledUpdatedTimestamp = disabledUpdatedTimestamp;
  }


  public PayeeResponseV3 address(PayeeAddress2 address) {
    
    this.address = address;
    return this;
  }

   /**
   * Get address
   * @return address
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PayeeAddress2 getAddress() {
    return address;
  }


  public void setAddress(PayeeAddress2 address) {
    this.address = address;
  }


  public PayeeResponseV3 individual(Individual2 individual) {
    
    this.individual = individual;
    return this;
  }

   /**
   * Get individual
   * @return individual
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_INDIVIDUAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Individual2 getIndividual() {
    return individual;
  }


  public void setIndividual(Individual2 individual) {
    this.individual = individual;
  }


  public PayeeResponseV3 company(Company2 company) {
    this.company = JsonNullable.<Company2>of(company);
    
    return this;
  }

   /**
   * Get company
   * @return company
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonIgnore

  public Company2 getCompany() {
        return company.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_COMPANY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Company2> getCompany_JsonNullable() {
    return company;
  }
  
  @JsonProperty(JSON_PROPERTY_COMPANY)
  public void setCompany_JsonNullable(JsonNullable<Company2> company) {
    this.company = company;
  }

  public void setCompany(Company2 company) {
    this.company = JsonNullable.<Company2>of(company);
  }


  public PayeeResponseV3 cellphoneNumber(String cellphoneNumber) {
    
    this.cellphoneNumber = cellphoneNumber;
    return this;
  }

   /**
   * Get cellphoneNumber
   * @return cellphoneNumber
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "1234567890", value = "")
  @JsonProperty(JSON_PROPERTY_CELLPHONE_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCellphoneNumber() {
    return cellphoneNumber;
  }


  public void setCellphoneNumber(String cellphoneNumber) {
    this.cellphoneNumber = cellphoneNumber;
  }


   /**
   * Get watchlistStatusUpdatedTimestamp
   * @return watchlistStatusUpdatedTimestamp
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "2019-01-20T09:00:00.000Z", value = "")
  @JsonIgnore

  public String getWatchlistStatusUpdatedTimestamp() {
    
    if (watchlistStatusUpdatedTimestamp == null) {
      watchlistStatusUpdatedTimestamp = JsonNullable.<String>undefined();
    }
    return watchlistStatusUpdatedTimestamp.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_WATCHLIST_STATUS_UPDATED_TIMESTAMP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getWatchlistStatusUpdatedTimestamp_JsonNullable() {
    return watchlistStatusUpdatedTimestamp;
  }
  
  @JsonProperty(JSON_PROPERTY_WATCHLIST_STATUS_UPDATED_TIMESTAMP)
  private void setWatchlistStatusUpdatedTimestamp_JsonNullable(JsonNullable<String> watchlistStatusUpdatedTimestamp) {
    this.watchlistStatusUpdatedTimestamp = watchlistStatusUpdatedTimestamp;
  }



   /**
   * Get gracePeriodEndDate
   * @return gracePeriodEndDate
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonIgnore

  public LocalDate getGracePeriodEndDate() {
    
    if (gracePeriodEndDate == null) {
      gracePeriodEndDate = JsonNullable.<LocalDate>undefined();
    }
    return gracePeriodEndDate.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_GRACE_PERIOD_END_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<LocalDate> getGracePeriodEndDate_JsonNullable() {
    return gracePeriodEndDate;
  }
  
  @JsonProperty(JSON_PROPERTY_GRACE_PERIOD_END_DATE)
  private void setGracePeriodEndDate_JsonNullable(JsonNullable<LocalDate> gracePeriodEndDate) {
    this.gracePeriodEndDate = gracePeriodEndDate;
  }



  public PayeeResponseV3 enhancedKycCompleted(Boolean enhancedKycCompleted) {
    
    this.enhancedKycCompleted = enhancedKycCompleted;
    return this;
  }

   /**
   * Get enhancedKycCompleted
   * @return enhancedKycCompleted
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ENHANCED_KYC_COMPLETED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getEnhancedKycCompleted() {
    return enhancedKycCompleted;
  }


  public void setEnhancedKycCompleted(Boolean enhancedKycCompleted) {
    this.enhancedKycCompleted = enhancedKycCompleted;
  }


  public PayeeResponseV3 kycCompletedTimestamp(String kycCompletedTimestamp) {
    this.kycCompletedTimestamp = JsonNullable.<String>of(kycCompletedTimestamp);
    
    return this;
  }

   /**
   * Get kycCompletedTimestamp
   * @return kycCompletedTimestamp
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "2019-01-20T09:00:00.000Z", value = "")
  @JsonIgnore

  public String getKycCompletedTimestamp() {
        return kycCompletedTimestamp.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_KYC_COMPLETED_TIMESTAMP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getKycCompletedTimestamp_JsonNullable() {
    return kycCompletedTimestamp;
  }
  
  @JsonProperty(JSON_PROPERTY_KYC_COMPLETED_TIMESTAMP)
  public void setKycCompletedTimestamp_JsonNullable(JsonNullable<String> kycCompletedTimestamp) {
    this.kycCompletedTimestamp = kycCompletedTimestamp;
  }

  public void setKycCompletedTimestamp(String kycCompletedTimestamp) {
    this.kycCompletedTimestamp = JsonNullable.<String>of(kycCompletedTimestamp);
  }


  public PayeeResponseV3 pausePayment(Boolean pausePayment) {
    
    this.pausePayment = pausePayment;
    return this;
  }

   /**
   * Get pausePayment
   * @return pausePayment
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PAUSE_PAYMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getPausePayment() {
    return pausePayment;
  }


  public void setPausePayment(Boolean pausePayment) {
    this.pausePayment = pausePayment;
  }


  public PayeeResponseV3 pausePaymentTimestamp(String pausePaymentTimestamp) {
    this.pausePaymentTimestamp = JsonNullable.<String>of(pausePaymentTimestamp);
    
    return this;
  }

   /**
   * Get pausePaymentTimestamp
   * @return pausePaymentTimestamp
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "2019-01-20T09:00:00.000Z", value = "")
  @JsonIgnore

  public String getPausePaymentTimestamp() {
        return pausePaymentTimestamp.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PAUSE_PAYMENT_TIMESTAMP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getPausePaymentTimestamp_JsonNullable() {
    return pausePaymentTimestamp;
  }
  
  @JsonProperty(JSON_PROPERTY_PAUSE_PAYMENT_TIMESTAMP)
  public void setPausePaymentTimestamp_JsonNullable(JsonNullable<String> pausePaymentTimestamp) {
    this.pausePaymentTimestamp = pausePaymentTimestamp;
  }

  public void setPausePaymentTimestamp(String pausePaymentTimestamp) {
    this.pausePaymentTimestamp = JsonNullable.<String>of(pausePaymentTimestamp);
  }


  public PayeeResponseV3 marketingOptInDecision(Boolean marketingOptInDecision) {
    
    this.marketingOptInDecision = marketingOptInDecision;
    return this;
  }

   /**
   * Get marketingOptInDecision
   * @return marketingOptInDecision
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_MARKETING_OPT_IN_DECISION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getMarketingOptInDecision() {
    return marketingOptInDecision;
  }


  public void setMarketingOptInDecision(Boolean marketingOptInDecision) {
    this.marketingOptInDecision = marketingOptInDecision;
  }


  public PayeeResponseV3 marketingOptInTimestamp(String marketingOptInTimestamp) {
    this.marketingOptInTimestamp = JsonNullable.<String>of(marketingOptInTimestamp);
    
    return this;
  }

   /**
   * Get marketingOptInTimestamp
   * @return marketingOptInTimestamp
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "2019-01-20T09:00:00.000Z", value = "")
  @JsonIgnore

  public String getMarketingOptInTimestamp() {
        return marketingOptInTimestamp.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_MARKETING_OPT_IN_TIMESTAMP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getMarketingOptInTimestamp_JsonNullable() {
    return marketingOptInTimestamp;
  }
  
  @JsonProperty(JSON_PROPERTY_MARKETING_OPT_IN_TIMESTAMP)
  public void setMarketingOptInTimestamp_JsonNullable(JsonNullable<String> marketingOptInTimestamp) {
    this.marketingOptInTimestamp = marketingOptInTimestamp;
  }

  public void setMarketingOptInTimestamp(String marketingOptInTimestamp) {
    this.marketingOptInTimestamp = JsonNullable.<String>of(marketingOptInTimestamp);
  }


   /**
   * The timestamp when the payee last accepted T&amp;Cs
   * @return acceptTermsAndConditionsTimestamp
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(example = "2019-01-20T09:00Z", value = "The timestamp when the payee last accepted T&Cs")
  @JsonIgnore

  public OffsetDateTime getAcceptTermsAndConditionsTimestamp() {
    
    if (acceptTermsAndConditionsTimestamp == null) {
      acceptTermsAndConditionsTimestamp = JsonNullable.<OffsetDateTime>undefined();
    }
    return acceptTermsAndConditionsTimestamp.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ACCEPT_TERMS_AND_CONDITIONS_TIMESTAMP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<OffsetDateTime> getAcceptTermsAndConditionsTimestamp_JsonNullable() {
    return acceptTermsAndConditionsTimestamp;
  }
  
  @JsonProperty(JSON_PROPERTY_ACCEPT_TERMS_AND_CONDITIONS_TIMESTAMP)
  private void setAcceptTermsAndConditionsTimestamp_JsonNullable(JsonNullable<OffsetDateTime> acceptTermsAndConditionsTimestamp) {
    this.acceptTermsAndConditionsTimestamp = acceptTermsAndConditionsTimestamp;
  }



  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PayeeResponseV3 payeeResponseV3 = (PayeeResponseV3) o;
    return Objects.equals(this.payeeId, payeeResponseV3.payeeId) &&
        Objects.equals(this.payorRefs, payeeResponseV3.payorRefs) &&
        Objects.equals(this.email, payeeResponseV3.email) &&
        Objects.equals(this.onboardedStatus, payeeResponseV3.onboardedStatus) &&
        Objects.equals(this.watchlistStatus, payeeResponseV3.watchlistStatus) &&
        Objects.equals(this.watchlistOverrideExpiresAtTimestamp, payeeResponseV3.watchlistOverrideExpiresAtTimestamp) &&
        Objects.equals(this.watchlistOverrideComment, payeeResponseV3.watchlistOverrideComment) &&
        Objects.equals(this.language, payeeResponseV3.language) &&
        Objects.equals(this.created, payeeResponseV3.created) &&
        Objects.equals(this.country, payeeResponseV3.country) &&
        Objects.equals(this.displayName, payeeResponseV3.displayName) &&
        Objects.equals(this.payeeType, payeeResponseV3.payeeType) &&
        Objects.equals(this.disabled, payeeResponseV3.disabled) &&
        Objects.equals(this.disabledComment, payeeResponseV3.disabledComment) &&
        Objects.equals(this.disabledUpdatedTimestamp, payeeResponseV3.disabledUpdatedTimestamp) &&
        Objects.equals(this.address, payeeResponseV3.address) &&
        Objects.equals(this.individual, payeeResponseV3.individual) &&
        Objects.equals(this.company, payeeResponseV3.company) &&
        Objects.equals(this.cellphoneNumber, payeeResponseV3.cellphoneNumber) &&
        Objects.equals(this.watchlistStatusUpdatedTimestamp, payeeResponseV3.watchlistStatusUpdatedTimestamp) &&
        Objects.equals(this.gracePeriodEndDate, payeeResponseV3.gracePeriodEndDate) &&
        Objects.equals(this.enhancedKycCompleted, payeeResponseV3.enhancedKycCompleted) &&
        Objects.equals(this.kycCompletedTimestamp, payeeResponseV3.kycCompletedTimestamp) &&
        Objects.equals(this.pausePayment, payeeResponseV3.pausePayment) &&
        Objects.equals(this.pausePaymentTimestamp, payeeResponseV3.pausePaymentTimestamp) &&
        Objects.equals(this.marketingOptInDecision, payeeResponseV3.marketingOptInDecision) &&
        Objects.equals(this.marketingOptInTimestamp, payeeResponseV3.marketingOptInTimestamp) &&
        Objects.equals(this.acceptTermsAndConditionsTimestamp, payeeResponseV3.acceptTermsAndConditionsTimestamp);
  }

  @Override
  public int hashCode() {
    return Objects.hash(payeeId, payorRefs, email, onboardedStatus, watchlistStatus, watchlistOverrideExpiresAtTimestamp, watchlistOverrideComment, language, created, country, displayName, payeeType, disabled, disabledComment, disabledUpdatedTimestamp, address, individual, company, cellphoneNumber, watchlistStatusUpdatedTimestamp, gracePeriodEndDate, enhancedKycCompleted, kycCompletedTimestamp, pausePayment, pausePaymentTimestamp, marketingOptInDecision, marketingOptInTimestamp, acceptTermsAndConditionsTimestamp);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PayeeResponseV3 {\n");
    sb.append("    payeeId: ").append(toIndentedString(payeeId)).append("\n");
    sb.append("    payorRefs: ").append(toIndentedString(payorRefs)).append("\n");
    sb.append("    email: ").append(toIndentedString(email)).append("\n");
    sb.append("    onboardedStatus: ").append(toIndentedString(onboardedStatus)).append("\n");
    sb.append("    watchlistStatus: ").append(toIndentedString(watchlistStatus)).append("\n");
    sb.append("    watchlistOverrideExpiresAtTimestamp: ").append(toIndentedString(watchlistOverrideExpiresAtTimestamp)).append("\n");
    sb.append("    watchlistOverrideComment: ").append(toIndentedString(watchlistOverrideComment)).append("\n");
    sb.append("    language: ").append(toIndentedString(language)).append("\n");
    sb.append("    created: ").append(toIndentedString(created)).append("\n");
    sb.append("    country: ").append(toIndentedString(country)).append("\n");
    sb.append("    displayName: ").append(toIndentedString(displayName)).append("\n");
    sb.append("    payeeType: ").append(toIndentedString(payeeType)).append("\n");
    sb.append("    disabled: ").append(toIndentedString(disabled)).append("\n");
    sb.append("    disabledComment: ").append(toIndentedString(disabledComment)).append("\n");
    sb.append("    disabledUpdatedTimestamp: ").append(toIndentedString(disabledUpdatedTimestamp)).append("\n");
    sb.append("    address: ").append(toIndentedString(address)).append("\n");
    sb.append("    individual: ").append(toIndentedString(individual)).append("\n");
    sb.append("    company: ").append(toIndentedString(company)).append("\n");
    sb.append("    cellphoneNumber: ").append(toIndentedString(cellphoneNumber)).append("\n");
    sb.append("    watchlistStatusUpdatedTimestamp: ").append(toIndentedString(watchlistStatusUpdatedTimestamp)).append("\n");
    sb.append("    gracePeriodEndDate: ").append(toIndentedString(gracePeriodEndDate)).append("\n");
    sb.append("    enhancedKycCompleted: ").append(toIndentedString(enhancedKycCompleted)).append("\n");
    sb.append("    kycCompletedTimestamp: ").append(toIndentedString(kycCompletedTimestamp)).append("\n");
    sb.append("    pausePayment: ").append(toIndentedString(pausePayment)).append("\n");
    sb.append("    pausePaymentTimestamp: ").append(toIndentedString(pausePaymentTimestamp)).append("\n");
    sb.append("    marketingOptInDecision: ").append(toIndentedString(marketingOptInDecision)).append("\n");
    sb.append("    marketingOptInTimestamp: ").append(toIndentedString(marketingOptInTimestamp)).append("\n");
    sb.append("    acceptTermsAndConditionsTimestamp: ").append(toIndentedString(acceptTermsAndConditionsTimestamp)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

