/*
 * Velo Payments APIs
 * ## Terms and Definitions  Throughout this document and the Velo platform the following terms are used:  * **Payor.** An entity (typically a corporation) which wishes to pay funds to one or more payees via a payout. * **Payee.** The recipient of funds paid out by a payor. * **Payment.** A single transfer of funds from a payor to a payee. * **Payout.** A batch of Payments, typically used by a payor to logically group payments (e.g. by business day). Technically there need be no relationship between the payments in a payout - a single payout can contain payments to multiple payees and/or multiple payments to a single payee. * **Sandbox.** An integration environment provided by Velo Payments which offers a similar API experience to the production environment, but all funding and payment events are simulated, along with many other services such as OFAC sanctions list checking.  ## Overview  The Velo Payments API allows a payor to perform a number of operations. The following is a list of the main capabilities in a natural order of execution:  * Authenticate with the Velo platform * Maintain a collection of payees * Query the payor’s current balance of funds within the platform and perform additional funding * Issue payments to payees * Query the platform for a history of those payments  This document describes the main concepts and APIs required to get up and running with the Velo Payments platform. It is not an exhaustive API reference. For that, please see the separate Velo Payments API Reference.  ## API Considerations  The Velo Payments API is REST based and uses the JSON format for requests and responses.  Most calls are secured using OAuth 2 security and require a valid authentication access token for successful operation. See the Authentication section for details.  Where a dynamic value is required in the examples below, the {token} format is used, suggesting that the caller needs to supply the appropriate value of the token in question (without including the { or } characters).  Where curl examples are given, the –d @filename.json approach is used, indicating that the request body should be placed into a file named filename.json in the current directory. Each of the curl examples in this document should be considered a single line on the command-line, regardless of how they appear in print.  ## Authenticating with the Velo Platform  Once Velo backoffice staff have added your organization as a payor within the Velo platform sandbox, they will create you a payor Id, an API key and an API secret and share these with you in a secure manner.  You will need to use these values to authenticate with the Velo platform in order to gain access to the APIs. The steps to take are explained in the following:  create a string comprising the API key (e.g. 44a9537d-d55d-4b47-8082-14061c2bcdd8) and API secret (e.g. c396b26b-137a-44fd-87f5-34631f8fd529) with a colon between them. E.g. 44a9537d-d55d-4b47-8082-14061c2bcdd8:c396b26b-137a-44fd-87f5-34631f8fd529  base64 encode this string. E.g.: NDRhOTUzN2QtZDU1ZC00YjQ3LTgwODItMTQwNjFjMmJjZGQ4OmMzOTZiMjZiLTEzN2EtNDRmZC04N2Y1LTM0NjMxZjhmZDUyOQ==  create an HTTP **Authorization** header with the value set to e.g. Basic NDRhOTUzN2QtZDU1ZC00YjQ3LTgwODItMTQwNjFjMmJjZGQ4OmMzOTZiMjZiLTEzN2EtNDRmZC04N2Y1LTM0NjMxZjhmZDUyOQ==  perform the Velo authentication REST call using the HTTP header created above e.g. via curl:  ```   curl -X POST \\   -H \"Content-Type: application/json\" \\   -H \"Authorization: Basic NDRhOTUzN2QtZDU1ZC00YjQ3LTgwODItMTQwNjFjMmJjZGQ4OmMzOTZiMjZiLTEzN2EtNDRmZC04N2Y1LTM0NjMxZjhmZDUyOQ==\" \\   'https://api.sandbox.velopayments.com/v1/authenticate?grant_type=client_credentials' ```  If successful, this call will result in a **200** HTTP status code and a response body such as:  ```   {     \"access_token\":\"19f6bafd-93fd-4747-b229-00507bbc991f\",     \"token_type\":\"bearer\",     \"expires_in\":1799,     \"scope\":\"...\"   } ``` ## API access following authentication Following successful authentication, the value of the access_token field in the response (indicated in green above) should then be presented with all subsequent API calls to allow the Velo platform to validate that the caller is authenticated.  This is achieved by setting the HTTP Authorization header with the value set to e.g. Bearer 19f6bafd-93fd-4747-b229-00507bbc991f such as the curl example below:  ```   -H \"Authorization: Bearer 19f6bafd-93fd-4747-b229-00507bbc991f \" ```  If you make other Velo API calls which require authorization but the Authorization header is missing or invalid then you will get a **401** HTTP status response. 
 *
 * The version of the OpenAPI document: 2.19.37
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.velopayments.oa3.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.velopayments.oa3.model.FxSummaryV4;
import com.velopayments.oa3.model.PayoutStatusV4;
import com.velopayments.oa3.model.PayoutTypeV4;
import com.velopayments.oa3.model.SourceAccountSummaryV4;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import javax.validation.constraints.*;
import javax.validation.Valid;

/**
 * PayoutSummaryAuditV4
 */
@JsonPropertyOrder({
  PayoutSummaryAuditV4.JSON_PROPERTY_PAYOUT_ID,
  PayoutSummaryAuditV4.JSON_PROPERTY_PAYOR_ID,
  PayoutSummaryAuditV4.JSON_PROPERTY_STATUS,
  PayoutSummaryAuditV4.JSON_PROPERTY_DATE_TIME,
  PayoutSummaryAuditV4.JSON_PROPERTY_SUBMITTED_DATE_TIME,
  PayoutSummaryAuditV4.JSON_PROPERTY_INSTRUCTED_DATE_TIME,
  PayoutSummaryAuditV4.JSON_PROPERTY_WITHDRAWN_DATE_TIME,
  PayoutSummaryAuditV4.JSON_PROPERTY_TOTAL_PAYMENTS,
  PayoutSummaryAuditV4.JSON_PROPERTY_TOTAL_INCOMPLETE_PAYMENTS,
  PayoutSummaryAuditV4.JSON_PROPERTY_TOTAL_RETURNED_PAYMENTS,
  PayoutSummaryAuditV4.JSON_PROPERTY_SOURCE_ACCOUNT_SUMMARY,
  PayoutSummaryAuditV4.JSON_PROPERTY_FX_SUMMARIES,
  PayoutSummaryAuditV4.JSON_PROPERTY_PAYOUT_MEMO,
  PayoutSummaryAuditV4.JSON_PROPERTY_PAYOUT_TYPE,
  PayoutSummaryAuditV4.JSON_PROPERTY_PAYOR_NAME
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-01-15T13:04:46.100429-05:00[America/New_York]")
public class PayoutSummaryAuditV4 {
  public static final String JSON_PROPERTY_PAYOUT_ID = "payoutId";
  private UUID payoutId;

  public static final String JSON_PROPERTY_PAYOR_ID = "payorId";
  private UUID payorId;

  public static final String JSON_PROPERTY_STATUS = "status";
  private PayoutStatusV4 status;

  public static final String JSON_PROPERTY_DATE_TIME = "dateTime";
  private OffsetDateTime dateTime;

  public static final String JSON_PROPERTY_SUBMITTED_DATE_TIME = "submittedDateTime";
  private String submittedDateTime;

  public static final String JSON_PROPERTY_INSTRUCTED_DATE_TIME = "instructedDateTime";
  private String instructedDateTime;

  public static final String JSON_PROPERTY_WITHDRAWN_DATE_TIME = "withdrawnDateTime";
  private OffsetDateTime withdrawnDateTime;

  public static final String JSON_PROPERTY_TOTAL_PAYMENTS = "totalPayments";
  private Integer totalPayments;

  public static final String JSON_PROPERTY_TOTAL_INCOMPLETE_PAYMENTS = "totalIncompletePayments";
  private Integer totalIncompletePayments;

  public static final String JSON_PROPERTY_TOTAL_RETURNED_PAYMENTS = "totalReturnedPayments";
  private Integer totalReturnedPayments;

  public static final String JSON_PROPERTY_SOURCE_ACCOUNT_SUMMARY = "sourceAccountSummary";
  private List<SourceAccountSummaryV4> sourceAccountSummary = null;

  public static final String JSON_PROPERTY_FX_SUMMARIES = "fxSummaries";
  private List<FxSummaryV4> fxSummaries = null;

  public static final String JSON_PROPERTY_PAYOUT_MEMO = "payoutMemo";
  private String payoutMemo;

  public static final String JSON_PROPERTY_PAYOUT_TYPE = "payoutType";
  private PayoutTypeV4 payoutType;

  public static final String JSON_PROPERTY_PAYOR_NAME = "payorName";
  private String payorName;


  public PayoutSummaryAuditV4 payoutId(UUID payoutId) {
    
    this.payoutId = payoutId;
    return this;
  }

   /**
   * Get payoutId
   * @return payoutId
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PAYOUT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getPayoutId() {
    return payoutId;
  }


  public void setPayoutId(UUID payoutId) {
    this.payoutId = payoutId;
  }


  public PayoutSummaryAuditV4 payorId(UUID payorId) {
    
    this.payorId = payorId;
    return this;
  }

   /**
   * Get payorId
   * @return payorId
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PAYOR_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getPayorId() {
    return payorId;
  }


  public void setPayorId(UUID payorId) {
    this.payorId = payorId;
  }


  public PayoutSummaryAuditV4 status(PayoutStatusV4 status) {
    
    this.status = status;
    return this;
  }

   /**
   * Get status
   * @return status
  **/
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public PayoutStatusV4 getStatus() {
    return status;
  }


  public void setStatus(PayoutStatusV4 status) {
    this.status = status;
  }


  public PayoutSummaryAuditV4 dateTime(OffsetDateTime dateTime) {
    
    this.dateTime = dateTime;
    return this;
  }

   /**
   * Get dateTime
   * @return dateTime
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DATE_TIME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getDateTime() {
    return dateTime;
  }


  public void setDateTime(OffsetDateTime dateTime) {
    this.dateTime = dateTime;
  }


  public PayoutSummaryAuditV4 submittedDateTime(String submittedDateTime) {
    
    this.submittedDateTime = submittedDateTime;
    return this;
  }

   /**
   * Get submittedDateTime
   * @return submittedDateTime
  **/
  @NotNull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_SUBMITTED_DATE_TIME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSubmittedDateTime() {
    return submittedDateTime;
  }


  public void setSubmittedDateTime(String submittedDateTime) {
    this.submittedDateTime = submittedDateTime;
  }


  public PayoutSummaryAuditV4 instructedDateTime(String instructedDateTime) {
    
    this.instructedDateTime = instructedDateTime;
    return this;
  }

   /**
   * Get instructedDateTime
   * @return instructedDateTime
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_INSTRUCTED_DATE_TIME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getInstructedDateTime() {
    return instructedDateTime;
  }


  public void setInstructedDateTime(String instructedDateTime) {
    this.instructedDateTime = instructedDateTime;
  }


  public PayoutSummaryAuditV4 withdrawnDateTime(OffsetDateTime withdrawnDateTime) {
    
    this.withdrawnDateTime = withdrawnDateTime;
    return this;
  }

   /**
   * Get withdrawnDateTime
   * @return withdrawnDateTime
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_WITHDRAWN_DATE_TIME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getWithdrawnDateTime() {
    return withdrawnDateTime;
  }


  public void setWithdrawnDateTime(OffsetDateTime withdrawnDateTime) {
    this.withdrawnDateTime = withdrawnDateTime;
  }


  public PayoutSummaryAuditV4 totalPayments(Integer totalPayments) {
    
    this.totalPayments = totalPayments;
    return this;
  }

   /**
   * Get totalPayments
   * @return totalPayments
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TOTAL_PAYMENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getTotalPayments() {
    return totalPayments;
  }


  public void setTotalPayments(Integer totalPayments) {
    this.totalPayments = totalPayments;
  }


  public PayoutSummaryAuditV4 totalIncompletePayments(Integer totalIncompletePayments) {
    
    this.totalIncompletePayments = totalIncompletePayments;
    return this;
  }

   /**
   * Get totalIncompletePayments
   * @return totalIncompletePayments
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TOTAL_INCOMPLETE_PAYMENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getTotalIncompletePayments() {
    return totalIncompletePayments;
  }


  public void setTotalIncompletePayments(Integer totalIncompletePayments) {
    this.totalIncompletePayments = totalIncompletePayments;
  }


  public PayoutSummaryAuditV4 totalReturnedPayments(Integer totalReturnedPayments) {
    
    this.totalReturnedPayments = totalReturnedPayments;
    return this;
  }

   /**
   * Get totalReturnedPayments
   * @return totalReturnedPayments
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TOTAL_RETURNED_PAYMENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getTotalReturnedPayments() {
    return totalReturnedPayments;
  }


  public void setTotalReturnedPayments(Integer totalReturnedPayments) {
    this.totalReturnedPayments = totalReturnedPayments;
  }


  public PayoutSummaryAuditV4 sourceAccountSummary(List<SourceAccountSummaryV4> sourceAccountSummary) {
    
    this.sourceAccountSummary = sourceAccountSummary;
    return this;
  }

  public PayoutSummaryAuditV4 addSourceAccountSummaryItem(SourceAccountSummaryV4 sourceAccountSummaryItem) {
    if (this.sourceAccountSummary == null) {
      this.sourceAccountSummary = new ArrayList<>();
    }
    this.sourceAccountSummary.add(sourceAccountSummaryItem);
    return this;
  }

   /**
   * Get sourceAccountSummary
   * @return sourceAccountSummary
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SOURCE_ACCOUNT_SUMMARY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<SourceAccountSummaryV4> getSourceAccountSummary() {
    return sourceAccountSummary;
  }


  public void setSourceAccountSummary(List<SourceAccountSummaryV4> sourceAccountSummary) {
    this.sourceAccountSummary = sourceAccountSummary;
  }


  public PayoutSummaryAuditV4 fxSummaries(List<FxSummaryV4> fxSummaries) {
    
    this.fxSummaries = fxSummaries;
    return this;
  }

  public PayoutSummaryAuditV4 addFxSummariesItem(FxSummaryV4 fxSummariesItem) {
    if (this.fxSummaries == null) {
      this.fxSummaries = new ArrayList<>();
    }
    this.fxSummaries.add(fxSummariesItem);
    return this;
  }

   /**
   * Get fxSummaries
   * @return fxSummaries
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_FX_SUMMARIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<FxSummaryV4> getFxSummaries() {
    return fxSummaries;
  }


  public void setFxSummaries(List<FxSummaryV4> fxSummaries) {
    this.fxSummaries = fxSummaries;
  }


  public PayoutSummaryAuditV4 payoutMemo(String payoutMemo) {
    
    this.payoutMemo = payoutMemo;
    return this;
  }

   /**
   * Get payoutMemo
   * @return payoutMemo
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PAYOUT_MEMO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPayoutMemo() {
    return payoutMemo;
  }


  public void setPayoutMemo(String payoutMemo) {
    this.payoutMemo = payoutMemo;
  }


  public PayoutSummaryAuditV4 payoutType(PayoutTypeV4 payoutType) {
    
    this.payoutType = payoutType;
    return this;
  }

   /**
   * Get payoutType
   * @return payoutType
  **/
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_PAYOUT_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public PayoutTypeV4 getPayoutType() {
    return payoutType;
  }


  public void setPayoutType(PayoutTypeV4 payoutType) {
    this.payoutType = payoutType;
  }


  public PayoutSummaryAuditV4 payorName(String payorName) {
    
    this.payorName = payorName;
    return this;
  }

   /**
   * Get payorName
   * @return payorName
  **/
  @NotNull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_PAYOR_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getPayorName() {
    return payorName;
  }


  public void setPayorName(String payorName) {
    this.payorName = payorName;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PayoutSummaryAuditV4 payoutSummaryAuditV4 = (PayoutSummaryAuditV4) o;
    return Objects.equals(this.payoutId, payoutSummaryAuditV4.payoutId) &&
        Objects.equals(this.payorId, payoutSummaryAuditV4.payorId) &&
        Objects.equals(this.status, payoutSummaryAuditV4.status) &&
        Objects.equals(this.dateTime, payoutSummaryAuditV4.dateTime) &&
        Objects.equals(this.submittedDateTime, payoutSummaryAuditV4.submittedDateTime) &&
        Objects.equals(this.instructedDateTime, payoutSummaryAuditV4.instructedDateTime) &&
        Objects.equals(this.withdrawnDateTime, payoutSummaryAuditV4.withdrawnDateTime) &&
        Objects.equals(this.totalPayments, payoutSummaryAuditV4.totalPayments) &&
        Objects.equals(this.totalIncompletePayments, payoutSummaryAuditV4.totalIncompletePayments) &&
        Objects.equals(this.totalReturnedPayments, payoutSummaryAuditV4.totalReturnedPayments) &&
        Objects.equals(this.sourceAccountSummary, payoutSummaryAuditV4.sourceAccountSummary) &&
        Objects.equals(this.fxSummaries, payoutSummaryAuditV4.fxSummaries) &&
        Objects.equals(this.payoutMemo, payoutSummaryAuditV4.payoutMemo) &&
        Objects.equals(this.payoutType, payoutSummaryAuditV4.payoutType) &&
        Objects.equals(this.payorName, payoutSummaryAuditV4.payorName);
  }

  @Override
  public int hashCode() {
    return Objects.hash(payoutId, payorId, status, dateTime, submittedDateTime, instructedDateTime, withdrawnDateTime, totalPayments, totalIncompletePayments, totalReturnedPayments, sourceAccountSummary, fxSummaries, payoutMemo, payoutType, payorName);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PayoutSummaryAuditV4 {\n");
    sb.append("    payoutId: ").append(toIndentedString(payoutId)).append("\n");
    sb.append("    payorId: ").append(toIndentedString(payorId)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    dateTime: ").append(toIndentedString(dateTime)).append("\n");
    sb.append("    submittedDateTime: ").append(toIndentedString(submittedDateTime)).append("\n");
    sb.append("    instructedDateTime: ").append(toIndentedString(instructedDateTime)).append("\n");
    sb.append("    withdrawnDateTime: ").append(toIndentedString(withdrawnDateTime)).append("\n");
    sb.append("    totalPayments: ").append(toIndentedString(totalPayments)).append("\n");
    sb.append("    totalIncompletePayments: ").append(toIndentedString(totalIncompletePayments)).append("\n");
    sb.append("    totalReturnedPayments: ").append(toIndentedString(totalReturnedPayments)).append("\n");
    sb.append("    sourceAccountSummary: ").append(toIndentedString(sourceAccountSummary)).append("\n");
    sb.append("    fxSummaries: ").append(toIndentedString(fxSummaries)).append("\n");
    sb.append("    payoutMemo: ").append(toIndentedString(payoutMemo)).append("\n");
    sb.append("    payoutType: ").append(toIndentedString(payoutType)).append("\n");
    sb.append("    payorName: ").append(toIndentedString(payorName)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

