/*
 * Velo Payments APIs
 * ## Terms and Definitions  Throughout this document and the Velo platform the following terms are used:  * **Payor.** An entity (typically a corporation) which wishes to pay funds to one or more payees via a payout. * **Payee.** The recipient of funds paid out by a payor. * **Payment.** A single transfer of funds from a payor to a payee. * **Payout.** A batch of Payments, typically used by a payor to logically group payments (e.g. by business day). Technically there need be no relationship between the payments in a payout - a single payout can contain payments to multiple payees and/or multiple payments to a single payee. * **Sandbox.** An integration environment provided by Velo Payments which offers a similar API experience to the production environment, but all funding and payment events are simulated, along with many other services such as OFAC sanctions list checking.  ## Overview  The Velo Payments API allows a payor to perform a number of operations. The following is a list of the main capabilities in a natural order of execution:  * Authenticate with the Velo platform * Maintain a collection of payees * Query the payor’s current balance of funds within the platform and perform additional funding * Issue payments to payees * Query the platform for a history of those payments  This document describes the main concepts and APIs required to get up and running with the Velo Payments platform. It is not an exhaustive API reference. For that, please see the separate Velo Payments API Reference.  ## API Considerations  The Velo Payments API is REST based and uses the JSON format for requests and responses.  Most calls are secured using OAuth 2 security and require a valid authentication access token for successful operation. See the Authentication section for details.  Where a dynamic value is required in the examples below, the {token} format is used, suggesting that the caller needs to supply the appropriate value of the token in question (without including the { or } characters).  Where curl examples are given, the –d @filename.json approach is used, indicating that the request body should be placed into a file named filename.json in the current directory. Each of the curl examples in this document should be considered a single line on the command-line, regardless of how they appear in print.  ## Authenticating with the Velo Platform  Once Velo backoffice staff have added your organization as a payor within the Velo platform sandbox, they will create you a payor Id, an API key and an API secret and share these with you in a secure manner.  You will need to use these values to authenticate with the Velo platform in order to gain access to the APIs. The steps to take are explained in the following:  create a string comprising the API key (e.g. 44a9537d-d55d-4b47-8082-14061c2bcdd8) and API secret (e.g. c396b26b-137a-44fd-87f5-34631f8fd529) with a colon between them. E.g. 44a9537d-d55d-4b47-8082-14061c2bcdd8:c396b26b-137a-44fd-87f5-34631f8fd529  base64 encode this string. E.g.: NDRhOTUzN2QtZDU1ZC00YjQ3LTgwODItMTQwNjFjMmJjZGQ4OmMzOTZiMjZiLTEzN2EtNDRmZC04N2Y1LTM0NjMxZjhmZDUyOQ==  create an HTTP **Authorization** header with the value set to e.g. Basic NDRhOTUzN2QtZDU1ZC00YjQ3LTgwODItMTQwNjFjMmJjZGQ4OmMzOTZiMjZiLTEzN2EtNDRmZC04N2Y1LTM0NjMxZjhmZDUyOQ==  perform the Velo authentication REST call using the HTTP header created above e.g. via curl:  ```   curl -X POST \\   -H \"Content-Type: application/json\" \\   -H \"Authorization: Basic NDRhOTUzN2QtZDU1ZC00YjQ3LTgwODItMTQwNjFjMmJjZGQ4OmMzOTZiMjZiLTEzN2EtNDRmZC04N2Y1LTM0NjMxZjhmZDUyOQ==\" \\   'https://api.sandbox.velopayments.com/v1/authenticate?grant_type=client_credentials' ```  If successful, this call will result in a **200** HTTP status code and a response body such as:  ```   {     \"access_token\":\"19f6bafd-93fd-4747-b229-00507bbc991f\",     \"token_type\":\"bearer\",     \"expires_in\":1799,     \"scope\":\"...\"   } ``` ## API access following authentication Following successful authentication, the value of the access_token field in the response (indicated in green above) should then be presented with all subsequent API calls to allow the Velo platform to validate that the caller is authenticated.  This is achieved by setting the HTTP Authorization header with the value set to e.g. Bearer 19f6bafd-93fd-4747-b229-00507bbc991f such as the curl example below:  ```   -H \"Authorization: Bearer 19f6bafd-93fd-4747-b229-00507bbc991f \" ```  If you make other Velo API calls which require authorization but the Authorization header is missing or invalid then you will get a **401** HTTP status response. 
 *
 * The version of the OpenAPI document: 2.19.37
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.velopayments.oa3.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.UUID;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import javax.validation.constraints.*;
import javax.validation.Valid;

/**
 * QuoteFxSummary
 */
@JsonPropertyOrder({
  QuoteFxSummary.JSON_PROPERTY_RATE,
  QuoteFxSummary.JSON_PROPERTY_INVERTED_RATE,
  QuoteFxSummary.JSON_PROPERTY_CREATION_TIME,
  QuoteFxSummary.JSON_PROPERTY_EXPIRY_TIME,
  QuoteFxSummary.JSON_PROPERTY_QUOTE_ID,
  QuoteFxSummary.JSON_PROPERTY_TOTAL_SOURCE_AMOUNT,
  QuoteFxSummary.JSON_PROPERTY_TOTAL_PAYMENT_AMOUNT,
  QuoteFxSummary.JSON_PROPERTY_SOURCE_CURRENCY,
  QuoteFxSummary.JSON_PROPERTY_PAYMENT_CURRENCY,
  QuoteFxSummary.JSON_PROPERTY_FUNDING_STATUS,
  QuoteFxSummary.JSON_PROPERTY_STATUS
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-01-15T13:04:46.100429-05:00[America/New_York]")
public class QuoteFxSummary {
  public static final String JSON_PROPERTY_RATE = "rate";
  private Float rate;

  public static final String JSON_PROPERTY_INVERTED_RATE = "invertedRate";
  private Float invertedRate;

  public static final String JSON_PROPERTY_CREATION_TIME = "creationTime";
  private OffsetDateTime creationTime;

  public static final String JSON_PROPERTY_EXPIRY_TIME = "expiryTime";
  private OffsetDateTime expiryTime;

  public static final String JSON_PROPERTY_QUOTE_ID = "quoteId";
  private UUID quoteId;

  public static final String JSON_PROPERTY_TOTAL_SOURCE_AMOUNT = "totalSourceAmount";
  private Integer totalSourceAmount;

  public static final String JSON_PROPERTY_TOTAL_PAYMENT_AMOUNT = "totalPaymentAmount";
  private Integer totalPaymentAmount;

  public static final String JSON_PROPERTY_SOURCE_CURRENCY = "sourceCurrency";
  private String sourceCurrency;

  public static final String JSON_PROPERTY_PAYMENT_CURRENCY = "paymentCurrency";
  private String paymentCurrency;

  /**
   * Gets or Sets fundingStatus
   */
  public enum FundingStatusEnum {
    UNFUNDED("UNFUNDED"),
    
    INSTRUCTED("INSTRUCTED"),
    
    FUNDED("FUNDED");

    private String value;

    FundingStatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static FundingStatusEnum fromValue(String value) {
      for (FundingStatusEnum b : FundingStatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_FUNDING_STATUS = "fundingStatus";
  private FundingStatusEnum fundingStatus;

  /**
   * Gets or Sets status
   */
  public enum StatusEnum {
    UNQUOTED("UNQUOTED"),
    
    QUOTED("QUOTED"),
    
    EXPIRED("EXPIRED"),
    
    EXECUTED("EXECUTED"),
    
    REJECTED("REJECTED");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StatusEnum fromValue(String value) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_STATUS = "status";
  private StatusEnum status;


  public QuoteFxSummary rate(Float rate) {
    
    this.rate = rate;
    return this;
  }

   /**
   * Get rate
   * @return rate
  **/
  @NotNull
  @ApiModelProperty(example = "1.12", required = true, value = "")
  @JsonProperty(JSON_PROPERTY_RATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Float getRate() {
    return rate;
  }


  public void setRate(Float rate) {
    this.rate = rate;
  }


  public QuoteFxSummary invertedRate(Float invertedRate) {
    
    this.invertedRate = invertedRate;
    return this;
  }

   /**
   * Get invertedRate
   * @return invertedRate
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "1.12", value = "")
  @JsonProperty(JSON_PROPERTY_INVERTED_RATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getInvertedRate() {
    return invertedRate;
  }


  public void setInvertedRate(Float invertedRate) {
    this.invertedRate = invertedRate;
  }


  public QuoteFxSummary creationTime(OffsetDateTime creationTime) {
    
    this.creationTime = creationTime;
    return this;
  }

   /**
   * Get creationTime
   * @return creationTime
  **/
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_CREATION_TIME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public OffsetDateTime getCreationTime() {
    return creationTime;
  }


  public void setCreationTime(OffsetDateTime creationTime) {
    this.creationTime = creationTime;
  }


  public QuoteFxSummary expiryTime(OffsetDateTime expiryTime) {
    
    this.expiryTime = expiryTime;
    return this;
  }

   /**
   * Get expiryTime
   * @return expiryTime
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_EXPIRY_TIME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getExpiryTime() {
    return expiryTime;
  }


  public void setExpiryTime(OffsetDateTime expiryTime) {
    this.expiryTime = expiryTime;
  }


  public QuoteFxSummary quoteId(UUID quoteId) {
    
    this.quoteId = quoteId;
    return this;
  }

   /**
   * Get quoteId
   * @return quoteId
  **/
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_QUOTE_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getQuoteId() {
    return quoteId;
  }


  public void setQuoteId(UUID quoteId) {
    this.quoteId = quoteId;
  }


  public QuoteFxSummary totalSourceAmount(Integer totalSourceAmount) {
    
    this.totalSourceAmount = totalSourceAmount;
    return this;
  }

   /**
   * Get totalSourceAmount
   * @return totalSourceAmount
  **/
  @NotNull
  @ApiModelProperty(example = "1234", required = true, value = "")
  @JsonProperty(JSON_PROPERTY_TOTAL_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getTotalSourceAmount() {
    return totalSourceAmount;
  }


  public void setTotalSourceAmount(Integer totalSourceAmount) {
    this.totalSourceAmount = totalSourceAmount;
  }


  public QuoteFxSummary totalPaymentAmount(Integer totalPaymentAmount) {
    
    this.totalPaymentAmount = totalPaymentAmount;
    return this;
  }

   /**
   * Get totalPaymentAmount
   * @return totalPaymentAmount
  **/
  @NotNull
  @ApiModelProperty(example = "1234", required = true, value = "")
  @JsonProperty(JSON_PROPERTY_TOTAL_PAYMENT_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getTotalPaymentAmount() {
    return totalPaymentAmount;
  }


  public void setTotalPaymentAmount(Integer totalPaymentAmount) {
    this.totalPaymentAmount = totalPaymentAmount;
  }


  public QuoteFxSummary sourceCurrency(String sourceCurrency) {
    
    this.sourceCurrency = sourceCurrency;
    return this;
  }

   /**
   * Get sourceCurrency
   * @return sourceCurrency
  **/
  @NotNull
 @Size(min=3,max=3)  @ApiModelProperty(example = "USD", required = true, value = "")
  @JsonProperty(JSON_PROPERTY_SOURCE_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSourceCurrency() {
    return sourceCurrency;
  }


  public void setSourceCurrency(String sourceCurrency) {
    this.sourceCurrency = sourceCurrency;
  }


  public QuoteFxSummary paymentCurrency(String paymentCurrency) {
    
    this.paymentCurrency = paymentCurrency;
    return this;
  }

   /**
   * Get paymentCurrency
   * @return paymentCurrency
  **/
  @NotNull
 @Size(min=3,max=3)  @ApiModelProperty(example = "USD", required = true, value = "")
  @JsonProperty(JSON_PROPERTY_PAYMENT_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getPaymentCurrency() {
    return paymentCurrency;
  }


  public void setPaymentCurrency(String paymentCurrency) {
    this.paymentCurrency = paymentCurrency;
  }


  public QuoteFxSummary fundingStatus(FundingStatusEnum fundingStatus) {
    
    this.fundingStatus = fundingStatus;
    return this;
  }

   /**
   * Get fundingStatus
   * @return fundingStatus
  **/
  @NotNull
  @ApiModelProperty(example = "FUNDED", required = true, value = "")
  @JsonProperty(JSON_PROPERTY_FUNDING_STATUS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public FundingStatusEnum getFundingStatus() {
    return fundingStatus;
  }


  public void setFundingStatus(FundingStatusEnum fundingStatus) {
    this.fundingStatus = fundingStatus;
  }


  public QuoteFxSummary status(StatusEnum status) {
    
    this.status = status;
    return this;
  }

   /**
   * Get status
   * @return status
  **/
  @NotNull
  @ApiModelProperty(example = "QUOTED", required = true, value = "")
  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public StatusEnum getStatus() {
    return status;
  }


  public void setStatus(StatusEnum status) {
    this.status = status;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    QuoteFxSummary quoteFxSummary = (QuoteFxSummary) o;
    return Objects.equals(this.rate, quoteFxSummary.rate) &&
        Objects.equals(this.invertedRate, quoteFxSummary.invertedRate) &&
        Objects.equals(this.creationTime, quoteFxSummary.creationTime) &&
        Objects.equals(this.expiryTime, quoteFxSummary.expiryTime) &&
        Objects.equals(this.quoteId, quoteFxSummary.quoteId) &&
        Objects.equals(this.totalSourceAmount, quoteFxSummary.totalSourceAmount) &&
        Objects.equals(this.totalPaymentAmount, quoteFxSummary.totalPaymentAmount) &&
        Objects.equals(this.sourceCurrency, quoteFxSummary.sourceCurrency) &&
        Objects.equals(this.paymentCurrency, quoteFxSummary.paymentCurrency) &&
        Objects.equals(this.fundingStatus, quoteFxSummary.fundingStatus) &&
        Objects.equals(this.status, quoteFxSummary.status);
  }

  @Override
  public int hashCode() {
    return Objects.hash(rate, invertedRate, creationTime, expiryTime, quoteId, totalSourceAmount, totalPaymentAmount, sourceCurrency, paymentCurrency, fundingStatus, status);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class QuoteFxSummary {\n");
    sb.append("    rate: ").append(toIndentedString(rate)).append("\n");
    sb.append("    invertedRate: ").append(toIndentedString(invertedRate)).append("\n");
    sb.append("    creationTime: ").append(toIndentedString(creationTime)).append("\n");
    sb.append("    expiryTime: ").append(toIndentedString(expiryTime)).append("\n");
    sb.append("    quoteId: ").append(toIndentedString(quoteId)).append("\n");
    sb.append("    totalSourceAmount: ").append(toIndentedString(totalSourceAmount)).append("\n");
    sb.append("    totalPaymentAmount: ").append(toIndentedString(totalPaymentAmount)).append("\n");
    sb.append("    sourceCurrency: ").append(toIndentedString(sourceCurrency)).append("\n");
    sb.append("    paymentCurrency: ").append(toIndentedString(paymentCurrency)).append("\n");
    sb.append("    fundingStatus: ").append(toIndentedString(fundingStatus)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

