/*
 * Decompiled with CFR 0.152.
 */
package com.velopayments.oa3.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@JsonPropertyOrder(value={"remoteId", "currencyType", "amount", "sourceAccountName", "payorPaymentId", "paymentMemo"})
public class AcceptedPayment {
    public static final String JSON_PROPERTY_REMOTE_ID = "remoteId";
    private String remoteId;
    public static final String JSON_PROPERTY_CURRENCY_TYPE = "currencyType";
    private String currencyType;
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private Integer amount;
    public static final String JSON_PROPERTY_SOURCE_ACCOUNT_NAME = "sourceAccountName";
    private String sourceAccountName;
    public static final String JSON_PROPERTY_PAYOR_PAYMENT_ID = "payorPaymentId";
    private String payorPaymentId;
    public static final String JSON_PROPERTY_PAYMENT_MEMO = "paymentMemo";
    private String paymentMemo;

    public AcceptedPayment remoteId(String remoteId) {
        this.remoteId = remoteId;
        return this;
    }

    @NotNull
    @ApiModelProperty(example="remoteIdVal123", required=true, value="")
    @JsonProperty(value="remoteId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getRemoteId() {
        return this.remoteId;
    }

    public void setRemoteId(String remoteId) {
        this.remoteId = remoteId;
    }

    public AcceptedPayment currencyType(String currencyType) {
        this.currencyType = currencyType;
        return this;
    }

    @NotNull
    @Size(min=3, max=3)
    @ApiModelProperty(example="USD", required=true, value="")
    @JsonProperty(value="currencyType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=3, max=3) String getCurrencyType() {
        return this.currencyType;
    }

    public void setCurrencyType(String currencyType) {
        this.currencyType = currencyType;
    }

    public AcceptedPayment amount(Integer amount) {
        this.amount = amount;
        return this;
    }

    @NotNull
    @ApiModelProperty(example="1234", required=true, value="")
    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Integer getAmount() {
        return this.amount;
    }

    public void setAmount(Integer amount) {
        this.amount = amount;
    }

    public AcceptedPayment sourceAccountName(String sourceAccountName) {
        this.sourceAccountName = sourceAccountName;
        return this;
    }

    @NotNull
    @ApiModelProperty(example="Chase", required=true, value="")
    @JsonProperty(value="sourceAccountName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSourceAccountName() {
        return this.sourceAccountName;
    }

    public void setSourceAccountName(String sourceAccountName) {
        this.sourceAccountName = sourceAccountName;
    }

    public AcceptedPayment payorPaymentId(String payorPaymentId) {
        this.payorPaymentId = payorPaymentId;
        return this;
    }

    @NotNull
    @ApiModelProperty(example="paymenIdVal123123", required=true, value="")
    @JsonProperty(value="payorPaymentId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getPayorPaymentId() {
        return this.payorPaymentId;
    }

    public void setPayorPaymentId(String payorPaymentId) {
        this.payorPaymentId = payorPaymentId;
    }

    public AcceptedPayment paymentMemo(String paymentMemo) {
        this.paymentMemo = paymentMemo;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Payment memo", value="")
    @JsonProperty(value="paymentMemo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPaymentMemo() {
        return this.paymentMemo;
    }

    public void setPaymentMemo(String paymentMemo) {
        this.paymentMemo = paymentMemo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AcceptedPayment acceptedPayment = (AcceptedPayment)o;
        return Objects.equals(this.remoteId, acceptedPayment.remoteId) && Objects.equals(this.currencyType, acceptedPayment.currencyType) && Objects.equals(this.amount, acceptedPayment.amount) && Objects.equals(this.sourceAccountName, acceptedPayment.sourceAccountName) && Objects.equals(this.payorPaymentId, acceptedPayment.payorPaymentId) && Objects.equals(this.paymentMemo, acceptedPayment.paymentMemo);
    }

    public int hashCode() {
        return Objects.hash(this.remoteId, this.currencyType, this.amount, this.sourceAccountName, this.payorPaymentId, this.paymentMemo);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AcceptedPayment {\n");
        sb.append("    remoteId: ").append(this.toIndentedString(this.remoteId)).append("\n");
        sb.append("    currencyType: ").append(this.toIndentedString(this.currencyType)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    sourceAccountName: ").append(this.toIndentedString(this.sourceAccountName)).append("\n");
        sb.append("    payorPaymentId: ").append(this.toIndentedString(this.payorPaymentId)).append("\n");
        sb.append("    paymentMemo: ").append(this.toIndentedString(this.paymentMemo)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

