/*
 * Decompiled with CFR 0.152.
 */
package com.velopayments.oa3.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import java.util.UUID;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@JsonPropertyOrder(value={"accountName", "accountNumber", "routingNumber", "payorId"})
public class CreateFundingAccountRequest {
    public static final String JSON_PROPERTY_ACCOUNT_NAME = "accountName";
    private String accountName;
    public static final String JSON_PROPERTY_ACCOUNT_NUMBER = "accountNumber";
    private String accountNumber;
    public static final String JSON_PROPERTY_ROUTING_NUMBER = "routingNumber";
    private String routingNumber;
    public static final String JSON_PROPERTY_PAYOR_ID = "payorId";
    private UUID payorId;

    public CreateFundingAccountRequest accountName(String accountName) {
        this.accountName = accountName;
        return this;
    }

    @NotNull
    @Size(min=1, max=22)
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="accountName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1, max=22) String getAccountName() {
        return this.accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public CreateFundingAccountRequest accountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
        return this;
    }

    @NotNull
    @Size(min=4, max=17)
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="accountNumber")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=4, max=17) String getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public CreateFundingAccountRequest routingNumber(String routingNumber) {
        this.routingNumber = routingNumber;
        return this;
    }

    @NotNull
    @Size(min=9, max=9)
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="routingNumber")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=9, max=9) String getRoutingNumber() {
        return this.routingNumber;
    }

    public void setRoutingNumber(String routingNumber) {
        this.routingNumber = routingNumber;
    }

    public CreateFundingAccountRequest payorId(UUID payorId) {
        this.payorId = payorId;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="payorId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getPayorId() {
        return this.payorId;
    }

    public void setPayorId(UUID payorId) {
        this.payorId = payorId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateFundingAccountRequest createFundingAccountRequest = (CreateFundingAccountRequest)o;
        return Objects.equals(this.accountName, createFundingAccountRequest.accountName) && Objects.equals(this.accountNumber, createFundingAccountRequest.accountNumber) && Objects.equals(this.routingNumber, createFundingAccountRequest.routingNumber) && Objects.equals(this.payorId, createFundingAccountRequest.payorId);
    }

    public int hashCode() {
        return Objects.hash(this.accountName, this.accountNumber, this.routingNumber, this.payorId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateFundingAccountRequest {\n");
        sb.append("    accountName: ").append(this.toIndentedString(this.accountName)).append("\n");
        sb.append("    accountNumber: ").append(this.toIndentedString(this.accountNumber)).append("\n");
        sb.append("    routingNumber: ").append(this.toIndentedString(this.routingNumber)).append("\n");
        sb.append("    payorId: ").append(this.toIndentedString(this.payorId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

