/*
 * Decompiled with CFR 0.152.
 */
package com.velopayments.oa3.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.velopayments.oa3.model.Challenge;
import com.velopayments.oa3.model.CompanyV1;
import com.velopayments.oa3.model.CreateIndividual;
import com.velopayments.oa3.model.CreatePayeeAddress;
import com.velopayments.oa3.model.CreatePaymentChannel;
import com.velopayments.oa3.model.Language;
import com.velopayments.oa3.model.PayeePayorRefV2;
import com.velopayments.oa3.model.PayeeType;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"payeeId", "payorRefs", "email", "remoteId", "type", "address", "paymentChannel", "challenge", "language", "company", "individual"})
public class CreatePayee {
    public static final String JSON_PROPERTY_PAYEE_ID = "payeeId";
    private UUID payeeId;
    public static final String JSON_PROPERTY_PAYOR_REFS = "payorRefs";
    private JsonNullable<List<PayeePayorRefV2>> payorRefs = JsonNullable.undefined();
    public static final String JSON_PROPERTY_EMAIL = "email";
    private String email;
    public static final String JSON_PROPERTY_REMOTE_ID = "remoteId";
    private String remoteId;
    public static final String JSON_PROPERTY_TYPE = "type";
    private PayeeType type;
    public static final String JSON_PROPERTY_ADDRESS = "address";
    private CreatePayeeAddress address;
    public static final String JSON_PROPERTY_PAYMENT_CHANNEL = "paymentChannel";
    private CreatePaymentChannel paymentChannel;
    public static final String JSON_PROPERTY_CHALLENGE = "challenge";
    private Challenge challenge;
    public static final String JSON_PROPERTY_LANGUAGE = "language";
    private Language language;
    public static final String JSON_PROPERTY_COMPANY = "company";
    private JsonNullable<CompanyV1> company = JsonNullable.undefined();
    public static final String JSON_PROPERTY_INDIVIDUAL = "individual";
    private CreateIndividual individual;

    @Nullable
    @Valid
    @ApiModelProperty(example="2aa5d7e0-2ecb-403f-8494-1865ed0454e9", value="")
    @JsonProperty(value="payeeId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getPayeeId() {
        return this.payeeId;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonIgnore
    public List<PayeePayorRefV2> getPayorRefs() {
        if (this.payorRefs == null) {
            this.payorRefs = JsonNullable.of(new ArrayList());
        }
        return (List)this.payorRefs.orElse(null);
    }

    @JsonProperty(value="payorRefs")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<List<PayeePayorRefV2>> getPayorRefs_JsonNullable() {
        return this.payorRefs;
    }

    @JsonProperty(value="payorRefs")
    private void setPayorRefs_JsonNullable(JsonNullable<List<PayeePayorRefV2>> payorRefs) {
        this.payorRefs = payorRefs;
    }

    public CreatePayee email(String email) {
        this.email = email;
        return this;
    }

    @NotNull
    @Size(min=3, max=255)
    @ApiModelProperty(example="bob@example.com", required=true, value="")
    @JsonProperty(value="email")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=3, max=255) String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public CreatePayee remoteId(String remoteId) {
        this.remoteId = remoteId;
        return this;
    }

    @NotNull
    @Size(min=1, max=100)
    @ApiModelProperty(example="remoteId123", required=true, value="")
    @JsonProperty(value="remoteId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1, max=100) String getRemoteId() {
        return this.remoteId;
    }

    public void setRemoteId(String remoteId) {
        this.remoteId = remoteId;
    }

    public CreatePayee type(PayeeType type) {
        this.type = type;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public PayeeType getType() {
        return this.type;
    }

    public void setType(PayeeType type) {
        this.type = type;
    }

    public CreatePayee address(CreatePayeeAddress address) {
        this.address = address;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public CreatePayeeAddress getAddress() {
        return this.address;
    }

    public void setAddress(CreatePayeeAddress address) {
        this.address = address;
    }

    public CreatePayee paymentChannel(CreatePaymentChannel paymentChannel) {
        this.paymentChannel = paymentChannel;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="paymentChannel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CreatePaymentChannel getPaymentChannel() {
        return this.paymentChannel;
    }

    public void setPaymentChannel(CreatePaymentChannel paymentChannel) {
        this.paymentChannel = paymentChannel;
    }

    public CreatePayee challenge(Challenge challenge) {
        this.challenge = challenge;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="challenge")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Challenge getChallenge() {
        return this.challenge;
    }

    public void setChallenge(Challenge challenge) {
        this.challenge = challenge;
    }

    public CreatePayee language(Language language) {
        this.language = language;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="language")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Language getLanguage() {
        return this.language;
    }

    public void setLanguage(Language language) {
        this.language = language;
    }

    public CreatePayee company(CompanyV1 company) {
        this.company = JsonNullable.of((Object)company);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonIgnore
    public CompanyV1 getCompany() {
        return (CompanyV1)this.company.orElse(null);
    }

    @JsonProperty(value="company")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<CompanyV1> getCompany_JsonNullable() {
        return this.company;
    }

    @JsonProperty(value="company")
    public void setCompany_JsonNullable(JsonNullable<CompanyV1> company) {
        this.company = company;
    }

    public void setCompany(CompanyV1 company) {
        this.company = JsonNullable.of((Object)company);
    }

    public CreatePayee individual(CreateIndividual individual) {
        this.individual = individual;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="individual")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CreateIndividual getIndividual() {
        return this.individual;
    }

    public void setIndividual(CreateIndividual individual) {
        this.individual = individual;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreatePayee createPayee = (CreatePayee)o;
        return Objects.equals(this.payeeId, createPayee.payeeId) && Objects.equals(this.payorRefs, createPayee.payorRefs) && Objects.equals(this.email, createPayee.email) && Objects.equals(this.remoteId, createPayee.remoteId) && Objects.equals((Object)this.type, (Object)createPayee.type) && Objects.equals(this.address, createPayee.address) && Objects.equals(this.paymentChannel, createPayee.paymentChannel) && Objects.equals(this.challenge, createPayee.challenge) && Objects.equals((Object)this.language, (Object)createPayee.language) && Objects.equals(this.company, createPayee.company) && Objects.equals(this.individual, createPayee.individual);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.payeeId, this.payorRefs, this.email, this.remoteId, this.type, this.address, this.paymentChannel, this.challenge, this.language, this.company, this.individual});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreatePayee {\n");
        sb.append("    payeeId: ").append(this.toIndentedString(this.payeeId)).append("\n");
        sb.append("    payorRefs: ").append(this.toIndentedString(this.payorRefs)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    remoteId: ").append(this.toIndentedString(this.remoteId)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    paymentChannel: ").append(this.toIndentedString(this.paymentChannel)).append("\n");
        sb.append("    challenge: ").append(this.toIndentedString(this.challenge)).append("\n");
        sb.append("    language: ").append(this.toIndentedString((Object)this.language)).append("\n");
        sb.append("    company: ").append(this.toIndentedString(this.company)).append("\n");
        sb.append("    individual: ").append(this.toIndentedString(this.individual)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

