/*
 * Decompiled with CFR 0.152.
 */
package com.velopayments.oa3.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"errorMessage", "location", "locationType", "reasonCode"})
public class Error {
    public static final String JSON_PROPERTY_ERROR_MESSAGE = "errorMessage";
    private String errorMessage;
    public static final String JSON_PROPERTY_LOCATION = "location";
    private String location;
    public static final String JSON_PROPERTY_LOCATION_TYPE = "locationType";
    private LocationTypeEnum locationType;
    public static final String JSON_PROPERTY_REASON_CODE = "reasonCode";
    private String reasonCode;

    public Error errorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="smsNumber must be in the E.164 format e.g. +15551231234", value="verbose message indicating the nature of the error Will be localised ")
    @JsonProperty(value="errorMessage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public Error location(String location) {
        this.location = location;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="smsNumber", value="the property or object that caused the error")
    @JsonProperty(value="location")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public Error locationType(LocationTypeEnum locationType) {
        this.locationType = locationType;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="requestBody", value="the location type in the request that was the cause of the error ")
    @JsonProperty(value="locationType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocationTypeEnum getLocationType() {
        return this.locationType;
    }

    public void setLocationType(LocationTypeEnum locationType) {
        this.locationType = locationType;
    }

    public Error reasonCode(String reasonCode) {
        this.reasonCode = reasonCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="validationError", value="a camel-cased string that can be used by clients to localise client error messages")
    @JsonProperty(value="reasonCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReasonCode() {
        return this.reasonCode;
    }

    public void setReasonCode(String reasonCode) {
        this.reasonCode = reasonCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Error error = (Error)o;
        return Objects.equals(this.errorMessage, error.errorMessage) && Objects.equals(this.location, error.location) && Objects.equals((Object)this.locationType, (Object)error.locationType) && Objects.equals(this.reasonCode, error.reasonCode);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.errorMessage, this.location, this.locationType, this.reasonCode});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Error {\n");
        sb.append("    errorMessage: ").append(this.toIndentedString(this.errorMessage)).append("\n");
        sb.append("    location: ").append(this.toIndentedString(this.location)).append("\n");
        sb.append("    locationType: ").append(this.toIndentedString((Object)this.locationType)).append("\n");
        sb.append("    reasonCode: ").append(this.toIndentedString(this.reasonCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum LocationTypeEnum {
        REQUESTBODY("requestBody"),
        QUERYPARAM("queryParam"),
        REQUESTPARAM("requestParam"),
        HEADER("header"),
        PATHPARAM("pathParam");

        private String value;

        private LocationTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static LocationTypeEnum fromValue(String value) {
            for (LocationTypeEnum b : LocationTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

