/*
 * Decompiled with CFR 0.152.
 */
package com.velopayments.oa3.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.velopayments.oa3.model.IndividualV1Name;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@JsonPropertyOrder(value={"name", "nationalIdentification", "dateOfBirth"})
public class Individual {
    public static final String JSON_PROPERTY_NAME = "name";
    private IndividualV1Name name;
    public static final String JSON_PROPERTY_NATIONAL_IDENTIFICATION = "nationalIdentification";
    private String nationalIdentification;
    public static final String JSON_PROPERTY_DATE_OF_BIRTH = "dateOfBirth";
    private String dateOfBirth;

    public Individual name(IndividualV1Name name) {
        this.name = name;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public IndividualV1Name getName() {
        return this.name;
    }

    public void setName(IndividualV1Name name) {
        this.name = name;
    }

    @Nullable
    @Size(min=6, max=30)
    @ApiModelProperty(example="AB123456C", value="If not authorized to view, value will be masked. Example: XXXXX1234")
    @JsonProperty(value="nationalIdentification")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Size(min=6, max=30) String getNationalIdentification() {
        return this.nationalIdentification;
    }

    @NotNull
    @ApiModelProperty(example="1985-01-01T00:00:00.000Z", required=true, value="If not authorized to view, value will be masked. Example: - XXXX-XX-XX")
    @JsonProperty(value="dateOfBirth")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDateOfBirth() {
        return this.dateOfBirth;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Individual individual = (Individual)o;
        return Objects.equals(this.name, individual.name) && Objects.equals(this.nationalIdentification, individual.nationalIdentification) && Objects.equals(this.dateOfBirth, individual.dateOfBirth);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.nationalIdentification, this.dateOfBirth);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Individual {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    nationalIdentification: ").append(this.toIndentedString(this.nationalIdentification)).append("\n");
        sb.append("    dateOfBirth: ").append(this.toIndentedString(this.dateOfBirth)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

