/*
 * Decompiled with CFR 0.152.
 */
package com.velopayments.oa3.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.velopayments.oa3.model.PaymentAuditCurrencyV3;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

@JsonPropertyOrder(value={"eventId", "eventDateTime", "eventType", "sourceCurrency", "sourceAmount", "paymentCurrency", "paymentAmount", "accountNumber", "routingNumber", "iban", "accountName", "principal"})
public class PaymentEventResponseV3 {
    public static final String JSON_PROPERTY_EVENT_ID = "eventId";
    private UUID eventId;
    public static final String JSON_PROPERTY_EVENT_DATE_TIME = "eventDateTime";
    private OffsetDateTime eventDateTime;
    public static final String JSON_PROPERTY_EVENT_TYPE = "eventType";
    private EventTypeEnum eventType;
    public static final String JSON_PROPERTY_SOURCE_CURRENCY = "sourceCurrency";
    private PaymentAuditCurrencyV3 sourceCurrency;
    public static final String JSON_PROPERTY_SOURCE_AMOUNT = "sourceAmount";
    private Long sourceAmount;
    public static final String JSON_PROPERTY_PAYMENT_CURRENCY = "paymentCurrency";
    private PaymentAuditCurrencyV3 paymentCurrency;
    public static final String JSON_PROPERTY_PAYMENT_AMOUNT = "paymentAmount";
    private Long paymentAmount;
    public static final String JSON_PROPERTY_ACCOUNT_NUMBER = "accountNumber";
    private String accountNumber;
    public static final String JSON_PROPERTY_ROUTING_NUMBER = "routingNumber";
    private String routingNumber;
    public static final String JSON_PROPERTY_IBAN = "iban";
    private String iban;
    public static final String JSON_PROPERTY_ACCOUNT_NAME = "accountName";
    private String accountName;
    public static final String JSON_PROPERTY_PRINCIPAL = "principal";
    private String principal;

    public PaymentEventResponseV3 eventId(UUID eventId) {
        this.eventId = eventId;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="The id of the event.")
    @JsonProperty(value="eventId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getEventId() {
        return this.eventId;
    }

    public void setEventId(UUID eventId) {
        this.eventId = eventId;
    }

    public PaymentEventResponseV3 eventDateTime(OffsetDateTime eventDateTime) {
        this.eventDateTime = eventDateTime;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="The date/time at which the event occurred.")
    @JsonProperty(value="eventDateTime")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public OffsetDateTime getEventDateTime() {
        return this.eventDateTime;
    }

    public void setEventDateTime(OffsetDateTime eventDateTime) {
        this.eventDateTime = eventDateTime;
    }

    public PaymentEventResponseV3 eventType(EventTypeEnum eventType) {
        this.eventType = eventType;
        return this;
    }

    @NotNull
    @ApiModelProperty(required=true, value="The type of the event.")
    @JsonProperty(value="eventType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public EventTypeEnum getEventType() {
        return this.eventType;
    }

    public void setEventType(EventTypeEnum eventType) {
        this.eventType = eventType;
    }

    public PaymentEventResponseV3 sourceCurrency(PaymentAuditCurrencyV3 sourceCurrency) {
        this.sourceCurrency = sourceCurrency;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="sourceCurrency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PaymentAuditCurrencyV3 getSourceCurrency() {
        return this.sourceCurrency;
    }

    public void setSourceCurrency(PaymentAuditCurrencyV3 sourceCurrency) {
        this.sourceCurrency = sourceCurrency;
    }

    public PaymentEventResponseV3 sourceAmount(Long sourceAmount) {
        this.sourceAmount = sourceAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1299", value="The source amount exposed by the event.")
    @JsonProperty(value="sourceAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getSourceAmount() {
        return this.sourceAmount;
    }

    public void setSourceAmount(Long sourceAmount) {
        this.sourceAmount = sourceAmount;
    }

    public PaymentEventResponseV3 paymentCurrency(PaymentAuditCurrencyV3 paymentCurrency) {
        this.paymentCurrency = paymentCurrency;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="paymentCurrency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PaymentAuditCurrencyV3 getPaymentCurrency() {
        return this.paymentCurrency;
    }

    public void setPaymentCurrency(PaymentAuditCurrencyV3 paymentCurrency) {
        this.paymentCurrency = paymentCurrency;
    }

    public PaymentEventResponseV3 paymentAmount(Long paymentAmount) {
        this.paymentAmount = paymentAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1299", value="The destination amount exposed by the event.")
    @JsonProperty(value="paymentAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getPaymentAmount() {
        return this.paymentAmount;
    }

    public void setPaymentAmount(Long paymentAmount) {
        this.paymentAmount = paymentAmount;
    }

    public PaymentEventResponseV3 accountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="123123123", value="The account number attached to the event.")
    @JsonProperty(value="accountNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public PaymentEventResponseV3 routingNumber(String routingNumber) {
        this.routingNumber = routingNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="123123123", value="The routing number attached to the event.")
    @JsonProperty(value="routingNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRoutingNumber() {
        return this.routingNumber;
    }

    public void setRoutingNumber(String routingNumber) {
        this.routingNumber = routingNumber;
    }

    public PaymentEventResponseV3 iban(String iban) {
        this.iban = iban;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="DE89 3704 0044 0532 0130 00", value="")
    @JsonProperty(value="iban")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIban() {
        return this.iban;
    }

    public void setIban(String iban) {
        this.iban = iban;
    }

    public PaymentEventResponseV3 accountName(String accountName) {
        this.accountName = accountName;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="My account", value="")
    @JsonProperty(value="accountName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAccountName() {
        return this.accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public PaymentEventResponseV3 principal(String principal) {
        this.principal = principal;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Prinicple example", value="")
    @JsonProperty(value="principal")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(String principal) {
        this.principal = principal;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentEventResponseV3 paymentEventResponseV3 = (PaymentEventResponseV3)o;
        return Objects.equals(this.eventId, paymentEventResponseV3.eventId) && Objects.equals(this.eventDateTime, paymentEventResponseV3.eventDateTime) && Objects.equals((Object)this.eventType, (Object)paymentEventResponseV3.eventType) && Objects.equals((Object)this.sourceCurrency, (Object)paymentEventResponseV3.sourceCurrency) && Objects.equals(this.sourceAmount, paymentEventResponseV3.sourceAmount) && Objects.equals((Object)this.paymentCurrency, (Object)paymentEventResponseV3.paymentCurrency) && Objects.equals(this.paymentAmount, paymentEventResponseV3.paymentAmount) && Objects.equals(this.accountNumber, paymentEventResponseV3.accountNumber) && Objects.equals(this.routingNumber, paymentEventResponseV3.routingNumber) && Objects.equals(this.iban, paymentEventResponseV3.iban) && Objects.equals(this.accountName, paymentEventResponseV3.accountName) && Objects.equals(this.principal, paymentEventResponseV3.principal);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.eventId, this.eventDateTime, this.eventType, this.sourceCurrency, this.sourceAmount, this.paymentCurrency, this.paymentAmount, this.accountNumber, this.routingNumber, this.iban, this.accountName, this.principal});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentEventResponseV3 {\n");
        sb.append("    eventId: ").append(this.toIndentedString(this.eventId)).append("\n");
        sb.append("    eventDateTime: ").append(this.toIndentedString(this.eventDateTime)).append("\n");
        sb.append("    eventType: ").append(this.toIndentedString((Object)this.eventType)).append("\n");
        sb.append("    sourceCurrency: ").append(this.toIndentedString((Object)this.sourceCurrency)).append("\n");
        sb.append("    sourceAmount: ").append(this.toIndentedString(this.sourceAmount)).append("\n");
        sb.append("    paymentCurrency: ").append(this.toIndentedString((Object)this.paymentCurrency)).append("\n");
        sb.append("    paymentAmount: ").append(this.toIndentedString(this.paymentAmount)).append("\n");
        sb.append("    accountNumber: ").append(this.toIndentedString(this.accountNumber)).append("\n");
        sb.append("    routingNumber: ").append(this.toIndentedString(this.routingNumber)).append("\n");
        sb.append("    iban: ").append(this.toIndentedString(this.iban)).append("\n");
        sb.append("    accountName: ").append(this.toIndentedString(this.accountName)).append("\n");
        sb.append("    principal: ").append(this.toIndentedString(this.principal)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum EventTypeEnum {
        PAYOUT_SUBMITTED("PAYOUT_SUBMITTED"),
        PAYOUT_COMPLETED("PAYOUT_COMPLETED"),
        PAYOUT_INSTRUCTED_V3("PAYOUT_INSTRUCTED_V3"),
        BANK_PAYMENT_REQUESTED("BANK_PAYMENT_REQUESTED"),
        SOURCE_AMOUNT_CONFIRMED("SOURCE_AMOUNT_CONFIRMED"),
        PAYMENT_SUBMITTED("PAYMENT_SUBMITTED"),
        PAYMENT_SUBMITTED_ACCEPTED("PAYMENT_SUBMITTED_ACCEPTED"),
        PAYMENT_SUBMITTED_REJECTED("PAYMENT_SUBMITTED_REJECTED"),
        PAYMENT_CONFIRMED("PAYMENT_CONFIRMED"),
        PAYMENT_AWAITING_FUNDS("PAYMENT_AWAITING_FUNDS"),
        PAYMENT_FUNDED("PAYMENT_FUNDED"),
        PAYMENT_UNFUNDED("PAYMENT_UNFUNDED"),
        PAYMENT_FAILED("PAYMENT_FAILED"),
        ACH_SUBMITTED_TO_ODFI("ACH_SUBMITTED_TO_ODFI"),
        PAYMENT_ACCEPTED_BY_RAILS("PAYMENT_ACCEPTED_BY_RAILS"),
        ACH_RETURN_RECEIVED("ACH_RETURN_RECEIVED"),
        RETURN_PAYMENT_FUNDING_REQUESTED("RETURN_PAYMENT_FUNDING_REQUESTED"),
        PAYOUT_BATCH_EXECUTED("PAYOUT_BATCH_EXECUTED"),
        PAYOUT_BATCH_QUOTE_EXPIRED("PAYOUT_BATCH_QUOTE_EXPIRED"),
        PAYOUT_BATCH_FUNDED("PAYOUT_BATCH_FUNDED"),
        PAYOUT_BATCH_FUNDS_RETURN_REQUEST("PAYOUT_BATCH_FUNDS_RETURN_REQUEST"),
        PAYOUT_BATCH_FUNDS_RETURNED("PAYOUT_BATCH_FUNDS_RETURNED"),
        PAYOUT_FUNDS_REQUEST("PAYOUT_FUNDS_REQUEST"),
        PAYOUT_FUNDS_GRANTED("PAYOUT_FUNDS_GRANTED"),
        PAYOUT_FUNDS_DENIED("PAYOUT_FUNDS_DENIED"),
        PAYOUT_BATCH_QUOTED("PAYOUT_BATCH_QUOTED"),
        PAYOUT_QUOTED("PAYOUT_QUOTED"),
        ACH_PAYMENT_RETURN_CANCELLED("ACH_PAYMENT_RETURN_CANCELLED"),
        RETURN_PAYMENT_CANCELLATION_REQUESTED("RETURN_PAYMENT_CANCELLATION_REQUESTED"),
        PAYOUT_WITHDRAWN("PAYOUT_WITHDRAWN");

        private String value;

        private EventTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static EventTypeEnum fromValue(String value) {
            for (EventTypeEnum b : EventTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

