/*
 * Decompiled with CFR 0.152.
 */
package com.velopayments.oa3.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"name", "description"})
public class PayorCreateApplicationRequest {
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private JsonNullable<String> description = JsonNullable.undefined();

    public PayorCreateApplicationRequest name(String name) {
        this.name = name;
        return this;
    }

    @NotNull
    @Size(min=2, max=100)
    @ApiModelProperty(example="SAP", required=true, value="The name of the application.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=2, max=100) String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public PayorCreateApplicationRequest description(String description) {
        this.description = JsonNullable.of((Object)description);
        return this;
    }

    @Nullable
    @Size(min=2, max=1024)
    @ApiModelProperty(example="SAP Application integration", value="Description of the application.")
    @JsonIgnore
    public @Size(min=2, max=1024) String getDescription() {
        return (String)this.description.orElse(null);
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getDescription_JsonNullable() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription_JsonNullable(JsonNullable<String> description) {
        this.description = description;
    }

    public void setDescription(String description) {
        this.description = JsonNullable.of((Object)description);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PayorCreateApplicationRequest payorCreateApplicationRequest = (PayorCreateApplicationRequest)o;
        return Objects.equals(this.name, payorCreateApplicationRequest.name) && Objects.equals(this.description, payorCreateApplicationRequest.description);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.description);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PayorCreateApplicationRequest {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

