/*
 * Decompiled with CFR 0.152.
 */
package com.velopayments.oa3.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.velopayments.oa3.model.AcceptedPayment;
import com.velopayments.oa3.model.QuoteFxSummary;
import com.velopayments.oa3.model.RejectedPayment;
import com.velopayments.oa3.model.SourceAccount;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

@JsonPropertyOrder(value={"payoutId", "status", "paymentsSubmitted", "paymentsAccepted", "paymentsRejected", "fxSummaries", "accounts", "acceptedPayments", "rejectedPayments"})
public class PayoutSummaryResponse {
    public static final String JSON_PROPERTY_PAYOUT_ID = "payoutId";
    private UUID payoutId;
    public static final String JSON_PROPERTY_STATUS = "status";
    private String status;
    public static final String JSON_PROPERTY_PAYMENTS_SUBMITTED = "paymentsSubmitted";
    private Integer paymentsSubmitted;
    public static final String JSON_PROPERTY_PAYMENTS_ACCEPTED = "paymentsAccepted";
    private Integer paymentsAccepted;
    public static final String JSON_PROPERTY_PAYMENTS_REJECTED = "paymentsRejected";
    private Integer paymentsRejected;
    public static final String JSON_PROPERTY_FX_SUMMARIES = "fxSummaries";
    private List<QuoteFxSummary> fxSummaries = new ArrayList<QuoteFxSummary>();
    public static final String JSON_PROPERTY_ACCOUNTS = "accounts";
    private List<SourceAccount> accounts = new ArrayList<SourceAccount>();
    public static final String JSON_PROPERTY_ACCEPTED_PAYMENTS = "acceptedPayments";
    private List<AcceptedPayment> acceptedPayments = new ArrayList<AcceptedPayment>();
    public static final String JSON_PROPERTY_REJECTED_PAYMENTS = "rejectedPayments";
    private List<RejectedPayment> rejectedPayments = new ArrayList<RejectedPayment>();

    public PayoutSummaryResponse payoutId(UUID payoutId) {
        this.payoutId = payoutId;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="payoutId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getPayoutId() {
        return this.payoutId;
    }

    public void setPayoutId(UUID payoutId) {
        this.payoutId = payoutId;
    }

    public PayoutSummaryResponse status(String status) {
        this.status = status;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="COMPLETED", value="")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public PayoutSummaryResponse paymentsSubmitted(Integer paymentsSubmitted) {
        this.paymentsSubmitted = paymentsSubmitted;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="10", value="")
    @JsonProperty(value="paymentsSubmitted")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getPaymentsSubmitted() {
        return this.paymentsSubmitted;
    }

    public void setPaymentsSubmitted(Integer paymentsSubmitted) {
        this.paymentsSubmitted = paymentsSubmitted;
    }

    public PayoutSummaryResponse paymentsAccepted(Integer paymentsAccepted) {
        this.paymentsAccepted = paymentsAccepted;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="10", value="")
    @JsonProperty(value="paymentsAccepted")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getPaymentsAccepted() {
        return this.paymentsAccepted;
    }

    public void setPaymentsAccepted(Integer paymentsAccepted) {
        this.paymentsAccepted = paymentsAccepted;
    }

    public PayoutSummaryResponse paymentsRejected(Integer paymentsRejected) {
        this.paymentsRejected = paymentsRejected;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="0", value="")
    @JsonProperty(value="paymentsRejected")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getPaymentsRejected() {
        return this.paymentsRejected;
    }

    public void setPaymentsRejected(Integer paymentsRejected) {
        this.paymentsRejected = paymentsRejected;
    }

    public PayoutSummaryResponse fxSummaries(List<QuoteFxSummary> fxSummaries) {
        this.fxSummaries = fxSummaries;
        return this;
    }

    public PayoutSummaryResponse addFxSummariesItem(QuoteFxSummary fxSummariesItem) {
        this.fxSummaries.add(fxSummariesItem);
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="fxSummaries")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<QuoteFxSummary> getFxSummaries() {
        return this.fxSummaries;
    }

    public void setFxSummaries(List<QuoteFxSummary> fxSummaries) {
        this.fxSummaries = fxSummaries;
    }

    public PayoutSummaryResponse accounts(List<SourceAccount> accounts) {
        this.accounts = accounts;
        return this;
    }

    public PayoutSummaryResponse addAccountsItem(SourceAccount accountsItem) {
        this.accounts.add(accountsItem);
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="accounts")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<SourceAccount> getAccounts() {
        return this.accounts;
    }

    public void setAccounts(List<SourceAccount> accounts) {
        this.accounts = accounts;
    }

    public PayoutSummaryResponse acceptedPayments(List<AcceptedPayment> acceptedPayments) {
        this.acceptedPayments = acceptedPayments;
        return this;
    }

    public PayoutSummaryResponse addAcceptedPaymentsItem(AcceptedPayment acceptedPaymentsItem) {
        this.acceptedPayments.add(acceptedPaymentsItem);
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="acceptedPayments")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<AcceptedPayment> getAcceptedPayments() {
        return this.acceptedPayments;
    }

    public void setAcceptedPayments(List<AcceptedPayment> acceptedPayments) {
        this.acceptedPayments = acceptedPayments;
    }

    public PayoutSummaryResponse rejectedPayments(List<RejectedPayment> rejectedPayments) {
        this.rejectedPayments = rejectedPayments;
        return this;
    }

    public PayoutSummaryResponse addRejectedPaymentsItem(RejectedPayment rejectedPaymentsItem) {
        this.rejectedPayments.add(rejectedPaymentsItem);
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="rejectedPayments")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<RejectedPayment> getRejectedPayments() {
        return this.rejectedPayments;
    }

    public void setRejectedPayments(List<RejectedPayment> rejectedPayments) {
        this.rejectedPayments = rejectedPayments;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PayoutSummaryResponse payoutSummaryResponse = (PayoutSummaryResponse)o;
        return Objects.equals(this.payoutId, payoutSummaryResponse.payoutId) && Objects.equals(this.status, payoutSummaryResponse.status) && Objects.equals(this.paymentsSubmitted, payoutSummaryResponse.paymentsSubmitted) && Objects.equals(this.paymentsAccepted, payoutSummaryResponse.paymentsAccepted) && Objects.equals(this.paymentsRejected, payoutSummaryResponse.paymentsRejected) && Objects.equals(this.fxSummaries, payoutSummaryResponse.fxSummaries) && Objects.equals(this.accounts, payoutSummaryResponse.accounts) && Objects.equals(this.acceptedPayments, payoutSummaryResponse.acceptedPayments) && Objects.equals(this.rejectedPayments, payoutSummaryResponse.rejectedPayments);
    }

    public int hashCode() {
        return Objects.hash(this.payoutId, this.status, this.paymentsSubmitted, this.paymentsAccepted, this.paymentsRejected, this.fxSummaries, this.accounts, this.acceptedPayments, this.rejectedPayments);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PayoutSummaryResponse {\n");
        sb.append("    payoutId: ").append(this.toIndentedString(this.payoutId)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    paymentsSubmitted: ").append(this.toIndentedString(this.paymentsSubmitted)).append("\n");
        sb.append("    paymentsAccepted: ").append(this.toIndentedString(this.paymentsAccepted)).append("\n");
        sb.append("    paymentsRejected: ").append(this.toIndentedString(this.paymentsRejected)).append("\n");
        sb.append("    fxSummaries: ").append(this.toIndentedString(this.fxSummaries)).append("\n");
        sb.append("    accounts: ").append(this.toIndentedString(this.accounts)).append("\n");
        sb.append("    acceptedPayments: ").append(this.toIndentedString(this.acceptedPayments)).append("\n");
        sb.append("    rejectedPayments: ").append(this.toIndentedString(this.rejectedPayments)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

