/*
 * Decompiled with CFR 0.152.
 */
package com.velopayments.oa3.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"tokenType", "verificationCode"})
public class ResendTokenRequest {
    public static final String JSON_PROPERTY_TOKEN_TYPE = "tokenType";
    private TokenTypeEnum tokenType;
    public static final String JSON_PROPERTY_VERIFICATION_CODE = "verificationCode";
    private JsonNullable<String> verificationCode = JsonNullable.undefined();

    public ResendTokenRequest tokenType(TokenTypeEnum tokenType) {
        this.tokenType = tokenType;
        return this;
    }

    @NotNull
    @ApiModelProperty(example="INVITE_MFA_USER", required=true, value="The type of the token to resend")
    @JsonProperty(value="tokenType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TokenTypeEnum getTokenType() {
        return this.tokenType;
    }

    public void setTokenType(TokenTypeEnum tokenType) {
        this.tokenType = tokenType;
    }

    public ResendTokenRequest verificationCode(String verificationCode) {
        this.verificationCode = JsonNullable.of((Object)verificationCode);
        return this;
    }

    @Nullable
    @Size(min=6, max=6)
    @ApiModelProperty(example="123456", value="<p>Optional property that MUST be suppied when manually verifying a user</p> <p>The user's smsNumber is registered via a separate endpoint and an OTP sent to them</p> ")
    @JsonIgnore
    public @Size(min=6, max=6) String getVerificationCode() {
        return (String)this.verificationCode.orElse(null);
    }

    @JsonProperty(value="verificationCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getVerificationCode_JsonNullable() {
        return this.verificationCode;
    }

    @JsonProperty(value="verificationCode")
    public void setVerificationCode_JsonNullable(JsonNullable<String> verificationCode) {
        this.verificationCode = verificationCode;
    }

    public void setVerificationCode(String verificationCode) {
        this.verificationCode = JsonNullable.of((Object)verificationCode);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResendTokenRequest resendTokenRequest = (ResendTokenRequest)o;
        return Objects.equals((Object)this.tokenType, (Object)resendTokenRequest.tokenType) && Objects.equals(this.verificationCode, resendTokenRequest.verificationCode);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.tokenType, this.verificationCode});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ResendTokenRequest {\n");
        sb.append("    tokenType: ").append(this.toIndentedString((Object)this.tokenType)).append("\n");
        sb.append("    verificationCode: ").append(this.toIndentedString(this.verificationCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TokenTypeEnum {
        INVITE_MFA_USER("INVITE_MFA_USER"),
        MFA_REGISTRATION("MFA_REGISTRATION");

        private String value;

        private TokenTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TokenTypeEnum fromValue(String value) {
            for (TokenTypeEnum b : TokenTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

