/*
 * Decompiled with CFR 0.152.
 */
package com.velopayments.oa3.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"roles", "verificationCode"})
public class RoleUpdateRequest {
    public static final String JSON_PROPERTY_ROLES = "roles";
    private List<String> roles = new ArrayList<String>();
    public static final String JSON_PROPERTY_VERIFICATION_CODE = "verificationCode";
    private JsonNullable<String> verificationCode = JsonNullable.undefined();

    public RoleUpdateRequest roles(List<String> roles) {
        this.roles = roles;
        return this;
    }

    public RoleUpdateRequest addRolesItem(String rolesItem) {
        this.roles.add(rolesItem);
        return this;
    }

    @NotNull
    @ApiModelProperty(example="[\"payor.admin\"]", required=true, value="<p>The role(s) for the user</p> <p>The role must exist</p> <p>The role can be a custom role or a system role but the invoker must have the permissions to assign the role</p> <p>System roles are: backoffice.admin, payor.master_admin, payor.admin, payor.support</p> ")
    @JsonProperty(value="roles")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<String> getRoles() {
        return this.roles;
    }

    public void setRoles(List<String> roles) {
        this.roles = roles;
    }

    public RoleUpdateRequest verificationCode(String verificationCode) {
        this.verificationCode = JsonNullable.of((Object)verificationCode);
        return this;
    }

    @Nullable
    @Size(min=6, max=6)
    @ApiModelProperty(example="123456", value="<p>Optional property that MUST be suppied when manually verifying a user</p> <p>The user's smsNumber is registered via a separate endpoint and an OTP sent to them</p> ")
    @JsonIgnore
    public @Size(min=6, max=6) String getVerificationCode() {
        return (String)this.verificationCode.orElse(null);
    }

    @JsonProperty(value="verificationCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getVerificationCode_JsonNullable() {
        return this.verificationCode;
    }

    @JsonProperty(value="verificationCode")
    public void setVerificationCode_JsonNullable(JsonNullable<String> verificationCode) {
        this.verificationCode = verificationCode;
    }

    public void setVerificationCode(String verificationCode) {
        this.verificationCode = JsonNullable.of((Object)verificationCode);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RoleUpdateRequest roleUpdateRequest = (RoleUpdateRequest)o;
        return Objects.equals(this.roles, roleUpdateRequest.roles) && Objects.equals(this.verificationCode, roleUpdateRequest.verificationCode);
    }

    public int hashCode() {
        return Objects.hash(this.roles, this.verificationCode);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RoleUpdateRequest {\n");
        sb.append("    roles: ").append(this.toIndentedString(this.roles)).append("\n");
        sb.append("    verificationCode: ").append(this.toIndentedString(this.verificationCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

