/*
 * Decompiled with CFR 0.152.
 */
package com.velopayments.oa3.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.Size;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"id", "balance", "currency", "fundingRef", "physicalAccountName", "railsId", "payorId", "name", "pooled", "balanceVisible", "customerId", "physicalAccountId", "fundingAccountId"})
public class SourceAccountResponse {
    public static final String JSON_PROPERTY_ID = "id";
    private UUID id;
    public static final String JSON_PROPERTY_BALANCE = "balance";
    private Long balance;
    public static final String JSON_PROPERTY_CURRENCY = "currency";
    private CurrencyEnum currency;
    public static final String JSON_PROPERTY_FUNDING_REF = "fundingRef";
    private String fundingRef;
    public static final String JSON_PROPERTY_PHYSICAL_ACCOUNT_NAME = "physicalAccountName";
    private String physicalAccountName;
    public static final String JSON_PROPERTY_RAILS_ID = "railsId";
    private String railsId;
    public static final String JSON_PROPERTY_PAYOR_ID = "payorId";
    private UUID payorId;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_POOLED = "pooled";
    private Boolean pooled;
    public static final String JSON_PROPERTY_BALANCE_VISIBLE = "balanceVisible";
    private Boolean balanceVisible;
    public static final String JSON_PROPERTY_CUSTOMER_ID = "customerId";
    private JsonNullable<String> customerId = JsonNullable.undefined();
    public static final String JSON_PROPERTY_PHYSICAL_ACCOUNT_ID = "physicalAccountId";
    private UUID physicalAccountId;
    public static final String JSON_PROPERTY_FUNDING_ACCOUNT_ID = "fundingAccountId";
    private JsonNullable<UUID> fundingAccountId = JsonNullable.undefined();

    public SourceAccountResponse id(UUID id) {
        this.id = id;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Source Account Id")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public SourceAccountResponse balance(Long balance) {
        this.balance = balance;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1203489", value="Decimal implied")
    @JsonProperty(value="balance")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getBalance() {
        return this.balance;
    }

    public void setBalance(Long balance) {
        this.balance = balance;
    }

    public SourceAccountResponse currency(CurrencyEnum currency) {
        this.currency = currency;
        return this;
    }

    @Nullable
    @Size(min=3, max=3)
    @ApiModelProperty(example="USD", value="")
    @JsonProperty(value="currency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Size(min=3, max=3) CurrencyEnum getCurrency() {
        return this.currency;
    }

    public void setCurrency(CurrencyEnum currency) {
        this.currency = currency;
    }

    public SourceAccountResponse fundingRef(String fundingRef) {
        this.fundingRef = fundingRef;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="a1b2c3d4", value="")
    @JsonProperty(value="fundingRef")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFundingRef() {
        return this.fundingRef;
    }

    public void setFundingRef(String fundingRef) {
        this.fundingRef = fundingRef;
    }

    public SourceAccountResponse physicalAccountName(String physicalAccountName) {
        this.physicalAccountName = physicalAccountName;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="VELO_FBO_MYBANKA_USD", value="")
    @JsonProperty(value="physicalAccountName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPhysicalAccountName() {
        return this.physicalAccountName;
    }

    public void setPhysicalAccountName(String physicalAccountName) {
        this.physicalAccountName = physicalAccountName;
    }

    public SourceAccountResponse railsId(String railsId) {
        this.railsId = railsId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="BOA_RAIL", value="")
    @JsonProperty(value="railsId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRailsId() {
        return this.railsId;
    }

    public void setRailsId(String railsId) {
        this.railsId = railsId;
    }

    public SourceAccountResponse payorId(UUID payorId) {
        this.payorId = payorId;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="payorId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getPayorId() {
        return this.payorId;
    }

    public void setPayorId(UUID payorId) {
        this.payorId = payorId;
    }

    public SourceAccountResponse name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="MyAccountName", value="")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SourceAccountResponse pooled(Boolean pooled) {
        this.pooled = pooled;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="pooled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getPooled() {
        return this.pooled;
    }

    public void setPooled(Boolean pooled) {
        this.pooled = pooled;
    }

    public SourceAccountResponse balanceVisible(Boolean balanceVisible) {
        this.balanceVisible = balanceVisible;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="balanceVisible")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getBalanceVisible() {
        return this.balanceVisible;
    }

    public void setBalanceVisible(Boolean balanceVisible) {
        this.balanceVisible = balanceVisible;
    }

    public SourceAccountResponse customerId(String customerId) {
        this.customerId = JsonNullable.of((Object)customerId);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Joe Customer", value="")
    @JsonIgnore
    public String getCustomerId() {
        return (String)this.customerId.orElse(null);
    }

    @JsonProperty(value="customerId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getCustomerId_JsonNullable() {
        return this.customerId;
    }

    @JsonProperty(value="customerId")
    public void setCustomerId_JsonNullable(JsonNullable<String> customerId) {
        this.customerId = customerId;
    }

    public void setCustomerId(String customerId) {
        this.customerId = JsonNullable.of((Object)customerId);
    }

    public SourceAccountResponse physicalAccountId(UUID physicalAccountId) {
        this.physicalAccountId = physicalAccountId;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="physicalAccountId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getPhysicalAccountId() {
        return this.physicalAccountId;
    }

    public void setPhysicalAccountId(UUID physicalAccountId) {
        this.physicalAccountId = physicalAccountId;
    }

    public SourceAccountResponse fundingAccountId(UUID fundingAccountId) {
        this.fundingAccountId = JsonNullable.of((Object)fundingAccountId);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonIgnore
    public UUID getFundingAccountId() {
        return (UUID)this.fundingAccountId.orElse(null);
    }

    @JsonProperty(value="fundingAccountId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<UUID> getFundingAccountId_JsonNullable() {
        return this.fundingAccountId;
    }

    @JsonProperty(value="fundingAccountId")
    public void setFundingAccountId_JsonNullable(JsonNullable<UUID> fundingAccountId) {
        this.fundingAccountId = fundingAccountId;
    }

    public void setFundingAccountId(UUID fundingAccountId) {
        this.fundingAccountId = JsonNullable.of((Object)fundingAccountId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SourceAccountResponse sourceAccountResponse = (SourceAccountResponse)o;
        return Objects.equals(this.id, sourceAccountResponse.id) && Objects.equals(this.balance, sourceAccountResponse.balance) && Objects.equals((Object)this.currency, (Object)sourceAccountResponse.currency) && Objects.equals(this.fundingRef, sourceAccountResponse.fundingRef) && Objects.equals(this.physicalAccountName, sourceAccountResponse.physicalAccountName) && Objects.equals(this.railsId, sourceAccountResponse.railsId) && Objects.equals(this.payorId, sourceAccountResponse.payorId) && Objects.equals(this.name, sourceAccountResponse.name) && Objects.equals(this.pooled, sourceAccountResponse.pooled) && Objects.equals(this.balanceVisible, sourceAccountResponse.balanceVisible) && Objects.equals(this.customerId, sourceAccountResponse.customerId) && Objects.equals(this.physicalAccountId, sourceAccountResponse.physicalAccountId) && Objects.equals(this.fundingAccountId, sourceAccountResponse.fundingAccountId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.balance, this.currency, this.fundingRef, this.physicalAccountName, this.railsId, this.payorId, this.name, this.pooled, this.balanceVisible, this.customerId, this.physicalAccountId, this.fundingAccountId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SourceAccountResponse {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    balance: ").append(this.toIndentedString(this.balance)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString((Object)this.currency)).append("\n");
        sb.append("    fundingRef: ").append(this.toIndentedString(this.fundingRef)).append("\n");
        sb.append("    physicalAccountName: ").append(this.toIndentedString(this.physicalAccountName)).append("\n");
        sb.append("    railsId: ").append(this.toIndentedString(this.railsId)).append("\n");
        sb.append("    payorId: ").append(this.toIndentedString(this.payorId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    pooled: ").append(this.toIndentedString(this.pooled)).append("\n");
        sb.append("    balanceVisible: ").append(this.toIndentedString(this.balanceVisible)).append("\n");
        sb.append("    customerId: ").append(this.toIndentedString(this.customerId)).append("\n");
        sb.append("    physicalAccountId: ").append(this.toIndentedString(this.physicalAccountId)).append("\n");
        sb.append("    fundingAccountId: ").append(this.toIndentedString(this.fundingAccountId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum CurrencyEnum {
        USD("USD");

        private String value;

        private CurrencyEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CurrencyEnum fromValue(String value) {
            for (CurrencyEnum b : CurrencyEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

