/*
 * Decompiled with CFR 0.152.
 */
package com.velopayments.oa3.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.velopayments.oa3.model.AutoTopUpConfig;
import com.velopayments.oa3.model.Notifications;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"id", "balance", "currency", "fundingRef", "physicalAccountName", "railsId", "payorId", "name", "pooled", "balanceVisible", "customerId", "physicalAccountId", "notifications", "fundingAccountId", "autoTopUpConfig"})
public class SourceAccountResponseV2 {
    public static final String JSON_PROPERTY_ID = "id";
    private UUID id;
    public static final String JSON_PROPERTY_BALANCE = "balance";
    private Long balance;
    public static final String JSON_PROPERTY_CURRENCY = "currency";
    private CurrencyEnum currency;
    public static final String JSON_PROPERTY_FUNDING_REF = "fundingRef";
    private String fundingRef;
    public static final String JSON_PROPERTY_PHYSICAL_ACCOUNT_NAME = "physicalAccountName";
    private String physicalAccountName;
    public static final String JSON_PROPERTY_RAILS_ID = "railsId";
    private String railsId;
    public static final String JSON_PROPERTY_PAYOR_ID = "payorId";
    private UUID payorId;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_POOLED = "pooled";
    private Boolean pooled;
    public static final String JSON_PROPERTY_BALANCE_VISIBLE = "balanceVisible";
    private Boolean balanceVisible;
    public static final String JSON_PROPERTY_CUSTOMER_ID = "customerId";
    private JsonNullable<String> customerId = JsonNullable.undefined();
    public static final String JSON_PROPERTY_PHYSICAL_ACCOUNT_ID = "physicalAccountId";
    private UUID physicalAccountId;
    public static final String JSON_PROPERTY_NOTIFICATIONS = "notifications";
    private Notifications notifications;
    public static final String JSON_PROPERTY_FUNDING_ACCOUNT_ID = "fundingAccountId";
    private JsonNullable<UUID> fundingAccountId = JsonNullable.undefined();
    public static final String JSON_PROPERTY_AUTO_TOP_UP_CONFIG = "autoTopUpConfig";
    private AutoTopUpConfig autoTopUpConfig;

    public SourceAccountResponseV2 id(UUID id) {
        this.id = id;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Source Account Id")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public SourceAccountResponseV2 balance(Long balance) {
        this.balance = balance;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1203489", value="Decimal implied")
    @JsonProperty(value="balance")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getBalance() {
        return this.balance;
    }

    public void setBalance(Long balance) {
        this.balance = balance;
    }

    public SourceAccountResponseV2 currency(CurrencyEnum currency) {
        this.currency = currency;
        return this;
    }

    @Nullable
    @Size(min=3, max=3)
    @ApiModelProperty(example="USD", value="")
    @JsonProperty(value="currency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Size(min=3, max=3) CurrencyEnum getCurrency() {
        return this.currency;
    }

    public void setCurrency(CurrencyEnum currency) {
        this.currency = currency;
    }

    public SourceAccountResponseV2 fundingRef(String fundingRef) {
        this.fundingRef = fundingRef;
        return this;
    }

    @NotNull
    @ApiModelProperty(example="a1b2c3d4", required=true, value="")
    @JsonProperty(value="fundingRef")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getFundingRef() {
        return this.fundingRef;
    }

    public void setFundingRef(String fundingRef) {
        this.fundingRef = fundingRef;
    }

    public SourceAccountResponseV2 physicalAccountName(String physicalAccountName) {
        this.physicalAccountName = physicalAccountName;
        return this;
    }

    @NotNull
    @ApiModelProperty(example="VELO_FBO_MYBANKA_USD", required=true, value="")
    @JsonProperty(value="physicalAccountName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getPhysicalAccountName() {
        return this.physicalAccountName;
    }

    public void setPhysicalAccountName(String physicalAccountName) {
        this.physicalAccountName = physicalAccountName;
    }

    public SourceAccountResponseV2 railsId(String railsId) {
        this.railsId = railsId;
        return this;
    }

    @NotNull
    @ApiModelProperty(example="BOA_RAIL", required=true, value="")
    @JsonProperty(value="railsId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getRailsId() {
        return this.railsId;
    }

    public void setRailsId(String railsId) {
        this.railsId = railsId;
    }

    public SourceAccountResponseV2 payorId(UUID payorId) {
        this.payorId = payorId;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="payorId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getPayorId() {
        return this.payorId;
    }

    public void setPayorId(UUID payorId) {
        this.payorId = payorId;
    }

    public SourceAccountResponseV2 name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="MyAccountName", value="")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SourceAccountResponseV2 pooled(Boolean pooled) {
        this.pooled = pooled;
        return this;
    }

    @NotNull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="pooled")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getPooled() {
        return this.pooled;
    }

    public void setPooled(Boolean pooled) {
        this.pooled = pooled;
    }

    public SourceAccountResponseV2 balanceVisible(Boolean balanceVisible) {
        this.balanceVisible = balanceVisible;
        return this;
    }

    @NotNull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="balanceVisible")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getBalanceVisible() {
        return this.balanceVisible;
    }

    public void setBalanceVisible(Boolean balanceVisible) {
        this.balanceVisible = balanceVisible;
    }

    public SourceAccountResponseV2 customerId(String customerId) {
        this.customerId = JsonNullable.of((Object)customerId);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Joe Customer", value="")
    @JsonIgnore
    public String getCustomerId() {
        return (String)this.customerId.orElse(null);
    }

    @JsonProperty(value="customerId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getCustomerId_JsonNullable() {
        return this.customerId;
    }

    @JsonProperty(value="customerId")
    public void setCustomerId_JsonNullable(JsonNullable<String> customerId) {
        this.customerId = customerId;
    }

    public void setCustomerId(String customerId) {
        this.customerId = JsonNullable.of((Object)customerId);
    }

    public SourceAccountResponseV2 physicalAccountId(UUID physicalAccountId) {
        this.physicalAccountId = physicalAccountId;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="physicalAccountId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getPhysicalAccountId() {
        return this.physicalAccountId;
    }

    public void setPhysicalAccountId(UUID physicalAccountId) {
        this.physicalAccountId = physicalAccountId;
    }

    public SourceAccountResponseV2 notifications(Notifications notifications) {
        this.notifications = notifications;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="notifications")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Notifications getNotifications() {
        return this.notifications;
    }

    public void setNotifications(Notifications notifications) {
        this.notifications = notifications;
    }

    public SourceAccountResponseV2 fundingAccountId(UUID fundingAccountId) {
        this.fundingAccountId = JsonNullable.of((Object)fundingAccountId);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonIgnore
    public UUID getFundingAccountId() {
        return (UUID)this.fundingAccountId.orElse(null);
    }

    @JsonProperty(value="fundingAccountId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<UUID> getFundingAccountId_JsonNullable() {
        return this.fundingAccountId;
    }

    @JsonProperty(value="fundingAccountId")
    public void setFundingAccountId_JsonNullable(JsonNullable<UUID> fundingAccountId) {
        this.fundingAccountId = fundingAccountId;
    }

    public void setFundingAccountId(UUID fundingAccountId) {
        this.fundingAccountId = JsonNullable.of((Object)fundingAccountId);
    }

    public SourceAccountResponseV2 autoTopUpConfig(AutoTopUpConfig autoTopUpConfig) {
        this.autoTopUpConfig = autoTopUpConfig;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="autoTopUpConfig")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public AutoTopUpConfig getAutoTopUpConfig() {
        return this.autoTopUpConfig;
    }

    public void setAutoTopUpConfig(AutoTopUpConfig autoTopUpConfig) {
        this.autoTopUpConfig = autoTopUpConfig;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SourceAccountResponseV2 sourceAccountResponseV2 = (SourceAccountResponseV2)o;
        return Objects.equals(this.id, sourceAccountResponseV2.id) && Objects.equals(this.balance, sourceAccountResponseV2.balance) && Objects.equals((Object)this.currency, (Object)sourceAccountResponseV2.currency) && Objects.equals(this.fundingRef, sourceAccountResponseV2.fundingRef) && Objects.equals(this.physicalAccountName, sourceAccountResponseV2.physicalAccountName) && Objects.equals(this.railsId, sourceAccountResponseV2.railsId) && Objects.equals(this.payorId, sourceAccountResponseV2.payorId) && Objects.equals(this.name, sourceAccountResponseV2.name) && Objects.equals(this.pooled, sourceAccountResponseV2.pooled) && Objects.equals(this.balanceVisible, sourceAccountResponseV2.balanceVisible) && Objects.equals(this.customerId, sourceAccountResponseV2.customerId) && Objects.equals(this.physicalAccountId, sourceAccountResponseV2.physicalAccountId) && Objects.equals(this.notifications, sourceAccountResponseV2.notifications) && Objects.equals(this.fundingAccountId, sourceAccountResponseV2.fundingAccountId) && Objects.equals(this.autoTopUpConfig, sourceAccountResponseV2.autoTopUpConfig);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.balance, this.currency, this.fundingRef, this.physicalAccountName, this.railsId, this.payorId, this.name, this.pooled, this.balanceVisible, this.customerId, this.physicalAccountId, this.notifications, this.fundingAccountId, this.autoTopUpConfig});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SourceAccountResponseV2 {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    balance: ").append(this.toIndentedString(this.balance)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString((Object)this.currency)).append("\n");
        sb.append("    fundingRef: ").append(this.toIndentedString(this.fundingRef)).append("\n");
        sb.append("    physicalAccountName: ").append(this.toIndentedString(this.physicalAccountName)).append("\n");
        sb.append("    railsId: ").append(this.toIndentedString(this.railsId)).append("\n");
        sb.append("    payorId: ").append(this.toIndentedString(this.payorId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    pooled: ").append(this.toIndentedString(this.pooled)).append("\n");
        sb.append("    balanceVisible: ").append(this.toIndentedString(this.balanceVisible)).append("\n");
        sb.append("    customerId: ").append(this.toIndentedString(this.customerId)).append("\n");
        sb.append("    physicalAccountId: ").append(this.toIndentedString(this.physicalAccountId)).append("\n");
        sb.append("    notifications: ").append(this.toIndentedString(this.notifications)).append("\n");
        sb.append("    fundingAccountId: ").append(this.toIndentedString(this.fundingAccountId)).append("\n");
        sb.append("    autoTopUpConfig: ").append(this.toIndentedString(this.autoTopUpConfig)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum CurrencyEnum {
        USD("USD");

        private String value;

        private CurrencyEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CurrencyEnum fromValue(String value) {
            for (CurrencyEnum b : CurrencyEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

