/*
 * Decompiled with CFR 0.152.
 */
package com.velopayments.oa3.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import java.util.UUID;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@JsonPropertyOrder(value={"toSourceAccountId", "amount", "currency"})
public class TransferRequest {
    public static final String JSON_PROPERTY_TO_SOURCE_ACCOUNT_ID = "toSourceAccountId";
    private UUID toSourceAccountId;
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private Long amount;
    public static final String JSON_PROPERTY_CURRENCY = "currency";
    private String currency;

    public TransferRequest toSourceAccountId(UUID toSourceAccountId) {
        this.toSourceAccountId = toSourceAccountId;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="The 'to' source account id, which will be credited")
    @JsonProperty(value="toSourceAccountId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getToSourceAccountId() {
        return this.toSourceAccountId;
    }

    public void setToSourceAccountId(UUID toSourceAccountId) {
        this.toSourceAccountId = toSourceAccountId;
    }

    public TransferRequest amount(Long amount) {
        this.amount = amount;
        return this;
    }

    @NotNull
    @Min(value=1L)
    @Max(value=9999999999L)
    @ApiModelProperty(required=true, value="Amount to transfer, in minor units")
    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=1L) @Max(value=9999999999L) Long getAmount() {
        return this.amount;
    }

    public void setAmount(Long amount) {
        this.amount = amount;
    }

    public TransferRequest currency(String currency) {
        this.currency = currency;
        return this;
    }

    @NotNull
    @Size(min=3, max=3)
    @ApiModelProperty(example="USD", required=true, value="")
    @JsonProperty(value="currency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=3, max=3) String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransferRequest transferRequest = (TransferRequest)o;
        return Objects.equals(this.toSourceAccountId, transferRequest.toSourceAccountId) && Objects.equals(this.amount, transferRequest.amount) && Objects.equals(this.currency, transferRequest.currency);
    }

    public int hashCode() {
        return Objects.hash(this.toSourceAccountId, this.amount, this.currency);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransferRequest {\n");
        sb.append("    toSourceAccountId: ").append(this.toIndentedString(this.toSourceAccountId)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

