/*
 * Decompiled with CFR 0.152.
 */
package com.velopayments.oa3.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;

@JsonPropertyOrder(value={"score", "valid", "warning", "suggestions"})
public class ValidatePasswordResponse {
    public static final String JSON_PROPERTY_SCORE = "score";
    private Integer score;
    public static final String JSON_PROPERTY_VALID = "valid";
    private Boolean valid;
    public static final String JSON_PROPERTY_WARNING = "warning";
    private String warning;
    public static final String JSON_PROPERTY_SUGGESTIONS = "suggestions";
    private List<String> suggestions = null;

    public ValidatePasswordResponse score(Integer score) {
        this.score = score;
        return this;
    }

    @Nullable
    @Min(value=0L)
    @Max(value=4L)
    @ApiModelProperty(example="2", value="More secure passwords are given a higher score. <P> For a password to be acceptable for use in Velo, it must score at least 3 ")
    @JsonProperty(value="score")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Min(value=0L) @Max(value=4L) Integer getScore() {
        return this.score;
    }

    public void setScore(Integer score) {
        this.score = score;
    }

    public ValidatePasswordResponse valid(Boolean valid) {
        this.valid = valid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="if true then the password can be accepted")
    @JsonProperty(value="valid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getValid() {
        return this.valid;
    }

    public void setValid(Boolean valid) {
        this.valid = valid;
    }

    public ValidatePasswordResponse warning(String warning) {
        this.warning = warning;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Historic Password", value="Any warning message as a reason for the given score.")
    @JsonProperty(value="warning")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getWarning() {
        return this.warning;
    }

    public void setWarning(String warning) {
        this.warning = warning;
    }

    public ValidatePasswordResponse suggestions(List<String> suggestions) {
        this.suggestions = suggestions;
        return this;
    }

    public ValidatePasswordResponse addSuggestionsItem(String suggestionsItem) {
        if (this.suggestions == null) {
            this.suggestions = new ArrayList<String>();
        }
        this.suggestions.add(suggestionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="suggestions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getSuggestions() {
        return this.suggestions;
    }

    public void setSuggestions(List<String> suggestions) {
        this.suggestions = suggestions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValidatePasswordResponse validatePasswordResponse = (ValidatePasswordResponse)o;
        return Objects.equals(this.score, validatePasswordResponse.score) && Objects.equals(this.valid, validatePasswordResponse.valid) && Objects.equals(this.warning, validatePasswordResponse.warning) && Objects.equals(this.suggestions, validatePasswordResponse.suggestions);
    }

    public int hashCode() {
        return Objects.hash(this.score, this.valid, this.warning, this.suggestions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ValidatePasswordResponse {\n");
        sb.append("    score: ").append(this.toIndentedString(this.score)).append("\n");
        sb.append("    valid: ").append(this.toIndentedString(this.valid)).append("\n");
        sb.append("    warning: ").append(this.toIndentedString(this.warning)).append("\n");
        sb.append("    suggestions: ").append(this.toIndentedString(this.suggestions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

