/*
 * Decompiled with CFR 0.152.
 */
package com.velopayments.oa3.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.velopayments.oa3.model.UserInfo2;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.validation.Valid;

@JsonPropertyOrder(value={"access_token", "token_type", "refresh_token", "expires_in", "scope", "user_info", "entityIds"})
public class AccessTokenResponse2 {
    public static final String JSON_PROPERTY_ACCESS_TOKEN = "access_token";
    private String accessToken;
    public static final String JSON_PROPERTY_TOKEN_TYPE = "token_type";
    private String tokenType = "bearer";
    public static final String JSON_PROPERTY_REFRESH_TOKEN = "refresh_token";
    private String refreshToken;
    public static final String JSON_PROPERTY_EXPIRES_IN = "expires_in";
    private Integer expiresIn;
    public static final String JSON_PROPERTY_SCOPE = "scope";
    private String scope;
    public static final String JSON_PROPERTY_USER_INFO = "user_info";
    private UserInfo2 userInfo;
    public static final String JSON_PROPERTY_ENTITY_IDS = "entityIds";
    private List<String> entityIds = null;

    public AccessTokenResponse2 accessToken(String accessToken) {
        this.accessToken = accessToken;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="9b58410b-e1b7-4f90-bebb-7e09c5427020", value="Bearer token used in headers to access secure endpoints ")
    @JsonProperty(value="access_token")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public AccessTokenResponse2 tokenType(String tokenType) {
        this.tokenType = tokenType;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="bearer", value="the type of the token")
    @JsonProperty(value="token_type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTokenType() {
        return this.tokenType;
    }

    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }

    public AccessTokenResponse2 refreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="c3d0f771-0997-4814-84e3-09690208545a", value="can be used to obtain a new access token")
    @JsonProperty(value="refresh_token")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public AccessTokenResponse2 expiresIn(Integer expiresIn) {
        this.expiresIn = expiresIn;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1800", value="The lifetime in seconds of the access token")
    @JsonProperty(value="expires_in")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getExpiresIn() {
        return this.expiresIn;
    }

    public void setExpiresIn(Integer expiresIn) {
        this.expiresIn = expiresIn;
    }

    public AccessTokenResponse2 scope(String scope) {
        this.scope = scope;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="https://api.velopayments.com/scopes/auth/users", value="the scope of the access token")
    @JsonProperty(value="scope")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public AccessTokenResponse2 userInfo(UserInfo2 userInfo) {
        this.userInfo = userInfo;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="user_info")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UserInfo2 getUserInfo() {
        return this.userInfo;
    }

    public void setUserInfo(UserInfo2 userInfo) {
        this.userInfo = userInfo;
    }

    public AccessTokenResponse2 entityIds(List<String> entityIds) {
        this.entityIds = entityIds;
        return this;
    }

    public AccessTokenResponse2 addEntityIdsItem(String entityIdsItem) {
        if (this.entityIds == null) {
            this.entityIds = new ArrayList<String>();
        }
        this.entityIds.add(entityIdsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"ed89eaa0-4450-4916-a4ff-62a328d60bd6\"]", value="the payeeId ")
    @JsonProperty(value="entityIds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getEntityIds() {
        return this.entityIds;
    }

    public void setEntityIds(List<String> entityIds) {
        this.entityIds = entityIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccessTokenResponse2 accessTokenResponse2 = (AccessTokenResponse2)o;
        return Objects.equals(this.accessToken, accessTokenResponse2.accessToken) && Objects.equals(this.tokenType, accessTokenResponse2.tokenType) && Objects.equals(this.refreshToken, accessTokenResponse2.refreshToken) && Objects.equals(this.expiresIn, accessTokenResponse2.expiresIn) && Objects.equals(this.scope, accessTokenResponse2.scope) && Objects.equals(this.userInfo, accessTokenResponse2.userInfo) && Objects.equals(this.entityIds, accessTokenResponse2.entityIds);
    }

    public int hashCode() {
        return Objects.hash(this.accessToken, this.tokenType, this.refreshToken, this.expiresIn, this.scope, this.userInfo, this.entityIds);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AccessTokenResponse2 {\n");
        sb.append("    accessToken: ").append(this.toIndentedString(this.accessToken)).append("\n");
        sb.append("    tokenType: ").append(this.toIndentedString(this.tokenType)).append("\n");
        sb.append("    refreshToken: ").append(this.toIndentedString(this.refreshToken)).append("\n");
        sb.append("    expiresIn: ").append(this.toIndentedString(this.expiresIn)).append("\n");
        sb.append("    scope: ").append(this.toIndentedString(this.scope)).append("\n");
        sb.append("    userInfo: ").append(this.toIndentedString(this.userInfo)).append("\n");
        sb.append("    entityIds: ").append(this.toIndentedString(this.entityIds)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

