/*
 * Decompiled with CFR 0.152.
 */
package com.velopayments.oa3.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

@JsonPropertyOrder(value={"access_token", "token_type", "expires_in", "refresh_token", "scope", "entityIds"})
public class AuthResponse {
    public static final String JSON_PROPERTY_ACCESS_TOKEN = "access_token";
    private UUID accessToken;
    public static final String JSON_PROPERTY_TOKEN_TYPE = "token_type";
    private String tokenType;
    public static final String JSON_PROPERTY_EXPIRES_IN = "expires_in";
    private BigDecimal expiresIn;
    public static final String JSON_PROPERTY_REFRESH_TOKEN = "refresh_token";
    private String refreshToken;
    public static final String JSON_PROPERTY_SCOPE = "scope";
    private String scope;
    public static final String JSON_PROPERTY_ENTITY_IDS = "entityIds";
    private List<String> entityIds = null;

    public AuthResponse accessToken(UUID accessToken) {
        this.accessToken = accessToken;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="access_token")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(UUID accessToken) {
        this.accessToken = accessToken;
    }

    public AuthResponse tokenType(String tokenType) {
        this.tokenType = tokenType;
        return this;
    }

    @NotNull
    @ApiModelProperty(example="bearer", required=true, value="")
    @JsonProperty(value="token_type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getTokenType() {
        return this.tokenType;
    }

    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }

    public AuthResponse expiresIn(BigDecimal expiresIn) {
        this.expiresIn = expiresIn;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(example="1799", value="")
    @JsonProperty(value="expires_in")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BigDecimal getExpiresIn() {
        return this.expiresIn;
    }

    public void setExpiresIn(BigDecimal expiresIn) {
        this.expiresIn = expiresIn;
    }

    public AuthResponse refreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="IwOGYzYTlmM2YxOTQ5MGE3YmNmMDFkNTVk", value="")
    @JsonProperty(value="refresh_token")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public AuthResponse scope(String scope) {
        this.scope = scope;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="example_scope", value="")
    @JsonProperty(value="scope")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public AuthResponse entityIds(List<String> entityIds) {
        this.entityIds = entityIds;
        return this;
    }

    public AuthResponse addEntityIdsItem(String entityIdsItem) {
        if (this.entityIds == null) {
            this.entityIds = new ArrayList<String>();
        }
        this.entityIds.add(entityIdsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="entityIds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getEntityIds() {
        return this.entityIds;
    }

    public void setEntityIds(List<String> entityIds) {
        this.entityIds = entityIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthResponse authResponse = (AuthResponse)o;
        return Objects.equals(this.accessToken, authResponse.accessToken) && Objects.equals(this.tokenType, authResponse.tokenType) && Objects.equals(this.expiresIn, authResponse.expiresIn) && Objects.equals(this.refreshToken, authResponse.refreshToken) && Objects.equals(this.scope, authResponse.scope) && Objects.equals(this.entityIds, authResponse.entityIds);
    }

    public int hashCode() {
        return Objects.hash(this.accessToken, this.tokenType, this.expiresIn, this.refreshToken, this.scope, this.entityIds);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AuthResponse {\n");
        sb.append("    accessToken: ").append(this.toIndentedString(this.accessToken)).append("\n");
        sb.append("    tokenType: ").append(this.toIndentedString(this.tokenType)).append("\n");
        sb.append("    expiresIn: ").append(this.toIndentedString(this.expiresIn)).append("\n");
        sb.append("    refreshToken: ").append(this.toIndentedString(this.refreshToken)).append("\n");
        sb.append("    scope: ").append(this.toIndentedString(this.scope)).append("\n");
        sb.append("    entityIds: ").append(this.toIndentedString(this.entityIds)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

