/*
 * Decompiled with CFR 0.152.
 */
package com.velopayments.oa3.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.velopayments.oa3.model.FundingEvent;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.validation.Valid;

@JsonPropertyOrder(value={"amount", "dateTime", "status", "currency", "sourceAccountName", "fundingAccountName", "fundingType", "events", "topupType"})
public class FundingAudit {
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private Double amount;
    public static final String JSON_PROPERTY_DATE_TIME = "dateTime";
    private OffsetDateTime dateTime;
    public static final String JSON_PROPERTY_STATUS = "status";
    private StatusEnum status;
    public static final String JSON_PROPERTY_CURRENCY = "currency";
    private String currency;
    public static final String JSON_PROPERTY_SOURCE_ACCOUNT_NAME = "sourceAccountName";
    private String sourceAccountName;
    public static final String JSON_PROPERTY_FUNDING_ACCOUNT_NAME = "fundingAccountName";
    private String fundingAccountName;
    public static final String JSON_PROPERTY_FUNDING_TYPE = "fundingType";
    private String fundingType;
    public static final String JSON_PROPERTY_EVENTS = "events";
    private List<FundingEvent> events = null;
    public static final String JSON_PROPERTY_TOPUP_TYPE = "topupType";
    private TopupTypeEnum topupType;

    public FundingAudit amount(Double amount) {
        this.amount = amount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getAmount() {
        return this.amount;
    }

    public void setAmount(Double amount) {
        this.amount = amount;
    }

    public FundingAudit dateTime(OffsetDateTime dateTime) {
        this.dateTime = dateTime;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="dateTime")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getDateTime() {
        return this.dateTime;
    }

    public void setDateTime(OffsetDateTime dateTime) {
        this.dateTime = dateTime;
    }

    public FundingAudit status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public FundingAudit currency(String currency) {
        this.currency = currency;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="currency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public FundingAudit sourceAccountName(String sourceAccountName) {
        this.sourceAccountName = sourceAccountName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="sourceAccountName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSourceAccountName() {
        return this.sourceAccountName;
    }

    public void setSourceAccountName(String sourceAccountName) {
        this.sourceAccountName = sourceAccountName;
    }

    public FundingAudit fundingAccountName(String fundingAccountName) {
        this.fundingAccountName = fundingAccountName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="fundingAccountName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFundingAccountName() {
        return this.fundingAccountName;
    }

    public void setFundingAccountName(String fundingAccountName) {
        this.fundingAccountName = fundingAccountName;
    }

    public FundingAudit fundingType(String fundingType) {
        this.fundingType = fundingType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="fundingType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFundingType() {
        return this.fundingType;
    }

    public void setFundingType(String fundingType) {
        this.fundingType = fundingType;
    }

    public FundingAudit events(List<FundingEvent> events) {
        this.events = events;
        return this;
    }

    public FundingAudit addEventsItem(FundingEvent eventsItem) {
        if (this.events == null) {
            this.events = new ArrayList<FundingEvent>();
        }
        this.events.add(eventsItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="events")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<FundingEvent> getEvents() {
        return this.events;
    }

    public void setEvents(List<FundingEvent> events) {
        this.events = events;
    }

    public FundingAudit topupType(TopupTypeEnum topupType) {
        this.topupType = topupType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="topupType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TopupTypeEnum getTopupType() {
        return this.topupType;
    }

    public void setTopupType(TopupTypeEnum topupType) {
        this.topupType = topupType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FundingAudit fundingAudit = (FundingAudit)o;
        return Objects.equals(this.amount, fundingAudit.amount) && Objects.equals(this.dateTime, fundingAudit.dateTime) && Objects.equals((Object)this.status, (Object)fundingAudit.status) && Objects.equals(this.currency, fundingAudit.currency) && Objects.equals(this.sourceAccountName, fundingAudit.sourceAccountName) && Objects.equals(this.fundingAccountName, fundingAudit.fundingAccountName) && Objects.equals(this.fundingType, fundingAudit.fundingType) && Objects.equals(this.events, fundingAudit.events) && Objects.equals((Object)this.topupType, (Object)fundingAudit.topupType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.amount, this.dateTime, this.status, this.currency, this.sourceAccountName, this.fundingAccountName, this.fundingType, this.events, this.topupType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FundingAudit {\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    dateTime: ").append(this.toIndentedString(this.dateTime)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    sourceAccountName: ").append(this.toIndentedString(this.sourceAccountName)).append("\n");
        sb.append("    fundingAccountName: ").append(this.toIndentedString(this.fundingAccountName)).append("\n");
        sb.append("    fundingType: ").append(this.toIndentedString(this.fundingType)).append("\n");
        sb.append("    events: ").append(this.toIndentedString(this.events)).append("\n");
        sb.append("    topupType: ").append(this.toIndentedString((Object)this.topupType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TopupTypeEnum {
        AUTOMATIC("AUTOMATIC"),
        MANUAL("MANUAL");

        private String value;

        private TopupTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TopupTypeEnum fromValue(String value) {
            for (TopupTypeEnum b : TopupTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum StatusEnum {
        PENDING("PENDING"),
        FAILED("FAILED"),
        CREDIT("CREDIT"),
        DEBIT("DEBIT");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

