/*
 * Decompiled with CFR 0.152.
 */
package com.velopayments.oa3.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.velopayments.oa3.model.PaymentAuditCurrencyV3;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

@JsonPropertyOrder(value={"quoteId", "creationDateTime", "rate", "invertedRate", "totalCost", "totalPaymentAmount", "sourceCurrency", "paymentCurrency", "status", "fundingStatus"})
public class FxSummaryV3 {
    public static final String JSON_PROPERTY_QUOTE_ID = "quoteId";
    private UUID quoteId;
    public static final String JSON_PROPERTY_CREATION_DATE_TIME = "creationDateTime";
    private OffsetDateTime creationDateTime;
    public static final String JSON_PROPERTY_RATE = "rate";
    private Float rate;
    public static final String JSON_PROPERTY_INVERTED_RATE = "invertedRate";
    private Float invertedRate;
    public static final String JSON_PROPERTY_TOTAL_COST = "totalCost";
    private Integer totalCost;
    public static final String JSON_PROPERTY_TOTAL_PAYMENT_AMOUNT = "totalPaymentAmount";
    private Integer totalPaymentAmount;
    public static final String JSON_PROPERTY_SOURCE_CURRENCY = "sourceCurrency";
    private PaymentAuditCurrencyV3 sourceCurrency;
    public static final String JSON_PROPERTY_PAYMENT_CURRENCY = "paymentCurrency";
    private PaymentAuditCurrencyV3 paymentCurrency;
    public static final String JSON_PROPERTY_STATUS = "status";
    private StatusEnum status;
    public static final String JSON_PROPERTY_FUNDING_STATUS = "fundingStatus";
    private FundingStatusEnum fundingStatus;

    public FxSummaryV3 quoteId(UUID quoteId) {
        this.quoteId = quoteId;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="quoteId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getQuoteId() {
        return this.quoteId;
    }

    public void setQuoteId(UUID quoteId) {
        this.quoteId = quoteId;
    }

    public FxSummaryV3 creationDateTime(OffsetDateTime creationDateTime) {
        this.creationDateTime = creationDateTime;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="creationDateTime")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public OffsetDateTime getCreationDateTime() {
        return this.creationDateTime;
    }

    public void setCreationDateTime(OffsetDateTime creationDateTime) {
        this.creationDateTime = creationDateTime;
    }

    public FxSummaryV3 rate(Float rate) {
        this.rate = rate;
        return this;
    }

    @NotNull
    @ApiModelProperty(example="1.12", required=true, value="")
    @JsonProperty(value="rate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Float getRate() {
        return this.rate;
    }

    public void setRate(Float rate) {
        this.rate = rate;
    }

    public FxSummaryV3 invertedRate(Float invertedRate) {
        this.invertedRate = invertedRate;
        return this;
    }

    @NotNull
    @ApiModelProperty(example="1.12", required=true, value="")
    @JsonProperty(value="invertedRate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Float getInvertedRate() {
        return this.invertedRate;
    }

    public void setInvertedRate(Float invertedRate) {
        this.invertedRate = invertedRate;
    }

    public FxSummaryV3 totalCost(Integer totalCost) {
        this.totalCost = totalCost;
        return this;
    }

    @NotNull
    @ApiModelProperty(example="1234", required=true, value="")
    @JsonProperty(value="totalCost")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Integer getTotalCost() {
        return this.totalCost;
    }

    public void setTotalCost(Integer totalCost) {
        this.totalCost = totalCost;
    }

    public FxSummaryV3 totalPaymentAmount(Integer totalPaymentAmount) {
        this.totalPaymentAmount = totalPaymentAmount;
        return this;
    }

    @NotNull
    @ApiModelProperty(example="1234", required=true, value="")
    @JsonProperty(value="totalPaymentAmount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Integer getTotalPaymentAmount() {
        return this.totalPaymentAmount;
    }

    public void setTotalPaymentAmount(Integer totalPaymentAmount) {
        this.totalPaymentAmount = totalPaymentAmount;
    }

    public FxSummaryV3 sourceCurrency(PaymentAuditCurrencyV3 sourceCurrency) {
        this.sourceCurrency = sourceCurrency;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="sourceCurrency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PaymentAuditCurrencyV3 getSourceCurrency() {
        return this.sourceCurrency;
    }

    public void setSourceCurrency(PaymentAuditCurrencyV3 sourceCurrency) {
        this.sourceCurrency = sourceCurrency;
    }

    public FxSummaryV3 paymentCurrency(PaymentAuditCurrencyV3 paymentCurrency) {
        this.paymentCurrency = paymentCurrency;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="paymentCurrency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PaymentAuditCurrencyV3 getPaymentCurrency() {
        return this.paymentCurrency;
    }

    public void setPaymentCurrency(PaymentAuditCurrencyV3 paymentCurrency) {
        this.paymentCurrency = paymentCurrency;
    }

    public FxSummaryV3 status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @NotNull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public FxSummaryV3 fundingStatus(FundingStatusEnum fundingStatus) {
        this.fundingStatus = fundingStatus;
        return this;
    }

    @NotNull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="fundingStatus")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public FundingStatusEnum getFundingStatus() {
        return this.fundingStatus;
    }

    public void setFundingStatus(FundingStatusEnum fundingStatus) {
        this.fundingStatus = fundingStatus;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FxSummaryV3 fxSummaryV3 = (FxSummaryV3)o;
        return Objects.equals(this.quoteId, fxSummaryV3.quoteId) && Objects.equals(this.creationDateTime, fxSummaryV3.creationDateTime) && Objects.equals(this.rate, fxSummaryV3.rate) && Objects.equals(this.invertedRate, fxSummaryV3.invertedRate) && Objects.equals(this.totalCost, fxSummaryV3.totalCost) && Objects.equals(this.totalPaymentAmount, fxSummaryV3.totalPaymentAmount) && Objects.equals((Object)this.sourceCurrency, (Object)fxSummaryV3.sourceCurrency) && Objects.equals((Object)this.paymentCurrency, (Object)fxSummaryV3.paymentCurrency) && Objects.equals((Object)this.status, (Object)fxSummaryV3.status) && Objects.equals((Object)this.fundingStatus, (Object)fxSummaryV3.fundingStatus);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.quoteId, this.creationDateTime, this.rate, this.invertedRate, this.totalCost, this.totalPaymentAmount, this.sourceCurrency, this.paymentCurrency, this.status, this.fundingStatus});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FxSummaryV3 {\n");
        sb.append("    quoteId: ").append(this.toIndentedString(this.quoteId)).append("\n");
        sb.append("    creationDateTime: ").append(this.toIndentedString(this.creationDateTime)).append("\n");
        sb.append("    rate: ").append(this.toIndentedString(this.rate)).append("\n");
        sb.append("    invertedRate: ").append(this.toIndentedString(this.invertedRate)).append("\n");
        sb.append("    totalCost: ").append(this.toIndentedString(this.totalCost)).append("\n");
        sb.append("    totalPaymentAmount: ").append(this.toIndentedString(this.totalPaymentAmount)).append("\n");
        sb.append("    sourceCurrency: ").append(this.toIndentedString((Object)this.sourceCurrency)).append("\n");
        sb.append("    paymentCurrency: ").append(this.toIndentedString((Object)this.paymentCurrency)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    fundingStatus: ").append(this.toIndentedString((Object)this.fundingStatus)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum FundingStatusEnum {
        FUNDED("FUNDED"),
        INSTRUCTED("INSTRUCTED"),
        UNFUNDED("UNFUNDED");

        private String value;

        private FundingStatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static FundingStatusEnum fromValue(String value) {
            for (FundingStatusEnum b : FundingStatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum StatusEnum {
        UNQUOTED("UNQUOTED"),
        QUOTED("QUOTED"),
        EXPIRED("EXPIRED"),
        EXECUTED("EXECUTED");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

