/*
 * Decompiled with CFR 0.152.
 */
package com.velopayments.oa3.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.velopayments.oa3.model.PaymentChannelRule;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

@JsonPropertyOrder(value={"isoCountryCode", "rules"})
public class PaymentChannelCountry {
    public static final String JSON_PROPERTY_ISO_COUNTRY_CODE = "isoCountryCode";
    private String isoCountryCode;
    public static final String JSON_PROPERTY_RULES = "rules";
    private List<PaymentChannelRule> rules = new ArrayList<PaymentChannelRule>();

    public PaymentChannelCountry isoCountryCode(String isoCountryCode) {
        this.isoCountryCode = isoCountryCode;
        return this;
    }

    @NotNull
    @ApiModelProperty(example="US", required=true, value="The ISO code for the country")
    @JsonProperty(value="isoCountryCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getIsoCountryCode() {
        return this.isoCountryCode;
    }

    public void setIsoCountryCode(String isoCountryCode) {
        this.isoCountryCode = isoCountryCode;
    }

    public PaymentChannelCountry rules(List<PaymentChannelRule> rules) {
        this.rules = rules;
        return this;
    }

    public PaymentChannelCountry addRulesItem(PaymentChannelRule rulesItem) {
        this.rules.add(rulesItem);
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="The rules for the given country")
    @JsonProperty(value="rules")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<PaymentChannelRule> getRules() {
        return this.rules;
    }

    public void setRules(List<PaymentChannelRule> rules) {
        this.rules = rules;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentChannelCountry paymentChannelCountry = (PaymentChannelCountry)o;
        return Objects.equals(this.isoCountryCode, paymentChannelCountry.isoCountryCode) && Objects.equals(this.rules, paymentChannelCountry.rules);
    }

    public int hashCode() {
        return Objects.hash(this.isoCountryCode, this.rules);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentChannelCountry {\n");
        sb.append("    isoCountryCode: ").append(this.toIndentedString(this.isoCountryCode)).append("\n");
        sb.append("    rules: ").append(this.toIndentedString(this.rules)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

