/*
 * Decompiled with CFR 0.152.
 */
package com.velopayments.oa3.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;

@ApiModel(description="Rules that will get applied when creating or updating a payment channel for the given country")
@JsonPropertyOrder(value={"element", "required", "displayName", "minLength", "maxLength", "validation", "displayOrder"})
public class PaymentChannelRule {
    public static final String JSON_PROPERTY_ELEMENT = "element";
    private String element;
    public static final String JSON_PROPERTY_REQUIRED = "required";
    private Boolean required;
    public static final String JSON_PROPERTY_DISPLAY_NAME = "displayName";
    private String displayName;
    public static final String JSON_PROPERTY_MIN_LENGTH = "minLength";
    private Integer minLength;
    public static final String JSON_PROPERTY_MAX_LENGTH = "maxLength";
    private Integer maxLength;
    public static final String JSON_PROPERTY_VALIDATION = "validation";
    private String validation;
    public static final String JSON_PROPERTY_DISPLAY_ORDER = "displayOrder";
    private Integer displayOrder;

    public PaymentChannelRule element(String element) {
        this.element = element;
        return this;
    }

    @NotNull
    @ApiModelProperty(example="accountName", required=true, value="<p>the rule element</p> <p>will match a given element name for a payment channel configuration ")
    @JsonProperty(value="element")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getElement() {
        return this.element;
    }

    public void setElement(String element) {
        this.element = element;
    }

    public PaymentChannelRule required(Boolean required) {
        this.required = required;
        return this;
    }

    @NotNull
    @ApiModelProperty(required=true, value="is this element required")
    @JsonProperty(value="required")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getRequired() {
        return this.required;
    }

    public void setRequired(Boolean required) {
        this.required = required;
    }

    public PaymentChannelRule displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @NotNull
    @ApiModelProperty(example="Account Name", required=true, value="User friendly name")
    @JsonProperty(value="displayName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public PaymentChannelRule minLength(Integer minLength) {
        this.minLength = minLength;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="5", value="mininum length of the element data")
    @JsonProperty(value="minLength")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getMinLength() {
        return this.minLength;
    }

    public void setMinLength(Integer minLength) {
        this.minLength = minLength;
    }

    public PaymentChannelRule maxLength(Integer maxLength) {
        this.maxLength = maxLength;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="50", value="maximum length of the element data")
    @JsonProperty(value="maxLength")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(Integer maxLength) {
        this.maxLength = maxLength;
    }

    public PaymentChannelRule validation(String validation) {
        this.validation = validation;
        return this;
    }

    @NotNull
    @ApiModelProperty(example="^[0-9]{6,11}$", required=true, value="a regex to validate the element data")
    @JsonProperty(value="validation")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getValidation() {
        return this.validation;
    }

    public void setValidation(String validation) {
        this.validation = validation;
    }

    public PaymentChannelRule displayOrder(Integer displayOrder) {
        this.displayOrder = displayOrder;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="displayOrder")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getDisplayOrder() {
        return this.displayOrder;
    }

    public void setDisplayOrder(Integer displayOrder) {
        this.displayOrder = displayOrder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentChannelRule paymentChannelRule = (PaymentChannelRule)o;
        return Objects.equals(this.element, paymentChannelRule.element) && Objects.equals(this.required, paymentChannelRule.required) && Objects.equals(this.displayName, paymentChannelRule.displayName) && Objects.equals(this.minLength, paymentChannelRule.minLength) && Objects.equals(this.maxLength, paymentChannelRule.maxLength) && Objects.equals(this.validation, paymentChannelRule.validation) && Objects.equals(this.displayOrder, paymentChannelRule.displayOrder);
    }

    public int hashCode() {
        return Objects.hash(this.element, this.required, this.displayName, this.minLength, this.maxLength, this.validation, this.displayOrder);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentChannelRule {\n");
        sb.append("    element: ").append(this.toIndentedString(this.element)).append("\n");
        sb.append("    required: ").append(this.toIndentedString(this.required)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    minLength: ").append(this.toIndentedString(this.minLength)).append("\n");
        sb.append("    maxLength: ").append(this.toIndentedString(this.maxLength)).append("\n");
        sb.append("    validation: ").append(this.toIndentedString(this.validation)).append("\n");
        sb.append("    displayOrder: ").append(this.toIndentedString(this.displayOrder)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

