/*
 * Decompiled with CFR 0.152.
 */
package com.velopayments.oa3.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.velopayments.oa3.model.PaymentAuditCurrencyV4;
import com.velopayments.oa3.model.PaymentEventResponseV4;
import com.velopayments.oa3.model.PaymentResponseV4Payout;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

@JsonPropertyOrder(value={"paymentId", "payeeId", "payorId", "payorName", "quoteId", "sourceAccountId", "sourceAccountName", "remoteId", "sourceAmount", "sourceCurrency", "paymentAmount", "paymentCurrency", "rate", "invertedRate", "submittedDateTime", "status", "fundingStatus", "routingNumber", "accountNumber", "iban", "paymentMemo", "filenameReference", "individualIdentificationNumber", "traceNumber", "payorPaymentId", "paymentChannelId", "paymentChannelName", "accountName", "railsId", "countryCode", "events", "returnCost", "returnReason", "payout"})
public class PaymentResponseV4 {
    public static final String JSON_PROPERTY_PAYMENT_ID = "paymentId";
    private UUID paymentId;
    public static final String JSON_PROPERTY_PAYEE_ID = "payeeId";
    private UUID payeeId;
    public static final String JSON_PROPERTY_PAYOR_ID = "payorId";
    private UUID payorId;
    public static final String JSON_PROPERTY_PAYOR_NAME = "payorName";
    private String payorName;
    public static final String JSON_PROPERTY_QUOTE_ID = "quoteId";
    private UUID quoteId;
    public static final String JSON_PROPERTY_SOURCE_ACCOUNT_ID = "sourceAccountId";
    private UUID sourceAccountId;
    public static final String JSON_PROPERTY_SOURCE_ACCOUNT_NAME = "sourceAccountName";
    private String sourceAccountName;
    public static final String JSON_PROPERTY_REMOTE_ID = "remoteId";
    private String remoteId;
    public static final String JSON_PROPERTY_SOURCE_AMOUNT = "sourceAmount";
    private Integer sourceAmount;
    public static final String JSON_PROPERTY_SOURCE_CURRENCY = "sourceCurrency";
    private PaymentAuditCurrencyV4 sourceCurrency;
    public static final String JSON_PROPERTY_PAYMENT_AMOUNT = "paymentAmount";
    private Integer paymentAmount;
    public static final String JSON_PROPERTY_PAYMENT_CURRENCY = "paymentCurrency";
    private PaymentAuditCurrencyV4 paymentCurrency;
    public static final String JSON_PROPERTY_RATE = "rate";
    private Double rate;
    public static final String JSON_PROPERTY_INVERTED_RATE = "invertedRate";
    private Double invertedRate;
    public static final String JSON_PROPERTY_SUBMITTED_DATE_TIME = "submittedDateTime";
    private OffsetDateTime submittedDateTime;
    public static final String JSON_PROPERTY_STATUS = "status";
    private StatusEnum status;
    public static final String JSON_PROPERTY_FUNDING_STATUS = "fundingStatus";
    private FundingStatusEnum fundingStatus;
    public static final String JSON_PROPERTY_ROUTING_NUMBER = "routingNumber";
    private String routingNumber;
    public static final String JSON_PROPERTY_ACCOUNT_NUMBER = "accountNumber";
    private String accountNumber;
    public static final String JSON_PROPERTY_IBAN = "iban";
    private String iban;
    public static final String JSON_PROPERTY_PAYMENT_MEMO = "paymentMemo";
    private String paymentMemo;
    public static final String JSON_PROPERTY_FILENAME_REFERENCE = "filenameReference";
    private String filenameReference;
    public static final String JSON_PROPERTY_INDIVIDUAL_IDENTIFICATION_NUMBER = "individualIdentificationNumber";
    private String individualIdentificationNumber;
    public static final String JSON_PROPERTY_TRACE_NUMBER = "traceNumber";
    private String traceNumber;
    public static final String JSON_PROPERTY_PAYOR_PAYMENT_ID = "payorPaymentId";
    private String payorPaymentId;
    public static final String JSON_PROPERTY_PAYMENT_CHANNEL_ID = "paymentChannelId";
    private String paymentChannelId;
    public static final String JSON_PROPERTY_PAYMENT_CHANNEL_NAME = "paymentChannelName";
    private String paymentChannelName;
    public static final String JSON_PROPERTY_ACCOUNT_NAME = "accountName";
    private String accountName;
    public static final String JSON_PROPERTY_RAILS_ID = "railsId";
    private String railsId;
    public static final String JSON_PROPERTY_COUNTRY_CODE = "countryCode";
    private String countryCode;
    public static final String JSON_PROPERTY_EVENTS = "events";
    private List<PaymentEventResponseV4> events = new ArrayList<PaymentEventResponseV4>();
    public static final String JSON_PROPERTY_RETURN_COST = "returnCost";
    private Integer returnCost;
    public static final String JSON_PROPERTY_RETURN_REASON = "returnReason";
    private String returnReason;
    public static final String JSON_PROPERTY_PAYOUT = "payout";
    private PaymentResponseV4Payout payout;

    public PaymentResponseV4 paymentId(UUID paymentId) {
        this.paymentId = paymentId;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="paymentId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getPaymentId() {
        return this.paymentId;
    }

    public void setPaymentId(UUID paymentId) {
        this.paymentId = paymentId;
    }

    public PaymentResponseV4 payeeId(UUID payeeId) {
        this.payeeId = payeeId;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="payeeId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getPayeeId() {
        return this.payeeId;
    }

    public void setPayeeId(UUID payeeId) {
        this.payeeId = payeeId;
    }

    public PaymentResponseV4 payorId(UUID payorId) {
        this.payorId = payorId;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Deprecated in v2.16. Will be populated with submitting payor ID until removed in a later release.")
    @JsonProperty(value="payorId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getPayorId() {
        return this.payorId;
    }

    public void setPayorId(UUID payorId) {
        this.payorId = payorId;
    }

    public PaymentResponseV4 payorName(String payorName) {
        this.payorName = payorName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="payorName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPayorName() {
        return this.payorName;
    }

    public void setPayorName(String payorName) {
        this.payorName = payorName;
    }

    public PaymentResponseV4 quoteId(UUID quoteId) {
        this.quoteId = quoteId;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="quoteId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getQuoteId() {
        return this.quoteId;
    }

    public void setQuoteId(UUID quoteId) {
        this.quoteId = quoteId;
    }

    public PaymentResponseV4 sourceAccountId(UUID sourceAccountId) {
        this.sourceAccountId = sourceAccountId;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="sourceAccountId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getSourceAccountId() {
        return this.sourceAccountId;
    }

    public void setSourceAccountId(UUID sourceAccountId) {
        this.sourceAccountId = sourceAccountId;
    }

    public PaymentResponseV4 sourceAccountName(String sourceAccountName) {
        this.sourceAccountName = sourceAccountName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="sourceAccountName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSourceAccountName() {
        return this.sourceAccountName;
    }

    public void setSourceAccountName(String sourceAccountName) {
        this.sourceAccountName = sourceAccountName;
    }

    public PaymentResponseV4 remoteId(String remoteId) {
        this.remoteId = remoteId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="remoteId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRemoteId() {
        return this.remoteId;
    }

    public void setRemoteId(String remoteId) {
        this.remoteId = remoteId;
    }

    public PaymentResponseV4 sourceAmount(Integer sourceAmount) {
        this.sourceAmount = sourceAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="sourceAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getSourceAmount() {
        return this.sourceAmount;
    }

    public void setSourceAmount(Integer sourceAmount) {
        this.sourceAmount = sourceAmount;
    }

    public PaymentResponseV4 sourceCurrency(PaymentAuditCurrencyV4 sourceCurrency) {
        this.sourceCurrency = sourceCurrency;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="sourceCurrency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PaymentAuditCurrencyV4 getSourceCurrency() {
        return this.sourceCurrency;
    }

    public void setSourceCurrency(PaymentAuditCurrencyV4 sourceCurrency) {
        this.sourceCurrency = sourceCurrency;
    }

    public PaymentResponseV4 paymentAmount(Integer paymentAmount) {
        this.paymentAmount = paymentAmount;
        return this;
    }

    @NotNull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="paymentAmount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Integer getPaymentAmount() {
        return this.paymentAmount;
    }

    public void setPaymentAmount(Integer paymentAmount) {
        this.paymentAmount = paymentAmount;
    }

    public PaymentResponseV4 paymentCurrency(PaymentAuditCurrencyV4 paymentCurrency) {
        this.paymentCurrency = paymentCurrency;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="paymentCurrency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PaymentAuditCurrencyV4 getPaymentCurrency() {
        return this.paymentCurrency;
    }

    public void setPaymentCurrency(PaymentAuditCurrencyV4 paymentCurrency) {
        this.paymentCurrency = paymentCurrency;
    }

    public PaymentResponseV4 rate(Double rate) {
        this.rate = rate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="rate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getRate() {
        return this.rate;
    }

    public void setRate(Double rate) {
        this.rate = rate;
    }

    public PaymentResponseV4 invertedRate(Double invertedRate) {
        this.invertedRate = invertedRate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="invertedRate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getInvertedRate() {
        return this.invertedRate;
    }

    public void setInvertedRate(Double invertedRate) {
        this.invertedRate = invertedRate;
    }

    public PaymentResponseV4 submittedDateTime(OffsetDateTime submittedDateTime) {
        this.submittedDateTime = submittedDateTime;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="submittedDateTime")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public OffsetDateTime getSubmittedDateTime() {
        return this.submittedDateTime;
    }

    public void setSubmittedDateTime(OffsetDateTime submittedDateTime) {
        this.submittedDateTime = submittedDateTime;
    }

    public PaymentResponseV4 status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @NotNull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public PaymentResponseV4 fundingStatus(FundingStatusEnum fundingStatus) {
        this.fundingStatus = fundingStatus;
        return this;
    }

    @NotNull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="fundingStatus")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public FundingStatusEnum getFundingStatus() {
        return this.fundingStatus;
    }

    public void setFundingStatus(FundingStatusEnum fundingStatus) {
        this.fundingStatus = fundingStatus;
    }

    public PaymentResponseV4 routingNumber(String routingNumber) {
        this.routingNumber = routingNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="routingNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRoutingNumber() {
        return this.routingNumber;
    }

    public void setRoutingNumber(String routingNumber) {
        this.routingNumber = routingNumber;
    }

    public PaymentResponseV4 accountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="accountNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public PaymentResponseV4 iban(String iban) {
        this.iban = iban;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="iban")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIban() {
        return this.iban;
    }

    public void setIban(String iban) {
        this.iban = iban;
    }

    public PaymentResponseV4 paymentMemo(String paymentMemo) {
        this.paymentMemo = paymentMemo;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="paymentMemo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPaymentMemo() {
        return this.paymentMemo;
    }

    public void setPaymentMemo(String paymentMemo) {
        this.paymentMemo = paymentMemo;
    }

    public PaymentResponseV4 filenameReference(String filenameReference) {
        this.filenameReference = filenameReference;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="filenameReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFilenameReference() {
        return this.filenameReference;
    }

    public void setFilenameReference(String filenameReference) {
        this.filenameReference = filenameReference;
    }

    public PaymentResponseV4 individualIdentificationNumber(String individualIdentificationNumber) {
        this.individualIdentificationNumber = individualIdentificationNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="individualIdentificationNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIndividualIdentificationNumber() {
        return this.individualIdentificationNumber;
    }

    public void setIndividualIdentificationNumber(String individualIdentificationNumber) {
        this.individualIdentificationNumber = individualIdentificationNumber;
    }

    public PaymentResponseV4 traceNumber(String traceNumber) {
        this.traceNumber = traceNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="traceNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTraceNumber() {
        return this.traceNumber;
    }

    public void setTraceNumber(String traceNumber) {
        this.traceNumber = traceNumber;
    }

    public PaymentResponseV4 payorPaymentId(String payorPaymentId) {
        this.payorPaymentId = payorPaymentId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="payorPaymentId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPayorPaymentId() {
        return this.payorPaymentId;
    }

    public void setPayorPaymentId(String payorPaymentId) {
        this.payorPaymentId = payorPaymentId;
    }

    public PaymentResponseV4 paymentChannelId(String paymentChannelId) {
        this.paymentChannelId = paymentChannelId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="paymentChannelId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPaymentChannelId() {
        return this.paymentChannelId;
    }

    public void setPaymentChannelId(String paymentChannelId) {
        this.paymentChannelId = paymentChannelId;
    }

    public PaymentResponseV4 paymentChannelName(String paymentChannelName) {
        this.paymentChannelName = paymentChannelName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="paymentChannelName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPaymentChannelName() {
        return this.paymentChannelName;
    }

    public void setPaymentChannelName(String paymentChannelName) {
        this.paymentChannelName = paymentChannelName;
    }

    public PaymentResponseV4 accountName(String accountName) {
        this.accountName = accountName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="accountName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAccountName() {
        return this.accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public PaymentResponseV4 railsId(String railsId) {
        this.railsId = railsId;
        return this;
    }

    @NotNull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="railsId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getRailsId() {
        return this.railsId;
    }

    public void setRailsId(String railsId) {
        this.railsId = railsId;
    }

    public PaymentResponseV4 countryCode(String countryCode) {
        this.countryCode = countryCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="countryCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public PaymentResponseV4 events(List<PaymentEventResponseV4> events) {
        this.events = events;
        return this;
    }

    public PaymentResponseV4 addEventsItem(PaymentEventResponseV4 eventsItem) {
        this.events.add(eventsItem);
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="events")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<PaymentEventResponseV4> getEvents() {
        return this.events;
    }

    public void setEvents(List<PaymentEventResponseV4> events) {
        this.events = events;
    }

    public PaymentResponseV4 returnCost(Integer returnCost) {
        this.returnCost = returnCost;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="returnCost")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getReturnCost() {
        return this.returnCost;
    }

    public void setReturnCost(Integer returnCost) {
        this.returnCost = returnCost;
    }

    public PaymentResponseV4 returnReason(String returnReason) {
        this.returnReason = returnReason;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="returnReason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReturnReason() {
        return this.returnReason;
    }

    public void setReturnReason(String returnReason) {
        this.returnReason = returnReason;
    }

    public PaymentResponseV4 payout(PaymentResponseV4Payout payout) {
        this.payout = payout;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="payout")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PaymentResponseV4Payout getPayout() {
        return this.payout;
    }

    public void setPayout(PaymentResponseV4Payout payout) {
        this.payout = payout;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentResponseV4 paymentResponseV4 = (PaymentResponseV4)o;
        return Objects.equals(this.paymentId, paymentResponseV4.paymentId) && Objects.equals(this.payeeId, paymentResponseV4.payeeId) && Objects.equals(this.payorId, paymentResponseV4.payorId) && Objects.equals(this.payorName, paymentResponseV4.payorName) && Objects.equals(this.quoteId, paymentResponseV4.quoteId) && Objects.equals(this.sourceAccountId, paymentResponseV4.sourceAccountId) && Objects.equals(this.sourceAccountName, paymentResponseV4.sourceAccountName) && Objects.equals(this.remoteId, paymentResponseV4.remoteId) && Objects.equals(this.sourceAmount, paymentResponseV4.sourceAmount) && Objects.equals((Object)this.sourceCurrency, (Object)paymentResponseV4.sourceCurrency) && Objects.equals(this.paymentAmount, paymentResponseV4.paymentAmount) && Objects.equals((Object)this.paymentCurrency, (Object)paymentResponseV4.paymentCurrency) && Objects.equals(this.rate, paymentResponseV4.rate) && Objects.equals(this.invertedRate, paymentResponseV4.invertedRate) && Objects.equals(this.submittedDateTime, paymentResponseV4.submittedDateTime) && Objects.equals((Object)this.status, (Object)paymentResponseV4.status) && Objects.equals((Object)this.fundingStatus, (Object)paymentResponseV4.fundingStatus) && Objects.equals(this.routingNumber, paymentResponseV4.routingNumber) && Objects.equals(this.accountNumber, paymentResponseV4.accountNumber) && Objects.equals(this.iban, paymentResponseV4.iban) && Objects.equals(this.paymentMemo, paymentResponseV4.paymentMemo) && Objects.equals(this.filenameReference, paymentResponseV4.filenameReference) && Objects.equals(this.individualIdentificationNumber, paymentResponseV4.individualIdentificationNumber) && Objects.equals(this.traceNumber, paymentResponseV4.traceNumber) && Objects.equals(this.payorPaymentId, paymentResponseV4.payorPaymentId) && Objects.equals(this.paymentChannelId, paymentResponseV4.paymentChannelId) && Objects.equals(this.paymentChannelName, paymentResponseV4.paymentChannelName) && Objects.equals(this.accountName, paymentResponseV4.accountName) && Objects.equals(this.railsId, paymentResponseV4.railsId) && Objects.equals(this.countryCode, paymentResponseV4.countryCode) && Objects.equals(this.events, paymentResponseV4.events) && Objects.equals(this.returnCost, paymentResponseV4.returnCost) && Objects.equals(this.returnReason, paymentResponseV4.returnReason) && Objects.equals(this.payout, paymentResponseV4.payout);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.paymentId, this.payeeId, this.payorId, this.payorName, this.quoteId, this.sourceAccountId, this.sourceAccountName, this.remoteId, this.sourceAmount, this.sourceCurrency, this.paymentAmount, this.paymentCurrency, this.rate, this.invertedRate, this.submittedDateTime, this.status, this.fundingStatus, this.routingNumber, this.accountNumber, this.iban, this.paymentMemo, this.filenameReference, this.individualIdentificationNumber, this.traceNumber, this.payorPaymentId, this.paymentChannelId, this.paymentChannelName, this.accountName, this.railsId, this.countryCode, this.events, this.returnCost, this.returnReason, this.payout});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentResponseV4 {\n");
        sb.append("    paymentId: ").append(this.toIndentedString(this.paymentId)).append("\n");
        sb.append("    payeeId: ").append(this.toIndentedString(this.payeeId)).append("\n");
        sb.append("    payorId: ").append(this.toIndentedString(this.payorId)).append("\n");
        sb.append("    payorName: ").append(this.toIndentedString(this.payorName)).append("\n");
        sb.append("    quoteId: ").append(this.toIndentedString(this.quoteId)).append("\n");
        sb.append("    sourceAccountId: ").append(this.toIndentedString(this.sourceAccountId)).append("\n");
        sb.append("    sourceAccountName: ").append(this.toIndentedString(this.sourceAccountName)).append("\n");
        sb.append("    remoteId: ").append(this.toIndentedString(this.remoteId)).append("\n");
        sb.append("    sourceAmount: ").append(this.toIndentedString(this.sourceAmount)).append("\n");
        sb.append("    sourceCurrency: ").append(this.toIndentedString((Object)this.sourceCurrency)).append("\n");
        sb.append("    paymentAmount: ").append(this.toIndentedString(this.paymentAmount)).append("\n");
        sb.append("    paymentCurrency: ").append(this.toIndentedString((Object)this.paymentCurrency)).append("\n");
        sb.append("    rate: ").append(this.toIndentedString(this.rate)).append("\n");
        sb.append("    invertedRate: ").append(this.toIndentedString(this.invertedRate)).append("\n");
        sb.append("    submittedDateTime: ").append(this.toIndentedString(this.submittedDateTime)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    fundingStatus: ").append(this.toIndentedString((Object)this.fundingStatus)).append("\n");
        sb.append("    routingNumber: ").append(this.toIndentedString(this.routingNumber)).append("\n");
        sb.append("    accountNumber: ").append(this.toIndentedString(this.accountNumber)).append("\n");
        sb.append("    iban: ").append(this.toIndentedString(this.iban)).append("\n");
        sb.append("    paymentMemo: ").append(this.toIndentedString(this.paymentMemo)).append("\n");
        sb.append("    filenameReference: ").append(this.toIndentedString(this.filenameReference)).append("\n");
        sb.append("    individualIdentificationNumber: ").append(this.toIndentedString(this.individualIdentificationNumber)).append("\n");
        sb.append("    traceNumber: ").append(this.toIndentedString(this.traceNumber)).append("\n");
        sb.append("    payorPaymentId: ").append(this.toIndentedString(this.payorPaymentId)).append("\n");
        sb.append("    paymentChannelId: ").append(this.toIndentedString(this.paymentChannelId)).append("\n");
        sb.append("    paymentChannelName: ").append(this.toIndentedString(this.paymentChannelName)).append("\n");
        sb.append("    accountName: ").append(this.toIndentedString(this.accountName)).append("\n");
        sb.append("    railsId: ").append(this.toIndentedString(this.railsId)).append("\n");
        sb.append("    countryCode: ").append(this.toIndentedString(this.countryCode)).append("\n");
        sb.append("    events: ").append(this.toIndentedString(this.events)).append("\n");
        sb.append("    returnCost: ").append(this.toIndentedString(this.returnCost)).append("\n");
        sb.append("    returnReason: ").append(this.toIndentedString(this.returnReason)).append("\n");
        sb.append("    payout: ").append(this.toIndentedString(this.payout)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum FundingStatusEnum {
        FUNDED("FUNDED"),
        INSTRUCTED("INSTRUCTED"),
        UNFUNDED("UNFUNDED");

        private String value;

        private FundingStatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static FundingStatusEnum fromValue(String value) {
            for (FundingStatusEnum b : FundingStatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum StatusEnum {
        ACCEPTED("ACCEPTED"),
        AWAITING_FUNDS("AWAITING_FUNDS"),
        FUNDED("FUNDED"),
        UNFUNDED("UNFUNDED"),
        BANK_PAYMENT_REQUESTED("BANK_PAYMENT_REQUESTED"),
        REJECTED("REJECTED"),
        ACCEPTED_BY_RAILS("ACCEPTED_BY_RAILS"),
        CONFIRMED("CONFIRMED"),
        RETURNED("RETURNED"),
        WITHDRAWN("WITHDRAWN");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

