/*
 * Decompiled with CFR 0.152.
 */
package com.velopayments.oa3.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"name", "description", "roles"})
public class PayorCreateApiKeyRequest {
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private JsonNullable<String> description = JsonNullable.undefined();
    public static final String JSON_PROPERTY_ROLES = "roles";
    private List<RolesEnum> roles = new ArrayList<RolesEnum>();

    public PayorCreateApiKeyRequest name(String name) {
        this.name = name;
        return this;
    }

    @NotNull
    @Size(min=2, max=100)
    @ApiModelProperty(example="iOS Key", required=true, value="A name for the key.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=2, max=100) String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public PayorCreateApiKeyRequest description(String description) {
        this.description = JsonNullable.of((Object)description);
        return this;
    }

    @Nullable
    @Size(min=2, max=1024)
    @ApiModelProperty(example="Key for iOS mobile application", value="Description of the key.")
    @JsonIgnore
    public @Size(min=2, max=1024) String getDescription() {
        return (String)this.description.orElse(null);
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getDescription_JsonNullable() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription_JsonNullable(JsonNullable<String> description) {
        this.description = description;
    }

    public void setDescription(String description) {
        this.description = JsonNullable.of((Object)description);
    }

    public PayorCreateApiKeyRequest roles(List<RolesEnum> roles) {
        this.roles = roles;
        return this;
    }

    public PayorCreateApiKeyRequest addRolesItem(RolesEnum rolesItem) {
        this.roles.add(rolesItem);
        return this;
    }

    @NotNull
    @Size(min=1, max=10)
    @ApiModelProperty(example="[\"payor.admin\"]", required=true, value="A list of roles to assign to the key.")
    @JsonProperty(value="roles")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1, max=10) List<RolesEnum> getRoles() {
        return this.roles;
    }

    public void setRoles(List<RolesEnum> roles) {
        this.roles = roles;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PayorCreateApiKeyRequest payorCreateApiKeyRequest = (PayorCreateApiKeyRequest)o;
        return Objects.equals(this.name, payorCreateApiKeyRequest.name) && Objects.equals(this.description, payorCreateApiKeyRequest.description) && Objects.equals(this.roles, payorCreateApiKeyRequest.roles);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.description, this.roles);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PayorCreateApiKeyRequest {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    roles: ").append(this.toIndentedString(this.roles)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum RolesEnum {
        ADMIN("payor.admin"),
        SUPPORT("payor.support");

        private String value;

        private RolesEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static RolesEnum fromValue(String value) {
            for (RolesEnum b : RolesEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

