/*
 * Decompiled with CFR 0.152.
 */
package com.velopayments.oa3.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import java.util.UUID;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

@ApiModel(description="Details of payor and principal participating in a payout.")
@JsonPropertyOrder(value={"payorId", "payorName", "dbaName", "principal", "principalId"})
public class PayoutPayorV4 {
    public static final String JSON_PROPERTY_PAYOR_ID = "payorId";
    private UUID payorId;
    public static final String JSON_PROPERTY_PAYOR_NAME = "payorName";
    private String payorName;
    public static final String JSON_PROPERTY_DBA_NAME = "dbaName";
    private String dbaName;
    public static final String JSON_PROPERTY_PRINCIPAL = "principal";
    private String principal;
    public static final String JSON_PROPERTY_PRINCIPAL_ID = "principalId";
    private UUID principalId;

    public PayoutPayorV4 payorId(UUID payorId) {
        this.payorId = payorId;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="The id of the payor.")
    @JsonProperty(value="payorId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getPayorId() {
        return this.payorId;
    }

    public void setPayorId(UUID payorId) {
        this.payorId = payorId;
    }

    public PayoutPayorV4 payorName(String payorName) {
        this.payorName = payorName;
        return this;
    }

    @NotNull
    @ApiModelProperty(required=true, value="The name of the payor.")
    @JsonProperty(value="payorName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getPayorName() {
        return this.payorName;
    }

    public void setPayorName(String payorName) {
        this.payorName = payorName;
    }

    public PayoutPayorV4 dbaName(String dbaName) {
        this.dbaName = dbaName;
        return this;
    }

    @NotNull
    @ApiModelProperty(required=true, value="The alternate name of the payor.")
    @JsonProperty(value="dbaName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDbaName() {
        return this.dbaName;
    }

    public void setDbaName(String dbaName) {
        this.dbaName = dbaName;
    }

    public PayoutPayorV4 principal(String principal) {
        this.principal = principal;
        return this;
    }

    @NotNull
    @ApiModelProperty(required=true, value="Email address if principal is a user or ID if application.")
    @JsonProperty(value="principal")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(String principal) {
        this.principal = principal;
    }

    public PayoutPayorV4 principalId(UUID principalId) {
        this.principalId = principalId;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="The id of the principal.")
    @JsonProperty(value="principalId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getPrincipalId() {
        return this.principalId;
    }

    public void setPrincipalId(UUID principalId) {
        this.principalId = principalId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PayoutPayorV4 payoutPayorV4 = (PayoutPayorV4)o;
        return Objects.equals(this.payorId, payoutPayorV4.payorId) && Objects.equals(this.payorName, payoutPayorV4.payorName) && Objects.equals(this.dbaName, payoutPayorV4.dbaName) && Objects.equals(this.principal, payoutPayorV4.principal) && Objects.equals(this.principalId, payoutPayorV4.principalId);
    }

    public int hashCode() {
        return Objects.hash(this.payorId, this.payorName, this.dbaName, this.principal, this.principalId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PayoutPayorV4 {\n");
        sb.append("    payorId: ").append(this.toIndentedString(this.payorId)).append("\n");
        sb.append("    payorName: ").append(this.toIndentedString(this.payorName)).append("\n");
        sb.append("    dbaName: ").append(this.toIndentedString(this.dbaName)).append("\n");
        sb.append("    principal: ").append(this.toIndentedString(this.principal)).append("\n");
        sb.append("    principalId: ").append(this.toIndentedString(this.principalId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

