/*
 * Decompiled with CFR 0.152.
 */
package com.velopayments.oa3.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import java.util.UUID;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

@ApiModel(description="Details of principal participating in a payout.")
@JsonPropertyOrder(value={"principal", "principalId"})
public class PayoutPrincipalV4 {
    public static final String JSON_PROPERTY_PRINCIPAL = "principal";
    private String principal;
    public static final String JSON_PROPERTY_PRINCIPAL_ID = "principalId";
    private UUID principalId;

    public PayoutPrincipalV4 principal(String principal) {
        this.principal = principal;
        return this;
    }

    @NotNull
    @ApiModelProperty(required=true, value="Email address if principal is a user or ID if application.")
    @JsonProperty(value="principal")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(String principal) {
        this.principal = principal;
    }

    public PayoutPrincipalV4 principalId(UUID principalId) {
        this.principalId = principalId;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="The id of the principal.")
    @JsonProperty(value="principalId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getPrincipalId() {
        return this.principalId;
    }

    public void setPrincipalId(UUID principalId) {
        this.principalId = principalId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PayoutPrincipalV4 payoutPrincipalV4 = (PayoutPrincipalV4)o;
        return Objects.equals(this.principal, payoutPrincipalV4.principal) && Objects.equals(this.principalId, payoutPrincipalV4.principalId);
    }

    public int hashCode() {
        return Objects.hash(this.principal, this.principalId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PayoutPrincipalV4 {\n");
        sb.append("    principal: ").append(this.toIndentedString(this.principal)).append("\n");
        sb.append("    principalId: ").append(this.toIndentedString(this.principalId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

