/*
 * Decompiled with CFR 0.152.
 */
package com.velopayments.oa3.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.velopayments.oa3.model.Address;
import com.velopayments.oa3.model.Company;
import com.velopayments.oa3.model.Individual;
import com.velopayments.oa3.model.Language;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"address", "type", "individual", "company", "language"})
public class Profile {
    public static final String JSON_PROPERTY_ADDRESS = "address";
    private Address address;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_INDIVIDUAL = "individual";
    private Individual individual;
    public static final String JSON_PROPERTY_COMPANY = "company";
    private JsonNullable<Company> company = JsonNullable.undefined();
    public static final String JSON_PROPERTY_LANGUAGE = "language";
    private Language language;

    public Profile address(Address address) {
        this.address = address;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Address getAddress() {
        return this.address;
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    public Profile type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @NotNull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public Profile individual(Individual individual) {
        this.individual = individual;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="individual")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Individual getIndividual() {
        return this.individual;
    }

    public void setIndividual(Individual individual) {
        this.individual = individual;
    }

    public Profile company(Company company) {
        this.company = JsonNullable.of((Object)company);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonIgnore
    public Company getCompany() {
        return (Company)this.company.orElse(null);
    }

    @JsonProperty(value="company")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Company> getCompany_JsonNullable() {
        return this.company;
    }

    @JsonProperty(value="company")
    public void setCompany_JsonNullable(JsonNullable<Company> company) {
        this.company = company;
    }

    public void setCompany(Company company) {
        this.company = JsonNullable.of((Object)company);
    }

    public Profile language(Language language) {
        this.language = language;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="language")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Language getLanguage() {
        return this.language;
    }

    public void setLanguage(Language language) {
        this.language = language;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Profile profile = (Profile)o;
        return Objects.equals(this.address, profile.address) && Objects.equals((Object)this.type, (Object)profile.type) && Objects.equals(this.individual, profile.individual) && Objects.equals(this.company, profile.company) && Objects.equals((Object)this.language, (Object)profile.language);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.address, this.type, this.individual, this.company, this.language});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Profile {\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    individual: ").append(this.toIndentedString(this.individual)).append("\n");
        sb.append("    company: ").append(this.toIndentedString(this.company)).append("\n");
        sb.append("    language: ").append(this.toIndentedString((Object)this.language)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        INDIVIDUAL("Individual"),
        COMPANY("Company");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

