/*
 * Decompiled with CFR 0.152.
 */
package com.velopayments.oa3.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;

@JsonPropertyOrder(value={"mfaType", "smsNumber"})
public class UpdateMFARequest {
    public static final String JSON_PROPERTY_MFA_TYPE = "mfaType";
    private MfaTypeEnum mfaType;
    public static final String JSON_PROPERTY_SMS_NUMBER = "smsNumber";
    private String smsNumber;

    public UpdateMFARequest mfaType(MfaTypeEnum mfaType) {
        this.mfaType = mfaType;
        return this;
    }

    @NotNull
    @ApiModelProperty(required=true, value="The Multi Factor Authentication type")
    @JsonProperty(value="mfaType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public MfaTypeEnum getMfaType() {
        return this.mfaType;
    }

    public void setMfaType(MfaTypeEnum mfaType) {
        this.mfaType = mfaType;
    }

    public UpdateMFARequest smsNumber(String smsNumber) {
        this.smsNumber = smsNumber;
        return this;
    }

    @NotNull
    @Pattern(regexp="^\\+?[1-9]\\d{1,14}$")
    @ApiModelProperty(example="11235555555", required=true, value="The phone number of a device that the user can receive sms messages on ")
    @JsonProperty(value="smsNumber")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Pattern(regexp="^\\+?[1-9]\\d{1,14}$") String getSmsNumber() {
        return this.smsNumber;
    }

    public void setSmsNumber(String smsNumber) {
        this.smsNumber = smsNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateMFARequest updateMFARequest = (UpdateMFARequest)o;
        return Objects.equals((Object)this.mfaType, (Object)updateMFARequest.mfaType) && Objects.equals(this.smsNumber, updateMFARequest.smsNumber);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.mfaType, this.smsNumber});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpdateMFARequest {\n");
        sb.append("    mfaType: ").append(this.toIndentedString((Object)this.mfaType)).append("\n");
        sb.append("    smsNumber: ").append(this.toIndentedString(this.smsNumber)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum MfaTypeEnum {
        SMS("SMS");

        private String value;

        private MfaTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static MfaTypeEnum fromValue(String value) {
            for (MfaTypeEnum b : MfaTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

