/*
 * Decompiled with CFR 0.152.
 */
package com.velopayments.oa3.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.velopayments.oa3.model.Role;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"id", "status", "email", "smsNumber", "primaryContactNumber", "secondaryContactNumber", "firstName", "lastName", "entityId", "roles", "mfaType", "mfaStatus", "lockedOut", "lockedOutTimestamp"})
public class UserResponse {
    public static final String JSON_PROPERTY_ID = "id";
    private UUID id;
    public static final String JSON_PROPERTY_STATUS = "status";
    private StatusEnum status;
    public static final String JSON_PROPERTY_EMAIL = "email";
    private String email;
    public static final String JSON_PROPERTY_SMS_NUMBER = "smsNumber";
    private String smsNumber;
    public static final String JSON_PROPERTY_PRIMARY_CONTACT_NUMBER = "primaryContactNumber";
    private String primaryContactNumber;
    public static final String JSON_PROPERTY_SECONDARY_CONTACT_NUMBER = "secondaryContactNumber";
    private String secondaryContactNumber;
    public static final String JSON_PROPERTY_FIRST_NAME = "firstName";
    private String firstName;
    public static final String JSON_PROPERTY_LAST_NAME = "lastName";
    private String lastName;
    public static final String JSON_PROPERTY_ENTITY_ID = "entityId";
    private UUID entityId;
    public static final String JSON_PROPERTY_ROLES = "roles";
    private List<Role> roles = null;
    public static final String JSON_PROPERTY_MFA_TYPE = "mfaType";
    private MfaTypeEnum mfaType;
    public static final String JSON_PROPERTY_MFA_STATUS = "mfaStatus";
    private MfaStatusEnum mfaStatus;
    public static final String JSON_PROPERTY_LOCKED_OUT = "lockedOut";
    private Boolean lockedOut;
    public static final String JSON_PROPERTY_LOCKED_OUT_TIMESTAMP = "lockedOutTimestamp";
    private JsonNullable<OffsetDateTime> lockedOutTimestamp = JsonNullable.undefined();

    public UserResponse id(UUID id) {
        this.id = id;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(example="8bbf301c-948f-4445-b411-357eec53e441", value="The id of the user")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public UserResponse status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="ENABLED", value="The status of the user when the user has been invited but not yet enrolled they will have a PENDING status ")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public UserResponse email(String email) {
        this.email = email;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="foo@example.com", value="the email address of the user")
    @JsonProperty(value="email")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public UserResponse smsNumber(String smsNumber) {
        this.smsNumber = smsNumber;
        return this;
    }

    @Nullable
    @Pattern(regexp="^\\+?[1-9]\\d{1,14}$")
    @ApiModelProperty(example="11235555555", value="The phone number of a device that the user can receive sms messages on ")
    @JsonProperty(value="smsNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Pattern(regexp="^\\+?[1-9]\\d{1,14}$") String getSmsNumber() {
        return this.smsNumber;
    }

    public void setSmsNumber(String smsNumber) {
        this.smsNumber = smsNumber;
    }

    public UserResponse primaryContactNumber(String primaryContactNumber) {
        this.primaryContactNumber = primaryContactNumber;
        return this;
    }

    @Nullable
    @Pattern(regexp="^\\+?[1-9]\\d{1,14}$")
    @ApiModelProperty(example="11235555555", value="The main contact number for the user ")
    @JsonProperty(value="primaryContactNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Pattern(regexp="^\\+?[1-9]\\d{1,14}$") String getPrimaryContactNumber() {
        return this.primaryContactNumber;
    }

    public void setPrimaryContactNumber(String primaryContactNumber) {
        this.primaryContactNumber = primaryContactNumber;
    }

    public UserResponse secondaryContactNumber(String secondaryContactNumber) {
        this.secondaryContactNumber = secondaryContactNumber;
        return this;
    }

    @Nullable
    @Pattern(regexp="^\\+?[1-9]\\d{1,14}$")
    @ApiModelProperty(example="11235555550", value="The secondary contact number for the user ")
    @JsonProperty(value="secondaryContactNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Pattern(regexp="^\\+?[1-9]\\d{1,14}$") String getSecondaryContactNumber() {
        return this.secondaryContactNumber;
    }

    public void setSecondaryContactNumber(String secondaryContactNumber) {
        this.secondaryContactNumber = secondaryContactNumber;
    }

    public UserResponse firstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    @Nullable
    @Size(min=1, max=128)
    @ApiModelProperty(example="John", value="")
    @JsonProperty(value="firstName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Size(min=1, max=128) String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public UserResponse lastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    @Nullable
    @Size(min=1, max=128)
    @ApiModelProperty(example="Doe", value="")
    @JsonProperty(value="lastName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Size(min=1, max=128) String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public UserResponse entityId(UUID entityId) {
        this.entityId = entityId;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(example="7fffa261-ac68-49e6-b605-d24a444d9206", value="The payorId or payeeId or null if the user is not a payor or payee user ")
    @JsonProperty(value="entityId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getEntityId() {
        return this.entityId;
    }

    public void setEntityId(UUID entityId) {
        this.entityId = entityId;
    }

    public UserResponse roles(List<Role> roles) {
        this.roles = roles;
        return this;
    }

    public UserResponse addRolesItem(Role rolesItem) {
        if (this.roles == null) {
            this.roles = new ArrayList<Role>();
        }
        this.roles.add(rolesItem);
        return this;
    }

    @Nullable
    @Valid
    @Size(min=1)
    @ApiModelProperty(example="[\"payor.admin\"]", value="The role(s) for the user ")
    @JsonProperty(value="roles")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Valid @Size(min=1) List<Role> getRoles() {
        return this.roles;
    }

    public void setRoles(List<Role> roles) {
        this.roles = roles;
    }

    public UserResponse mfaType(MfaTypeEnum mfaType) {
        this.mfaType = mfaType;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="TOTP", value="The type of the MFA device")
    @JsonProperty(value="mfaType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MfaTypeEnum getMfaType() {
        return this.mfaType;
    }

    public void setMfaType(MfaTypeEnum mfaType) {
        this.mfaType = mfaType;
    }

    public UserResponse mfaStatus(MfaStatusEnum mfaStatus) {
        this.mfaStatus = mfaStatus;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="REGISTERED", value="The status of the MFA device")
    @JsonProperty(value="mfaStatus")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MfaStatusEnum getMfaStatus() {
        return this.mfaStatus;
    }

    public void setMfaStatus(MfaStatusEnum mfaStatus) {
        this.mfaStatus = mfaStatus;
    }

    public UserResponse lockedOut(Boolean lockedOut) {
        this.lockedOut = lockedOut;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="If true the user is currently locked out and unable to log in")
    @JsonProperty(value="lockedOut")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getLockedOut() {
        return this.lockedOut;
    }

    public void setLockedOut(Boolean lockedOut) {
        this.lockedOut = lockedOut;
    }

    public UserResponse lockedOutTimestamp(OffsetDateTime lockedOutTimestamp) {
        this.lockedOutTimestamp = JsonNullable.of((Object)lockedOutTimestamp);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="A timestamp showing when the user was locked out If null then the user is not currently locked out ")
    @JsonIgnore
    public OffsetDateTime getLockedOutTimestamp() {
        return (OffsetDateTime)this.lockedOutTimestamp.orElse(null);
    }

    @JsonProperty(value="lockedOutTimestamp")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<OffsetDateTime> getLockedOutTimestamp_JsonNullable() {
        return this.lockedOutTimestamp;
    }

    @JsonProperty(value="lockedOutTimestamp")
    public void setLockedOutTimestamp_JsonNullable(JsonNullable<OffsetDateTime> lockedOutTimestamp) {
        this.lockedOutTimestamp = lockedOutTimestamp;
    }

    public void setLockedOutTimestamp(OffsetDateTime lockedOutTimestamp) {
        this.lockedOutTimestamp = JsonNullable.of((Object)lockedOutTimestamp);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserResponse userResponse = (UserResponse)o;
        return Objects.equals(this.id, userResponse.id) && Objects.equals((Object)this.status, (Object)userResponse.status) && Objects.equals(this.email, userResponse.email) && Objects.equals(this.smsNumber, userResponse.smsNumber) && Objects.equals(this.primaryContactNumber, userResponse.primaryContactNumber) && Objects.equals(this.secondaryContactNumber, userResponse.secondaryContactNumber) && Objects.equals(this.firstName, userResponse.firstName) && Objects.equals(this.lastName, userResponse.lastName) && Objects.equals(this.entityId, userResponse.entityId) && Objects.equals(this.roles, userResponse.roles) && Objects.equals((Object)this.mfaType, (Object)userResponse.mfaType) && Objects.equals((Object)this.mfaStatus, (Object)userResponse.mfaStatus) && Objects.equals(this.lockedOut, userResponse.lockedOut) && Objects.equals(this.lockedOutTimestamp, userResponse.lockedOutTimestamp);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.status, this.email, this.smsNumber, this.primaryContactNumber, this.secondaryContactNumber, this.firstName, this.lastName, this.entityId, this.roles, this.mfaType, this.mfaStatus, this.lockedOut, this.lockedOutTimestamp});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserResponse {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    smsNumber: ").append(this.toIndentedString(this.smsNumber)).append("\n");
        sb.append("    primaryContactNumber: ").append(this.toIndentedString(this.primaryContactNumber)).append("\n");
        sb.append("    secondaryContactNumber: ").append(this.toIndentedString(this.secondaryContactNumber)).append("\n");
        sb.append("    firstName: ").append(this.toIndentedString(this.firstName)).append("\n");
        sb.append("    lastName: ").append(this.toIndentedString(this.lastName)).append("\n");
        sb.append("    entityId: ").append(this.toIndentedString(this.entityId)).append("\n");
        sb.append("    roles: ").append(this.toIndentedString(this.roles)).append("\n");
        sb.append("    mfaType: ").append(this.toIndentedString((Object)this.mfaType)).append("\n");
        sb.append("    mfaStatus: ").append(this.toIndentedString((Object)this.mfaStatus)).append("\n");
        sb.append("    lockedOut: ").append(this.toIndentedString(this.lockedOut)).append("\n");
        sb.append("    lockedOutTimestamp: ").append(this.toIndentedString(this.lockedOutTimestamp)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum MfaStatusEnum {
        REGISTERED("REGISTERED"),
        UNREGISTERED("UNREGISTERED");

        private String value;

        private MfaStatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static MfaStatusEnum fromValue(String value) {
            for (MfaStatusEnum b : MfaStatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum MfaTypeEnum {
        SMS("SMS"),
        YUBIKEY("YUBIKEY"),
        TOTP("TOTP");

        private String value;

        private MfaTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static MfaTypeEnum fromValue(String value) {
            for (MfaTypeEnum b : MfaTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum StatusEnum {
        ENABLED("ENABLED"),
        DISABLED("DISABLED"),
        PENDING("PENDING");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

