/*
 * Velo Payments APIs
 * ## Terms and Definitions  Throughout this document and the Velo platform the following terms are used:  * **Payor.** An entity (typically a corporation) which wishes to pay funds to one or more payees via a payout. * **Payee.** The recipient of funds paid out by a payor. * **Payment.** A single transfer of funds from a payor to a payee. * **Payout.** A batch of Payments, typically used by a payor to logically group payments (e.g. by business day). Technically there need be no relationship between the payments in a payout - a single payout can contain payments to multiple payees and/or multiple payments to a single payee. * **Sandbox.** An integration environment provided by Velo Payments which offers a similar API experience to the production environment, but all funding and payment events are simulated, along with many other services such as OFAC sanctions list checking.  ## Overview  The Velo Payments API allows a payor to perform a number of operations. The following is a list of the main capabilities in a natural order of execution:  * Authenticate with the Velo platform * Maintain a collection of payees * Query the payor’s current balance of funds within the platform and perform additional funding * Issue payments to payees * Query the platform for a history of those payments  This document describes the main concepts and APIs required to get up and running with the Velo Payments platform. It is not an exhaustive API reference. For that, please see the separate Velo Payments API Reference.  ## API Considerations  The Velo Payments API is REST based and uses the JSON format for requests and responses.  Most calls are secured using OAuth 2 security and require a valid authentication access token for successful operation. See the Authentication section for details.  Where a dynamic value is required in the examples below, the {token} format is used, suggesting that the caller needs to supply the appropriate value of the token in question (without including the { or } characters).  Where curl examples are given, the –d @filename.json approach is used, indicating that the request body should be placed into a file named filename.json in the current directory. Each of the curl examples in this document should be considered a single line on the command-line, regardless of how they appear in print.  ## Authenticating with the Velo Platform  Once Velo backoffice staff have added your organization as a payor within the Velo platform sandbox, they will create you a payor Id, an API key and an API secret and share these with you in a secure manner.  You will need to use these values to authenticate with the Velo platform in order to gain access to the APIs. The steps to take are explained in the following:  create a string comprising the API key (e.g. 44a9537d-d55d-4b47-8082-14061c2bcdd8) and API secret (e.g. c396b26b-137a-44fd-87f5-34631f8fd529) with a colon between them. E.g. 44a9537d-d55d-4b47-8082-14061c2bcdd8:c396b26b-137a-44fd-87f5-34631f8fd529  base64 encode this string. E.g.: NDRhOTUzN2QtZDU1ZC00YjQ3LTgwODItMTQwNjFjMmJjZGQ4OmMzOTZiMjZiLTEzN2EtNDRmZC04N2Y1LTM0NjMxZjhmZDUyOQ==  create an HTTP **Authorization** header with the value set to e.g. Basic NDRhOTUzN2QtZDU1ZC00YjQ3LTgwODItMTQwNjFjMmJjZGQ4OmMzOTZiMjZiLTEzN2EtNDRmZC04N2Y1LTM0NjMxZjhmZDUyOQ==  perform the Velo authentication REST call using the HTTP header created above e.g. via curl:  ```   curl -X POST \\   -H \"Content-Type: application/json\" \\   -H \"Authorization: Basic NDRhOTUzN2QtZDU1ZC00YjQ3LTgwODItMTQwNjFjMmJjZGQ4OmMzOTZiMjZiLTEzN2EtNDRmZC04N2Y1LTM0NjMxZjhmZDUyOQ==\" \\   'https://api.sandbox.velopayments.com/v1/authenticate?grant_type=client_credentials' ```  If successful, this call will result in a **200** HTTP status code and a response body such as:  ```   {     \"access_token\":\"19f6bafd-93fd-4747-b229-00507bbc991f\",     \"token_type\":\"bearer\",     \"expires_in\":1799,     \"scope\":\"...\"   } ``` ## API access following authentication Following successful authentication, the value of the access_token field in the response (indicated in green above) should then be presented with all subsequent API calls to allow the Velo platform to validate that the caller is authenticated.  This is achieved by setting the HTTP Authorization header with the value set to e.g. Bearer 19f6bafd-93fd-4747-b229-00507bbc991f such as the curl example below:  ```   -H \"Authorization: Bearer 19f6bafd-93fd-4747-b229-00507bbc991f \" ```  If you make other Velo API calls which require authorization but the Authorization header is missing or invalid then you will get a **401** HTTP status response. 
 *
 * The version of the OpenAPI document: 2.20.11
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.velopayments.oa3.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.velopayments.oa3.model.Challenge;
import com.velopayments.oa3.model.CompanyV1;
import com.velopayments.oa3.model.CreateIndividual2;
import com.velopayments.oa3.model.CreatePayeeAddress2;
import com.velopayments.oa3.model.CreatePaymentChannel2;
import com.velopayments.oa3.model.Language2;
import com.velopayments.oa3.model.PayeePayorRefV3;
import com.velopayments.oa3.model.PayeeType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import javax.validation.constraints.*;
import javax.validation.Valid;

/**
 * CreatePayee2
 */
@JsonPropertyOrder({
  CreatePayee2.JSON_PROPERTY_PAYEE_ID,
  CreatePayee2.JSON_PROPERTY_PAYOR_REFS,
  CreatePayee2.JSON_PROPERTY_EMAIL,
  CreatePayee2.JSON_PROPERTY_REMOTE_ID,
  CreatePayee2.JSON_PROPERTY_TYPE,
  CreatePayee2.JSON_PROPERTY_ADDRESS,
  CreatePayee2.JSON_PROPERTY_PAYMENT_CHANNEL,
  CreatePayee2.JSON_PROPERTY_CHALLENGE,
  CreatePayee2.JSON_PROPERTY_LANGUAGE,
  CreatePayee2.JSON_PROPERTY_COMPANY,
  CreatePayee2.JSON_PROPERTY_INDIVIDUAL
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-01-15T12:46:56.400768-05:00[America/New_York]")
public class CreatePayee2 {
  public static final String JSON_PROPERTY_PAYEE_ID = "payeeId";
  private UUID payeeId;

  public static final String JSON_PROPERTY_PAYOR_REFS = "payorRefs";
  private JsonNullable<List<PayeePayorRefV3>> payorRefs = JsonNullable.<List<PayeePayorRefV3>>undefined();

  public static final String JSON_PROPERTY_EMAIL = "email";
  private String email;

  public static final String JSON_PROPERTY_REMOTE_ID = "remoteId";
  private String remoteId;

  public static final String JSON_PROPERTY_TYPE = "type";
  private PayeeType type;

  public static final String JSON_PROPERTY_ADDRESS = "address";
  private CreatePayeeAddress2 address;

  public static final String JSON_PROPERTY_PAYMENT_CHANNEL = "paymentChannel";
  private CreatePaymentChannel2 paymentChannel;

  public static final String JSON_PROPERTY_CHALLENGE = "challenge";
  private Challenge challenge;

  public static final String JSON_PROPERTY_LANGUAGE = "language";
  private Language2 language;

  public static final String JSON_PROPERTY_COMPANY = "company";
  private JsonNullable<CompanyV1> company = JsonNullable.<CompanyV1>undefined();

  public static final String JSON_PROPERTY_INDIVIDUAL = "individual";
  private CreateIndividual2 individual;


   /**
   * Get payeeId
   * @return payeeId
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(example = "2aa5d7e0-2ecb-403f-8494-1865ed0454e9", value = "")
  @JsonProperty(JSON_PROPERTY_PAYEE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getPayeeId() {
    return payeeId;
  }




   /**
   * Get payorRefs
   * @return payorRefs
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonIgnore

  public List<PayeePayorRefV3> getPayorRefs() {
    
    if (payorRefs == null) {
      payorRefs = JsonNullable.<List<PayeePayorRefV3>>of(new ArrayList<>());
    }
    return payorRefs.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PAYOR_REFS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<PayeePayorRefV3>> getPayorRefs_JsonNullable() {
    return payorRefs;
  }
  
  @JsonProperty(JSON_PROPERTY_PAYOR_REFS)
  private void setPayorRefs_JsonNullable(JsonNullable<List<PayeePayorRefV3>> payorRefs) {
    this.payorRefs = payorRefs;
  }



  public CreatePayee2 email(String email) {
    
    this.email = email;
    return this;
  }

   /**
   * Get email
   * @return email
  **/
  @NotNull
 @Size(min=3,max=255)  @ApiModelProperty(example = "bob@example.com", required = true, value = "")
  @JsonProperty(JSON_PROPERTY_EMAIL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getEmail() {
    return email;
  }


  public void setEmail(String email) {
    this.email = email;
  }


  public CreatePayee2 remoteId(String remoteId) {
    
    this.remoteId = remoteId;
    return this;
  }

   /**
   * Get remoteId
   * @return remoteId
  **/
  @NotNull
 @Size(min=1,max=100)  @ApiModelProperty(example = "Remote ID", required = true, value = "")
  @JsonProperty(JSON_PROPERTY_REMOTE_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getRemoteId() {
    return remoteId;
  }


  public void setRemoteId(String remoteId) {
    this.remoteId = remoteId;
  }


  public CreatePayee2 type(PayeeType type) {
    
    this.type = type;
    return this;
  }

   /**
   * Get type
   * @return type
  **/
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public PayeeType getType() {
    return type;
  }


  public void setType(PayeeType type) {
    this.type = type;
  }


  public CreatePayee2 address(CreatePayeeAddress2 address) {
    
    this.address = address;
    return this;
  }

   /**
   * Get address
   * @return address
  **/
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public CreatePayeeAddress2 getAddress() {
    return address;
  }


  public void setAddress(CreatePayeeAddress2 address) {
    this.address = address;
  }


  public CreatePayee2 paymentChannel(CreatePaymentChannel2 paymentChannel) {
    
    this.paymentChannel = paymentChannel;
    return this;
  }

   /**
   * Get paymentChannel
   * @return paymentChannel
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PAYMENT_CHANNEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CreatePaymentChannel2 getPaymentChannel() {
    return paymentChannel;
  }


  public void setPaymentChannel(CreatePaymentChannel2 paymentChannel) {
    this.paymentChannel = paymentChannel;
  }


  public CreatePayee2 challenge(Challenge challenge) {
    
    this.challenge = challenge;
    return this;
  }

   /**
   * Get challenge
   * @return challenge
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CHALLENGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Challenge getChallenge() {
    return challenge;
  }


  public void setChallenge(Challenge challenge) {
    this.challenge = challenge;
  }


  public CreatePayee2 language(Language2 language) {
    
    this.language = language;
    return this;
  }

   /**
   * Get language
   * @return language
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_LANGUAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Language2 getLanguage() {
    return language;
  }


  public void setLanguage(Language2 language) {
    this.language = language;
  }


  public CreatePayee2 company(CompanyV1 company) {
    this.company = JsonNullable.<CompanyV1>of(company);
    
    return this;
  }

   /**
   * Get company
   * @return company
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonIgnore

  public CompanyV1 getCompany() {
        return company.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_COMPANY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<CompanyV1> getCompany_JsonNullable() {
    return company;
  }
  
  @JsonProperty(JSON_PROPERTY_COMPANY)
  public void setCompany_JsonNullable(JsonNullable<CompanyV1> company) {
    this.company = company;
  }

  public void setCompany(CompanyV1 company) {
    this.company = JsonNullable.<CompanyV1>of(company);
  }


  public CreatePayee2 individual(CreateIndividual2 individual) {
    
    this.individual = individual;
    return this;
  }

   /**
   * Get individual
   * @return individual
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_INDIVIDUAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CreateIndividual2 getIndividual() {
    return individual;
  }


  public void setIndividual(CreateIndividual2 individual) {
    this.individual = individual;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CreatePayee2 createPayee2 = (CreatePayee2) o;
    return Objects.equals(this.payeeId, createPayee2.payeeId) &&
        Objects.equals(this.payorRefs, createPayee2.payorRefs) &&
        Objects.equals(this.email, createPayee2.email) &&
        Objects.equals(this.remoteId, createPayee2.remoteId) &&
        Objects.equals(this.type, createPayee2.type) &&
        Objects.equals(this.address, createPayee2.address) &&
        Objects.equals(this.paymentChannel, createPayee2.paymentChannel) &&
        Objects.equals(this.challenge, createPayee2.challenge) &&
        Objects.equals(this.language, createPayee2.language) &&
        Objects.equals(this.company, createPayee2.company) &&
        Objects.equals(this.individual, createPayee2.individual);
  }

  @Override
  public int hashCode() {
    return Objects.hash(payeeId, payorRefs, email, remoteId, type, address, paymentChannel, challenge, language, company, individual);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CreatePayee2 {\n");
    sb.append("    payeeId: ").append(toIndentedString(payeeId)).append("\n");
    sb.append("    payorRefs: ").append(toIndentedString(payorRefs)).append("\n");
    sb.append("    email: ").append(toIndentedString(email)).append("\n");
    sb.append("    remoteId: ").append(toIndentedString(remoteId)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    address: ").append(toIndentedString(address)).append("\n");
    sb.append("    paymentChannel: ").append(toIndentedString(paymentChannel)).append("\n");
    sb.append("    challenge: ").append(toIndentedString(challenge)).append("\n");
    sb.append("    language: ").append(toIndentedString(language)).append("\n");
    sb.append("    company: ").append(toIndentedString(company)).append("\n");
    sb.append("    individual: ").append(toIndentedString(individual)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

